/*------------------------------------------------------------------------*/
/* Classification -  IBM Internal Use Only                                */
/*                                                                        */
/* Name           -  R-STRESS CMD                                         */
/* Programmer     -  Greg Rollins                                         */
/* Date Written   -  21 June 1990                                         */
/* Release Level  -  6.2                                                  */
/* Function       -  WARP stress configuration utility                    */
/*                                                                        */
/* Change History -                                                       */
/*   6.2   08/21/97  B. Budak                                             */
/*                   Modified to support the ability to pass in a boot    */
/*                   drive letter and a drive letter for where the Stress */
/*                   Test bucket should be installed to.  The default is  */
/*                   to use "C:" for boot and "D:" for the stress if not  */
/*                   specified during invocation.                         */
/*                                                                        */
/*------------------------------------------------------------------------*/
extraparms = 'CONFIG STRESS DB SF'
ltrctr = '0'
default = '0'

parse arg arglist

  numparms = words(arglist)

  do y = 1 to 9
    if y > numparms then
      vr.y = ''
    else
      vr.y = WORD(arglist,y)
  end

  /*----------------------------------------------------------------------*/
  /* Load the RexxUtil functions.                                         */
  /*----------------------------------------------------------------------*/
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs

  if vr.1 = "" | vr.1 = "?" then call BADPARM

  /*----------------------------------------------------------------------*/
  /* Copy R-STRESS to drive specified and restart it there (first pass    */
  /* only)                                                                */
  /*----------------------------------------------------------------------*/
  if vr.1 \= 'RunCopy' then
  do
    map = SysDriveMap('C:', 'USED')
    numdrvs = WORDS(map)
    yy = 1

    do while yy <= numdrvs
      info = SysDriveInfo(SUBWORD(map,yy,1))

      if info = '' then
      do
        map = DELWORD(map,yy,1)
        yy = yy - 1
        numdrvs = numdrvs - 1
      end

      yy = yy + 1
    end

    if LENGTH(vr.2) = 1 then
      vr.2 = vr.2||':'

    if LENGTH(vr.3) = 1 then
      vr.3 = vr.3||':'

    if LENGTH(vr.2) = 2 then
    do
      if WORDPOS(TRANSLATE(vr.2),map) > 0 then
      do
        bdrv = vr.2

        call SysFileTree bdrv||'\os2\boot', 'sysdrv', 'D'

        if sysdrv.0 = 0 then
        do
          if LENGTH(vr.3) = 2 then
            call BADBOOT
          else
          do
            bdrv = 'C:'
            say ' '
            say ' The boot drive has defaulted to: 'bdrv

            sdrv = vr.2
            say ' The stress drive will be: 'sdrv

            default = '1'
          end
        end

        ltrctr = 1
      end
      else
        call BADBOOT
    end
    else
    do
      bdrv = 'C:'
      say ' '
      say ' The boot drive has defaulted to: 'bdrv
    end

    if default = '0' then
    do
      if LENGTH(vr.3) = 2 then
      do
        if WORDPOS(TRANSLATE(vr.3),map) > 0 then
        do
          sdrv = vr.3

          ltrctr = ltrctr + 1
        end
        else
          call BADSTRESS
      end
      else
      do
        sdrv = 'D:'

        say ' '
        say ' The stress test bucket drive has defaulted to: 'sdrv
      end
    end

    'copy a:\r-stress.cmd 'sdrv'\'
    sdrv

    select
      when ltrctr = '1' then
        'call r-stress RunCopy' vr.1 bdrv sdrv vr.3 vr.4 vr.5 vr.6 vr.7 vr.8 vr.9
      /*------------------------------------------------------------------*/
      when ltrctr = '2' then
        'call r-stress RunCopy' vr.1 bdrv sdrv vr.4 vr.5 vr.6 vr.7 vr.8 vr.9
      /*------------------------------------------------------------------*/
      otherwise
        'call r-stress RunCopy' vr.1 bdrv sdrv vr.2 vr.3 vr.4 vr.5 vr.6 vr.7 vr.8 vr.9
    end
  end
  else
  do
    rstress = vr.2

    bdrv = vr.3
    sdrv = vr.4

    do z = 1 to 2
      do y = 3 to numparms
        yy = y + 1
        vr.y = translate(vr.yy)
      end

      numparms = numparms - 1
    end
    rc = SysFileDelete(stress.cmd)
    rc = SysFileDelete(config.cmd)
    rc = SysFileDelete(db.cmd)
    rc = SysFileDelete(sf.cmd)

    select
      when vr.3 = '' then
      do
        'copy  a:\stress.cmd 'sdrv'\'
        'copy  a:\config.cmd 'sdrv'\'
        'copy  a:\db.cmd     'sdrv'\'
        'copy  a:\sf.cmd     'sdrv'\'
      end
      /*------------------------------------------------------------------*/
      when vr.3 = 'ONLY' then
      do
        if vr.4 = "" then call BADPARM

        do y = 3 to numparms
          parm = vr.y

          select
            when pos(parm,extraparms) > 0 then
              'copy a:\'parm'.cmd 'sdrv'\'
            /*------------------------------------------------------------*/
            when parm = 'ONLY' then
              NOP
            /*------------------------------------------------------------*/
            otherwise
            do
              say 'ERROR - 'parm' is not supported or needs to be re-entered in all uppercase or all'
              say 'lowercase characters.  Supported choices are STRESS, CONFIG, DB, or SF.'
              say ' '

              call BADPARM
            end
          end
        end
      end
      /*------------------------------------------------------------------*/
      otherwise
        call BADPARM
    end

    'copy a:\suicide.cmd  'sdrv'\'

    /*--------------------------------------------------------------------*/
    /* Version.cmd will set version=CRUISER or CUTTER                     */
    /*--------------------------------------------------------------------*/
    call 'a:\version.cmd' bdrv
    version = result

    say ' '
    say ' '
    say 'Stress Re-Installation for 'version
    say ' '

    if stream( sdrv'\stress.cmd', 'C', 'query exists') \= '' then
    do
      'call 'sdrv'\stress.cmd 'bdrv sdrv
      'erase 'sdrv'\stress.cmd'
    end

    if stream( sdrv'\config.cmd', 'C', 'query exists') \= '' then
    do
      'call 'sdrv'\config.cmd 'rstress bdrv sdrv
      'erase 'sdrv'\config.cmd'
    end

    if stream( sdrv'\db.cmd', 'C', 'query exists') \= '' then
    do
      'call 'sdrv'\db.cmd 'bdrv sdrv
      'erase 'sdrv'\db.cmd'
    end

    if stream( sdrv'\sf.cmd', 'C', 'query exists') \= '' then
    do
      'call 'sdrv'\sf.cmd 'bdrv sdrv
      'erase 'sdrv'\sf.cmd'
    end

    say '[33;41m'
    say ' '
    say 'Rstress Installation Complete!'
    say ' '

    'prompt Remove all disks and reboot the System!'

    /*--------------------------------------------------------------------*/
    /* SUICIDE.cmd lets c:\R-stress.cmd commit suicide quietly (no error  */
    /* messages)                                                          */
    /*--------------------------------------------------------------------*/
    if stream( sdrv'\suicide.cmd', 'C', 'query exists') \= '' then
      'call 'sdrv'\suicide.cmd 2>nul 'sdrv

  end

EXIT


/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/
/*                                                                        */
/*                       S U B R O U T I N E S                            */
/*                                                                        */
/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/

BADPARM: procedure

  say ' Parameters entered are incorrect.  Please try again using the format below.'
  say ' '
  'pause'

  say ' Syntax:'
  say ' '
  say '    A:\R-STRESS config [bootdrv] [drv] [ONLY [STRESS] [CONFIG] [DB] [SF]]'
  say ' '
  say '    where:'
  say '           config  is a valid machine configuration number.  Current machine'
  say '                   numbers are 6, 6-1, 7, 8, 9, M, P, T, X, Y, and Z.'
  say ' '
  say '           [] brackets enclose optional parameters'
  say ' '
  say '           bootdrv is the drive letter where OS/2 was installed on.'
  say '                   (Default is "C:")'
  say ' '
  say '           drv     is the drive letter to install the stress test bucket to.'
  say '                   (Default is "D:")'
  say ' '
  say '           ONLY    is used if only the list of phases after it are to be'
  say '                   performed.  See example 2 below.'
  say ' '
  say '           STRESS  will make Rstress setup the stress directories and files'
  say '                   on drive specified.'
  say ' '
  say '           CONFIG  will make Rstress append the Config.sys based on the'
  say '                   config parameter mentioned above.'
  say ' '
  say '           DB      will make Rstress copy the debug kernel from the DB disk'
  say ' '
  say '           SF      will make Rstress copy the symbol files from the SF disk'
  say ' '
  'pause'

  say ' '
  say ' EXAMPLES:'
  say ' '
  say ' 1)  For a normal Rstress on a machine of type 6, enter "A:\R-STRESS  6".     '
  say '     This will automatically perform all STRESS, CONFIG, DB, and SF functions'
  say '     listed above.'
  say ' '
  say ' 2)  If just certain phases of Rstress are needed, the ONLY option is used.'
  say '     Suppose a normal Rstress has been performed but the wrong DB and SF disks'
  say '     were used.  For a machine of type 7 enter:'
  say ' '
  say '     A:\R-STRESS  7  ONLY  DB  SF'
  say ' '
  say '     or'
  say ' '
  say '     A:\R-STRESS  7  ONLY  SF  DB'
  say ' '
  say '     The order of DB and SF does not matter; by design DB is always performed'
  say '     before SF.'
  say ' '

EXIT


/*------------------------------------------------------------------------*/
/*                                                                        */
/*------------------------------------------------------------------------*/
BADBOOT: procedure expose vr.

  say ' '
  say ' The boot drive specified: "'vr.2'"  doesn''t contain OS/2.'
  say ' '
  say ' Check the parameters and please try again.'
  say ' '
  say ' Syntax:'
  say ' '
  say '    A:\R-STRESS config [bootdrv] [drv] [ONLY [STRESS] [CONFIG] [DB] [SF]]'
  say ' '

EXIT


/*------------------------------------------------------------------------*/
/*                                                                        */
/*------------------------------------------------------------------------*/
BADSTRESS: procedure expose vr.

  say ' '
  say ' The drive specified: "'vr.3'"  for the stress test bucket to be installed to'
  say ' doesn''t exist.'
  say ' '
  say ' Check the parameters and please try again.'
  say ' '
  say ' Syntax:'
  say ' '
  say '    A:\R-STRESS config [bootdrv] [drv] [ONLY [STRESS] [CONFIG] [DB] [SF]]'
  say ' '

EXIT


