/*------------------------------------------------------------------------*/
/* Classification -  IBM Internal Use Only                                */
/*                                                                        */
/* Name           -  SF       CMD                                         */
/* Programmer     -  Greg Rollins                                         */
/* Date Written   -  27 June 1990                                         */
/* Release Level  -  3.2                                                  */
/* Function       -  This manhandles Microsoft builds in addition to the  */
/*                   "normal" IBM builds.                                 */
/*                                                                        */
/*                   Microsoft lumps all of their symbol files in the root*/
/*                   directory.  The first time an MS SF disk is run      */
/*                   through this batch, an \rst-sym subdirectory is made */
/*                   on it and the symbol files are copied to it.  This   */
/*                   copy could take several minutes.                     */
/*                                                                        */
/*                   During this copy, the SYM extension is dropped from  */
/*                   the symbol files so that the batch file can look for */
/*                   executables of the same name on the Boot Drive.  When*/
/*                   the directory of the executable for each symbol file */
/*                   is found, the symbol is copied there and its SYM     */
/*                   extension is restored.                               */
/*                                                                        */
/*                   Once an MS SF disk has been treated in this manner,  */
/*                   this batch file only needs to perform the last       */
/*                   statement above.                                     */
/*                                                                        */
/*                                                                        */
/* Change History -                                                       */
/*   3.2   08/21/97  B. Budak                                             */
/*                                                                        */
/*                                                                        */
/*------------------------------------------------------------------------*/

copy_sf = '0'
copy_sf2 = '0'
copy_ms = '0'

parse arg bdrv sdrv .

  if bdrv = '' then bdrv = 'c:'
  if sdrv = '' then sdrv = 'd:'

  /*----------------------------------------------------------------------*/
  /* Load the RexxUtils                                                   */
  /*----------------------------------------------------------------------*/
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs

  say '[1;44;36m'

  do forever
    call SysFileTree 'a:\os2krnld.sym', 'file', 'F'

    if file.0 > 0 then
    do
      copy_sf = '1'
      LEAVE
    end

    call SysFileTree 'a:\rst-sym\*.*', 'file', 'B'

    if file.0 > 0 then
    do
      copy_ms = '1'
      LEAVE
    end

    say ' '
    say '  ͻ'
    say '                                                              '
    say '                 Insert the SF disk in drive A:               '
    say '                                                              '
    say '  ͼ'
    say ' '
    'pause'

    say '[0;1;41;33m'
  end

  if copy_sf = '1' then
  do
    say '[1;44;36m'

    if stream('a:\os2\*.*', 'C', 'query exists') \= '' then
    do
      say ' '
      say ' Copying Symbols from drive A:'
      say ' '

      /*------------------------------------------------------------------*/
      /* Normal Cutter or Cruiser builds copied here                      */
      /*                                                                  */
      /* This Xcopy should and is being used, but it is slower than Copy. */
      /*------------------------------------------------------------------*/
      'xcopy a:\ 'bdrv'\ /s'

      /*------------------------------------------------------------------*/
      /* All the Copy commands                                            */
      /* copy a:\              c:\                                        */
      /* copy a:\os2           c:\os2                                     */
      /* copy a:\os2\dll       c:\os2\dll                                 */
      /* copy a:\os2\system    c:\os2\system                              */
      /* copy a:\os2\install   c:\os2\install                             */
      /* if exist a:\os2\intro\*.*   copy a:\os2\intro     c:\os2\intro   */
      /* if exist a:\os2\mdos\*.*    copy a:\os2\mdos      c:\os2\mdos    */
      /*                                                                  */
      /* Check for retail directory on diskette SF                        */
      /* If directory exists this is CUTTER, otherwise go                 */
      /* get the .SYMs from symbol diskette #2                            */
      /*------------------------------------------------------------------*/
      if stream('a:\os2\retail\dll\pmwin.sym', 'C', 'query exists') \= '' then
        'copy a:\os2\retail\dll\pmwin.sym 'bdrv'\os2\dll'

      if stream('a:\os2\mdos\*.*', 'C', 'query exists') \= '' then
      do
        do forever
          say ' '
          say '  ͻ'
          say '                                                              '
          say '                 Insert the SF2 disk in drive A:              '
          say '                                                              '
          say '  ͼ'
          say ' '
          'pause'

          if stream('a:\os2\mdos\doskrnl.sym', 'C', 'query exists') \= '' then
          do
            copy_sf2 = '1'
            LEAVE
          end

          say '[0;1;41;33m'
        end
      end

      if copy_sf2 = '1' then
      do
        'xcopy a:\ 'bdrv'\ /s'
        /*----------------------------------------------------------------*/
        /* copy a:\os2\mdos      c:\os2\mdos                              */
        /* copy a:\os2\dll       c:\os2\dll                               */
        /*----------------------------------------------------------------*/
        if stream('a:\os2\retail\dll\pmwin.sym', 'C', 'query exists') \= '' then
          'copy a:\os2\retail\dll\pmwin.sym 'bdrv'\os2\dll'
      end
    end
    else
    do
      /*------------------------------------------------------------------*/
      /* Microsoft builds lump all symbol files in the root directory.    */
      /*------------------------------------------------------------------*/
      say ' '
      say ' Preparing Microsoft SF disk . . .'
      say ' '

      'md 'sdrv'\rst-sym'

      /*------------------------------------------------------------------*/
      /* Copy and rename without SYM extension                            */
      /*------------------------------------------------------------------*/
      'copy a:\*.sym 'sdrv'\rst-sym\*.'

      /*------------------------------------------------------------------*/
      /* Now copy back to floppy                                          */
      /*------------------------------------------------------------------*/
      say ' Y| del a:\'
      'md a:\rst-sym'
      'copy 'sdrv'\rst-sym a:\rst-sym'
      say ' Y| del 'sdrv'\rst-sym'
      'rd 'sdrv'\rst-sym'

      copy_ms = '1'
    end
  end

  if copy_ms = '1' then
  do
    say ' '
    say ' Placing Microsoft SF files in correct subdirectories:'
    say ' '
    'a:'
    'cd\rst-sym'

    if stream('.\os2\*.*', 'C', 'query exists') \= '' then
      'copy .\os2\*.* 'bdrv'\os2\*.sym'

    if stream('.\os2\dll\*.*', 'C', 'query exists') \= '' then
      'copy .\os2\dll\*.* 'bdrv'\os2\dll\*.sym'

    if stream('.\os2\system\*.*', 'C', 'query exists') \= '' then
      'copy .\os2\system\*.* 'bdrv'\os2\system\*.sym'

    if stream('.\os2\install\*.*', 'C', 'query exists') \= '' then
      'copy .\os2\install\*.* 'bdrv'\os2\install\*.sym'

    if stream('.\os2\intro\*.*', 'C', 'query exists') \= '' then
      'copy .\os2\intro\*.* 'bdrv'\os2\intro\*.sym'

    if stream('.\os2\mdos\*.*', 'C', 'query exists') \= '' then
      'copy .\os2\mdos\*.* 'bdrv'\os2\mdos\*.sym'

    bdrv
  end


  /*----------------------------------------------------------------------*/
  /* If possible, rename the appropriate *.SYM video file to DISPLAY.SYM  */
  /* Only supported BVH video DLL's are installed, so the video types     */
  /* listed below MUST be in order from lowest to highest.                */
  /*----------------------------------------------------------------------*/
  'copy 'bdrv'\OS2\DLL\%DISPLAYSYM%.sym 'bdrv'\OS2\DLL\DISPLAY.SYM'

  say ' '
  say ' Delete any extra files:'
  say ' '

  if stream(bdrv'\os2krnld.', 'C', 'query exists') \= '' then
    'del 'bdrv'\os2krnld.'

  if stream(bdrv'\os2krnld.sym', 'C', 'query exists') \= '' then
    'del 'bdrv'\os2krnld.sym'

  if stream(bdrv'\*.map', 'C', 'query exists') \= '' then
    'del 'bdrv'\*.map'

  say ' '

EXIT
