/*------------------------------------------------------------------------*/
/* Classification -  IBM Internal Use Only                                */
/*                                                                        */
/* Name           -  VERSION CMD                                          */
/* Programmer     -  Greg Rollins                                         */
/* Date Written   -  26 June 1990                                         */
/* Release Level  -  1.2                                                  */
/* Function       -                                                       */
/*                                                                        */
/* Change History -                                                       */
/*   1.2   08/20/97  B. Budak                                             */
/*                   Restructured to use REXX. Boot Drive letter is now   */
/*                   passed in to test other than C and D drives.         */
/*                                                                        */
/*------------------------------------------------------------------------*/

parse upper arg bdrv .

  if bdrv = '' then bdrv = 'C:'

  /*----------------------------------------------------------------------*/
  /* Load the RexxUtils                                                   */
  /*----------------------------------------------------------------------*/
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs

  ver = SysOS2Ver()

  if POS('2.',ver) > 0 | POS('3.',ver) > 0 then
    version = 'CRUISER'
  else
    version = 'CUTTER'

RETURN version
