/*


       Program ID      :   STR008.c (Concurrent random copy testcase)


       Author          :   Tim Keating
                           Contractor  - "The Experts"
                           IBM System Test Group, Delray beach, Fl


       Date written    :   08/26/86
       Date revised    :

       External
       Subroutines
       Linked          :   Writelog subsystem

                           DosExitList
                           DosExit
                           DosSetSigHandler
                           DosCreateThread
                           DosChgFilePtr
                           DosOpen
                           DosRead
                           DosWrite
                           DosClose
                           DosQueryFileInfo
                           DosSetMaxFH
                           DosNewSize
                           DosSetFileInfo
                           DosQFileInfo
                           DosSleep


       Comments        :     Copies a single file from source to dest paths.
                           Splits up file allocation among multiple threads
                           and each thread will then randomly read and write
                           source to destination file.  After

                           If /n switch is specified then mulitple copy
                           threads are started and as each one completes
                           another is started.  Each new thread will copy
                           a seperate file.  Files to copied are split up
                           into 100 even size areas and random size data blocks are
                           copied from source to target file.  When all 100
                           areas are exhusted then copy is complete and thread
                           terminates.

                           cmd line
                               str008 input.path output.path -n99

                input.path  input path without wild card specs.
                output.path output path spec. (should be a file name).
                -n99       number of threads 1-16 copying. 1 default.


                           max number of threads is 16.

                               Open log file.
                               Write starting message.
                               Set Cntrl-c handler.
                               Set exit vector to closelog.
                               phase command line args.
                               if null second_path then
                                  use internal name "STR008.dat"

                               DosOpenfile      -- open input file
                               DosOpenfile      -- open output file
                               DosQFileInfo     -- get size of input file
                               DosNewSize       -- make output file = input
                                                   file size.

                               Copy input file to test file.

                               CreateCopyThreads.
                                 (each thread will add a different byte value)
                               Wait for threads to complete.

                               compare input file with output file.
                                 (each byte should n-total larger than input).
                                 (fatal error in fail to match)

                               CreateCopyThreads.
                                 (each thread will reverse action in prev ).
                               Wait for threads to complete.

                               compare input file with output file.
                                 (each byte should n-total larger than input).
                                 (fatal error in fail to match)

                               if error report to log and
                                   decrement active_threads.
                               done.

                           copy_thread:
                               (See copy thread function description).


                           cntrl_c_vector:
                               write log message.
                               write threads active message--aborting.
                               DosExit(1,0); -- kill all threads.

                           exit_vector:
                               write ending log message.
                               close log.
                               exit program.




*/
#include <testlog.h>
#include <cpcalls.h>
#include <v2tov3.h>

#define Uint   unsigned int
#define Ulong  unsigned long

void far exit_program();
void far control_c();
void far copy_thread();

char   *str;                           /* pass fail indicator */
char   input_path[70] = "";            /* input path buffer */
char   output_path[70] = "";           /* output print path buffer */
                                       /* default to prn device */
int    active_threads = 0;             /* zero out counters */
int    threads_started = 0;
int    threads_completed = 0;
int    threads_aborted = 0;
int    copy_ok = 0;                    /* default flags to fail */
Uint   total_offset = 0;

Uint   thread_id[16];                  /* thread id's of executing threads */
Uint   thread_ptry[16];                /* print thread prioritys */
Uint   thread_stack[16][1500];         /* reserve statck for 16 threads */
                                       /* executing at same time, each thread */
                                       /* needs at least 3000 bytes of stack */

char   buffer_one[512];                /* input buffer for primary thread */
char   buffer_two[512];                /* output buffer for primary thread */

extern long    M_switch;               /* reference switches from addn_arg */
extern long    N_switch;

/**/
main(argc, argv, envp)

int argc;                              /* number of command line args */
char **argv;                           /* command line arguments pointers */
char **envp;                           /* environment variables pointers*/
{
       int     rc;                     /* error return code variable */
       int     regs;                   /* starting pass value */
       int     index,count;            /* work values*/
       Ulong   return_val;             /* returned value from function */
       Ulong   prev_handler;           /* previous sig handle address */
       Ulong   temp;                   /* temporary long work var */
       Uint    prev_action;            /* previous action dor sig hand */

       Uint    max_file_handles;       /* number of file handles to alloc */
       Uint    file_attrib;            /* returned file attrib from query */
       Uint    action_taken;           /* action taken from opens */

       Uint    mwrite_size;            /* master thread write size */
       Uint    mread_size;             /* master thread read size */
       Uint    msread_size;            /* secondary master read size */
       Uint    minput_handle;          /* master thread input handle */
       Uint    moutput_handle;         /* master thread output handle */

       struct  FileStatus file_info;    /* Reserve area for file info */

       get_cmd_arg(argc, argv);        /* read command line arguments */
       get_addn_arg(argc, argv);       /* read command line arguments */

       str = "FAIL";                   /* default to failed condition */
       OPENLOG("STR008");              /* open the log file in the root */

       CWRITELOG(L_HDR, 0,
                (l_log," STR008 concurrent random copy stress test\n"));

       if (N_switch > 16)
           {
           CWRITELOG(L_DEBUG,-1,
                    (l_log,"too many threads specified, reduced to 16\n"));
           N_switch = 16;
           }
       if (N_switch == 0)
           N_switch = 1;

       rc = DosExitList(1,(void (far *)()) exit_program);
       if (rc != 0) exit_program();

                                       /* set up sig handler for cntrl - c*/
       rc = DosSetSigHandler( (void (far *)()) control_c,
                              (Ulong far *) &prev_handler,
                              (Uint far *) &prev_action,
                              2, 1);
       CWRITELOG(L_DEBUG, 0,
                (l_log," prev handler = %8.8lx, action = %4.4x \n",
                       prev_handler, prev_action ));
       if (rc != 0) DosExit(0,0);

       for(index = 1; index < argc; index++)
           {
           if( *(argv[index]) !=  '/' &&
               *(argv[index]) !=  '-' &&
               *(argv[index]) !=  ' ' &&
               *(argv[index]) !=  '#' )
               if (input_path[0] == 0 )
                   strcpy(input_path, argv[index]); /* get input path */
                 else
                   if (output_path[0] == 0 )
                       strcpy(output_path, argv[index]); /* get output path */
           }
       if (output_path[0] == 0)
           strcpy(output_path, "str008.dat");      /* set up our own data file*/

       rc = DosOpen((char far *) input_path,       /* open orginal file */
                    (Uint far *) &minput_handle,
                    (Uint far *) &action_taken,
                    0x00000000l,                   /* zero size */
                    0x0000,                        /* file attributes */
                    0x0001,                        /* open mode, open if exist*/
                    0x0040, 0l);                   /* allow r/w acess, rd-only*/
       if (rc != 0) DosExit(0,0);

       rc = DosOpen((char far *) output_path,
                    (Uint far *) &moutput_handle,
                    (Uint far *) &action_taken,
                    0x00000000l,                   /* zero size on open*/
                    0x0000,                        /* file attributes */
                    0x0011,                        /* open file or create */
                    0x0041, 0l);                   /* allow r/w acess, rd-only*/
       if (rc != 0) DosExit(0,0);

       rc = DosQFileInfo(minput_handle, 1, (char far *)
                         (struct FileStatus far *) &file_info,
                         sizeof(file_info));
       if (rc != 0) DosExit(0,0);

       rc = DosNewSize(moutput_handle, file_info.file_size);
       if (rc != 0) DosExit(0,0);

       mread_size = 512;                           /* default to true cond */
       while (mread_size == 512)                   /* make duplicate of file */
           {
           rc = DosRead(minput_handle, (char far *) buffer_one,
                        512, (Uint far *) &mread_size);
           if (rc != 0) DosExit(0,0);
           if (mread_size == 0)
               break;                              /* break loop if zero size */
           rc = DosWrite(moutput_handle, (char far *) buffer_one,
                        mread_size, (Uint far *) &mwrite_size);
           if (rc != 0) DosExit(0,0);
           if (mwrite_size != mread_size)
               {
               CWRITELOG(L_ABORT, -1,
                        (l_log,"  write size %4d != %4d read size\n",
                           mwrite_size, mread_size));
               DosExit(0,0);
               }
           }

       max_file_handles = N_switch * 1 + 5; /* set up max file handles as */
                                            /* follows */
                                            /* 1 - stdin handle */
                                            /* 1 - stdout handle */
                                            /* 1 - stderr handle */
                                            /* 2 - primary thread opens */
                                            /* 2 x N - handles for each thread*/

       rc = DosSetMaxFH(max_file_handles);
       if (rc !=0) DosExit(0,0);            /* abort if not enough handles */

       CWRITELOG(L_TRACE,0,
                (l_log," Entering 1st thread updates of files\n"));

       for (index = 0; index < N_switch; index++)
           {
           thread_stack[index][1499] = (index * 10 +1);
           total_offset += index * 10 + 1;
                                           /* define file byte adder */
           thread_stack[index][1498] = index % 10 + 1;
                                           /* starting seed value for child */
                                           /* start child copy task */
           rc = DosCreateThread( (void (far *) ()) copy_thread,
                                 (Uint far *) &thread_id[index],
                    (char far *) (Uint far *) &thread_stack[index][1498]);
           threads_started++;
           active_threads++;
           }

       while (active_threads >= 0)
           {
           for (index = 0; index < 16; index++)
               {
               if (thread_id[index] != 0)
                   {
                   rc = DosGetPrty(1,
                                  (Uint far *) &thread_ptry[index],
                                  thread_id[index]);
                   if (rc !=0)             /* look for thread done */
                       {
                       thread_id[index] = 0;
                       active_threads--;
                       }
                   }
               }
           if (active_threads > 0)
               rc = DosSleep(3000l);       /* Sleep for three seconds */
                                           /* and try again */
           }
       CWRITELOG(L_WARN,0,
                (l_log," exiting 1st thread updates of files\n"));

       CWRITELOG(L_TRACE,0,
                (l_log," entering 1st stage verify of files\n"));

       rc = DosChgFilePtr(minput_handle, 0l, 0,
                          (Ulong far *) &temp);
       if (rc != 0) DosExit(0,0);

       rc = DosChgFilePtr(moutput_handle, 0l, 0,
                          (Ulong far *) &temp);
       if (rc != 0) DosExit(0,0);

       mread_size = 512;                           /* default to true cond */
       while (mread_size == 512)                   /* make duplicate of file */
           {
           rc = DosRead(minput_handle, (char far *) buffer_one,
                        512, (Uint far *) &mread_size);
           if (rc != 0) DosExit(0,0);
           if (mread_size == 0)
               break;                              /* break loop if zero size */
           rc = DosRead(moutput_handle, (char far *) buffer_two,
                        mread_size, (Uint far *) &msread_size);
           if (rc != 0) DosExit(0,0);
           if (msread_size != mread_size)
               {
               CWRITELOG(L_ABORT, -1,
                        (l_log,"  verify read size %4d != %4d read size\n",
                           msread_size, mread_size));
               DosExit(0,0);
               }
           for (index = 0; index < msread_size;index++)
               if (buffer_one[index] != buffer_two[index] + total_offset)
                   {
                   CWRITELOG(L_ABORT, -1,
                            (l_log," Miss-match in files  %d, %d %d\n",
                              index, buffer_one[index], buffer_two[index]));
                   DosExit(0,0);
                   }
           }

       CWRITELOG(L_WARN,0,
                (l_log," exiting 1s stage verify of files\n"));

       CWRITELOG(L_TRACE,0,
                (l_log," entering 2nd thread updates of files\n"));

       for (index = 0; index < N_switch; index++)
           {
           thread_stack[index][1499] = -(index * 10 +1);
                                           /* define file byte adder */
           thread_stack[index][1498] = index % 10 + 1;
                                           /* starting seed value for child */
                                           /* start child copy task */
           rc = DosCreateThread( (void (far *) ()) copy_thread,
                                 (Uint far *) &thread_id[index],
                    (char far *) (Uint far *) &thread_stack[index][1498]);
           threads_started++;
           active_threads++;
           }

       while (active_threads >= 0)
           {
           for (index = 0; index < 16; index++)
               {
               if (thread_id[index] != 0)
                   {
                   rc = DosGetPrty(1,
                                  (Uint far *) &thread_ptry[index],
                                  thread_id[index]);
                   if (rc !=0)             /* look for thread done */
                       {
                       thread_id[index] = 0;
                       active_threads--;
                       }
                   }
               }
           if (active_threads > 0)
               rc = DosSleep(3000l);       /* Sleep for three seconds */
                                           /* and try again */
           }

       CWRITELOG(L_WARN,0,
                (l_log," exiting 2nd thread updates of files\n"));

       CWRITELOG(L_TRACE,0,
                (l_log," entering 2nd stage verify of files\n"));

       rc = DosChgFilePtr(minput_handle, 0l, 0,    /* reset file pointers */
                          (Ulong far *) &temp);
       if (rc != 0) DosExit(0,0);

       rc = DosChgFilePtr(moutput_handle, 0l, 0,
                          (Ulong far *) &temp);
       if (rc != 0) DosExit(0,0);

       mread_size = 512;                           /* default to true cond */
       while (mread_size == 512)                   /* make duplicate of file */
           {
           rc = DosRead(minput_handle, (char far *) buffer_one,
                        512, (Uint far *) &mread_size);
           if (rc != 0) DosExit(0,0);
           if (mread_size == 0)
               break;                              /* break loop if zero size */
           rc = DosRead(moutput_handle, (char far *) buffer_two,
                        mread_size, (Uint far *) &msread_size);
           if (rc != 0) DosExit(0,0);
           if (msread_size != mread_size)
               {
               CWRITELOG(L_ABORT, -1,
                        (l_log,"  verify read size %4d != %4d read size\n",
                           msread_size, mread_size));
               DosExit(0,0);
               }
           for (index = 0; index < msread_size;index++)
               if (buffer_one[index] != buffer_two[index])
                   {
                   CWRITELOG(L_ABORT, -1,
                            (l_log," Miss-match in files  %d, %d %d\n",
                              index, buffer_one[index], buffer_two[index]));
                   DosExit(0,0);
                   }
           }

       CWRITELOG(L_WARN,0,
                (l_log," exiting 2nd stage verify of files\n"));



       DosExit(0,0);                   /* kill only this thread */
                                       /* all other threads should be done */
}

/**/
void far copy_thread(seed,offset_value)
/*

       This routine performs actual copy function.
       Each entry into this routine is a seperate thread.


       Open file.        /shared read-write /
       if (error open file)
            then  abort thread
       Get input file size.
       Divide file into a 10 element table buffers.

copy_loop:
       if (done with copy)
           goto copy_done.
       get random table index value.
       get_random number from 1 to 2048 bytes.
       Lock file range.
       read file (random size)
       if (error open input file)
            then  abort thread.
       add value to each char in buffer;
       write buffer to output file (random size)
       unlock file range.
       goto copy_loop;

copy_done:
       close files
       inc files_copied.
       exit thread.


abort_thread:
       dec threads active.
       inc threads aborted.
       copy file name - failed.
       exit thread.
*/
Uint   seed;                           /* starting seed value */
Uint   offset_value;                   /* contains offset value for file*/
                                       /* add from parent thread */
{
       int     index;                  /* working variable */
       int     medium_seed = 1;        /* define begginning file seed */
       int     small_seed = seed;      /* define table index seed */
       int     rc;                     /* error return code */

       Uint    cread_size = 0;         /* number of bytes to read */
       Uint    csread_size;            /* number of bytes read from file */
       Uint    cwrite_size = 0;        /* number of bytes to write */

       Uint    rw_handle;              /* thread file handle */
       Uint    action_taken;           /* action taken by file opens */
       Ulong   file_offset = 0;        /* file offset to point to */
       Ulong   file_size;              /* number of byte to read */
       Ulong   returned_offset;        /* returned file offset */
       Ulong   temp;                   /* working variable */

       Ulong   bytes_read = 0;         /* number of bytes read */
       Ulong   retry_time;             /* amount of sleep time between */
                                       /* dos file lock retries */

       struct  FileStatus input_info;  /* input information */
       struct  FileStatus output_info; /* output information */

       struct  file_locks              /* lock structure for updates */
           {
           Ulong   offset;
           Ulong   size;
           }   lock_area;              /* define lock area */

       Ulong   remain_offset[10];      /* table of offsets to be read */
       Ulong   remain_size[10];        /* table of block sizes to be read */

       char    file_buffer[2048];      /* buffer for disk read and copy */
                                       /* writes */

       rc = DosOpen((char far *) output_path,
                   (Uint far *) &rw_handle,
                   (Uint far *) &action_taken,
                   (Ulong) 0,              /* make intial alloc = 0*/
                   0x0000,                 /* standard attributes */
                   0x0001,                 /* open existing file only.*/
                   0x0040,0l);             /* normal read only open */
                                           /* allow other r/w access */
       if (rc != 0 || action_taken != 1)
           {
           threads_aborted++;
           CWRITELOG(L_ABORT,0,
                    (l_log," thread was unable to open file %s %4.4x \n",
                           output_path, action_taken));
           DosExit(0,0);
           }

       rc = DosChgFilePtr(rw_handle, 0l , 2,
                          (Ulong far *) &file_size);

       if (rc != 0)
           {
           threads_aborted++;
           CWRITELOG(L_ABORT,0,
                    (l_log," thread was unable to determind file size %s %8ld \n",
                           output_path, file_size));
           DosExit(0,0);
           }

       for (index = 0; index < 10; index++)   /* build array of allocations */
           {
           temp = file_size / 10;
           remain_offset[index] = file_offset;
           remain_size[index] = temp;
           file_offset = file_offset + temp;
           }

       remain_size[9] =  remain_size[9] + file_size % 10;
                                               /* add any leftovers in last */
                                               /*  table entry */

copy_data:
       if (bytes_read >= file_size)
           goto copy_done;                     /* check for completion here */
       small_seed = small_random(small_seed);  /* get random table index value*/
       index = small_seed - 1;                 /* convert random no to index */
       file_offset = remain_offset[index];     /* get starting offset */
       medium_seed = medium_random(medium_seed);
       cread_size = min( medium_seed, remain_size[index]);
                                               /* check if size > block remain*/
       if (cread_size == 0)                    /* don't attempt to copy 0 byte*/
           goto copy_data;                     /* table entries */

       remain_offset[index] = remain_offset[index] + cread_size;
                                               /* increment table offset start*/
       remain_size[index] = remain_size[index] - cread_size;
                                               /* also subtract remain size */
                                               /* of table entry.*/
       csread_size = cread_size;

       lock_area.offset = file_offset;
       lock_area.size = cread_size;
       retry_time = 0;

retry_locks:
       rc = DosFileLocks(rw_handle,(long far *) 0l,
                           (long far *) (struct file_locks far *)
                           &lock_area);
       if (rc != 0)
           {
           if (retry_time > 60000l)
               {
               CWRITELOG(L_ABORT, -1,
                        (l_log," aborting file locks, too much time %ld %ld %ld\n",
                           lock_area.offset, lock_area.size, retry_time));
               goto abort_thread;
               }
           DosSleep(retry_time);
           retry_time = retry_time * 2 + 1000l;
           goto retry_locks;
           }


       rc = DosChgFilePtr(rw_handle, file_offset, 0,
                          (Ulong far *) &returned_offset);

       if (rc != 0)
           {
           threads_aborted++;
           CWRITELOG(L_ABORT,0,
                    (l_log," thread was unable to set file ptr %s\n",
                       output_path));
           DosExit(0,0);
           }

       if (file_offset != returned_offset)
           {
           threads_aborted++;
           CWRITELOG(L_ABORT,0,
                    (l_log," thread was unable to set file ptr %s %8ld %8ld\n",
                       output_path, file_offset, returned_offset));
           DosExit(0,0);
           }

       rc = DosRead(rw_handle,
                    (char far *) file_buffer,
                    cread_size,
                    (Uint far *) &csread_size);
       bytes_read += cread_size;
       if (rc != 0)
           {
           CWRITELOG(L_ABORT,rc,
                    (l_log," error in dos read,  bytes read = %ld\n",
                           bytes_read));
           goto abort_thread;
           }
       if (csread_size != cread_size)
           {
           CWRITELOG(L_ABORT,rc,
                    (l_log," error in dos read,  bytes read = %ld, %d, %d\n",
                           bytes_read,csread_size, cread_size));
           goto abort_thread;
           }

       for (index = 0; index < cread_size; cread_size++);
           file_buffer[index] += offset_value;  /* add offset to buffer chars */

       rc = DosWrite(rw_handle,
                     (char far *) file_buffer,
                     csread_size,
                     (Uint far *) &cwrite_size);
       if (rc != 0)
           {
           threads_aborted++;
           CWRITELOG(L_ABORT,rc,
                    (l_log," error in dos write,  stats = %ld %d %d\n",
                           bytes_read,csread_size,cwrite_size));
           goto abort_thread;
           }

       rc = DosFileLocks(rw_handle, (long far *) (struct file_locks far *)
                           &lock_area, (long far *) 0l);
       if (rc != 0)                    /* check for unlock error */
           {
           CWRITELOG(L_ABORT, -1,
                    (l_log," aborting file unlocks, error %ld %ld %d\n",
                       lock_area.offset, lock_area.size, rc));
           goto abort_thread;
           }

       if (bytes_read < file_size && cwrite_size == cread_size)
           goto copy_data;

       if (cwrite_size != cread_size)
           {
           CWRITELOG(L_ABORT,-1,
                    (l_log," can't overwrite existing file area\n"));
           goto abort_thread;
           }

copy_done:
       threads_completed++;
       rc = DosClose(rw_handle);

       DosExit(0,0);

abort_thread:
       threads_aborted++;
       CWRITELOG(L_ABORT,-1,
                (l_log," thread aborting ***\n"));
       rc = DosClose(rw_handle);
       DosExit(0,0);                   /* Quit copy thread */
}

/**/

small_random(seed)
/*
       This subroutine creates a pesudo random number between
       1 and 10. The random number is passed back via the
       return code.

       No errors are normally possible.
*/
Uint   seed;
{
       seed = (seed * 7) % 11;
       return(seed);
}

medium_random(seed)
/*
       This subroutine creates a pesudo random number between
       1 and 2011. The random number is passed back via the
       return code.

       No errors are normally possible.

*/
Uint   seed;
{
       seed = (seed * 17) % 2011;
       return(seed);
}


void far control_c()
/*

       routine for processing cntrl-c signal.

           Control- c Signal handler Routine, simply terminates
           program so that default processing will not be used.

*/
{
       CWRITELOG(L_TRACE, 0,
                (l_log,"Entering control_c signal processing routine\n"));

       CWRITELOG(L_WARN, 0,
                (l_log,"Exiting control_c signal processing routine\n"));

       DosExit(1,0);                   /* terminate program  */
                                       /* don't restore cntrl-c */

}

/**/
void far exit_program()
/*

       Used in exit list processing to closelog, and stop
         timers correctly. Exits special processing
         by calling DOSEXITLIST fcncode = 3;

*/
{
       int     rc;

       CWRITELOG(L_TRACE, 0,
                (l_log,"Entering exit_program processing \n"));

       CWRITELOG(5,0,
                (l_log," active threads = %d\n",active_threads));
       CWRITELOG(5,0,
                (l_log," threads started = %d\n",threads_started));
       CWRITELOG(5,0,
                (l_log," threads completed = %d\n",threads_completed));
       CWRITELOG(5,0,
                (l_log," threads aborted = %d\n",threads_aborted));

       CWRITELOG(L_WARN, 0,
                (l_log,"Exiting exit_program processing \n"));

       if (threads_completed == threads_started && copy_ok)
           str = "PASS";                   /* set to pass condition */

       CLOSELOG(str,(l_log,"\n"));       /* close log file with str indicator */

       rc = DosExitList(3,(void (far *)()) exit_program);
                                           /* processing completed */
       DosExit(1,-1);                      /* re-issue just in case */
}
  S 437,0001
