/*


       Program ID      :   STR008as.c (Concurrent sequential copy testcase)


       Author          :   Tim Keating
                           Contractor  - "The Experts"
                           IBM System Test Group, Delray beach, Fl


       Date written    :   08/20/86
       Date revised    :   08/22/86

       External
       Subroutines
       Linked          :   Writelog subsystem

                           DosExitList
                           DosExit
                           DosSetSigHandler
                           DosCreateThread
                           DosOpen
                           DosRead
                           DosWrite
                           DosClose
                           DosFindFirst
                           DosFindNext
                           DosFindClose
                           DosQueryFileInfo
                           DosQCurDisk
                           DosQCurDir
                           DosSetMaxFH
                           DosSetFileInfo
                           DosQFileInfo
                           DosSleep


       Comments        :     Executes like the current copy command.
                           It will use wild card chars for files to copy
                           and it display each file name as it copies.
                           If /n switch is specified then mulitple copy
                           threads are started and as each one completes
                           another is started.  Each new thread will copy
                           a seperate file.

                           cmd line
                               str008rs path.spec opt.spec -n99 -m9999

                path.spec  input path with wild card specs.
                opt.sec    optional output spec. (must be a directory).
                -n99       number of threads 1-16 printing. 1 default.
                -m99999    copy open mode flags. 0x00A1 default.


                           max number of threads is 16.

                               Open log file.
                               Set Cntrl-c handler.
                               Set exit vector to closelog.
                               phase command line args.
                               Write starting message.

                               DosFindFirst -- find first matching file.
                               check output path if null then
                                  Query current disk & directory.
                                  and put into output path.

                               check for directory in output path spec.

                           main_loop:
                               DosQueryFileInfo -- confirm output file ok.
                               CreateCopyThread.
                               inc active_threads;
                               if active_threads => max_switch then
                                   sleep until copy_threads
                               DosFindNext match.
                               repeat until matches complete.
                               wait until active_threads = 0;
                                  while waiting query each thread ptry.
                                  if error report to log and
                                     decrement active_threads.

                           copy_thread:
                               don't retry hard errors.
                               open input file in given buffer.
                               open output file.
                               if output file reports error then
                                   abort thread.

                           copy_loop:
                               don't retry hard errors.
                               read sequential random size between 1 and 2048
                                   bytes.
                               write same buffer to output file.
                               if read-size = requested-size then
                                   goto copy_loop.
                               close input file
                               close output file.
                               inc files_printed.
                               inc threads_completed.
                               hprintf file name to stdout.
                               DosExit(0,0);

                           cntrl_c_vector:
                               write log message.
                               write threads active message--aborting.
                               due DosExit(1,0); -- kill all threads.

                           exit_vector:
                               write ending log message.
                               close log.
                               exit program.




*/
#include <testlog.h>
#include <cpcalls.h>
#define Uint   unsigned int
#define Ulong  unsigned long

void far exit_program();
void far control_c();
void far copy_thread();

char   *str;                           /* pass fail indicator */
char   input_path[70] = "";            /* input path buffer */
char   output_path[70] = "";           /* output print path buffer */
                                       /* default to prn device */
char   input_pass[80];                 /* pass to copy thread path buffer */
char   output_pass[80];                /* pass to copy thread path buffer */

int    active_threads = 0;             /* zero out counters */
int    files_copied = 0;
int    threads_started = 0;
int    threads_completed = 0;
int    threads_aborted = 0;

Uint   open_mode = 0x00A1;             /* default print file open mode */

Uint   thread_id[16];                  /* thread id's of executing threads */
Uint   thread_ptry[16];                /* print thread prioritys */
Uint   thread_stack[16][1500];         /* reserve statck for 16 threads */
                                       /* executing at same time, each thread */
                                       /* needs at least 3000 bytes of stack */

extern long    M_switch;               /* reference switches from addn_arg */
extern long    N_switch;

/**/
main(argc, argv, envp)

int argc;                              /* number of command line args */
char **argv;                           /* command line arguments pointers */
char **envp;                           /* environment variables pointers*/
{
       int     rc;                     /* error return code variable */
       int     regs;                   /* starting pass value */
       int     index,count;            /* work values*/
       Ulong   return_val;             /* returned value from function */
       Ulong   prev_handler;           /* previous sig handle address */
       Uint    prev_action;            /* previous action dor sig hand */

       Uint    dir_handle = 0xffff;    /* initialise dir handle for create */
       Uint    match_count = 1;        /* match one file at start */
       Uint    max_file_handles;       /* number of file handles to alloc */

       Uint    file_attrib;            /* returned file attrib from query */
       Uint    drive_number;           /* drive number returned */
       Ulong   drive_map;              /* map of installed drives */
       Uint    path_size;              /* size of output path spec */

       struct  FileFindBuf search_buf; /* allocate storage for search buffer */

       M_switch = open_mode;           /* default m_switch to open default */
       get_cmd_arg(argc, argv);        /* read command line arguments */
       get_addn_arg(argc, argv);       /* read command line arguments */
       open_mode = M_switch;           /* get new open mode if user entered */
                                       /* -m switch */
       str = "FAIL";                   /* default to failed condition */
       OPENLOG("STR008as");            /* open the log file in the root */

       CWRITELOG(L_HDR, 0,
                (l_log," STR008AS concurrent sequential copy stress test\n"));

       if (N_switch > 16)
           {
           CWRITELOG(L_DEBUG,-1,
                    (l_log,"two many threads specified reduced to 16\n"));
           N_switch = 16;
           }
       if (N_switch == 0)
           N_switch = 1;

       rc = DosExitList(1,(void (far *)()) exit_program);
       if (rc != 0)
           exit_program();

                                       /* set up sig handler for cntrl - c*/
       rc = DosSetSigHandler( (void (far *)()) control_c,
                              (Ulong far *) &prev_handler,
                              (Uint far *) &prev_action,
                              2, 1);
       CWRITELOG(L_DEBUG, 0,
                (l_log," prev handler = %8.8lx, action = %4.4x \n",
                       prev_handler, prev_action ));
       if (rc != 0)
           DosExit(0,0);

       for(index = 1; index < argc; index++)
           {
           if( *(argv[index]) !=  '/' &&
               *(argv[index]) !=  '-' &&
               *(argv[index]) !=  ' ' &&
               *(argv[index]) !=  '#' )
               if (input_path[0] == 0 )
                   strcpy(input_path, argv[index]); /* get input path */
                 else
                   if (output_path[0] == 0 )
                       strcpy(output_path, argv[index]); /* get output path */
           }

       if (output_path[0] == 0)
           {
           rc = DosQCurDisk((Uint far *) &drive_number,
                            (Ulong far *) &drive_map);
           if (rc != 0)
               DosExit(0,0);
           path_size = sizeof(output_path) - 3;
           rc = DosQCurDir( drive_number,
                            (char far *) &output_path[3],
                            (Uint far *) &path_size);
           if (rc != 0)
               DosExit(0,0);

           output_path[0] = 'A' + drive_number - 1;/* put on drive number */
           output_path[1] = ':';                   /* put : in path */
           output_path[2] = '\\';                  /* put \ to start at root */
           output_path[path_size + 3] = 0;         /* tack on terminating null*/
           }

       path_size = strlen(output_path);
       if (path_size > 1)
           if (output_path[path_size-1] == '\\')           /* check for '/' */
               if (output_path[path_size-2] == ':')        /* check for ':' */
                   output_path[path_size-1] = 0;   /* zap any ending '\' */
                                                   /* except if in first pos */
                                                   /* or just after ':' */

       rc = DosQFileMode((char far *) output_path,
                         (Uint far *) &file_attrib,
                         0x0000000l);
       if (rc != 0)
           {
           hprintf(1l,"invalid target directory \n");
           CWRITELOG(L_ABORT,rc,
                    (l_log," invalid target directory [%s]\n",output_path));
           DosExit(0,0);
           }
       if ((file_attrib & 0x0010) == 0)
           if (output_path[path_size - 1] != ':' &&
               output_path[path_size - 1] != '\\' )
               {
               hprintf(1l,"target cannot be a file\n");
               CWRITELOG(L_ABORT,rc,
                        (l_log,"target [%s] is a file\n",output_path));
               DosExit(0,0);
               }

       rc =DosFindFirst( (char far *) input_path,
                         (Uint far *) &dir_handle,
                         0x0000,           /* look for normal handles */
                         (struct FileFindBuf far *) &search_buf,
                         sizeof(search_buf),
                         (Uint far *) &match_count,
                         0x000000l);
       if (rc != 0)
           DosExit(0,0);

       max_file_handles = N_switch * 2 + 4; /* set up max file handles as */
                                            /* follows */
                                            /* 1 - directory handle */
                                            /* 1 - stdin handle */
                                            /* 1 - stdout handle */
                                            /* 1 - stderr handle */
                                            /* 2 x N - handles for each thread*/

       rc = DosSetMaxFH(max_file_handles);
       if (rc !=0)
           DosExit(0,0);                    /* abort if not enough handles */

main_loop:
       search_buf.file_name[search_buf.string_len] = 0;
                                       /* tack on null terminator */
       strcpy(input_pass,input_path);
       strcpy(output_pass,output_path);
                                       /* zap wild card chars from path */
                                       /* also zap ending file name */
       if( (index = strlen(input_pass)) != 0 )
           for(; index >= 0 && input_pass[index] != ':' &&
               input_pass[index] != '\\'; index-- )
               input_pass[index]=0;
                                       /* now tack on file name from */
                                       /* directory search */
       if (output_pass[path_size - 1] != ':' &&
           output_pass[path_size - 1] != '\\' )
           {
           strcat(output_pass,"\\");
           }
       strcat(input_pass,search_buf.file_name);
       strcat(output_pass,search_buf.file_name);

       rc = DosQFileMode((char far *) input_pass,
                         (Uint far *) &file_attrib,
                         0x00000000l);
       if (rc != 0)
           DosExit(0,0);

       if ((file_attrib & 0x001f) != 0)
           {
           CWRITELOG(L_ABORT,file_attrib,
                    (l_log," invalid file attributes from search \n"));
           DosExit(0,0);
           }

       for (index = 0; index < 15 && thread_id[index] != 0 ; index++);
       if (index > 15)
           {
           CWRITELOG(L_ABORT,-1,
                    (l_log," unable to find open slot in thread table\n"));
           DosExit(0,0);
           }

       thread_stack[index][1499] = -1;  /* set flag for child */

                                       /* start child copy task */
       rc = DosCreateThread( (void (far *) ()) copy_thread,
                             (Uint far *) &thread_id[index],
                (char far *) (Uint far *) &thread_stack[index][1499]);

       threads_started++;
       active_threads++;

       for (count = 0; count < 30; count++)
           {
           rc = DosSleep(1l);          /* give up time slice */
           if (thread_stack[index][1499] == 0)
               count = 40;             /* check if thread has copied path */
                                       /* yet */
             else
               rc = DosSleep(1000l);   /* give up time slice for 1 second*/
           }

       if (count == 30)
           {
           CWRITELOG(L_ABORT,-1,
                    (l_log," child process #%4.4x index %d failed to start\n",
                       thread_id[index],index));
           DosExit(0,0);
           }

       while (active_threads >= N_switch)
           {
           for (index = 0; index < 16; index++)
               {
               if (thread_id[index] != 0)
                   {
                   rc = DosGetPrty(1,
                                  (Uint far *) &thread_ptry[index],
                                  thread_id[index]);
                   if (rc !=0)             /* look for thread done */
                       {
                       thread_id[index] = 0;
                       active_threads--;
                       }
                   }
               }
           if (active_threads >= N_switch)
               rc = DosSleep(3000l);       /* Sleep for three seconds */
                                           /* and try again */
           }


       rc =DosFindNext(dir_handle,
                       (struct FileFindBuf far *) &search_buf,
                       sizeof(search_buf),
                       (Uint far *) &match_count);
       if (rc == 0)
           goto main_loop;

       rc = DosFindClose(dir_handle);
       DosExit(0,0);                   /* kill only this thread */
                                       /* process will terminate */
                                       /* when all complete their jobs */
}

/**/
void far copy_thread(proceed_flag)
/*

       This routine performs actual copy function.
       Each entry into this routine is a seperate thread.

       Copy input_path into local storage.
       Open input file.        /shared read-write /
       if (error open input file)
            then  abort thread
       Open copy output file. /exclusive write/
       if (error on open output file) then
           sleep 3 seconds and try again.

copy_loop:
       get_random number from 1 to 2048 bytes.
       read input file (random size)
       if (error open input file)
            then  abort thread.
       write to output file (random size)
       if (error open input file)
            then  abort thread.
       if (not eof)
           goto copy_loop;
       close files
       inc files_copied.
       copy file name.
       exit thread.


abort_thread:
       dec threads active.
       inc threads aborted.
       copy file name - failed.
       exit thread.
*/

Uint   proceed_flag;                   /* flag to clear when ok for main */
                                       /* thread to continue */
{
       int     index;                  /* working variable */
       int     random_seed = 1;        /* define begginning file seed */
       int     rc;                     /* error return code */
       Uint    read_size = 0;          /* number of bytes to read */
       Uint    write_size = 0;         /* number of bytes to write */

       Uint    input_handle;           /* thread input file handle */
       Uint    output_handle;          /* thread output file handle */
       Uint    action_taken;           /* action taken by file opens */

       Ulong   bytes_read = 0;         /* number of bytes read */
       struct  FileStatus input_info;  /* input information */
       struct  FileStatus output_info; /* output information */

       char    input_path[80];         /* input file path */
       char    output_path[80];        /* output file path */
       char    file_buffer[2048];      /* buffer for disk read and copy */
                                       /* writes */

       for (index = 0; index < 80;index++)
           {
           input_path[index] = input_pass[index];
           output_path[index] = output_pass[index];
           }

       proceed_flag = 0;               /* clearing this variable will */
                                       /* allow main thread to continue */
                                       /* again. */

       rc = DosOpen((char far *) input_path,
                   (Uint far *) &input_handle,
                   (Uint far *) &action_taken,
                   (Ulong) 0,              /* make intial alloc = 0*/
                   0x0000,                 /* standard attributes */
                   0x0001,                 /* open existing file only.*/
                   0x0040,0l);             /* normal read only open */
                                           /* allow other r/w access */
       if (rc != 0 || action_taken != 1)
           {
           threads_aborted++;
           CWRITELOG(L_ABORT,0,
                    (l_log," thread was unable to open input file %s %4.4x \n",
                           input_path, action_taken));
           DosExit(0,0);
           }

       rc = DosOpen((char far *) output_path,
                    (Uint far *) &output_handle,
                    (Uint far *) &action_taken,
                    (Ulong) 0,             /* make intial alloc = 0*/
                    0x0000,                /* standard attributes */
                    0x0011,                /* open existing file */
                                           /* or create new one */
                    41,0l);                /* normal open with exclusive acc*/

/*                  open_mode,0l); */      /* normal open with exclusive acc*/

       if (rc != 0)
           {
           threads_aborted++;
           CWRITELOG(L_ABORT,0,
                    (l_log," thread was unable to open copy file %s %4.4x \n",
                           output_path, action_taken));
           DosExit(0,0);
           }

copy_data:
       random_seed = medium_random(random_seed);
       read_size = random_seed;
       rc = DosRead(input_handle,
                    (char far *) file_buffer,
                    2048,
                    (Uint far *) &read_size);
       bytes_read += read_size;
       if (rc != 0)
           {
           threads_aborted++;
           CWRITELOG(L_ABORT,rc,
                    (l_log," error in dos read,  bytes read = %ld\n",
                           bytes_read));
           goto abort_thread;
           }
       rc = DosWrite(output_handle,
                     (char far *) file_buffer,
                     read_size,
                     (Uint far *) &write_size);
       if (rc != 0)
           {
           threads_aborted++;
           CWRITELOG(L_ABORT,rc,
                    (l_log," error in dos write,  stats = %ld %d %d\n",
                           bytes_read,read_size,write_size));
           goto abort_thread;
           }
       if (read_size == random_seed && write_size == read_size)
           goto copy_data;

       if (write_size != read_size)
           {
           hprintf(1l,"%s -- disk full\n",input_path);
           goto abort_thread;
           }

       files_copied++;
       threads_completed++;
       hprintf(1l,"%s\n",input_path);

       rc = DosQFileInfo(input_handle, 1,
           (char far *) &input_info, sizeof(input_info));
       if (rc != 0)
           goto abort_thread;

       rc = DosQFileInfo(output_handle, 1,
           (char far *) &output_info, sizeof(output_info));
       if (rc != 0)
           goto abort_thread;

       if (input_info.file_size != output_info.file_size)
           {
           CWRITELOG(L_WARN,0,
                    (l_log," file sizes are different I%8.8lx O%8.8lx\n"));
           }

       rc = DosSetFileInfo(output_handle, 1,
                           (char far *) &input_info, 12);
       if (rc != 0)
           goto abort_thread;

       rc = DosClose(output_handle);   /* close files */
       rc = DosClose(input_handle);

       DosExit(0,0);

abort_thread:
       CWRITELOG(L_ABORT,-1,
                (l_log," thread aborting ***\n"));
       rc = DosClose(output_handle);   /* close files */
       rc = DosClose(input_handle);
       DosExit(0,0);                   /* Quit copy thread */
}

/**/
medium_random(seed)
/*
       This subroutine creates a pesudo random number between
       1 and 2011. The random number is passed back via the
       return code.

       No errors are normally possible.

*/
Uint   seed;
{
       seed = (seed * 19) % 2011;
       return(seed);
}


void far control_c()
/*

       routine for processing cntrl-c signal.

           Control- c Signal handler Routine, simply terminates
           program so that default processing will not be used.

*/
{
       CWRITELOG(L_TRACE, 0,
                (l_log,"Entering control_c signal processing routine\n"));

       CWRITELOG(L_WARN, 0,
                (l_log,"Exiting control_c signal processing routine\n"));

       DosExit(1,0);                   /* terminate program  */
                                       /* don't restore cntrl-c */

}

/**/
void far exit_program()
/*

       Used in exit list processing to closelog, and stop
         timers correctly. Exits special processing
         by calling DOSEXITLIST fcncode = 3;

*/
{
       int     rc;

       CWRITELOG(L_TRACE, 0,
                (l_log,"Entering exit_program processing \n"));

       CWRITELOG(5,0,
                (l_log," active threads = %d\n",active_threads));
       CWRITELOG(5,0,
                (l_log," files copied = %d\n",files_copied));
       CWRITELOG(5,0,
                (l_log," threads started = %d\n",threads_started));
       CWRITELOG(5,0,
                (l_log," threads completed = %d\n",threads_completed));
       CWRITELOG(5,0,
                (l_log," threads aborted = %d\n",threads_aborted));

       hprintf(1l,"%d files copied\n",files_copied);

       CWRITELOG(L_WARN, 0,
                (l_log,"Exiting exit_program processing \n"));

       if (files_copied == threads_started)
           str = "PASS";                   /* set to pass condition */

       CLOSELOG(str,(l_log,"\n"));       /* close log file with str indicator */

       rc = DosExitList(3,(void (far *)()) exit_program);
                                           /* processing completed */
       DosExit(1,-1);                      /* re-issue just in case */
}
  S 437,0003
