
       if (N_switch == 1)
           {
           CWRITELOG(L_HDR,0,
                    (l_log," stress testing Mono Display adpator \n"));
           cgd = 0;                    /* clear cgd display type */
           mdd = -1;                   /* set mono display type */
           egd = 0;                    /* clear ega display type */
           new_mode.length  = 12;      /* 12 bytes in struct */
           new_mode.type = 0x00;       /* mono text display, color burst off */
           new_mode.color = 0;         /* set to 0 color display */
           new_mode.col = 80;          /* eighty columns in display */
           new_mode.row = 25;          /* twenty five rows */
           new_mode.hres = 720;        /* 720 dots horzi res */
           new_mode.vres = 350;        /* 350 dots vertical res */
           }

       if (N_switch == 2)
           {
           CWRITELOG(L_HDR,0,
                    (l_log," stress testing Ega Display adpator \n"));
           cgd = 0;                    /* clear cgd display type */
           mdd = 0;                    /* clear mono display type */
           egd = -1;                   /* set ega display type */
           new_mode.length  = 12;      /* 12 bytes in struct */
           new_mode.type = 0x01;       /* color text, color burst on */
           new_mode.color = 4;         /* set to 16 color display */
           new_mode.col = 80;          /* eighty columns in display */
           new_mode.row = 25;          /* twenty five rows */
           new_mode.hres = 640;        /* 640 dots horzi res */
           new_mode.vres = 350;        /* 350 dots vertical res */
           }

       rc = DosExitList(1,(void (far *)()) exit_program);
       if (rc != 0)
           exit_program();
                                       /* set up sig handler for cntrl - c*/
       rc = DosSetSigHandler( (void (far *)()) control_c,
                              (Ulong far *) &prev_handler,
                              (Uint far *) &prev_action,
                              2, 1);
       CWRITELOG(L_DEBUG, 0,
                (l_log," prev handler = %8.8lx, action = %4.4x \n",
                       prev_handler, prev_action ));
       if (rc != 0)
           DosExit(0,0);

       rc = VioSetMode((struct ModeData far *) &new_mode, 0);
       if (rc)
           DosExit(1,0);

       start_up();
       clear_screen();

       CWRITELOG(5,0,
                (l_log,"PASS number 0 starting\n",loop));
       CWRITELOG(5,0,
                (l_log,"command string = %s\n",ptr));

       for(loop = 0; loop < M_switch; )
           {

           switch(*ptr++)
               {
               case 'A':       /* single character -- VioWrtNChar function */
                   phase_a();
                   break;
               case 'B':       /* single attribute -- VioWrtNAttr function */
                   phase_b();
                   break;
               case 'C':       /* single cell -- VioWrtNCell function */
                   phase_c();
                   break;
               case 'D':       /* single character -- VioWrtCharStr function */
                   phase_d();
                   break;
               case 'E':       /* single char -- VioWrtCharStrAttr function */
                   phase_e();
                   break;
               case 'F':       /* single cell -- VioWrtCellStr function */
                   phase_f();
                   break;
               case 'G':       /* single character -- VioWrtTTy function */
                   phase_g();
                   break;

               case 'H':       /* multiple character -- VioWrtNChar function */
                   phase_h();
                   break;
               case 'I':       /* multiple attribute -- VioWrtNAttr function */
                   phase_i();
                   break;
               case 'J':       /* Multiple cell -- VioWrtNCell function */
                   phase_j();
                   break;
  S 437,0019
