/**************************************************************************/
/*  MCONFIG.cmd -- Merlin stress test configuration utility               */
/*   ͻ    */
/*   Testcase title  :   STRESS INSTALL                                 */
/*                                                                      */
/*   Test name       :   CONFIG.CMD                                     */
/*                                                                      */
/*   Written by      :   Patrick Melli                                  */
/*                                                                      */
/*   Date created    :   05/10/88 for OS/2 1.10                         */
/*   Date updated    :   05/26/88 (Keith Schuettpelz)                   */
/*                                                                      */
/*                       numerous times   b                            */
/*                                        Fpr                           */
/*                                        Jdc                           */
/*                                        GDR                           */
/*                                                                      */
/*                       13 Nov 1996  JAK                               */
/*                       made into a REXX program so that stress        */
/*                       test directories can be added to current       */
/*                       PATH, DPATH, and LIBPATH, without              */
/*                       omitting most pre-defined directories.         */
/*                       Old non-REXX config.cmd omitted some           */
/*                       pre-defined directories.                       */
/*                                                                      */
/*   Testcase Notes  :   Appends Config.sys based on machine type       */
/*                                                                      */
/*   ͼ    */
/*  If there is no machine number then display parmlist                   */
/**************************************************************************/

parse arg machine oldfile newfile alt1 alt2

  /*----------------------------------------------------------------------*/
  /*                                                                      */
  /*----------------------------------------------------------------------*/
  if pos(':',oldfile) > 0 then
  do
    bdrv = translate(oldfile)
    oldfile = ''
  end
  else
    bdrv = 'C:'

  /*----------------------------------------------------------------------*/
  /*                                                                      */
  /*----------------------------------------------------------------------*/
  if pos(':',newfile) > 0 then
  do
    sdrv = translate(newfile)
    newfile = ''
  end
  else
    sdrv = 'D:'

  /*----------------------------------------------------------------------*/
  /* Carriage return & line feed should be at end of each config.sys      */
  /* line                                                                 */
  /*----------------------------------------------------------------------*/
  cr = x2c('0D')                                      /* carriage return  */

  /*----------------------------------------------------------------------*/
  /* Start of main program                                                */
  /*----------------------------------------------------------------------*/
  call defaults                       /* set defaults and initial values  */

  /*----------------------------------------------------------------------*/
  /* Valid machine types                                                  */
  /*----------------------------------------------------------------------*/
  validmachines = '03456789XYZTMP'       /* TWR machines handled in main  */

  /*----------------------------------------------------------------------*/
  /* Load REXX utilities routines                                         */
  /*----------------------------------------------------------------------*/
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs

  /*----------------------------------------------------------------------*/
  /* Make machine type uppercase                                          */
  /*----------------------------------------------------------------------*/
  machine = TRANSLATE(machine)

  /*----------------------------------------------------------------------*/
  /* See if the parameter is a proper machine type                        */
  /*----------------------------------------------------------------------*/
  if POS(machine,validmachines) > 0 | machine = 'TWR' then
  do
    call defaults                                /* set defaults          */
    cstring = loadfile(oldfile)                  /* load config.sys       */
    ncstring = setenv(cstring)                   /* set environment       */
    call writeconfig ncstring, oldfile, newfile; /* write new config.sys  */
    call writeos2init ncstring                   /* write os2init.cmd     */
    call writeautoexec ncstring                  /* write autoexec.bat    */
  end
  else
    call BADPARM

EXIT                                             /* end of main program   */




/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/
/*                                                                        */
/*                       S U B R O U T I N E S                            */
/*                                                                        */
/*------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*/

defaults:
/*ͻ*/
/* (defaults)           Set default values and initialize variables     */
/*ͼ*/

  /*----------------------------------------------------------------------*/
  /* Config file is config.sys on boot drive; the boot drive is passed    */
  /* in by the calling program (cmd file) but would have been specified   */
  /* by the user or defaults to the C: drive.                             */
  /*----------------------------------------------------------------------*/
  if oldfile = '' then oldfile = bdrv||'\config.sys'

  if oldfile = bdrv||'\config.mer' then
  do
    say 'cannot use 'bdrv'\config.mer as input file; using 'bdrv'\config.tmp instead'
    oldfile = bdrv||'\config.tmp'
  end

  if newfile = '' then newfile = bdrv||'\config.mer'

RETURN


/*ͻ*/
/* (badparm) Indicates that there is a bad parameter                    */
/*ͼ*/
badparm: procedure

say '-----------------------------------------------------------------------------'
say ' INVALID PARAMETER SPECIFIED: MACHINE NUMBER     =' machine
say ''
say ' FOR ^<MACHINE NUMBER^> = 3,4,5,6,7,TWR,8,9,X,Y,T,M,P, or Z USE:'
say ''
say '    A:\M-STRESS  ^<MACHINE_NUMBER^>  ONLY  CONFIG'
say ''
say ' OR USE ^<MACHINE NUMBER^> = 0 FOR GENERIC STRESS MACHINE'
say ''
say '-----------------------------------------------------------------------------'
say ''
say ''
say '----------------------^> CONFIG.SYS will not be appended. ^<----------------------'
say ''
'pause'

RETURN



/*ͻ*/
/* (setenv) Sets environment settings in string memory                  */
/*ͼ*/
setenv: procedure expose machine bdrv sdrv

arg InString

  'echo [46;37m'
  say ' '
  say 'Beginning CONFIG phase of Mstress . . .'

  /*----------------------------------------------------------------------*/
  /* Copy argument configuration string into a working string and use     */
  /* the working string throughout the routine                            */
  /*----------------------------------------------------------------------*/
  wstring = InString

  say 'Setting up environment variables'

  /*----------------------------------------------------------------------*/
  /* Set DISPLAYSYM to be VGA as the default and then modify if           */
  /* necessary.                                                           */
  /*----------------------------------------------------------------------*/
  dsym = 'SET DISPLAYSYM=VGA'

  /*----------------------------------------------------------------------*/
  /* Set DISPLAYSYM via machine type                                      */
  /*----------------------------------------------------------------------*/
  select
    /*--------------------------------------------------------------------*/
    when machine = '3' then                    /* STRESS MACHINES 3       */
      dsym = 'SET DISPLAYSYM=EGA'
    /*--------------------------------------------------------------------*/
    when machine = '7' then                    /* STRESS MACHINES 7       */
      dsym = 'SET DISPLAYSYM=8514'
    /*--------------------------------------------------------------------*/
    when machine = 'TWR' then                  /* STRESS MACHINES TWR     */
    do
      set DISKCACHE=128
      ECHO DISKCACHE = 128 >>bdrv\CONFIG.SYS
    end
    /*--------------------------------------------------------------------*/
    otherwise                                  /* GENERIC STRESS MACHINE  */
      machine = '0'
  end

  /*----------------------------------------------------------------------*/
  /* Set PARTITIONS via SysDriveMap                                       */
  /*----------------------------------------------------------------------*/
  map = SysDriveMap('C:','USED')         /* drive map will be C: D: etc.  */

  tj = 1

  numwords = WORDS(map)

  do while tj <= numwords
    drvltr = SUBWORD(map,tj,1)

    if SysDriveInfo(drvltr) = '' then
    do
      map = DELWORD(map,tj,1)
      tj = tj - 1
      numwords = numwords - 1
    end

    tj = tj + 1
  end

  partitions = ''
  maplength = LENGTH(map)

  do i = 1 to maplength                           /* omit the colons (:)  */
    if substr(map,i,1) \= ':' then
      partitions = partitions || substr(map,i,1)
  end

  partitions = 'SET PARTITIONS=' || partitions

  /*----------------------------------------------------------------------*/
  /* Retrieve original LIBPATH                                            */
  /*----------------------------------------------------------------------*/
  lpstart = POS('LIBPATH',wstring,1)          /* find 1st LIBPATH         */
  lpend = POS(x2c('0D'),wstring,lpstart)      /* ends at inserted return  */
  lpdelim = SUBSTR(wstring,lpend-1,1)         /* check last character     */
  lplen = lpend - lpstart                     /* original LIBPATH length  */

  if lpdelim = ';' then
    appender = sdrv'\NEW;'sdrv'\STRESS;'
  else
    appender = ';'sdrv'\NEW;'sdrv'\STRESS;'

  /*----------------------------------------------------------------------*/
  /* Make new LIBPATH with stress directory added                         */
  /*----------------------------------------------------------------------*/
  newlpath = SUBSTR(wstring,lpstart,lplen) || appender || x2c('0D')

  /*----------------------------------------------------------------------*/
  /* Retrieve original PATH                                               */
  /*----------------------------------------------------------------------*/
  pstart = POS('SET PATH=',wstring,1)          /* find 1st PATH           */
  pend = POS(x2c('0D'),wstring,pstart)         /* ends at inserted return */
  pdelim = SUBSTR(wstring,pend-1,1)            /* check last character    */
  plen = pend - pstart                         /* original PATH length    */

  if pdelim = ';' then
    appender = sdrv'\CMD;'sdrv'\E3;'sdrv'\NEW;'sdrv'\STRESS;'sdrv'\UTIL;'
  else
    appender = ';'sdrv'\CMD;'sdrv'\E3;'sdrv'\NEW;'sdrv'\STRESS;'sdrv'\UTIL;'

  /*----------------------------------------------------------------------*/
  /* Make new PATH with stress directories added                          */
  /*----------------------------------------------------------------------*/
  newpath = SUBSTR(wstring,pstart,plen) || appender || x2c('0D')

  /*----------------------------------------------------------------------*/
  /* Retrieve original DPATH                                              */
  /*----------------------------------------------------------------------*/
  dpstart = POS('SET DPATH=',wstring,1)        /* find 1st DPATH          */
  dpend = POS(x2c('0D'),wstring,dpstart)       /* ends at inserted return */
  dpdelim = SUBSTR(wstring,dpend-1,1)          /* check last character    */
  dplen = dpend - dpstart                      /* original DPATH length   */

  if dpdelim = ';' then
    appender = sdrv'\CMD;'sdrv'\E3;'sdrv'\NEW;'sdrv'\STRESS;'sdrv'\UTIL;'sdrv'\SCRIPT;'
  else
    appender = ';'sdrv'\CMD;'sdrv'\E3;'sdrv'\NEW;'sdrv'\STRESS;'sdrv'\UTIL;'sdrv'\SCRIPT;'

  /*----------------------------------------------------------------------*/
  /* Make new DPATH with stress directories added                         */
  /*----------------------------------------------------------------------*/
  newdpath = SUBSTR(wstring,dpstart,dplen) || appender || x2c('0D')

  /*----------------------------------------------------------------------*/
  /* Retrieve original HELP environment variable expression               */
  /*----------------------------------------------------------------------*/
  hstart = POS('SET HELP=',wstring,1)         /* find 1st HELP            */
  hend = POS(x2c('0D'),wstring,hstart)        /* ends at inserted return  */
  hdelim = SUBSTR(wstring,hend-1,1)           /* check last character     */
  hlen = hend - hstart                        /* original HELP length     */

  if hdelim = ';' then
    appender = sdrv'\NEW;'sdrv'\STRESS;'
  else
    appender = ';'sdrv'\NEW;'sdrv'\STRESS;'

  /*----------------------------------------------------------------------*/
  /* Make new HELP command with stress directory added                    */
  /*----------------------------------------------------------------------*/
  newhelp = SUBSTR(wstring,hstart,hlen) || appender || x2c('0D')

  /*----------------------------------------------------------------------*/
  /* Make one big string out of all the additional settings.  Remember    */
  /* to add a carriage return at the end of each line.  The carriage      */
  /* returns will be taken off when the new config.sys is created by      */
  /* calling writefile                                                    */
  /*----------------------------------------------------------------------*/
  asettings = 'SET VERSION=CRUISER'           || x2c('0D')
  asettings = asettings || partitions         || x2c('0D')
  asettings = asettings || dsym               || x2c('0D')
  asettings = asettings || 'MAXWAIT=3'        || x2c('0D')
  asettings = asettings || 'THREADS=512'      || x2c('0D')
  asettings = asettings || 'BREAK=ON'         || x2c('0D')
  asettings = asettings || 'TIMESLICE=64,192' || x2c('0D')
  asettings = asettings || 'TRAPDUMP=OFF'     || x2c('0D')
  asettings = asettings || 'BUFFERS=50'       || x2c('0D')
  pshell = 'PROTSHELL='bdrv'\OS2\PMSHELL.EXE 'bdrv'\OS2\OS2.INI 'bdrv'\OS2\OS2SYS.INI '
  pshell = pshell || bdrv || '\OS2\CMD.EXE /K 'bdrv'\OS2INIT.CMD'
  asettings = asettings || pshell             || x2c('0D')
  asettings = asettings || 'IOPL=YES'         || x2c('0D')
  asettings = asettings || 'PAUSEONERROR=NO'  || x2c('0D')

  if machine = 'X' then
    asettings = asettings || 'DISKCACHE = 128' || x2c('0D')

  if machine = 'TWR' then
    asettings = asettings || 'DISKCACHE = 128' || x2c('0D')

  /*----------------------------------------------------------------------*/
  /* Add new libpath, path, dpath, and help to configuration string       */
  /*----------------------------------------------------------------------*/
  OutString = wstring || newlpath || newpath || newdpath || newhelp

  /*----------------------------------------------------------------------*/
  /* Add additional settings to the configuration string                  */
  /*----------------------------------------------------------------------*/
  OutString = OutString || asettings

RETURN OutString



/*ͻ*/
/* (loadfile) function to read a file into a string and                 */
/*            return that string to the caller                          */
/*ͼ*/
loadfile: procedure

parse arg InputName

  if stream( InputName, 'C', 'query exists') = '' then
  do
    message = 'Cannot find ' || filename || '; exiting.'
    say message
    EXIT
  end

  cond = stream( InputName, 'C', 'open read' )          /* open file */

  stringout = ''
  IsLine = lines( InputName )

  if IsLine = 1 then I = 1

  do while IsLine = 1
    stringin = linein( InputName,,1 )
    stringout = stringout || stringin || x2c('0D')
    IsLine = lines( InputName )
    if IsLine = 1 then I = I + 1
  end

  nlines = I
  cond = stream( InputName, 'C', 'close' )          /* close file */

RETURN stringout



/*ͻ*/
/* (writeconfig) Function to write new config.sys from a string         */
/*               containing carriage return at end of each              */
/*               line; removes cr's before writing each line            */
/*ͼ*/
writeconfig: procedure expose bdrv sdrv

arg OutString, oldfile, newfile

  wstring = OutString               /* working copy of output string */
  outline = ''                      /* each line of file to be built */

  OutputName = newfile

  /*----------------------------------------------------------------------*/
  /* If a previous version of new file exists, delete it                  */
  /*----------------------------------------------------------------------*/
  if stream(OutputName,'C','query exists') \= '' then
    'erase' OutputName

  cond = stream(OutputName,'C','open write')   /* open new config.sys     */

  LineNumber = 0

  say ' '
  say 'APPENDING CORRECTIONS TO CONFIG.SYS'
  say ' '

  /*----------------------------------------------------------------------*/
  /* Assume at outset that locker statements are not already there        */
  /*----------------------------------------------------------------------*/
  locker = 'N'
  lock32 = 'N'

  /*----------------------------------------------------------------------*/
  /* Loop for writing lines to new config.sys                             */
  /*----------------------------------------------------------------------*/
  do while wstring \= ''                 /* working string non-null?      */
    LineNumber = LineNumber + 1          /* increment line number         */
    oend = POS(x2c('0D'),wstring,1)      /* look for carriage return      */
    oenda = oend - 1                     /* one before is end of command  */
    oendb = oend + 1                     /* one after is rest of string   */
    outline = SUBSTR(wstring,1,oenda)    /* get one line, out to cr       */
    outlineu = TRANSLATE(outline)        /* make uppercase                */

    /*--------------------------------------------------------------------*/
    /* Exclude locker statements pointing to drive C:                     */
    /*--------------------------------------------------------------------*/
    lockerc = 'N'

    if SUBSTR(outlineu,1,20) = 'DEVICE='bdrv'\LOCKER.SYS' then
      lockerc = 'Y'

    if SUBSTR(outlineu,1,20) = 'DEVICE='bdrv'\LOCK32.SYS' then
      lockerc = 'Y'

    if lockerc \= 'Y' then                  /* not locker on C: drive?    */
    do
      cond = LINEOUT(OutputName,outline)    /* write that line to file    */

      if LineNumber > nlines then           /* display each line added    */
        say outline;
    end

    /*--------------------------------------------------------------------*/
    /* See if the locker statements are there already                     */
    /*--------------------------------------------------------------------*/
    if outlineu = 'DEVICE='sdrv'\STRESS\LOCKER.SYS' then locker = 'Y'
    if outlineu = 'DEVICE='sdrv'\STRESS\LOCK32.SYS' then lock32 = 'Y'

    /*--------------------------------------------------------------------*/
    /* See if there are more lines to write                               */
    /*--------------------------------------------------------------------*/
    if oend < LENGTH(wstring) then       /* more lines to write?          */
      wstring = SUBSTR(wstring,oendb)    /* cut line just written         */
    else                                 /* no more lines to write?       */
      wstring = ''                       /* break out of loop             */
  end

  /*----------------------------------------------------------------------*/
  /* Add the locker statements if not there already                       */
  /*----------------------------------------------------------------------*/
  if locker = 'N' then
  do
    cond = LINEOUT(OutputName,'DEVICE='sdrv'\STRESS\LOCKER.SYS')
    say 'DEVICE='sdrv'\STRESS\LOCKER.SYS'
  end

  if lock32 = 'N' then
  do
    cond = LINEOUT(OutputName,'DEVICE='sdrv'\STRESS\LOCK32.SYS')
    say 'DEVICE='sdrv'\STRESS\LOCK32.SYS'
  end

  cond = LINEOUT(OutputName)               /* close new config.sys       */

  b4stress = bdrv||'\config.b4s'

  if stream( b4stress, 'C', 'query exists') = '' then
    'copy' oldfile bdrv||'\config.b4s'     /* rename old config.sys      */

  'copy' newfile bdrv||'\config.sys'       /* rename new config.sys      */

RETURN



/*ͻ*/
/* (writeos2init) function to write an os2init.cmd with PATH, DPATH,    */
/*                HELP, and stress setup statements                     */
/*ͼ*/
writeos2init: procedure expose bdrv sdrv

arg OutString

  wstring = OutString               /* working copy of output string */
  outline = ''                      /* each line of file to be built */

  OutputName = bdrv'\os2init.cmd'
  OldOS2Name = bdrv'\os2init.old'

  if stream( OutputName, 'C', 'query exists') \= '' then
  do
    'copy' OutputName OldOS2Name
    'erase' OutputName
  end

  say ' '
  say 'APPENDING CORRECTIONS TO OS2INIT.CMD'
  say ' '


  /*----------------------------------------------------------------------*/
  /* Write stress setup statements to file                                */
  /*----------------------------------------------------*-----------------*/
  outline = 'if exist 'sdrv'\log\bin*.* attrib -r 'sdrv'\log\bin*.*'
  cond = LINEOUT(OutputName,outline)         /* write that line to file   */
  say outline                                /* show it on screen         */
  outline = sdrv
  cond = LINEOUT(OutputName,outline)         /* write that line to file   */
  say outline                                /* show it on screen         */
  outline = 'cd \log'
  cond = LINEOUT(OutputName,outline)         /* write that line to file   */
  say outline                                /* show it on screen         */
  outline = 'cls'
  cond = LINEOUT(OutputName,outline)         /* write that line to file   */
  say outline                                /* show it on screen         */
  cond = LINEOUT(OutputName)                 /* close new os2init.cmd     */

RETURN



/*ͻ*/
/* (writeautoexec) function to write an autoexec.bat with PATH, APPEND, */
/*                 and stress setup statements                          */
/*ͼ*/
writeautoexec: procedure expose bdrv sdrv

arg OutString

  wstring = OutString                   /* working copy of output string  */
  outline = ''                          /* each line of file to be built  */

  OutputName = bdrv'\autoexec.bat'
  B4StressAutoExec = bdrv'\autoexec.b4s'

  if stream( B4StressAutoExec, 'C', 'query exists') \= '' then
    'copy 'B4StressAutoExec OutputName
  else
    'copy 'OutputName B4StressAutoExec


  say ' '
  say 'APPENDING CORRECTIONS TO AUTOEXEC.BAT'
  say ' '

  /*----------------------------------------------------------------------*/
  /* Retrieve PATH statement                                              */
  /*----------------------------------------------------------------------*/
  pathfound = 0                              /* when found, set to 1      */
  pstart = POS('PATH=',wstring,1)            /* find PATH statement       */

  do while pathfound = 0
    pend = POS(x2c('0D'),wstring,pstart)     /* ends at inserted return   */
    pprev = pstart-1                         /* check character before    */

    if pprev > 0 then                        /* not at start of wstring   */
    do
      pcharb4 = SUBSTR(wstring,pprev,1)      /* check character before    */

      /*------------------------------------------------------------------*/
      /* if cr or blank before PATH, then PATH statement is found         */
      /*------------------------------------------------------------------*/
      if pcharb4 = x2c('0D') | pcharb4 = ' ' then
        pathfound = 1                        /* then PATH was found       */
      else                                   /* must be LIBPATH or DPATH  */
        pstart = POS('PATH',wstring,pend)    /* keep looking for PATH     */
    end
    else                                     /* PATH was 1st in wstring   */
      pathfound = 1                          /* so PATH was found         */
  end

  pend = POS(x2c('0D'),wstring,pstart)       /* ends at inserted return   */
  pendl = pend - pstart                      /* length of PATH command    */
  outline = SUBSTR(wstring,pstart,pendl)     /* get one line, out to cr   */

  /*----------------------------------------------------------------------*/
  /* Append stress directories                                            */
  /*----------------------------------------------------------------------*/
  pend = LENGTH(outline)                     /* find end of PATH          */
  pdelim = SUBSTR(outline,pend,1)            /* get last character        */

  if pdelim = ';' then
    appender = sdrv'\CMD;'sdrv'\UTIL;'sdrv'\NEW;'sdrv'\STRESS;'
  else
    appender = ';'sdrv'\CMD;'sdrv'\UTIL;'sdrv'\NEW;'sdrv'\STRESS;'

  outline = outline || appender

  /*----------------------------------------------------------------------*/
  /* Trim off 'SET ' from the start of the PATH statement                 */
  /*----------------------------------------------------------------------*/
  if SUBSTR(outline,1,4) = 'SET ' then
  do
    plen = pend - 4
    outline = SUBSTR(outline,5,plen)
  end

  /*----------------------------------------------------------------------*/
  /* These are the directories to allow in autoexec PATH                  */
  /*----------------------------------------------------------------------*/
  allow.1  = bdrv||'\OS2;'
  allow.2  = bdrv||'\OS2\SYSTEM;'
  allow.3  = bdrv||'\OS2\MDOS\WINOS2;'
  allow.4  = bdrv||'\OS2\INSTALL;'
  allow.5  = bdrv||'\;'
  allow.6  = bdrv||'\OS2\MDOS;'
  allow.7  = bdrv||'\OS2\APPS;'
  allow.8  = sdrv||'\CMD;'
  allow.9  = sdrv||'\UTIL;'
  allow.10 = sdrv||'\STRESS;'

  /*----------------------------------------------------------------------*/
  /* Trim autoexec PATH statement to limit of 128 characters or less      */
  /*----------------------------------------------------------------------*/
  pstart = 6                                 /* start just beyond PATH=   */

  /*----------------------------------------------------------------------*/
  /* Loop filters out parts of PATH not allowed, to trim to 128 or less   */
  /*----------------------------------------------------------------------*/
  do while LENGTH(outline) > 128
    pend = POS(';',outline,pstart)           /* look for first semicolon  */

    if pend = 0 then                         /* must be at end of string  */
      pend = LENGTH(outline)                 /* so point to end of strng  */

    plen = pend - pstart + 1                 /* length of path element    */
    pdir = SUBSTR(outline,pstart,plen)       /* extract path element      */

    pdirup = TRANSLATE(pdir)                 /* make it uppercase         */
    match = 0                                /* assume no match to start  */

    do i = 1 to 10                           /* look in allowable table   */
      if pdirup = allow.i then               /* is this path dir ok?      */
      do
        match = 1                            /* we have a match           */
        LEAVE                                /* break out of loop         */
      end
    end

    if match = 0 then                        /* path element not allowed  */
    do
      pnext = pend + 1                       /* point just past this dir  */
      tline = outline                        /* use temporary string      */
      plen = LENGTH(outline) - pend          /* how long is rest of path  */

      /*------------------------------------------------------------------*/
      /* Leave out disallowed path element                                */
      /*------------------------------------------------------------------*/
      pprev = pstart - 1                     /* just before disallowed    */

      if plen > 0 then
        outline = SUBSTR(tline,1,pprev) || SUBSTR(tline,pnext,plen)
      else                                   /* must be at endof string   */
        outline = SUBSTR(tline,1,pprev)      /* disallowed path is last   */
    end
    else                                     /* keep this part of path    */
      pstart = pstart + plen                 /* point just past element   */
  end

  cond = LINEOUT(OutputName,outline)         /* write that line to file   */
  say outline

  /*----------------------------------------------------------------------*/
  /* Write append statement to autoexec.bat                               */
  /*----------------------------------------------------------------------*/
  outline = 'append 'bdrv'\os2\install'
  cond = LINEOUT(OutputName,outline)         /* write that line to file   */
  say outline

  /*----------------------------------------------------------------------*/
  /* Write stress setup statements to file                                */
  /*----------------------------------------------------------------------*/
  outline = sdrv
  cond = LINEOUT(OutputName,outline)         /* write that line to file   */
  say outline
  outline = 'cd \log'
  cond = LINEOUT(OutputName,outline)         /* write that line to file   */
  say outline
  outline = 'cls'
  cond = LINEOUT(OutputName,outline)         /* write that line to file   */
  say outline

  cond = LINEOUT(OutputName)                 /* close new autoexec.bat    */

  'copy 'OutputName bdrv'\autoexec.new'

RETURN

