/*------------------------------------------------------------------------*/
/* Classification -  IBM Internal Use Only                                */
/*                                                                        */
/* Name           -  MSTRCOPY CMD                                         */
/* Programmer     -                                                       */
/* Date Written   -                                                       */
/* Release Level  -  1.3                                                  */
/* Function       -  Copies warp & merlin stress tests to test machine.   */
/*                                                                        */
/*                   Syntax:  mstrcopy x y z                              */
/*                                                                        */
/*                      where x is an unused drive letter you chose for   */
/*                              \\aussrvcid\cid                           */
/*                            y is an unused drive letter you chose for   */
/*                              \\ripstres                                */
/*                            z is the machine type (6, 7, 8, 9, X, M, Y, */
/*                              T, or P)                                  */
/*                                                                        */
/*                   Modified on 8/21/97 to be the following:             */
/*                                                                        */
/*                   Syntax:  mstrcopy mtype z                            */
/*                                                                        */
/*                      where mtype is the machine type (6, 7, 8, 9, X,   */
/*                              M, Y, T, or P)                            */
/*                            z is the drive letter to install tests to.  */
/*                                                                        */
/*                                                                        */
/* Change History -                                                       */
/*   1.2   08/22/97  B. Budak                                             */
/*   1.3   01/08/98  B. Budak  Changes made to support the server being   */
/*                             provided to India.                         */
/*                             Remove the need for ripstres               */
/*                                                                        */
/*------------------------------------------------------------------------*/
parse upper arg machtype sdrv .

  if machtype = '' | machtype = '?' then
    call STRCOPY_HELP

  curr_dir = directory()

  /*----------------------------------------------------------------------*/
  /* Load the RexxUtils                                                   */
  /*----------------------------------------------------------------------*/
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs

  /*----------------------------------------------------------------------*/
  /* Determine which drive is available and then use the last drive       */
  /* letter for the attaching to \\fpserv2\testcase                       */
  /*----------------------------------------------------------------------*/
  map = SysDriveMap('G:', 'FREE')

  call SysDropFuncs

  numdrvs = WORDS(map)
  if numdrvs < 1 then
  do
    say ' '
    say ' There isn''t any drive letter available to run MSTRCOPY.  There is a'
    say ' a requirement that there be 1 drive letter available.'
    say ' '
    say ' Please correct the situation and try again.'
    say ' '

    EXIT
  end

  share = SUBWORD(map,numdrvs,1)

  'NET USE 'share' \\fpserv2\testcase'
  if rc \= 0 then
  do
    say ' '
    say ' There was a problem when trying to NET USE '
    say ' '
    say ' MSTRCOPY can not continue.'
    say ' '

    EXIT
  end

  cond = directory(sdrv'\cmd')
  if cond = '' then 'md 'sdrv'\cmd'

  cond = directory(sdrv'\e3')
  if cond = '' then 'md 'sdrv'\e3'

  cond = directory(sdrv'\log')
  if cond = '' then
    'md 'sdrv'\log'
  else
  do
    'attrib -r 'sdrv'\log\comp.in'
    'attrib -r 'sdrv'\log\fortext'
    'attrib -r 'sdrv'\log\ret'
    'attrib -r 'sdrv'\log\ret.in'
    'attrib -r 'sdrv'\log\yes.in'
  end

  cond = directory(sdrv'\new')
  if cond = '' then 'md 'sdrv'\new'

  cond = directory(sdrv'\script')
  if cond = '' then 'md 'sdrv'\script'

  cond = directory(sdrv'\scriptp')
  if cond = '' then 'md 'sdrv'\script'

  cond = directory(sdrv'\stress')
  if cond = '' then 'md 'sdrv'\stress'

  cond = directory(sdrv'\text')
  if cond = '' then 'md 'sdrv'\text'

  cond = directory(sdrv'\util')
  if cond = '' then 'md 'sdrv'\util'

  'cd \'

  call directory curr_dir

  'xcopy 'share'\base\stress\e3            'sdrv'\e3'
  'xcopy 'share'\base\stress\log           'sdrv'\log /T /R /O'
  'xcopy 'share'\base\stress\script        'sdrv'\script'
  'xcopy 'share'\base\stress\scriptp       'sdrv'\script'
  'xcopy 'share'\base\stress\stress        'sdrv'\stress'
  'xcopy 'share'\base\stress\new           'sdrv'\new'
  'xcopy 'share'\base\stress\text          'sdrv'\text'
  'xcopy 'share'\base\stress\util          'sdrv'\util'
  'xcopy 'share'\base\stress\cmd           'sdrv'\cmd'

  'attrib +r 'sdrv'\log\comp.in'
  'attrib +r 'sdrv'\log\fortext'
  'attrib +r 'sdrv'\log\ret'
  'attrib +r 'sdrv'\log\ret.in'
  'attrib +r 'sdrv'\log\yes.in'

  'NET USE 'share' /d'

EXIT


/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*                                                                         */
/*                       S U B R O U T I N E S                             */
/*                                                                         */
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/

STRCOPY_HELP: procedure

  say ' '
  say ' Syntax:'
  say '         MSTRCOPY  mtype  z  '
  say ' '
  say ' where:'
  say '         mtype  is the machine type (6, 7, 8, 9, X, M, Y, T or P)'
  say ' '
  say '         z  is the drive letter to install the stress test bucket to.'
  say ' '

EXIT
