/*------------------------------------------------------------------------*/
/* Classification -  IBM Internal Use Only                                */
/*                                                                        */
/* Name           -  NEWSTRES CMD                                         */
/* Programmer     -  Greg Rollins                                         */
/* Date Written   -  14 June 1990                                         */
/* Release Level  -  3.1                                                  */
/* Function       -                                                       */
/*                                                                        */
/* Change History -                                                       */
/*   3.1   08/25/97  B. Budak                                             */
/*                                                                        */
/*------------------------------------------------------------------------*/
validtypes = '3 4 5 6 6-1 7 7-B 7-b 8 9 X x Y y Z z'

parse arg machtype bdrv sdrv .

  'echo off'

  if machtype = '' | machtype = '?' then
    call BADPARM

  if bdrv = '' then bdrv = 'c:'
  else
    if LENGTH(bdrv) = 1 then
      bdrv = bdrv || ':'

  if sdrv = '' then sdrv = 'd:'
  else
    if LENGTH(sdrv) = 1 then
      sdrv = sdrv || ':'

  if WORDPOS(machtype,validtypes) = 0 then
  do
    say ' '
    say ' The configuration type you entered ( 'machtype' ) is not supported.'
    say ' '

    call BADPARM
  end

  /*----------------------------------------------------------------------*/
  /* Load the RexxUtils                                                   */
  /*----------------------------------------------------------------------*/
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs

  if stream(sdrv'\cmd\rstress.cmd', 'C', 'query exists')  \= '' then
  do
    say ' This machine has already been specified as the configuration type below:'
    say ' '

    /*--------------------------------------------------------------------*/
    /* The "%%" below will be interpreted as "%" at run time              */
    /*--------------------------------------------------------------------*/
    'type  'sdrv'\cmd\rstress.cmd | find "set " | find /v "%%"'
  end

  say ' '
  say ' This system will be specified as type 'machtype

  'pause'
  say ' '

  call SysFileTree sdrv||'\cmd', 'dr', 'D'
  if dr.0 = 0 then
    'md 'sdrv||'\cmd'

  /*----------------------------------------------------------------------*/
  /* Create first line of D:\CMD\RSTRESS.cmd to SET the default rstress   */
  /* configuration                                                        */
  /*----------------------------------------------------------------------*/
  say 'set rstress='machtype
  rstress=machtype
  cond = LINEOUT(sdrv||'\cmd\rstress.cmd','/* @set rstress='machtype' */')
  cond = LINEOUT(sdrv||'\cmd\rstress.cmd','rstress='rstress)
  cond = LINEOUT(sdrv||'\cmd\rstress.cmd')

  /*----------------------------------------------------------------------*/
  /* Now append the main body to it                                       */
  /*----------------------------------------------------------------------*/
  'type a:\rst\rst.cmd 1>>'sdrv||'\cmd\rstress.cmd'

  say ' '
  'call 'sdrv'\cmd\rstress.cmd' rstress sdrv bdrv

EXIT



/**************************************************************************/
/**************************************************************************/
/*                                                                        */
/*                       S U B R O U T I N E S                            */
/*                                                                        */
/**************************************************************************/
/**************************************************************************/
BADPARM:  procedure

  say ' A parameter must be entered to specify the machine configuration.  Please enter'
  say ' NEWSTRES again, followed by a setup type.'
  say ' '
  say ' COMMAND FORMAT:'
  say '                     NEWSTRES  N  [DRIVE]  [BOOTDRV]'
  say ' '
  say '         where N is a supported configuration type of:'
  say ' '
  say '               For CUTTER:  3, 4, 5, 6, 7, 8, 9, X, Y, or Z'
  say ' '
  say '               or'
  say ' '
  say '               For CRUISER: 6, 6-1, 7, 8, 9, X, Y, or Z'
  say ' '
  say '               [] optional parameters'
  say ' '
  say '               DRIVE is the drive where the stress files were installed.  If'
  say '                     not specified it will default to "D:"'
  say ' '
  say '               BOOTDRV is the drive where OS/2 was installed.  If not specified'
  say '                       it will default to "C:"'
  say ' '

EXIT
