/*------------------------------------------------------------------------*/
/* Classification -  IBM Internal Use Only                                */
/*                                                                        */
/* Name           -  PATCH    CMD                                         */
/* Programmer     -  Greg Rollins                                         */
/* Date Written   -  14 June 1990                                         */
/* Release Level  -  1.3                                                  */
/* Function       -  This temporary patch converts "older" Stress         */
/*                   machines to Rstress 6.0 standards.                   */
/*                                                                        */
/* Change History -                                                       */
/*   1.3   08/25/97  B. Budak                                             */
/*                                                                        */
/*                                                                        */
/*------------------------------------------------------------------------*/

parse arg sdrv .

  if sdrv = '' then sdrv = 'd:'

  /*----------------------------------------------------------------------*/
  /* Load the RexxUtils                                                   */
  /*----------------------------------------------------------------------*/
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs

  say ' '
  say ' Performing corrective patch . . .'
  say ' '

  if stream(sdrv'\stress\testlog2.*', 'C', 'query exists') \= '' then
    'del 'sdrv'\stress\testlog2.*'

  if stream(sdrv'\testlog\*.*', 'C', 'query exists') \= '' then
  do
    sdrv
    'cd\testlog'

    if stream('.\testlog2.*', 'C', 'query exists') \= '' then
      'del testlog2.*'

    curr_dir = directory()

    call SysFileTree '*.*', 'file', 'F'

    do y = 1 to file.0
      parse var file.y  literal(curr_dir) '\' v1

      if stream(sdrv'\stress\'v1, 'C', 'query exists') == '' then
        'copy 'v1 sdrv||'\stress'
    end

    say ' del 'sdrv'\testlog'
  end

  sdrv
  'cd\'

  call SysFileTree sdrv||'\testlog', dr, 'D'

  if dr.0 > 0 then
    'rd 'sdrv'\testlog'

  if stream(sdrv'\script\*.cmd', 'C', 'query exists') \= '' then
  do
    'copy 'sdrv'\script\*.cmd 'sdrv'\stress'
    'del 'sdrv'\script\*.cmd'
  end

EXIT
