/*------------------------------------------------------------------------*/
/* Classification -  IBM Internal Use Only                                */
/*                                                                        */
/* Name           -  STRESS CMD                                           */
/* Programmer     -  Greg Rollins                                         */
/* Date Written   -  26 June 1990                                         */
/* Release Level  -  6.4                                                  */
/* Function       -  To speed up STRESS.CMD, support files are only       */
/*                   copied if their subdirectories have to be created.   */
/*                   So, if any of these support files are updated, a     */
/*                   temporary patch MUST be made in STRESS.cmd to force  */
/*                   the copying of effected files.                       */
/*                                                                        */
/* Change History -                                                       */
/*   6.4   08/21/97  B. Budak                                             */
/*                                                                        */
/*                                                                        */
/*------------------------------------------------------------------------*/

parse arg bdrv sdrv .

  say '[1;42;37m'
  say ' '
  say 'Beginning STRESS phase of Rstress/Mstress . . .'
  say ' '
  say ' '
  say 'Create directory tree and copy support files:'
  say ' '

  bdrv = TRANSLATE(bdrv)
  sdrv = TRANSLATE(sdrv)

  Fname = bdrv'\config.sys'
  b4stress = bdrv||'\config.b4s'

  if stream( b4stress, 'C', 'query exists') \= '' then
    'copy 'b4stress Fname

  if stream( sdrv'\log\*.*', 'C', 'query exists') = '' then
  do
    'md 'sdrv'\log'
    'copy a:\log 'sdrv'\log'
    say ' '

    /*--------------------------------------------------------------------*/
    /* Make these files read-only so RUNTEST.cmd won't erase them         */
    /*--------------------------------------------------------------------*/
    'attrib +r 'sdrv'\log\ret'
    'attrib +r 'sdrv'\log\*.in'
    'attrib +r 'sdrv'\log\fortext'
  end

  if stream( sdrv'\util\*.*', 'C', 'query exists') = '' then
  do
    'md 'sdrv'\util'
    'copy a:\util 'sdrv'\util'
    say ' '
  end

  if stream( sdrv'\text\*.*', 'C', 'query exists') = '' then
  do
    'md 'sdrv'\text'
    'copy a:\text 'sdrv'\text'
    say ' '
  end

  if stream( sdrv'\cmd\*.*', 'C', 'query exists') = '' then
  do
    'md 'sdrv'\cmd'
    'copy a:\cmd 'sdrv'\cmd'
    say ' '
  end
  else
  do
    'copy a:\cmd\mruntest.cmd 'sdrv'\cmd'
    'copy a:\cmd\runtest.cmd 'sdrv'\cmd'
    'copy a:\cmd\feedtest.cmd 'sdrv'\cmd'
    say ' '
  end

  if stream( sdrv'\stress\*.*', 'C', 'query exists') = '' then
  do
    'md 'sdrv'\stress'

    /*--------------------------------------------------------------------*/
    /* Files copied are Testlog and Switch only; Testlog2 EXE & DLL's go  */
    /* on a TL2 (Testlog2) disk in \EXE and \DLL subdirectories           */
    /*--------------------------------------------------------------------*/
    'copy a:\testlog 'sdrv'\stress'
    say ' '
  end

  if stream( sdrv'\script\*.*', 'C', 'query exists') = '' then
  do
    'md 'sdrv'\script'

    /*--------------------------------------------------------------------*/
    /* Files copied are VID, CNT, and SCR (Loader/Sched.) support files   */
    /* only                                                               */
    /*--------------------------------------------------------------------*/
    'copy a:\script 'sdrv'\script'
    say ' '
  end
  else
    'copy a:\script\upscript.cmd 'sdrv'\script'

  if stream( sdrv'\e3\*.*', 'C', 'query exists') = '' then
  do
    'md 'sdrv'\e3'
    'copy a:\e3 'sdrv'\e3'
    say ' '
  end

  /*----------------------------------------------------------------------*/
  /* E.cmd allows starting E3 edits by typing E                           */
  /*----------------------------------------------------------------------*/
  'copy a:\e.cmd 'bdrv'\'
  say ' '
  say 'Installing Device Drivers:'
  say ' '

  /*----------------------------------------------------------------------*/
  /* 16 bit *.SYS files for both CUTTER and CRUISER                       */
  /*----------------------------------------------------------------------*/
  zz = '0'
  do while LINES(Fname) \= 0
    zz = zz + 1
    cnfgln.zz = LINEIN(Fname)
  end

  rc = LINEOUT(Fname)

  'erase' Fname

  'a:'
  'cd\sys16bit'
  'copy *.* 'sdrv'\STRESS'

  /*----------------------------------------------------------------------*/
  /* Load the RexxUtils                                                   */
  /*----------------------------------------------------------------------*/
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs

  call SysFileTree '*.sys', 'file'

  do i = 1 to file.0
    parse var file.i . . . . devdrv .

    slashend = LASTPOS('\',devdrv)
    devdrv = TRANSLATE(STRIP(SUBSTR(devdrv,slashend,LENGTH(devdrv))))

    say ' '
    say 'DEVICE='sdrv||'\STRESS'||devdrv '>> 'Fname
    zz = zz + 1
    cnfgln.zz = 'DEVICE='sdrv||'\STRESS'||devdrv
  end

  say ' '

  call 'a:\version.cmd' bdrv
  version = result

  /*----------------------------------------------------------------------*/
  /* VERSION.cmd will set version to CRUISER or CUTTER                    */
  /*----------------------------------------------------------------------*/
  if version == 'CRUISER' then
  do
    /*--------------------------------------------------------------------*/
    /* CRUISER commands only from this point of STRESS.cmd on             */
    /*                                                                    */
    /* Now the 32 bit *.SYS files for CRUISER only                        */
    /*--------------------------------------------------------------------*/
    'a:'
    'cd\sys32bit'
    'copy *.* 'sdrv'\STRESS'

    call SysFileTree '*.sys', 'file'

    do i = 1 to file.0
      parse var file.i . . . . devdrv .

      slashend = LASTPOS('\',devdrv)
      devdrv = TRANSLATE(STRIP(SUBSTR(devdrv,slashend,LENGTH(devdrv))))

      say ' '
      say 'Device='sdrv||'\STRESS'||devdrv '>> 'Fname
      zz = zz + 1
      cnfgln.zz = 'DEVICE='sdrv||'\STRESS'||devdrv
    end

    say ' '

    /*--------------------------------------------------------------------*/
    /* This file resets vector for debugger automatically on boot up.     */
    /*--------------------------------------------------------------------*/
    'copy a:\kdb.ini 'bdrv'\'
    say ' '

    /*--------------------------------------------------------------------*/
    /* ASSUMPTION:  If testlog2.* is in sdrv\STRESS, it's DLL's are       */
    /* already with it                                                    */
    /*--------------------------------------------------------------------*/
    if stream( sdrv'\stress\testlog2.*', 'C', 'query exists') == '' then
    do
      do forever
        say ' '
        say ' ͻ'
        say '                                                             '
        say '                Insert the TL2 disk in drive A:              '
        say '                                                             '
        say ' ͼ'
        say ''
        pause

        if stream( 'a:\exe\*.*', 'C', 'query exists') \= '' then
          say '[1;41;33m'
        else
          leave
      end

      say '[1;42;37m'

      /*------------------------------------------------------------------*/
      /* Copy Testlog2 EXE & SYM and all support DLL & SYM's              */
      /*------------------------------------------------------------------*/
      'copy a:\exe 'sdrv'\stress'
      say ' '
      'copy a:\dll 'sdrv'\stress'
    end
  end

  do ty = 1 to zz
    rc = LINEOUT(Fname,cnfgln.ty)
  end

  rc = LINEOUT(Fname)

  'cd a:\'
  bdrv

EXIT
