/* 31.10.1998 hidewind.c 
 * 
 * Addon DLL (c) 1998 Chris Wohlgemuth for watchcat
 * This DLL inserts an item into the watchcat addon menu to
 * hide the windows of processes. The entry of the Process is
 * removed from the windowlist.
 * This is useful for crashed programs hanging in the exitlist
 * which block the screen.
 *
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#define INCL_DOS
#define INCL_DOSPROCESS
#define INCL_WIN
#include <os2.h>
#include <stdlib.h>

static void* win;

/* This is in the watchcat 2.1 package: */
#include "dllbase.c"

/* This function hides the window of the selected Process */
void hideIt()
{
	HENUM henum;
	HWND hwndNext;
	HSWITCH hswitch;
	PTIB ptib;
	PPIB ppib;
	TID tid2;
	PID pid2;
	PID pid;
	
	ULONG wcatPID;
	char szBuffer[255];
	char szArguments[100];
	char szPgmName[]="hidewindow.exe";
	RESULTCODES result;
	
	STARTDATA startData={0};
	char chrLoadError[CCHMAXPATH];
	ULONG ulSessionID;
	ULONG rc;
	
	wcatPID=WCatQueryPID();
	
	if(wcatPID==-1)return;

	sprintf(szArguments,"%d",wcatPID);
	/*sprintf(szArguments," %d",720);*/
	DosExecPgm(szBuffer,sizeof(szBuffer),EXEC_ASYNC,szArguments,(PSZ)NULL,&result,szPgmName);
	return;
	
				memset(&startData,0,sizeof(startData));
				startData.Length=sizeof(startData);
				startData.Related=SSF_RELATED_INDEPENDENT;
				startData.FgBg=SSF_FGBG_BACK;
				startData.TraceOpt=SSF_TRACEOPT_NONE;
				startData.PgmTitle="HideWindow";
				startData.PgmName="i:\\wcat21\\hidewindow.exe";
				startData.InheritOpt=SSF_INHERTOPT_SHELL;
				startData.SessionType=SSF_TYPE_FULLSCREEN;
				startData.PgmControl=SSF_CONTROL_VISIBLE|SSF_CONTROL_MAXIMIZE|SSF_CONTROL_NOAUTOCLOSE;
				startData.InitXPos=30;
				startData.InitYPos=30;
				startData.InitXSize=500;
				startData.InitYSize=400;
				startData.ObjectBuffer=chrLoadError;
				startData.ObjectBuffLen=(ULONG)sizeof(chrLoadError);
				startData.PgmInputs=szArguments;
				rc=DosStartSession(&startData,&ulSessionID,&pid);	
				return;
				

	henum=WinBeginEnumWindows(HWND_DESKTOP);
	if(!henum){
		DosBeep(100,1000);
		return;
	}
	while((hwndNext=WinGetNextWindow(henum))!=NULLHANDLE) {
		WinQueryWindowProcess(hwndNext,&pid2,&tid2);/* query process of this particular window */
		if(pid2==wcatPID){/* True -> it's our process */
			WinSetWindowPos(hwndNext,0,0,0,50,50,SWP_HIDE);/* hide the window */
			hswitch=WinQuerySwitchHandle(hwndNext,0);/* find switch handle */
			if(hswitch) WinRemoveSwitchEntry(hswitch);/*remove window from the switch list */
		}
	}
	WinEndEnumWindows(henum);
	DosBeep(5000,1000);
	/*	DosSleep(100000);
	 */
}


int WCEXPORT WCSYSTEM WCatInit()
  {
		/* initialize my Hide window addon */
		win=WCatBegWindow("Question","Hide Window","This Funktion hides the window\
of a Process.",hideIt);
		return 0;
  }

