/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                OS/2 2.0 SLIP Driver for IBM TCP/IP version 2.0           */
/*                                                                          */
/*                               FONUSER.CMD                                */
/*                                                                          */
/*            ..................................................            */
/*                                                                          */
/* Sample attachment script for dialing into a system w/o password          */
/* protection.  This script should be specified using the "attachcmd" and   */
/* "attachparm" elements in SLIP.CFG file.                                  */
/*                                                                          */
/*              interface sl0 {                                             */
/*                 attachcmd  = fonuser.cmd                                 */
/*                 attachparm = "dialcmd"                                   */
/*              }                                                           */
/*                                                                          */
/*            - - - - - - - - - - - - - - - - - - - - - - - - -             */
/*                                                                          */
/* When the script runs, it is automatically passed the interface name for  */
/* the interface it is running on as the first argument, and the user       */
/* arguments (from SLIP.CFG) as the second argument.                        */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/

parse arg interface , dialcmd

/*--------------------------------------------------------------------------*/
/*                   Initialization and Main Script Code                    */
/*--------------------------------------------------------------------------*/

/* Set some definitions for easier COM strings */
cr='0d'x
crlf='0d0a'x
timeout = 0

say ''
say 'FONUSER - SLIP Script ',
    '(interface' interface')'

'mode com1 38400,n,8,1,buffer=on'
/* Prompt for missing information */
if dialcmd = '' then do
   call charout , 'Dial Command: '
   parse pull dialcmd
end

/* Flush any stuff left over from previous COM activity */
call flush_receive

/* Dial the remote server */
call lineout , 'Reset modem...'
call send 'ATZ' || cr
call waitfor 'OK', 5 ; call flush_receive 'echo'
 if RC = 1 then do
    call lineout , 'Modem not resetting... Trying again'
    call send '+++'
    call waitfor 'OK'
    call send 'ATHZ' || cr
    call waitfor 'OK', 3
  end

/* Wait for connection */
call lineout , 'Now Dialing...'
call send dialcmd || cr
call waitfor 'CONNECT', 40 ; call waitfor crlf , 2
 if RC = 1 then do
    call lineout , ' Unable to connect exit from FONUSER '
    exit(2)
  end
  else do
    /* Flush anything else */
    call flush_receive 'echo'
    /* Now configure this host for the appropriate address, */
    'ifconfig sl0 222.222.222.10 222.222.222.20 netmask 255.255.255.0'
    'route -f add default' 222.222.222.20 '1'
    /* All done */
    exit 0
  end




/*--------------------------------------------------------------------------*/
/*                            send ( sendstring)                            */
/*..........................................................................*/
/*                                                                          */
/* Routine to send a character string off to the modem.                     */
/*                                                                          */
/*--------------------------------------------------------------------------*/

send:

   parse arg sendstring
   call slip_com_output interface , sendstring

   return

/*--------------------------------------------------------------------------*/
/*                    waitfor ( waitstring , [timeout] )                    */
/*..........................................................................*/
/*                                                                          */
/* Waits for the supplied string to show up in the COM input.  All input    */
/* from the time this function is called until the string shows up in the   */
/* input is accumulated in the "waitfor_buffer" variable.                   */
/*                                                                          */
/* If timeout is specified, it says how long to wait if data stops showing  */
/* up on the COM port (in seconds).                                                         */
/*                                                                          */
/*--------------------------------------------------------------------------*/

waitfor:

   parse arg waitstring , timeout

   if timeout = '' then
     timeout = 5000    /* L O N G   delay if not specified */
   waitfor_buffer = '' ; done = -1; curpos = 1
   ORI_TIME=TIME('E')

   if (remain_buffer = 'REMAIN_BUFFER') then do
      remain_buffer = ''
   end

   do while (done = -1)
      if (remain_buffer \= '') then do
         line = remain_buffer
         remain_buffer = ''
       end
       else do
         line = slip_com_input(interface,,10)
      end
      waitfor_buffer = waitfor_buffer || line
      index = pos(waitstring,waitfor_buffer)
      if (index > 0) then do
         remain_buffer = substr(waitfor_buffer,index+length(waitstring))
         waitfor_buffer = delstr(waitfor_buffer,index+length(waitstring))
         done = 0
      end
      call charout , substr(waitfor_buffer,curpos)
      curpos = length(waitfor_buffer)+1
      if ((done \= 0) & (TIME('E')>timeout)) then do
        call lineout , ' WAITFOR: timed out '
        done = 1
       end
   end
   timeout=0
   RC=done
 return RC


/*--------------------------------------------------------------------------*/
/*                               readpass ()                                */
/*..........................................................................*/
/*                                                                          */
/* Routine used to read a password from the user without echoing the        */
/* password to the screen.                                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

readpass:

  answer = ''
  do until key = cr
    key = slip_getch()
    if key \= cr then do
      answer = answer || key
    end
  end
  say ''
  return answer


/*--------------------------------------------------------------------------*/
/*                             flush_receive ()                             */
/*..........................................................................*/
/*                                                                          */
/* Routine to flush any pending characters to be read from the COM port.    */
/* Reads everything it can until nothing new shows up for 100ms, at which   */
/* point it returns.                                                        */
/*                                                                          */
/* The optional echo argument, if 1, says to echo flushed information.      */
/*                                                                          */
/*--------------------------------------------------------------------------*/

flush_receive:

   parse arg echo

   /* If echoing the flush - take care of waitfor remaining buffer */
   if (echo \= '') & (length(remain_buffer) > 0) then do
      call charout , remain_buffer
      remain_buffer = ''
   end

   /* Eat anything left in the modem or COM buffers */
   /* Stop when nothing new appears for 100ms.      */

   do until line = ''
     line = slip_com_input(interface,,100)
     if echo \= '' then
        call charout , line
   end

   return
