/* ------------------------------------------------------------------------ */
/* Create The UltiMail Desktop                                              */
/* ------------------------------------+----------------------------------- */
/*                                     |   Multimedia Messaging             */
/* Version: 1.00                       |   IBM T.J. Watson Research Center  */
/*                                     |   P.O. Box 218                     */
/*                                     |   Yorktown Heights, NY 10598       */
/* ------------------------------------+----------------------------------- */
/* History:                                                                 */
/* --------                                                                 */
/*                                                                          */
/* created: Jul 16 1994 by JVK - modeled after code by Glenn Martin         */
/* updated: Mar  4 1995 by JVK - 6269 added FAQ to info folder              */
/* changed: Mar 12 1995 by WHS defect 6304 Icon class change                */
/* ------------------------------------------------------------------------ */
trace O   /* use O for OFF, I for INTERNAL debugging */
Version = 'MAKEWPS Version 1.00 July 16, 1994'

/* --- make sure RXUTILS are loaded --------------------------------------- */
ADDRESS CMD '@echo off'
CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs

/* --- now here starts the real program ----------------------------------- */
PARSE ARG argstring
argstring = TRANSLATE(STRIP(argstring))
IF substr(argstring,1,1)='?' THEN DO
  SAY "+--------------------------------------------------------------------+"
  SAY "| MAKEWPS.CMD Version 1.00                                           |"
  SAY "| ------------------------                                           |"
  SAY "|                                                                    |"
  SAY "| Rebuilds a specific or all components of the UltiMail Desktop.     |"
  SAY "|                                                                    |"
  SAY "| SYNTAX:                                                            |"
  SAY "| MAKEWPS [?] | [Component] [/DESTROY]                               |"
  SAY "|                                                                    |"
  SAY "| where:                                                             |"
  SAY "| Component is the name of the component to be built. No Component   |"
  SAY "|           ALL        build all components  (default)               |"
  SAY "|           FOLDER     build desktop UltiMail folder (this folder    |"
  SAY "|                      also gets built implicitly by all other       |"
  SAY "|                      components since they reside inside this      |"
  SAY "|                      folder.                                       |"
  SAY "|           INBASKET   build the InBasket object                     |"
  SAY "|           CABINET    build the Mail cabinet object                 |"
  SAY "|           NEWLETTR   build the New Letter object                   |"
  SAY "|           ADDRBOOK   build the Address Book object                 |"
  SAY "| /DESTROY  destroy the component and deregister its classes         |"
  SAY "|                                                                    |"
  SAY "+--------------------------------------------------------------------+"
  EXIT 99
END

/* --- get the component name --------------------------------------------- */
PARSE VAR argstring Component Options

MsgON   = 1
Sleep   = 1
Destroy = 0
Target  = 'ALL'
NewLine = X2C('0D0A')
Success = 1
/* --- parse options --- */
DO WHILE Options <> ' '
  PARSE VAR Options Token Options
  SELECT
    WHEN Token = '/QUIET' | Token = 'UIET' THEN DO
      MsgOn = 0
    END
    WHEN Token = '/DESTROY' THEN DO
      Destroy = 1
    END
    OTHERWISE DO
      IF MsgON THEN SAY 'Unknown Parameter: 'Token
    END
  END
END

/* --- set up the component list ------------------------------------------ */
curDir       = DIRECTORY()
viewHelp     = "VIEWHELP.EXE"
i            = 0
FolderID     = '<ULTIMAIL_LITE>'
InfoFolderID = '<ULTIMAIL_INFO_LITE>'
Obj.0        = 0;

IF Component = '' THEN DO
  Component = 'ALL'
END; ELSE DO
  Component = TRANSLATE(Component)
  IF WORDPOS(Component, 'ALL FOLDER INBASKET CABINET NEWLETTR ADDRBOOK INFORMATION DEBUG') = 0 THEN DO
    IF MsgON THEN SAY 'Unknown Component:' Component '(assuming ALL)'
    Component = 'ALL'
  END
END

IF (Component = 'ALL') | (Component = 'FOLDER') THEN DO
  i               = i+1
  Obj.0           = i
  Obj.i.Class     = 'WPFolder'
  Obj.i.DLL       = ''
  Obj.i.Check     = ''
  Obj.i.Title     = "Ultimedia" || NewLine || "Mail/2 Lite"
  Obj.i.Setup     = 'OBJECTID=' || FolderID || ';ICONFILE=' || curDir || '\UMAILFLL.ICO'  || ';ICONNFILE=1,' || curDir || '\UMAILFLO.ICO'
  Obj.i.ParentID  = '<IAK>'  /* '<WP_DESKTOP>' */
END
IF (Component = 'ALL') | (Component = 'INBASKET') THEN DO
  i               = i+1
  Obj.0           = i
  Obj.i.Class     = 'IBMUmailWPS'
  Obj.i.DLL       = 'UMAILWPS'
  Obj.i.Check     = ''
  Obj.i.Title     = 'In-basket'
  Obj.i.Setup     = 'OBJECTID=<ULTIMAIL_INBASKET>;ICONFILE=' || curDir || '\INBOX0.ICO;MAILTYPE=2;'
  Obj.i.ParentID  = FolderID
END
IF (Component = 'ALL') | (Component = 'CABINET') THEN DO
  i               = i+1
  Obj.0           = i
  Obj.i.Class     = 'IBMUmailWPS'
  Obj.i.DLL       = 'UMAILWPS'
  Obj.i.Check     = ''
  Obj.i.Title     = 'Mail Cabinet'
  Obj.i.Setup     = 'OBJECTID=<ULTIMAIL_CABINET>;ICONFILE=' || curDir || '\CABINET.ICO;MAILTYPE=3;'
  Obj.i.ParentID  = FolderID
END
IF (Component = 'ALL') | (Component = 'NEWLETTR') THEN DO
  i               = i+1
  Obj.0           = i
  Obj.i.Class     = 'IBMUmailWPS'
  Obj.i.DLL       = 'UMAILWPS'
  Obj.i.Check     = ''
  Obj.i.Title     = 'New Letter'
  Obj.i.Setup     = 'OBJECTID=<ULTIMAIL_NEWLETTR>;ICONFILE=' || curDir || '\NEWLETTR.ICO;MAILTYPE=5;'
  Obj.i.ParentID  = FolderID
END
IF (Component = 'ALL') | (Component = 'ADDRBOOK') THEN DO
  i               = i+1
  Obj.0           = i
  Obj.i.Class     = 'IBMUmailWPS'
  Obj.i.DLL       = 'UMAILWPS'
  Obj.i.Check     = ''
  Obj.i.Title     = 'Names and' || NewLine || 'Addresses'
  Obj.i.Setup     = 'OBJECTID=<ULTIMAIL_ADDRBOOK>;ICONFILE=' || curDir || '\ADDRBOOK.ICO;MAILTYPE=4;'
  Obj.i.ParentID  = FolderID
END
IF (Component = 'DEBUG') THEN DO
  i               = i+1
  Obj.0           = i
  Obj.i.Class     = 'IBMUmailWPS'
  Obj.i.DLL       = 'UMAILWPS'
  Obj.i.Check     = ''
  Obj.i.Title     = 'Debug ToUmail'
  Obj.i.Setup     = 'OBJECTID=<ULTIMAIL_UMWPSDBG>;ICONFILE=' || curDir || '\UMWPSDBG.ICO;ULTIMAILTYPE=7;'
  Obj.i.ParentID  = FolderID
END
IF (Component = 'ALL') | (Component = 'INFORMATION') THEN DO
  i               = i+1
  Obj.0           = i
  Obj.i.Class     = 'WPFolder'
  Obj.i.DLL       = ''
  Obj.i.Check     = ''
  Obj.i.Title     = 'Information'
  Obj.i.Setup     = 'OBJECTID=' || InfoFolderID || ';ICONFILE=' || curDir || '\UMAILINF.ICO'
  Obj.i.ParentID  = FolderID
  i               = i+1
  Obj.0           = i
  Obj.i.Class     = 'WPProgram'
  Obj.i.DLL       = ''
  Obj.i.Check     = ''
  Obj.i.Title     = 'Read Me'
  Obj.i.Setup     = 'OBJECTID=<UMAIL_VIEW_README_LITE>;EXENAME=' || viewHelp || ';PARAMETERS=' || curDir || '\README.HLP;STARTUPDIR=' || curDir || ';ICONFILE=' || curDir || '\README.ICO'
  Obj.i.ParentID  = InfoFolderID
  i               = i+1
  Obj.0           = i
  Obj.i.Class     = 'WPProgram'
  Obj.i.DLL       = ''
  Obj.i.Check     = ''
  Obj.i.Title     = 'Tutorial'
  Obj.i.Setup     = 'OBJECTID=<UMAIL_VIEW_TUTORIAL_LITE>;EXENAME=' || viewHelp || ';PARAMETERS=' || curDir || '\TUTORIAL.HLP;STARTUPDIR=' || curDir || ';ICONFILE=' || curDir || '\UMTUTOR.ICO'
  Obj.i.ParentID  = InfoFolderID
  i               = i+1
  Obj.0           = i
  Obj.i.Class     = 'WPProgram'
  Obj.i.DLL       = ''
  Obj.i.Check     = ''
  Obj.i.Title     = "User's Guide"
  Obj.i.Setup     = 'OBJECTID=<UMAIL_VIEW_USG_LITE>;EXENAME=' || viewHelp || ';PARAMETERS="' || curDir || '\UGUIDE.HLP ' || curDir || '\UMAIL.HLP";STARTUPDIR=' || curDir
  Obj.i.ParentID  = InfoFolderID
  i               = i+1                                                                                                                                                          /* 6269a */
  Obj.0           = i                                                                                                                                                            /* 6269a */
  Obj.i.Class     = 'WPProgram'                                                                                                                                                  /* 6269a */
  Obj.i.DLL       = ''                                                                                                                                                           /* 6269a */
  Obj.i.Check     = 'FAQ.HLP'                                                                                                                                                    /* 6269a */
  Obj.i.Title     = 'Frequently asked' || NewLine || 'Questions'                                                                                                                 /* 6269a */
  Obj.i.Setup     = 'OBJECTID=<UMAIL_VIEW_FAQ_LITE>;EXENAME=' || viewHelp || ';PARAMETERS="' || curDir || '\FAQ.HLP";STARTUPDIR=' || curDir';ICONFILE=' || curDir || '\FAQ.ICO'  /* 6269a */
  Obj.i.ParentID  = InfoFolderID                                                                                                                                                 /* 6269a */
/*
  i               = i+1
  Obj.0           = i
  Obj.i.Class     = 'WPProgram'
  Obj.i.DLL       = ''
  Obj.i.Check     = ''
  Obj.i.Title     = 'Double click here to recreate' || NewLine || 'the UltiMail desktop'
  Obj.i.Setup     = 'OBJECTID=<UMAIL_INST_INFO>;EXENAME=' || curDir || '\MAKEWPS.CMD;STARTUPDIR=' || curDir || ';ICONFILE=' || curDir || '\HAMMER.ICO'
  Obj.i.ParentID  = InfoFolderID
*/
END

/* --- register and create UltiMail WPS objects --------------------------- */
IF Destroy THEN DO
  DO i = Obj.0 TO 1 BY -1
    PARSE VAR Obj.i.Setup . 'OBJECTID=<' ObjID '>' Rest
    IF ObjID <> '' THEN DO
      rc = SysDestroyObject('<'ObjID'>')
      IF rc <> 1 THEN DO
        SAY 'Could not destroy object:' Obj.i.Title '(ID = <'ObjID'>)'
        Success = 0
      END
    END
    IF Obj.i.DLL <> '' THEN DO
      /* deregister class */
      rc = SysDeregisterObjectClass(Obj.i.Class)
      IF rc <> 1 THEN DO
        SAY 'Could not deregister class for object:' Obj.i.DLL
        Success = 0
      END
    END
  END
END; ELSE DO
  IF MsgOn THEN DO
    SAY '*******************************************************************************'
    SAY '*******************************************************************************'
    SAY '*****                                                                     *****'
    SAY '*****  Creating the UltiMail Desktop Objects might take a while, please   *****'
    SAY '*****  be patient.                                                        *****'
    SAY '*****                                                                     *****'
    SAY '*******************************************************************************'
    SAY '*******************************************************************************'
  END
  DO i = 1 TO Obj.0
    rc = 1
    IF Obj.i.Check <> '' THEN DO                                      /* 6269a */
      /* check if the prerequisite file for this object exists */     /* 6269a */
      CALL SysFileTree Obj.i.Check, 'file', 'FO'                      /* 6269a */
      IF file.0 = 0 THEN ITERATE                                      /* 6269a */
    END                                                               /* 6269a */
    IF Obj.i.DLL <> '' THEN DO
      /* register new class */
      rc = SysRegisterObjectClass(Obj.i.Class, curDir || '\' || Obj.i.DLL || '.DLL');
      IF rc <> 1 THEN DO
        SAY 'Could not register class for object:' Obj.i.DLL
        Success = 0
      END; ELSE DO
        IF MsgON THEN DO
          SAY 'Registered class for object:' Obj.i.DLL
        END
      END
    END
    IF rc = 1 THEN DO
      /* create object */
      rc = SysCreateObject(Obj.i.Class, Obj.i.Title, Obj.i.ParentID, Obj.i.Setup, 'ReplaceIfExists');
      IF rc <> 1 THEN DO
        n = SysSleep(Sleep)
        /* retry */
        rc = SysCreateObject(Obj.i.Class, Obj.i.Title, Obj.i.ParentID, Obj.i.Setup, 'ReplaceIfExists');
        IF rc <> 1 THEN DO
          /* try to create it on the desktop */
          n = SysSleep(Sleep)
          rc = SysCreateObject(Obj.i.Class, Obj.i.Title, "<WP_DESKTOP>", Obj.i.Setup, 'ReplaceIfExists');
          IF rc <> 1 THEN DO
            n = SysSleep(Sleep)
            SAY 'Could not create object:' Obj.i.Title
            Success = 0
          END; ELSE DO
            IF MsgON THEN DO
              SAY 'Created object on the desktop:' Obj.i.Title
            END
          END
        END; ELSE DO
          IF MsgON THEN DO
            SAY 'Created object:' Obj.i.Title
          END
        END
      END; ELSE DO
        IF MsgON THEN DO
          SAY 'Created object:' Obj.i.Title
        END
      END
    END
  END
END

/* --- destroy the install object in the startup folder ------------------- */
rc = SysDestroyObject('<UMAIL_INST_LITE>')
/* --- destroy the install object in the ultimail folder ------------------ */
IF Success THEN DO
  rc = SysDestroyObject('<UMAIL_INST_UMAIL>')
END

EXIT
