/* Test the installation of UltiMail, looking for a few key things.
*/
'@echo off'
mlocal1 = ''
dest1   = ''
mqdir1  = ''
mlocal2 = ''
pparm2  = ''
aparm2  = ''
dest2   = ''
mqdir2  = ''
appl    = 'ERROR:'
uselan  = ''
popsrvr = ''
mailgw  = ''
replydom= ''
srvdir  = ''
dd1     = ''
dw1     = ''
dh2     = ''
dv2     = ''
provider= ''
etcdir  = value('ETC',,'OS2ENVIRONMENT')
tmpdir  = value('TMP',,'OS2ENVIRONMENT')
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
newTCP  = ('' <> SysSearchPath('PATH', 'TCPCFG.EXE'))
outlog = 'UMCHECK.LOG'
'erase' outlog '2> nul'

umpro = 'UMAILSRV.PRO'
tag. = 0
do forever
  line = linein(umpro)
  if stream(umpro, 's') <> 'READY' then leave
  select
  when substr(line,1,6) = ':MAIL ' then do
    tag. = 0; tag.mail = 1
    line = delword(line,1,1)
   end
  when substr(line,1,9) = ':PROFILE ' then do
    tag. = 0; tag.profile = 1
    line = delword(line,1,1)
   end
  when substr(line,1,1) = ':' then tag. = 0
  otherwise nop
  end
  if tag.mail & word(line,1) = 'directory' then srvdir = translate(strip(word(line,3),,"'"))
  if tag.profile & word(line,1) = 'provider' then provider = translate(strip(word(line,3),,"'"))
end
call stream umpro, 'c', 'close'
if srvdir = '' then call say 'No server directory was found in' umpro'!'
else do
  rc = SysFileTree(srvdir, 'dummy', 'D')
  if dummy.0=0 then call say 'The server directory "'srvdir'" does not exist!'
  rc = SysFileTree(srvdir'\INBOX', 'dummy', 'D')
  if dummy.0=0 then call say 'The server directory "'srvdir'\INBOX" does not exist!'
  rc = SysFileTree(srvdir'\PARTIAL', 'dummy', 'D')
  if dummy.0=0 then call say 'The server directory "'srvdir'\PARTIAL" does not exist!'
  rc = SysFileTree(srvdir'\NOWHERE', 'dummy', 'D')
  if dummy.0=0 then call say 'The server directory "'srvdir'\NOWHERE" does not exist!'
end

if tmpdir = '' then call say 'No "TMP" environment variable!'
else do
  rc = SysFileTree(tmpdir, 'dummy', 'D')
  if dummy.0=0 then call say 'The "TMP" directory, "'tmpdir'", does not exist!'
end

if etcdir = '' then call say 'No "ETC" environment variable!'
else do
  rc = SysFileTree(etcdir, 'dummy', 'D')
  if dummy.0=0 then call say 'The "ETC" directory, "'etcdir'", does not exist!'
  else do
    inifile = etcdir'\TCPOS2.INI'
    rc = SysFileTree(inifile, 'dummy', 'F')
    if dummy.0=0 then call say 'The file "'inifile'" does not exist!'
    else do
      uselan = translate(SysIni(inifile, 'LAN', 'MAIL_USE_LAN'), ' ', '00'x)
      if uselan = 'ERROR:' then uselan = ''
      if uselan = '' & newTCP then call say 'The key "LAN/MAIL_USE_LAN" in' inifile 'was not found!'

      if uselan = 'YES' then appl = 'LAN'
      else appl = strip(SysIni(inifile, 'CONNECTION', 'CURRENT_CONNECTION'))
      if appl = 'ERROR:' then call say 'The key "CONNECTION/CURRENT_CONNECTION" in' inifile 'was not found!'
      else do
        popsrvr = strip(translate(SysIni(inifile, appl, 'POPSRVR'), ' ', '00'x))
        if popsrvr = 'ERROR:' then popsrvr = ''
        if popsrvr = '' then call say 'The key "'appl'/POPSRVR" in' inifile 'was not found!'
        else do
          IsNumber = 1
          temp = translate(popsrvr, ' ', '.')
          do while temp <> ''
            parse var temp  num temp
            if \datatype(num, 'W') then IsNumber = 0
          end
          if IsNumber then call say 'The key "'appl'/POPSRVR" in' inifile', "'popsrvr'", is numeric!'
         end
        mailgw = strip(translate(SysIni(inifile, appl, 'MAIL_GW'), ' ', '00'x))
        if mailgw = 'ERROR:' then mailgw = ''
        if mailgw = '' then call say 'The key "'appl'/MAIL_GW" in' inifile 'was not found!'
        else do
          IsNumber = 1
          temp = translate(mailgw, ' ', '.')
          do while temp <> ''
            parse var temp  num temp
            if \datatype(num, 'W') then IsNumber = 0
          end
          if IsNumber then call say 'The key "'appl'/MAIL_GW" in' inifile', "'mailgw'", is numeric!'
         end
        replydom = strip(translate(SysIni(inifile, appl, 'REPLY_DOMAIN'), ' ', '00'x))
        if replydom = 'ERROR:' then replydom = ''
        if replydom = '' then call say 'The key "'appl'/REPLY_DOMAIN" in' inifile 'was not found!'
        else do
          IsNumber = 1
          temp = translate(replydom, ' ', '.')
          do while temp <> ''
            parse var temp  num temp
            if \datatype(num, 'W') then IsNumber = 0
          end
          if IsNumber then call say 'The key "'appl'/REPLY_DOMAIN" in' inifile', "'replydom'", is numeric!'
         end
      end
    end

    sendmailcf = etcdir'\SENDMAIL.CF'
    call checksendmailcf newTCP
    mlocal1 = mlocal
    dest1 = translate(dest)
    mqdir1 = translate(mqdir)
    dd1 = dd
    dw1 = dw
    if newTCP then do
      if dd1 = '' then call say 'The domain name (DD keyword) is missing from SENDMAIL.CF!'
      if dw1 = '' then call say 'The host name (Dw keyword) is missing from SENDMAIL.CF!'
    end

    sendmailcf = etcdir'\SENDMAIL.UML'
    call checksendmailcf 1
    mlocal2 = mlocal
    dest2 = translate(dest)
    mqdir2 = translate(mqdir)
    dv2 = dv
    dh2 = dh
  end
end

if mqdir1 <> '' & mqdir2 <> '' & mqdir1 <> mqdir2 then
  call say 'The "MQUEUE" directory in SENDMAIL.CF, "'mqdir1'", does not',
      'match the "MQUEUE" directory in SENDMAIL.UML, "'mqdir2'"!'
if dest1 <> '' & dest2 <> '' & dest1 <> dest2 then
  call say 'The "-dest" directory in SENDMAIL.CF, "'dest1'", does not',
      'match the "-dest" directory in SENDMAIL.UML, "'dest2'"!'



/* Now report the info we found. */
call say ''
call say 'Installation information:'
if provider = '' then call say '  UltiMail is not using TCPOS2.INI'
else                  call say '  The UltiMail provider is' provider
if tmpdir  <> '' then call say '  TMP =' tmpdir
if etcdir  <> '' then call say '  ETC =' etcdir
if srvdir  <> '' then call say '  SRV =' srvdir
if uselan  <> '' then call say '  LAN =' uselan
if appl    <> 'ERROR:' then call say '  CONNECTION =' appl
if popsrvr <> '' then call say '  POPSRVR =' popsrvr
if mailgw  <> '' then call say '  MAIL_GW =' mailgw
if replydom<> '' then call say '  REPLY_DOMAIN =' replydom
if mqdir1  <> '' then call say '  MQueue from SENDMAIL.CF: ' mqdir1
if mlocal1 <> '' then call say '  Mlocal from SENDMAIL.CF: ' mlocal1
if dd1     <> '' then call say '  DD from SENDMAIL.CF:     ' dd1
if dw1     <> '' then call say '  Dw from SENDMAIL.CF:     ' dw1
if mqdir2  <> '' then call say '  MQueue from SENDMAIL.UML:' mqdir2
if mlocal2 <> '' then call say '  Mlocal from SENDMAIL.UML:' mlocal2
if dv2     <> '' then call say '  DV from SENDMAIL.UML:    ' dv2
if dh2     <> '' then call say '  DH from SENDMAIL.UML:    ' dh2

call stream outlog, 'c', 'close'
return 0

checksendmailcf:
  arg complain
  mlocal  = ''
  pparm   = ''
  aparm   = ''
  dest    = ''
  mqdir   = ''
  dv = ''
  dh = ''
  dw = ''
  dd = ''
  rc = SysFileTree(sendmailcf, 'dummy', 'F')
  if dummy.0=0 then if complain then call say 'The file "'sendmailcf'" does not exist!'; else nop
  else do
    do forever
      line = linein(sendmailcf)
      if stream(sendmailcf, 's') <> 'READY' then leave
      select
      when substr(line,1,2) = 'OQ' then do
        mqdir = substr(line,3)
        rc = SysFileTree(mqdir, 'dummy', 'D')
        if dummy.0=0 then call say 'The "MQUEUE" directory in' sendmailcf', "'mqdir'", does not exist!'
       end
      when substr(line,1,2) = 'Dw' then dw = substr(line,3)
      when substr(line,1,2) = 'DD' then dd = substr(line,3)
      when substr(line,1,2) = 'DV' then dv = substr(line,3)
      when substr(line,1,2) = 'DH' then dh = substr(line,3)
      when word(line,1) = 'Mlocal,' then do
        mlocal = translate(line, ' ', ',')
        parse var mlocal 'P='pparm . 'A=' aparm
        if pparm = '' | aparm = '' then call say 'The Mlocal line in' sendmailcf 'is invalid: "'mlocal'"!'
        else do
          mailexe = filespec('name', pparm)
          if translate(mailexe) <> 'UMAILER.EXE' then dummy.0=0
          else rc = SysFileTree(pparm, 'dummy', 'F')
          if dummy.0=0 then call say 'The "P=" parameter in' sendmailcf', "'pparm'", does not point to UMAILER.EXE!'
          temp = aparm
          toparm = ''
          do while temp <> ''
            parse var temp  tag temp
            select
            when tag = '-dest' then parse var temp  dest temp
            when tag = '-to' then parse var temp  toparm temp
            otherwise nop
            end  /* select */
          end
          if toparm <> '$u' then call say 'The "A=" parameter in' sendmailcf', "'aparm'", is missing "-to $u"!'
          if dest = '' then call say 'The "A=" parameter in' sendmailcf', "'aparm'", does not have a valid "-dest"!'
          else do
            rc = SysFileTree(dest, 'dummy', 'D')
            if dummy.0=0 then call say 'The "-dest" directory in' sendmailcf', "'dest'", does not exist!'
            else if translate(dest) <> srvdir'\INBOX' then
              call say 'The "-dest" directory in' sendmailcf', "'dest'", does not match',
                  'the server inbox in UMAILSRV.PRO, "'srvdir'\INBOX"!'
          end
         end
       end
      otherwise nop
      end  /* select */
    end
    call stream sendmailcf, 'c', 'close'
    if mqdir = '' then call say 'No "MQUEUE" directory was found in' sendmailcf'!'
    if mlocal = '' then call say 'No "Mlocal" line was found in' sendmailcf'!'
  end
  return 0

say:
  parse arg outline
  say outline
  call lineout outlog, outline
  return 0
