//
// $Header: d:\\32bits\\ext2-os2\\misc\\rcs\\umount.c,v 1.2 1997/03/16 12:38:49 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996, 1997  Matthieu WILLM (willm@ibm.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_DOSDEVIOCTL
#include <os2.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

char banner[] = "unmount utility for ext2-os2\n"
                "(built on "__DATE__" at "__TIME__ " in Paris - France)\n"
                "Copyright (C) Matthieu Willm 1996\n"
                "This program is licensed under the terms of the GNU general public license.\n"
                "See the file COPYING for details.\n\n";

void usage(void) {
    fprintf(stderr, "\nUsage : umount <drive:>\n");
}

void os2_err(int error) {
    int           rc;
    char         *buf;
    unsigned long len;


    buf = malloc(4096);
    if (buf) {
        rc = DosGetMessage(0, 0, buf, 4096, error, "OSO001.MSG", &len);
        if (rc == NO_ERROR) {
            fprintf(stderr, "%s", buf);
        }
        free(buf);
    }
}

int main(int argc, char **argv) {
    HFILE  f;
    APIRET rc;
    ULONG  action;
    ULONG  parmio;
    ULONG  dataio;
    ULONG  pio;
    ULONG  dio;
    int    retval;
    int    namelen;
    char  *file;

    printf(banner);
    retval = 1;
    if (argc == 2) {
        file    = argv[1];
        namelen = strlen(argv[1]);
        if ((namelen == 2)        &&
            (file[1] == ':')      && 
            (((file[0] >= 'A') && (file[0] <= 'Z')) || ((file[0] >= 'a') && (file[0] <= 'z')))) {
            /*
             * This is a valid drive letter
             */
            rc = DosOpen(
                         file,
                         &f,
                         &action,
                         0,
                         0,
                         OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
                         OPEN_FLAGS_DASD | OPEN_FLAGS_NO_CACHE | OPEN_ACCESS_READONLY | OPEN_SHARE_DENYREADWRITE,
                         0
                        );
            if (rc == NO_ERROR) {
                parmio = 0;
                dataio = 0;
                pio    = 1;
                dio    = 1;
                rc = DosDevIOCtl(
                                 f,
                                 IOCTL_DISK,
                                 DSK_LOCKDRIVE,
                                 &parmio, 1, &pio,
                                 &dataio, 1, &dio
                                );
                if (rc == NO_ERROR) {
                    parmio = 0;
                    pio    = 1;
                    dio    = 1;
                    dataio = 0;
                    rc = DosDevIOCtl(
                                          f,
                                          IOCTL_DISK,
                                          DSK_BEGINFORMAT,
                                          &parmio, pio, &pio,
                                          &dataio, dio, &dio
                                         );



                    if (rc == NO_ERROR) {
                        printf("drive %s successfuly unmounted\n", file);
                        retval = 0;
                    } else {
                        retval = 1;
                        os2_err(rc);
                    }

                    parmio = 0;
                    dataio = 0;
                    pio    = 1;
                    dio    = 1;
                    rc = DosDevIOCtl(
                                     f,
                                     IOCTL_DISK,
                                     DSK_UNLOCKDRIVE,
                                     &parmio, pio, &pio,
                                     &dataio, dio, &dio
                                    );
                    if (rc == NO_ERROR) {
                    parmio = 2;
                    dataio = 0;
                    pio    = 2;
                    dio    = 1;
                    rc = DosDevIOCtl(
                                     f,
                                     IOCTL_DISK,
                                     DSK_UNLOCKEJECTMEDIA,
                                     &parmio, pio, &pio,
                                     &dataio, dio, &dio
                                    );
                    if (rc == NO_ERROR) {
                        /*
                         * nothing else
                         */
                    } else {
                        if (retval == 0)
                            retval = 1;
                        os2_err(rc);
                    }
                        /*
                         * nothing else
                         */
                    } else {
                        if (retval == 0)
                            retval = 1;
                        os2_err(rc);
                    }
                } else {
                    os2_err(rc);
                }
                rc = DosClose(f);
                if (rc == NO_ERROR) {
                    /*
                     * nothing else to do
                     */
                } else {
                    if (retval == 0)
                        retval = 1;
                    os2_err(rc);
                }
            } else {
                os2_err(rc);
            }
        } else {
            fprintf(stderr, "%s is an invalid drive name\n", file);
        }
    } else {
        usage();
    }

    return retval;
}
