/* Virexx.cmd                                                                */
/*    Rexx program for virus checking uploaded files for Maximus 2.01wb
              Doug Cullen  1:157/603.52@fidonet 12 Oct. 92
              Revised 24 Jan. 93
              Mucho further revision 4 Feb. 93
      Rev to do generic scans and scan nested compressed files.
          Also added Node variable for multinode BBS's.
          Cleaned up code for various errors.
          Working directories deleted at the completion.
          Modifications by Dave Sloan 81:950/10@OS2net March 12,1992
      Modifications for scanning TICed files (especially TTick - great Ticker
          by Thomas Seeling :-) ) by
          Jens Gecius 2:241/1040@fidonet
          Date 29.10., 4.11., 6.11.94, diverse in '95, 3.7.95

        The RunCmd-line should look like this:

        RunCmd * d:\dfue\ttick\virexxt.cmd %D:%P\ %N .%E
        
        This way, _every_ File will be virus-checked.
        
        No way to make me responsible for this little thing. You (your Ticker)
        start this program on your own risk.

*/
'@echo off'
parse upper arg path file ext           /* Sammeln der Kommandozeile         */
lpath = STRIP(path)                     /* Entfernt lediglich Leerzeichen    */
lfile = STRIP(file)
lext = STRIP(ext)
lnode = '9'                             /* Mu ich auch mal sehen, woher/fr */
                                        /* das ist                           */
oldestfile=''                           /* Noch keine Daten ber das Alter   */
/*---------------------------------------------------------------------------*/
/*  - - - - - - - - - -   C O N F I G U R A T I O N - - - - - - - - - - -    */
/*-----  Set these variables for your System ------------------------------- */

/* 1) LISTS  (lists of file extensions and how to deal with them)            */
/* ***** THESE MUST BE UPPER CASE OR THEY WONT WORK !!!!!    ******          */

username='Tic-File'                     /* May be changed, but isn't used... */

arc_list='.ZIP .LZH .ARC .ARJ .ZOO .RAR' /* list of defined achives          */
reject_list='.GIF .TIF .# .## .###'     /* list of file extensions to reject */
                                        /* # extensions prevent confusion    */
                                        /* numbers that are translated later */
pass_list='.UC2 .CTL .LSM .TGZ .DEL .LST .C .BAT .CMD .TIC .TXT .ARL'
pass_list=pass_list||' .ARV .ARH .FAQ .OS2 .EXE .MEC .TX8 .WLK .UHS'
                                        /* list of file extensions to pass   */
                                        /* automatically                     */
series_list='.# .## .### .A## .Z##'     /* list of file extensions to pass   */
                                        /* #'s will match any NUMBER         */

/* 2) VARIABLES */

bbsname = 'AkademiaBBS'                 /* Your BBS name - not used          */
oldest = 8001                           /* date for oldest file YYMM         */
                                        /* 8001 = jan 80 use 0000 to disable */
descblanks = 31                         /* # of blanks to add to file desc.  */
                                        /* to align properly                 */
                                        /* align left edge - not used        */
workdrive= 'e:'                         /* Wo passiert was                   */

/* 3) PATHS (paths to various files and directories needed by VIREXX         */
/* ****NOTE**** Change only UPPER CASE PARTS                                 */

maxpath      = 'D:\DFUE\TTICK'          /* Path for misc operation           */
badfiledir   = 'E:\FB\ADM\BADFTIC'      /* path to copy bad files to         */
testfiledir  = 'E:\FB\ADM\TEST'         /* dir for testing lnode = 1,2 ect.  */
                                        /* ist hier abgeschaltet, da nur ein */
                                        /* Task gleichzeitig TICs beharkt    */

miscpath     = 'E:\FB\ADM'              /* Path to uploaded files.bbs        */
                                        /* NO FOLLOWING BACKSLASH            */
                                        /* Must be UPPER case !!!!           */
logname     = 'D:\DFUE\LOG\viretic.log' /* Virexx Log                        */
maxlog      = 'D:\DFUE\LOG\bink.log'    /* path to max log file              */
logfile     = 'D:\DFUE\LOG\viretic.log' /* path and name of Virexx log       */
commentfile = 'D:\DFUE\UTILS\AKAHEAD.TXT' /* bbs add file for zip comment    */
database    = 'D:\DFUE\MAX\filedata.fil' /* database of additional file info */
debugfile   = 'D:\DFUE\LOG\DEBUG.TXT'   /* to  debug = 1                     */

/* 4) COMMANDS (Command lines for various programs called by VIREXXT)        */
/*    NOTE: Virexx appends the filename to the end of the archiver commands  */
/*    so the space at the end is important                                   */

lh_command='lh x /o /i '                /* command to extract .lzh file      */
                                        /* this ones for 32bit LH2 2.12      */
zip_command1 ='unzip -jo '              /* command to extract .ZIP files     */
                                        /* with version 1.x signature        */
                                        /* this ones for PKUNZIP2 1.02       */
zip_command2 ='unzip -jo '              /* command to extract .ZIP files     */
                                        /* with version 2.x signature        */
                                        /* this ones for InfoZip unzip 5.0   */
arj_command ='arj e -y '                /* unarj command for DOS-ARJ         */
                                        /* Hier wird der DOS-ARJ genutzt     */
/* arj_command ='gnunarj x '*/          /* unarj command for 32bit GNU port  */
                                        /* of R. Jungs Demo Unarj 2.30       */
arc_command ='arc2 eo '                 /* command to extract archive using  */
                                        /* SEA's ARC2 ver 6.00               */
zoo_command ='zoo e:O '                 /* command to extract archive using  */
                                        /* ZOO 2.1 (renamed to ZOO2.exe)     */
rar_command ='unrar e '                 /* command to extract archive using  */
                                        /* RAR ver 1.00e Freeware            */
comment_command = 'zip -z -k '          /* command to add comment to         */
                                        /* .zip file                         */

zipdir = 'd:\util\packer\'              /* path to arcive subdirectory       */

scancmd='d:\util\os2scan '              /* command line for your virusscanner*/

tonul=' >NUL'                           /* Kommando, um Bildschirmausgaben   */
                                        /* zu unterdrcken                   */

/* 5) SWITCHES (switches for various functions. Use 1 for ON, 0 for OFF)     */

mlog       = 0                          /* Add VIREXX entry to MAXLOG        */
                                        /* NEVER CHANGE !!                   */
sdi        = 1                          /* enter FILE_ID.DIZ or DESC.SDI to  */
                                        /* files.bbs if found.               */
                                        /* Brauchts hier nicht, macht TTick  */
zipcomment = 0                          /* Add bbs comment to .zip files     */
                                        /* Funktionierte bisher nur bei ZIP  */
dbase      = 0                          /* write entry to file database      */
debug      = 0                          /* turns on extra output to assist   */
                                        /* in debugging problems             */
                                        /* NICHT im Realbetrieb verwenden!!! */
/* --------------------------------------------------------------------------*/
/*    - - - - -  E N D    O F    C O N F I G U R A T I O N  - - - - - - -    */
/* ---------------------------- Main Program --------------------------------*/
/*trace all*/
if debug then do
  file = LINEOUT(debugfile,'parameters 'lpath' 'lfile' 'lext' status='status)
  file = LINEOUT(debugfile,'initialzing')
end
                                        /* Klare Sache: wenn DEBUG dann alle */
                                        /* Parameter ins DEBUGLOG schreiben  */

fullname = lpath||lfile||lext           /* full pathname to file(s)          */
call initialize                         /* initialize program                */

/* Look for all files with the specified name*/
call SysFileTree fullname,'lfile','FO'

/* If any exist then process them*/
if lfile.0 > 0 then do

  /* Setup to trap errors and inform user to inform sysop*/
  status = ''
  status = 'INCOMPLETE'
  status = 'GOOD'
  
  if debug then
    file = LINEOUT(debugfile,'status='status)
  
  /* Perform check for all of the files*/
  /* This version is made for generic scans of subdirectories*/
  do filecnt = 1 to lfile.0
  
    /* Get the first/next file to process*/
    fullname = TRANSLATE(lfile.filecnt)     /* full pathname to file, Grobuchst.*/
    filename = FILESPEC('NAME',fullname)    /* nur der file name */
    lpath    = DELSTR(fullname, POS(filename, fullname))
    dot = POS('.',filename)
    lfile = DELSTR(filename, dot)
    lext = DELSTR(filename, 1, dot - 1)

    select
      when lext =  miscpath then do   /* file had no extension */
        if debug then
          file = LINEOUT(debugfile,'no file extension')
        status = 'NOEXT'
      end   /* do */
    
      /* expand files in test directories*/
      when POS(lext,arc_list)<>0 then
        call unarchive
    
      when  POS(lext,pass_list)<>0 then do
        if debug then
          file = LINEOUT(debugfile,'AutoPass 'fullname)
        'COPY 'fullname testfiledir tonul
        status = 'PASS'
      end /* do */
    
      when  POS(lext,reject_list)<>0 then do        /* wird hier nicht rejected, */
        if debug then                               /* da wir GIFs usw. ab und an*/
          file = LINEOUT(debugfile,'Passing 'fullname) /* erhalten...            */
        status = 'PASS'
      end /* do */

      when lext = '.EXE' | lext = '.COM' then do
        if debug then
          file = LINEOUT(debugfile,'rejecting 'fullname' exe or com')
        'COPY 'fullname testfiledir tonul
        status = 'EXE'
        
      end /* do */
    
      otherwise do
        trans_ext=TRANSLATE(lext,'##########','1234567890')
        if debug then
          file = LINEOUT(debugfile,'extension is now 'trans_ext)
        if POS(trans_ext,series_list)<>0 then do
          if debug then
            file = LINEOUT(debugfile,'AutoPass serial file 'fullname)
          status = 'PASS'
          'COPY 'fullname' 'testfiledir tonul
        end /* do */
        else do
          if debug then
            file = LINEOUT(debugfile,fullname' is UNKNOWN type')
          status = 'UNKNOWN'
        end /* else */
      end /* do */
    end /* select */

    if oldest <> '0000' then
      call checkdate       /* check for old files       */
                                                     /* unless turned off         */
    if status = 'GOOD' | status = 'EXE' then do
      if debug then do
        file = LINEOUT(debugfile,"checking oldfiles")
        file = LINEOUT(debugfile,"checking descriptions")
        file = LINEOUT(debugfile,"calling scanner")
      end
      call scanner                    /* scan for virii if the file unpacks OK */
      if sdi & status<>'INFECTED' then
        call checkdesc          /* check for file descriptions       */
    end /* do */

    if status = 'PASS' then do
      if debug then
        file = LINEOUT(debugfile,"calling scanner")
      call scanner                   /* scan for virii bei Passfiles (sicher ist */
                                     /* sicher...                                */
    end /* do */
    if lfile.0 = 1 then do
      if debug then
        file = LINEOUT(debugfile,"doing filestats")
      call filestats
      if debug then
        file = LINEOUT(debugfile,"sending BBS file")
    /*  call sendmsg */                  /* send appropriate msg (hier nicht)    */
    end
    if debug then
      file = LINEOUT(debugfile,"updating database")
    if dbase then call databaseout                 /* add fileinfo to data base  */

    if zipcomment & lext = '.ZIP' then do
      if debug then
        file = LINEOUT(debugfile,"adding zip comment")
      if status = 'GOOD' then
        zipdir||comment_command' 'fullname' < 'commentfile tonul
    end /* do */
    if debug then
      file = LINEOUT(debugfile,"cleaning up test directories")
    call cleanupdir                  /* clean up test directory               */
    if debug then
      file = LINEOUT(debugfile,'cleaning up')
  end /* Loop for all files*/
end /* Files exist*/
cleanup:
if debug then
  file = LINEOUT(debugfile,'Status='status)
  
if status='GOOD' THEN status='OK'
if status='PASS' Then status='OK'
if status='EXE' Then status='OK'
if status='NOEXT' Then status='OK'
if status='INFECTED' Then status='DELETE'
if status='UNKNOWN' Then status='BAD'
if status='REJECT' Then status='OK'
if status='STATUS' Then status='BAD'
if status='NEWDESC' Then status='NEWDESC '||diz
if status='OLD' Then status='BAD'
if debug then
  file = LINEOUT(debugfile)
cd maxpath

say status
/*return status*/

exit status

else 
  say 'NOFILE'
exit

/* ------------ end -  main program ------------------ */

/*     Possible Status Values

        GOOD     = No problems
        BAD      = Failed to Unarchive 
        INFECTED = Failed Virus Scan 
        UNKNOWN  = File extension was not of any type defined
        EXE      = File was .exe or .com (I treat these with a great 
                    deal of suspicion! )
        NOEXT    = file had no extension i.e. 'filename.'
        OLD      = archive contained files older than oldest date
        PASS     = Scan and PASS thru (use for other extension you
                   want to pass automatically (GIF, TIF or whatever)
        REJECT   = file was in the reject list.  Deleted and the user
                   is sent a warning note
*/

/* ----- Subroutine Initialize ----------------------- */
initialize:
 if lext = '' then
   call USAGE
 dontask = '/FY'tonul
 if debug then
   file = LINEOUT(debugfile,'Initializing needed REXX-functions')
 call RxFuncAdd 'SysFileTree','RexxUtil','SysFileTree'
 call RxFuncAdd 'SysMkDir','RexxUtil','SysMkDir'
 call RxFuncAdd 'SysRmDir','RexxUtil','SysRmDir'
                                   /* make sure Rexxutils loaded */
 if debug then
   file = LINEOUT(debugfile,'Checking for TestDir')
 call SysFileTree testfiledir,'dir','DO'
 if dir.0 = 0 then do
   if debug then
     file = LINEOUT(debugfile,'TestDir doesnt exist, making it')
   if debug then
     file = LINEOUT(debugfile,'Checking for FILE named TestDir')
   if STREAM(testfiledir,'C','query exist') <> '' then do
     if debug then
       file = LINEOUT(debugfile,'Deleting File named TestDir')
     'attrib -r 'testfiledir
     'del 'testfiledir dontask
   end
   call SysMkDir testfiledir
 end
 if debug then
   file = LINEOUT(debugfile,'Checking for BadFileDir')
 call SysFileTree badfiledir,'dir','DO'
 if dir.0 = 0 then do
   if debug then
     file = LINEOUT(debugfile,'BadFileDir doesnt exist, making it')
   call SysMkDir badfiledir
 end
 if debug then
   file = LINEOUT(debugfile,'Checking for existing files in TestFileDir')
 if stream(testfiledir||'\*.*','c','query exist')  <> '' then do
   if debug then
     file = LINEOUT(debugfile,'Killing existing files in TestFileDir')
   'attrib -r 'testfiledir'\* 'tonul
   'del 'testfiledir'\*.* 'dontask   /* cleanup test dir */
 end
 testfiledir.0 = 0 /* No arcs within arcs yet*/
 parse value DATE('N') with dd mmm yyyy      /* dd   = day
                                                mmm  = month
                                                yyyy = year */
 dd = RIGHT(dd,2,'0')
 archsize = 0
 logdate = ' 'dd' 'mmm' 'TIME()' VIRX'
 uldate = dd'-'mmm'-'yyyy
 logentry = '+'logdate' checking 'fullname   /* build up log entry */
 file = LINEOUT(logfile,logentry)            /* and write log entry */  
 file = LINEOUT(logfile)
 nested = NO                                 /* clear nested */
 ZIPTYPE =''
 
/* check that dirs exist - if not make them */


return

/* ----- End - Initialize ---------------------------- */

/* ----- Subroutine Unarchive ------------------------ */

unarchive:
 ffname = fullname
 fname = filename
 if debug then
   file = LINEOUT(debugfile,'unarchiving 'fname)
 testdir = testfiledir
 signature = CHARIN(ffname,1,6)
 temp = stream(ffname,'c','close')
 Select

   when (substr(signature,1,5) = 'PK') then do  /* version 2.x zip file    */
     call unzip2
   end /* do */

   when (substr(signature,1,4) = 'PK') then do  /* version 1.x zip file    */
     call unzip1
   end /* do */

   when (substr(signature,3,3) = '-lh'  ) then do      /* .lzh file          */
     call unlzh
   end /* do */

   when (substr(signature,1,2) = '`'   ) then do      /* .arj file          */
     call unarj
   end /* do */

   when (substr(signature,1,4) = 'Rar!'  ) then do     /* .rar file          */
     call unrar
   end /* do */

   when (substr(signature,1,3) = 'ZOO'  ) then do      /* .zoo file          */
     call unzoo
   end /* do */

   when (substr(signature,1,1) = x2c('1a')) then do     /* .arc file          */
     call unarc
   end /* do */

   otherwise do
     status = 'BAD'                             /* Kein Packer definiert.... */
   end /* do */

end /* select */

if status = 'GOOD' then
  call checknested
else
  if status = 'BAD' then do
  end /* do */


return

/* ----------- End - unarchive -----------------------------*/

/* ------- look for description files ---------------------- */
/* ------- (FILE_ID.DIZ or DESC.SDI)inside archive --------- */
/* ------- and if existent give it to ttick ---------------- */

checkdesc:
 if debug then
   file = LINEOUT(debugfile,'Checking for DIZ/SDI')
 fileinfo = testfiledir'\file_id.diz'
 if stream(fileinfo,'c','query exist') <> '' then do 
   copy fileinfo maxpath'\file_id.diz' tonul
   desc = 'DONE'
   status='NEWDESC'
   diz='@file_id.diz'
/*  file = LINEOUT(fileinfo)*/
 end /* do */
 if desc <> 'DONE' then do
   fileinfo = testfiledir'\desc.sdi'
   if stream(fileinfo,'c','query exist') <> ''then do 
     copy fileinfo maxpath'\desc.sdi' tonul
     status='NEWDESC'
     diz='@desc.sdi'
   end /* do */
 end 
return
/* ------ end of checkdesc ------------- */

/* - Run McAffees Scan on testfiledir - */

scanner:
 if debug then
   file = LINEOUT(debugfile,'Scanner subfunction')
  scanc=scancmd||testfiledir' /ALL /DEL'tonul
  /* Test the files in the main package*/
  scanc
  if RC>0 then do
    if RC=1 then
      status = 'INFECTED'
    else
      status = 'ERROR'
  end
  /* Test the subdirectories*/
  if (testfiledir.0 > 0) & (status <> 'INFECTED') & (status <> 'ERROR') then do

    push testfiledir
    do ii = 1 to testfiledir.0
      testfiledir = testfiledir.ii
      scanc=scancmd||testfiledir'\*.* /ALL /DEL'tonul
      scanc
      if RC>0 then do
        if RC=1 then
          status = 'INFECTED'
        else
          status = 'ERROR'
        leave
      end

    end
    pull testfiledir
  end
 
return

/* ----------end --  scanner ------------- */

/* -  clean up testfile dir when we're done - */

cleanupdir:
 if debug then
   file = LINEOUT(debugfile,'Cleaning up Dir')
  workdrive
  'CD\'
  if stream(testfiledir||'\*.*','c','query exist')  <> '' then do
 if debug then
   file = LINEOUT(debugfile,'Something to clear in 'testfiledir)
    'attrib -r 'testfiledir'\* 'tonul
    'del 'testfiledir'\*.* 'dontask   /* cleanup test dir     */
  end
  if testfiledir.0 > 0 then do
    do ii = 1 to testfiledir.0
      if stream(testfiledir.ii||'\*.*','c','query exist') <> '' then do
        if debug then
          file = LINEOUT(debugfile,'Something to clear in 'testfiledir.ii)
        'attrib -r 'testfiledir.ii'\* 'tonul
        'del 'testfiledir.ii'\*.* 'dontask  /* cleanup 2nd test dir */
      end
      if debug then
        file = LINEOUT(debugfile,'re-making 'testfiledir.ii)
      call SysRmDir testfiledir.ii
    end
  end
  /* Remove test subdirectory if complete*/
  if filecnt = lfile.0 then do
    if debug then
      file = LINEOUT(debugfile,'re-making 'testfiledir)
    call SysRmDir testfiledir
  end
return
/* ------- end -- cleanupdir ---------------- */  

/*  ----------- Subroutine SendMsg --------------------------- */
/*  enter appropriate messages to log(s) and bbs user          */

sendmsg:
 fileentry =''
 select 
   when status = 'BAD' then do
     logentry = '!'logdate filename' failed extract'
     fileentry =  filename" failed to extract from archive - uploaded by: "username
   end /* do */
   when status = 'EXE' then do
     logentry = '!'logdate' 'filename' suspicious'
     fileentry = filename" exec, moved to prevent trojan, virii ...-uploaded by: "username
   end /* do */
   when status = 'UNKNOWN' then do 
     logentry = '!'logdate' 'filename' UNKNOWN type'
     fileentry = filename" of unknown type, moved - uploaded by: "username
   end /* do */
   when status = 'INFECTED' then do
     logentry = '!'logdate' 'filename' INFECTED!!!'
     fileentry = filename" INFECTED - triggered scanner -uploaded by: "username
   end /* do */
   when status = 'GOOD' then do
     logentry = '+'logdate' 'filename' OK credit given' 
     file = LINEOUT(logfile,RIGHT('Filesize:',32)' 'fsize' bytes, dated: 'fildate)
     file = LINEOUT(logfile,RIGHT(numfiles,35)' files, Newest: 'newdate' - Oldest: 'olddate)
     if ZIPTYPE \= '' then do
       logentry = RIGHT('archive was ',35)' 'ZIPTYPE
       file = LINEOUT(logfile,RIGHT('Uploaded by:',35)' 'username)
     end
     else
       logentry = RIGHT('Uploaded by:',35)' 'username
   end
   when status = 'NOEXT' then do
     logentry = '!'logdate' 'filename' had no .ext - moved to badfiles'
     fileentry = filename" had no extension, moved - uploaded by:"username
   end /* do */
   when status = 'REJECT' then do
     logentry = '!'logdate' 'filename' was in reject list - deleted'
     fileentry = filename" on reject list, deleted - uploaded by:"username
   end /* do */
   when status = 'OLD' then do
     logentry = '!'logdate' 'filename' was too old - moved to badfiles'
     fileentry = filename" was older than allowed - uploaded by: "username
   end /* do */
   when status = 'PASS' then do
     file = LINEOUT(logfile,'+'logdate' 'filename' ok - credit given (AutoPass)')
/*     logentry = RIGHT('Uploaded by:',35)' 'username*/
   end
   otherwise do
     logentry = '!'logdate' ERROR running ViREXX'
     fileentry = filename "ERROR running ViREXX"
   end /* do */
 end /* select */

 file = LINEOUT(logfile,logentry)                /* write entry to Virexx log   */
 file = LINEOUT(logfile)


if Mlog then do
  file = LINEOUT(maxlog,logentry)    /* write to Max log if enabled */
  file = LINEOUT(maxlog)
end

if status = 'BAD' | status = 'INFECTED' | status = 'UNKNOWN' | status = 'EXE' | status = 'NOEXT' | status = 'OLD'  then do
  badfilebbs=badfiledir'\files.bbs'
  file = LINEOUT(badfilebbs,fileentry)
  file = LINEOUT(badfilebbs)
end /* do */

/*call tokens*/                         /* load mecca tokens for .bbs output  */
/*call bbsmsg*/                         /* write file_ok.bbs or file_bad.bbs  */ 
return


/* ----- check date - move to badfilesarchive if it contains ----- */
/* ----- files older than oldest ----------------------------------*/

checkdate:
  datelist=''
  archsize = 0
  numfiles = 0
  SrchFile = testfiledir'\*.*'
  call SysFileTree SrchFile,'file','FT'
  oldestfile = ''
  call TestDate
  if testfiledir.0 > 0 then do
    do ii = 1 to testfiledir.0
      SrchFile = testfiledir.ii'\*.*'
      if debug then
        file = LINEOUT(debugfile,'SearchFile= 'srchfile)
      call SysFileTree SrchFile,'file','FT'
      call TestDate
    end
  end
  DROP(file.)
return   /* checkdate */

/* Get oldest and newest dates*/
TestDate:
do i = 1 to file.0

  fsize = WORD(file.i, 2)
  archsize = archsize + fsize
  numfiles = numfiles + 1

  testdate  = SUBSTR(file.i, 1, 2)||SUBSTR(file.i, 4, 2)
  if testdate > oldest then do
    if oldestfile <> '' then do
      if testdate > newestfile then
        newestfile = testdate
      else
      if testdate < oldestfile then
        oldestfile = testdate
    end /* do */
    else do
      oldestfile = testdate
      newestfile = testdate
    end /* do */
  end
  else do 
    status = 'OLD'
  end /* do */
end  /* do */
return
/* ----- end -- checkdate ---- */

/* ------ Unzip - run unzip on filename ------- */
unzip1:
  'CD 'testdir tonul
  if debug then
    file = LINEOUT(debugfile,'unzipping version 1.x file 'fname)
  ZIPTYPE = 'Zip 1.x'
  zipdir||zip_command1' 'ffname tonul
  if RC = 0 then do                             /* unzipped OK           */
    status = 'GOOD'
  end
  else do                                       /* failed to unzip       */
    status = 'BAD'
  end  /* do */
return

/* end unzip1 */
/* ------ Unzip2 - run unzip on version 2.x filename ------- */
unzip2:
 'CD 'testdir tonul
 if debug then
   file = LINEOUT(debugfile,'unziping type 2.x zipfile: 'fname)
 ZIPTYPE = 'Zip 2.x'
 zipdir||zip_command2' 'ffname tonul           /* unzip file to testdir */
 if RC = 0 then do                             /* unzipped OK           */
   status = 'GOOD'
 end
 else do                                       /* failed to unzip       */
   status = 'BAD'
 end  /* do */
return  

/* end unzip2 */
/* ------ Unzoo - run zoo on filename ------- */
unzoo:
  'CD 'testdir tonul
  if debug then
    file = LINEOUT(debugfile,'unzooing 'fname)
  zipdir||zoo_command' 'ffname tonul
  if RC = 0 then do                             /* unzipped OK           */
    status = 'GOOD'
  end
  else do                                       /* failed to unzip       */
    status = 'BAD'
  end  /* do */
return

/* end unzoo */

/* ------ UnRaR - run Unrar on filename ------- */
unrar:
  'CD 'testdir tonul
  if debug then
    file = LINEOUT(debugfile,'unraring 'fname)
  zipdir||rar_command' 'ffname tonul
  if RC = 0 then do                             /* unzipped OK           */
    status = 'GOOD'
  end
  else do                                       /* failed to unzip       */
    status = 'BAD'
  end  /* do */
return

/* end unzoo */


/* ---------  unarj -- run unarj on filename --------------- */
unarj:
     /* written for arj                                                     */

  'CD 'testdir tonul
  if debug then
    file = LINEOUT(debugfile,'unarjing 'fname)
  zipdir||arj_command' 'ffname tonul
  if RC = 0 then do                                 /* unarjed OK       */
    status = 'GOOD'
  end /* do */
  else do          
    status = 'BAD'                              /* failed to unarj   */
  end  /* do */
return

/* end unarj */

/* ----------- unlzh -- unlzh filename ----------- */
         
unlzh:
  /* written for LH32  2.21    */
  'CD 'testdir tonul
  if debug then
    file = LINEOUT(debugfile,'unlhzing 'fname)
  zipdir||lh_command' 'ffname tonul             /* unlzh file to testdir */
  if RC = 0 then do                             /* unlzh'd OK           */
    status = 'GOOD'
  end
  else do                                       /* failed to unlzh       */
    status = 'BAD'
  end  /* do */
return

/* end unlzh */

/* ----- unarc -- unarc filename using ARC2 ---- */

unarc:
  /* written for ARC2 6.00p                                              */

  if debug then
    file = LINEOUT(debugfile,'unarcing 'fname)
  'CD 'testdir tonul
  zipdir||arc_command' 'ffname tonul             /* unarc file        */
  if RC = 0 then do                              /* unarced OK        */
    status = 'GOOD'
  end
  else do                                          /* failed to unarc   */
    status = 'BAD'
  end  /* do */
return

/* end unarc  */

/* ---- checknested -- look for nested archives ------ */ 

checknested:
  testfiledir.0 = 0                  /* testdir is where unpacked files go*/
  testcnt = 0
  call searchnest
  if testcnt > 0 then do             /* check for 2nd level of nested*/
    push testfiledir

    /* Do until no more compressed files found*/
    do until testfiledir.0 = testcnt
      startdir = testfiledir.0 + 1
      testfiledir.0 = testcnt
      
      do ii = startdir to testfiledir.0
        testfiledir = testfiledir.ii
        call searchnest
      end

    end
    pull testfiledir
  end /* do */
return /* checknested */


  /*     searchnest -- does the actual searching for files with   */
  /*     archive type extensions                                  */


searchnest:

  workdrive = FILESPEC("drive",testfiledir)
  SrchFile = testfiledir'\*.arj'           /* look for .arj files          */
  call SysFileTree SrchFile,'file','FO'
  if file.0 > 0 then
  do i = 1 to file.0
    ffname = file.i
    fname = FILESPEC("name",ffname)
    /* Find path to the directory*/
    fpath = FILESPEC("path",ffname)
    /* Takeout last \ */
    fpath = STRIP(fpath,'T','\')
    /* Change to working drive*/
    workdrive
    /* Get to the correct subdirectory*/
    'CD 'fpath
    /* get the new subdirectory name*/
    testdir = OVERLAY('$$$',ffname,LENGTH(ffname) - 2)
    call SysMkDir testdir
    /* Expand the file*/
    call unarj
    /* del the Unarjed file*/
    'attrib -r 'ffname tonul
    'del 'ffname' 'dontask
    /* Add the file to the list*/
    testcnt = testcnt + 1
    testfiledir.testcnt = testdir
  end /* do */

  SrchFile = testfiledir'\*.zip'             /* look for .zip files       */
  call SysFileTree SrchFile,'file','FO'
  if file.0 > 0 then
  do i = 1 to file.0
    ffname = file.i
    fname = FILESPEC("name",ffname)
    /* Find path to the directory*/
    fpath = FILESPEC("path",ffname)
    /* Takeout last \ */
    fpath = STRIP(fpath,'T','\')
    /* Change to working drive*/
    workdrive
    /* Get to the correct subdirectory*/
    'CD 'fpath
    /* get the new subdirectory name*/
    testdir = OVERLAY('$$$',ffname,LENGTH(ffname) - 2)
    if debug then do
      file = LINEOUT(debugfile,'TestFileDir= 'testfiledir)
    end
/*   say testdir*/
    call SysMkDir testdir
    /* Expand the file*/
    signature = CHARIN(ffname,1,6)
    select
      when (substr(signature,1,5) = 'PK') then do  /* version 2.x zip file    */
        temp = stream(ffname,'c','close')
        call unzip2
      end /* do */

      when (substr(signature,1,4) = 'PK') then do  /* version 1.x zip file    */
        temp = stream(ffname,'c','close')
        call unzip1
      end /* do */
      otherwise
        nop
    end /* select */
    'attrib -r 'ffname tonul
    'del 'ffname' 'dontask
    /* Add the file to the list*/
    testcnt = testcnt + 1
    testfiledir.testcnt = testdir
  end /* do */

  SrchFile = testfiledir'\*.arc'           /* look for .arc files         */
  call SysFileTree SrchFile,'file','FO'
  if file.0 > 0 then
  do i = 1 to file.0
    ffname = file.i
    fname = FILESPEC("name",ffname)
    /* Find path to the directory*/
    fpath = FILESPEC("path",ffname)
    /* Takeout last \ */
    fpath = STRIP(fpath,'T','\')
    /* Change to working drive*/
    workdrive
    /* Get to the correct subdirectory*/
    'CD 'fpath
    /* get the new subdirectory name*/
    testdir = OVERLAY('$$$',ffname,LENGTH(ffname) - 2)
    call SysMkDir testdir
    /* Expand the file*/
    call unarc
    'attrib -r 'ffname tonul
    'del 'ffname' 'dontask
    /* Add the file to the list*/
    testcnt = testcnt + 1
    testfiledir.testcnt = testdir
  end /* do */


  SrchFile = testfiledir'\*.lzh'          /* look for .lzh files           */
  call SysFileTree SrchFile,'file','FO'
  if file.0 > 0 then do
  do i = 1 to file.0
    ffname = file.i
    fname = FILESPEC("name",ffname)
    /* Find path to the directory*/
    fpath = FILESPEC("path",ffname)
    /* Takeout last \ */
    fpath = STRIP(fpath,'T','\')
    /* Change to working drive*/
    workdrive
    /* Get to the correct subdirectory*/
    'CD 'fpath
    /* get the new subdirectory name*/
    testdir = OVERLAY('$$$',ffname,LENGTH(ffname) - 2)
    call SysMkDir testdir
    /* Expand the file*/
      call unlzh
    end
    'attrib -r 'ffname tonul
    'del 'ffname' 'dontask
    /* Add the file to the list*/
    testcnt = testcnt + 1
    testfiledir.testcnt = testdir
  end /* do */

  SrchFile = testfiledir'\*.rar'          /* look for .lzh files           */
  call SysFileTree SrchFile,'file','FO'
  if file.0 > 0 then do
  do i = 1 to file.0
    ffname = file.i
    fname = FILESPEC("name",ffname)
    /* Find path to the directory*/
    fpath = FILESPEC("path",ffname)
    /* Takeout last \ */
    fpath = STRIP(fpath,'T','\')
    /* Change to working drive*/
    workdrive
    /* Get to the correct subdirectory*/
    'CD 'fpath
    /* get the new subdirectory name*/
    testdir = OVERLAY('$$$',ffname,LENGTH(ffname) - 2)
    call SysMkDir testdir
    /* Expand the file*/
      call unrar
    end
    'attrib -r 'ffname tonul
    'del 'ffname' 'dontask
    /* Add the file to the list*/
    testcnt = testcnt + 1
    testfiledir.testcnt = testdir
  end /* do */

return

/* --- end checknested ---------- */
tokens:
cls=''
firstname=''
blue=''
lightblue=''
cyan=''
lightcyan=''
green=''
lightgreen=''
brown=''
yellow=''
grey=''
gray=''
white=''
red=''
lightred=''
magenta=''
lightmagenta=''
blink=''
steady=''
enter=''
return



bbsmsg:     
return
do i = 7 to 25    /* clear msg */
  msg.i = ''
end /* do */

 msg.1=cls   
 msg.2="      "blue"ͻ"
 msg.3="      "blue"             "lightcyan"ViREXX "yellow"Scan Report                  "blue"" 
 msg.4="      "blue"Ķ"
 msg.5="      "blue"  "lightcyan"ViREXX "yellow"Archive verifier/Virus Checker "white"[beta]   "blue""
 msg.6="      "blue" "lightcyan"(c) Doug Cullen, 1992,1993 "blue"ͼ"

select
  when status = 'GOOD' | status = 'TEXT'  then do
   file_out = file_ok
   msg.8=green"  ͸"
   msg.9=green"  "lightcyan" FileName: "yellow||CENTER(filename,14)||green" "lightcyan"Dated :"yellow||fildate"             "green""
   msg.10=green"  Ĵ"
   msg.11=green"   "lightcyan"FileSize:"yellow||CENTER(filesize,8)"bytes  "green" "lightcyan"Extracted Size: "yellow||CENTER(archsize,8)"bytes"green""
   msg.12=green"  Ĵ"
   msg.13=green"   "lightcyan"Archive contains: "yellow||CENTER(numfiles,3)" files                            "green""
   msg.14=green"  Ĵ"
   msg.15=green"   "lightcyan"Oldest file :"yellow||CENTER(olddate,8)"   "green" "lightcyan"Newest file :"yellow||CENTER(newdate,8)"        "green""
   msg.16=green"  ;"
   msg.18=lightcyan "Thanks for the upload, "firstname" Everything checks out OK"
   msg.20=lightcyan "Full credit given for your upload"grey
  end /* GOOD */

  when status = 'PASS' then do
   file_out = file_ok
   msg.8="     "lightcyan"ViREXX "yellow"has scanned your file:"white filename
   msg.10="     "yellow"and it PASSED.   You have "white"FULL CREDIT "yellow"for the upload"
   msg.12="     "yellow
   msg.14="     "yellow"Thanks for Supporting "lightcyan bbsname
   msg.16="     "yellow
  end /* PASS */

  when status = 'BAD' then do
   file_out = file_bad
   msg.8="     "lightcyan"ViREXX "yellow"has scanned your file:"white filename       
   msg.10="     "yellow"and was unable to extract any files from the archive"
   msg.12="     "yellow"You may want to check your file for errors. (Please "lightred"DONT "yellow"use"
   msg.14="     "yellow"PKZIP 1.93a)   You won't receive any credit for the file at"
   msg.16="     "yellow"this time, but the file has been moved for SYSOP inspection"grey
   msg.18=enter
   end /* BAD */

  when status = 'INFECTED' then do
   file_out = file_bad
   msg.8="     "blink red"WARNING "white"WARNING "red"WARNING "white"WARNING - "steady yellow"Your file :"white filename
   msg.10="     "yellow"has caused a "red"VIRUS "yellow"warning from our system.  You won't"
   msg.12="     "yellow"receive any credit for you upload at this time, but the"
   msg.14="     "yellow"file has been moved for SYSOP inspection."grey
   msg.16=""
   msg.18=enter
   end /* infected */

  when status = 'UNKNOWN' then do
   file_out = file_bad
   msg.8="     "lightcyan"ViREXX "yellow"was unsure what to do with your file:"white filename
   msg.10="     "yellow"since it was not one of the kind we accept.  Please"
   msg.12="     "yellow"limit your uploads to .ZIP, .ARC, .ARJ or .LZH files."
   msg.14="     "yellow"You won't recieve any credit for your upload at this" 
   msg.16="     "yellow"time, but the file has been moved for SYSOP inspection"grey
   msg.18=enter
  end /* UNKNOWN */

  when status = 'EXE' then do
   file_out = file_bad
   msg.8="      "lightcyan"Virexx "yellow"has moved your file to a holding area for the"
   msg.10="      "yellow"Sysop to inspect.   This action has been taken to help"
   msg.12="      "yellow"prevent the spread of "lightred"viruses, bombs "yellow"and "lightred"trojans "yellow"that"
   msg.14="      "yellow"are frequently spread around in executable files. "
   msg.16="      "white"Thanks for your understanding."grey
   msg.18=enter
  end /* EXE */

  when status = 'NOEXT' then do
   file_out = file_bad
   msg.8="     "lightcyan"ViREXX "yellow"was unsure of how to handle your file: "file
   msg.10="     "yellow"since it had no file extension.  Please limit your"
   msg.12="     "yellow"uploads to "lightgreen".ZIP, .ARC, .ARJ "yellow"or "lightgreen".LZH "yellow"files.  You won't"
   msg.14="     "yellow"recieve any credit for your upload at this time, but" 
   msg.16="     "yellow"the file has been moved for "white"SYSOP "yellow"inspection"grey
   msg.18=enter
  end /* NOEXT */

  when status = 'OLD' then do
   file_out = file_bad
   msg.8="     "lightcyan"ViREXX "yellow"has found that some of the files in "filename
   msg.10="     "yellow"are older than we normally accept.  Sorry, but you"
   msg.12="     "yellow"won't receive credit for your upload.  The file has"
   msg.14="     "yellow"been moved for SYSOP inspection"
   msg.18="     "grey
   msg.20=enter
  end /* OLD */

  when status = 'REJECT' then do
   file_out = file_bad
   msg.8="     "yellow"Sorry "fname" but the file you uploaded:"lightcyan filename
   msg.10="     "yellow"is not accepted here at"lightmagenta bbsname
   msg.12=""
   msg.14="     "yellow"Please refrain from uploading similar files in the"
   msg.16="     "yellow"future."
   msg.18="     "lightred"Failure to heed this warning may result in Sysop action"
   msg.20=grey enter
  end /* REJECT */

  when status = 'INCOMPLETE' then do
   file_out = file_ok
   msg.8="     "yellow"The Virus check did not Complete"
   msg.10="     "yellow"Please leave a message at "lightmagenta bbsname
   msg.12=""
   msg.14="     "yellow"Ask the sysop to check the return code in the"
   msg.16="     "yellow"log file and report the problem."
   msg.18="     "lightred"If a 1042 error then a program was not found in Path"
   msg.20=grey enter
  end /* REJECT */

  otherwise
   nop
end /* select */

  'del 'file_out' 'dontask
/*  do i = 1 to 20*/
/*    file = LINEOUT(file_out,msg.i)*/
/*  end /* do */*/
/*  file = LINEOUT(file_out)*/

return

filestats:
numfiles=0
oldmonth = ''
oldyear  = ''
newyear = ''
newmonth= ''
numonth = '010203040506070809101112'
month = 'JanFebMarAprMayJunJulAugSepOctNovDec'
SrchFile = fullname
filesize = stream(SrchFile,'c','query size')
fdate=stream(SrchFile,'c','query datetime')
parse value fdate with fm'-'fd'-'fy  hours
if fm <> '' then do
  findmth = (POS(fm,numonth) + 1) / 2
  if findmth=1.5 then findmth=10
  findmth=findmth-1
  if findmth >= 0 then
    fildate = fd'-'SUBSTR(month, 3 * findmth + 1, 3)'-'fy
  else
    fildate = fd'-xxx-'fy
  SrchFile = testfiledir'\*.*'
  call SysFileTree SrchFile,'file','FO'
  do i = 1 to file.0
    fsize=stream(file.i,'c','query size')
    archsize=archsize+fsize
    numfiles=numfiles+1
  end /* do */

  oldyear  = SUBSTR(oldestfile,1,2)
  newyear  = SUBSTR(newestfile,1,2)
  oldmonth = '   '
  newmonth = '   '
  findmth = (POS(SUBSTR(oldestfile,3,2),numonth) + 1) / 2 * 3 - 2
  if findmth=2.5 then findmth=13
  if findmth=-0.5 then findmth=1
    oldmonth = SUBSTR(month, findmth, 3)
  findmth = (POS(SUBSTR(newestfile,3,2),numonth) + 1) / 2 * 3 - 2
  if findmth=2.5 then findmth=13
  if findmth >= 1 then
    newmonth = SUBSTR(month, findmth, 3)
  olddate=oldmonth'-'oldyear
  newdate=newmonth'-'newyear
end
return

databaseout:
databaseentry=filename','fildate','uldate','filesize','archsize','numfiles','olddate','newdate','username
file = LINEOUT(database,databaseentry)
file = LINEOUT(database)
return

USAGE:
say ' '
say ' ViREXXT.CMD - File Integrety Tester written in REXX '
say ' '
say ' USAGE: Virexx d:\path\ filename .ext'
say ' '
say ' d:\path\   = path to file to be checked INCLUDING trailing \'
say ' '
say ' filename   = the name of the file with no path or extension'
say ' '
say ' .ext       = the file extension including the . '
say ' '
signal CLEANUP
return
