#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <conio.h>
#include "snsrv_32.h"

#define kbhit() (_read_kbd(0,0,0)!=-1)

static short mesgfunc(short error, char *mesg);

void sigsegv(int sig) {
  signal(sig,SIG_ACK);
  printf("\nSegment violation, abort\n");
  exit(3);
}

void sigint(int sig) {
  signal(sig,SIG_ACK);
  printf("\nInterrupt %d, abort\n",sig);
  exit(4);
}

int main(int argc, char **argv) {
  static char *testmsg="Test application";
  HSNOOP2 hsn;
  USHORT rc;
  long   c = 0L;
  char  *str;
  char  *pipe;

  signal(SIGSEGV,sigsegv);
  signal(SIGHUP,sigint);
  signal(SIGINT,sigint);
  signal(SIGTERM,sigint);

  if (argc>1)
    pipe = argv[1];
  else
    pipe = "\\pipe\\maxsnoop";

  hsnoop=0;

  rc=SnoopOpen2(pipe,&hsnoop,testmsg,mesgfunc);
/*  printf("rc=%d, hsn=%d\n",rc,hsn); */
  str=malloc(80);

  while (!kbhit()) {
/*    DosSleep(20); */
    sprintf(str, "+ Hello #%lu\n", c);
    if( !(c % 20L) )
      sprintf(str, "! Hello #%lu\n", c);
    rc=SnoopWrite2(hsn, str);
    printf("%lu\r", c++);
  }

  getch();
  free(str);
  str=NULL;
  rc=SnoopClose2(hsn);
  return 0;
}

static short mesgfunc(short error, char *mesg) {
  if (error)
    printf("! SYS%04u: %s\n", error, mesg);
  else
    printf("> %s\n", mesg);
  return(0);
}
