/* Recreate objects script.
 *
 * Generated via Object Desktop Package File 'Object Package'.
 */

/* Register with REXX API extensions. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

CreateCollision = 'Update'

Call SysCls

/* Get COM port. */
Say ' '
Say 'Create Bind 8.2.3 for OS/2 folder and icons.'
Say
Say 'NOTE: This program needs to be executed from the base directory'
Say '      of your working setup.'
Say ' '
'@pause'

Call CreateObjects
Exit

CreateObject: procedure
    Parse Arg Class, Title, Location, Setup, Collision
    Say 'Creating ['Title']'
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        Say ' > failed to create ['Title' | 'Class'] at location ['Location']'
    return rc

CreateObjects:

/* Figure out the directories involved. */
current_dir = directory()

  rc = CreateObject( 'WPFolder',,
    'BIND 8.2.3^for OS/2',,
    '<WP_DESKTOP>',,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ALWAYSSORT=YES;'||,
        'OBJECTID=<Bind_8_2_3_for_OS_2>',,
    CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'INSTALL.OS2',,
      '<Bind_8_2_3_for_OS_2>',,
      'SHADOWID='||current_dir||'\INSTALL.OS2',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'README.OS2',,
      '<Bind_8_2_3_for_OS_2>',,
      'SHADOWID='||current_dir||'\README.OS2',,
      CreateCollision )

/*  rc = CreateObject( 'WPUrl',,
      'OS/2 Readme',,
      '<Bind_8_2_3_for_OS_2>',,
      'URL=file:///'||current_dir||'\doc\readme.html;',,
      CreateCollision ) */

  rc = CreateObject( 'WPUrl',,
      'Bind Documentation',,
      '<Bind_8_2_3_for_OS_2>',,
      'URL=file:///'||current_dir||'\doc\html\index.html;',,
      CreateCollision )

/*  rc = CreateObject( 'WPUrl',,
      'Bind Manuals',,
      '<Bind_8_2_3_for_OS_2>',,
      'URL=file:///'||current_dir||'\doc\man\index.html;',,
      CreateCollision ) */

  rc = CreateObject( 'WPProgram',,
      'NSLOOKUP^(Prompts for DNS name)',,
      '<Bind_8_2_3_for_OS_2>',,
      'NOPRINT=YES;'||,
           'DEFAULTVIEW=RUNNING;'||,
           'EXENAME='||current_dir||'\bin\nslookup.EXE;'||,
           'STARTUPDIR='||current_dir||'\bin;'||,
           'PARAMETERS=[DNS Name];'||,
           'PROGTYPE=WINDOWABLEVIO;'||,
           'NOAUTOCLOSE=YES',,
       CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'NSLOOKUP^(Interactive)',,
      '<Bind_8_2_3_for_OS_2>',,
      'NOPRINT=YES;'||,
           'DEFAULTVIEW=RUNNING;'||,
           'EXENAME='||current_dir||'\bin\nslookup.EXE;'||,
           'STARTUPDIR='||current_dir||'\bin;'||,
           'PROGTYPE=WINDOWABLEVIO',,
       CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'NDC2^(Prompts for Command)',,
      '<Bind_8_2_3_for_OS_2>',,
      'NOPRINT=YES;'||,
           'DEFAULTVIEW=RUNNING;'||,
           'EXENAME='||current_dir||'\bin\ndc2.cmd;'||,
           'STARTUPDIR='||current_dir||'\bin;'||,
           'PARAMETERS=[Command: (status|dumpdb|reload|stats|trace|notrace|querylog|start|stop|restart)];'||,
           'PROGTYPE=WINDOWABLEVIO;'||,
           'NOAUTOCLOSE=YES',,
       CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'NDC2^(Stop)',,
      '<Bind_8_2_3_for_OS_2>',,
      'NOPRINT=YES;'||,
           'DEFAULTVIEW=RUNNING;'||,
           'EXENAME='||current_dir||'\bin\ndc2.cmd;'||,
           'STARTUPDIR='||current_dir||'\bin;'||,
           'PARAMETERS=stop;'||,
           'PROGTYPE=WINDOWABLEVIO;'||,
           'NOAUTOCLOSE=YES',,
       CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'NDC2^(Reload)',,
      '<Bind_8_2_3_for_OS_2>',,
      'NOPRINT=YES;'||,
           'DEFAULTVIEW=RUNNING;'||,
           'EXENAME='||current_dir||'\bin\ndc2.cmd;'||,
           'STARTUPDIR='||current_dir||'\bin;'||,
           'PARAMETERS=reload;'||,
           'PROGTYPE=WINDOWABLEVIO;'||,
           'NOAUTOCLOSE=YES',,
       CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'NDC2^(Stats)',,
      '<Bind_8_2_3_for_OS_2>',,
      'NOPRINT=YES;'||,
           'DEFAULTVIEW=RUNNING;'||,
           'EXENAME='||current_dir||'\bin\ndc2.cmd;'||,
           'STARTUPDIR='||current_dir||'\bin;'||,
           'PARAMETERS=stats;'||,
           'PROGTYPE=WINDOWABLEVIO;'||,
           'NOAUTOCLOSE=YES',,
       CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'NDC2^(Status)',,
      '<Bind_8_2_3_for_OS_2>',,
      'NOPRINT=YES;'||,
           'DEFAULTVIEW=RUNNING;'||,
           'EXENAME='||current_dir||'\bin\ndc2.cmd;'||,
           'STARTUPDIR='||current_dir||'\bin;'||,
           'PARAMETERS=status;'||,
           'PROGTYPE=WINDOWABLEVIO;'||,
           'NOAUTOCLOSE=YES',,
       CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'NDC2^(Start)',,
      '<Bind_8_2_3_for_OS_2>',,
      'NOPRINT=YES;'||,
           'DEFAULTVIEW=RUNNING;'||,
           'EXENAME='||current_dir||'\bin\ndc2.cmd;'||,
           'STARTUPDIR='||current_dir||'\bin;'||,
           'PARAMETERS=start;'||,
           'PROGTYPE=WINDOWABLEVIO;'||,
           'NOAUTOCLOSE=YES',,
       CreateCollision )

  confFile = value('ETC',,'OS2ENVIRONMENT')||'\named.conf'
  rc = CreateObject( 'WPProgram',,
      'NAMED',,
      '<Bind_8_2_3_for_OS_2>',,
      'NOPRINT=YES;'||,
           'DEFAULTVIEW=RUNNING;'||,
           'EXENAME='||current_dir||'\bin\named.exe;'||,
           'STARTUPDIR='||current_dir||'\bin;'||,
           'PARAMETERS=-c '||confFile||';'||,
           'MINIMIZED=YES;'||,
           'PROGTYPE=WINDOWABLEVIO',,
       CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'named.conf',,
      '<Bind_8_2_3_for_OS_2>',,
      'SHADOWID='||confFile,,
      CreateCollision )


  rc = CreateObject( 'WPProgram',,
      'HOST^(Prompts for IP)',,
      '<Bind_8_2_3_for_OS_2>',,
      'NOPRINT=YES;'||,
           'DEFAULTVIEW=RUNNING;'||,
           'EXENAME='||current_dir||'\bin\host.exe;'||,
           'STARTUPDIR='||current_dir||'\bin;'||,
           'PARAMETERS=[Enter IP to Lookup Hostname For];'||,
           'PROGTYPE=WINDOWABLEVIO;'||,
           'NOAUTOCLOSE=YES',,
       CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'NDC^(Interactive)',,
      '<Bind_8_2_3_for_OS_2>',,
      'NOPRINT=YES;'||,
           'DEFAULTVIEW=RUNNING;'||,
           'EXENAME='||current_dir||'\bin\ndc.EXE;'||,
           'STARTUPDIR='||current_dir||'\bin;'||,
           'PROGTYPE=WINDOWABLEVIO',,
       CreateCollision )


return

