/* Sample IRC REXX script for Virtual IRC Alpha, for OS/2 ! */

Parse Upper Arg Winhandle WinName OurNick Verb Parm1 Parms
Parse Arg xWinHandle xWinName xOurNick xVerb xParm1 xParms

Pool = 'OS2ENVIRONMENT'

/* rc = LineOut('rxdebug.txt', xWinHandle xWinName xUs xVerb xParm1 xParms)  */
 
if (Verb = '/REXXTEST') then do
   rc = IrcRexxDisplay('*** Test of IRC Rexx', WinHandle)
   rc = IrcRexxDisplay('*** Testing IrcRexxWildCard("*!*smaze@*.hogia.net", "Smaze!smaze@xiivc.modem.hogia.net")', WinHandle)
   rc = IrcRexxDisplay('*** Returned: ' IrcRexxWildCard("*!*smaze@*.hogia.net", "Smaze!smaze@xiivc.modem.hogia.net"), WinHandle)
   rc = IrcRexxDisplay('*** Testing IrcRexxWildCard("*!*smaze@*.hogia.net", "Smaze!smaze@t12p20.telia.com")', WinHandle)
   rc = IrcRexxDisplay('*** Returned: ' IrcRexxWildCard("*!*smaze@*.hogia.net", "Smaze!smaze@t12p20.telia.com"), WinHandle)
   rc = IrcRexxDisplay('*** Testing IrcRexxCommand("/j virc2", WinHandle)', WinHandle)
   rc = IrcRexxCommand('/j virc2', WinHandle)
   rc = IrcRexxDisplay('*** Testing IrcRexxSend("WHOIS' xOurNick || '", WinHandle)', WinHandle)
   rc = IrcRexxSend('WHOIS' xOurNick, WinHandle)
   rc = IrcRexxDisplay('*** IRC Rexx successfully tested!', WinHandle)   
   Return ''
end

if (Verb = '/NOTOPS') then do
    Users = IrcRexxVariable(WinHandle, '$USERS', '')
    if (Parm1 = '') | (Users = '') then rc = IrcRexxDisplay('### Invalid channel or no parameter.', WinHandle)
    Else do
       do While Users <> ''
          Parse Var Users User xUsers
          Users = xUsers
          if User <> '' then
            if Pos('@', User) = 1 then do
               User = Strip(User, 'L','@')
               if Translate(User) <> OurNick then
                 rc = IrcRexxSend('NOTICE' User ':[Ops on' xWinName || ']:' xParm1 xParms, WinHandle)
            End
       End
       rc = IrcRexxDisplay('-> [Ops on' xWinName || ']:' xParm1 xParms, WinHandle)
    End
    Return ''
End

 /***********************************************\
|   /EXEC Command Written By Rod Taylor (Dark)    |
 \***********************************************/
if (Verb = '/EXEC') then do
    call library
    if (parms = '') then do
         rc = IrcRexxDisplay('Use:', WinHandle)    
         rc = IrcRexxDisplay('/EXEC <PARMIMETERS>', WinHandle)
         rc = IrcRexxDisplay('Where <PARMIMETERS> is what is executed via the command line', WinHandle)    
         return ''
    end
    else if (parm1 <> '-O') then 
        parms = parm1' 'parms
    
    if parm1 = '-O' then 
        rc = IrcRexxCommand('<Command: 'parms'  running...>', WinHandle)
    else 
        rc = IrcRexxDisplay('<Command: 'parms'  running...>', WinHandle)       

    rc = sysfiledelete('temp.dat')
    parms' >> temp.dat'
    rc = stream('temp.dat', 'c', 'open read')
    do while lines('temp.dat')
        filedata = linein('temp.dat')
        if filedata <> '' then do
            if parm1 = '-O' then 
                rc = IrcRexxCommand(filedata, WinHandle)
            else 
                rc = IrcRexxDisplay(filedata, WinHandle)       
        end
    end
    rc = stream('./temp.dat', 'c', 'close')
    rc = sysfiledelete('./temp.dat')
    if parm1 = '-O' then 
        rc = IrcRexxCommand('<End Of Data>', WinHandle)
    else 
        rc = IrcRexxDisplay('<End Of Data>', WinHandle)       

    return ''
end

If (Verb = '/SOUND') then do
    if (Parm1 = '') then rc = IrcRexxDisplay('### Invalid nickname parmameter.', Winhandle)
    else if (Parms = '') then rc = IrcRexxDisplay('### Invalid sound file parmameter.', Winhandle)
    else do
        Parse Var Parms Parm2 Parms
        Parse Var xParms xParm2 xParms
        If (Parms = '') then do
            rc = IrcRexxSend('PRIVMSG' Parm1 ':SOUND 'Parm2'', Winhandle)
            rc = IrcRexxDisplay('*** Playing 'xParm2' to 'xParm1'', Winhandle)
        end
        else do
            rc = IrcRexxSend('PRIVMSG' Parm1 ':SOUND 'Parm2 xParms'', Winhandle)
            rc = IrcRexxDisplay('*** Playing 'xParm2' to 'xParm1' ('xParms')', Winhandle)
        end
    end
    Return ''
end

Return "OK"

library:
	CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
	CALL SysLoadFuncs
Return
