/* Install program for WarpAMP

   (c) 1998 Software Developers Guild */

/* Load RexxUtil extensions */
if RxFuncQuery("SysLoadFuncs") then do
    say "loading RexxUtil extensions..."
    call RxFuncAdd "SysLoadFuncs","RexxUtil","SysLoadFuncs"
    if result \= "0" then do
        say "error loading RexxUtil.dll"
        exit
    end
    call SysLoadFuncs
end


/* Banner to announce what the user is installing */

CALL SysCls
say ''
say ' Ŀ'
say '                                                                           '
say '                                 WarpAMP                                   '
say ' Ĵ'
say '           WarpAMP copyright (c) 1998 by Software Developers Guild         '
say '                              All Rights Reserved                          '
say '                                                                           '
say ' '
say ''
say 'Press CTRL-C to cancel or any key to continue'
'@pause >nul'

/* Get the directory to install to */

CALL SysCls
say ''
say ' Ŀ'
say '                                                                           '
say '                                 WarpAMP                                   '
say ' Ĵ'
say '           WarpAMP copyright (c) 1998 by Software Developers Guild         '
say '                              All Rights Reserved                          '
say '                                                                           '
say ' '
say ''
say ' Enter the directory in which you wish to install WarpAMP: '
say ' A Blank line will cancel the install.'
say ''
PARSE PULL installdir
if installdir = "" then exit

installdir = strip(installdir, "T", "\")

/* Verify install dir */

CALL SysCls
say ''
say ' Ŀ'
say '                                                                           '
say '                                 WarpAMP                                   '
say ' Ĵ'
say '           WarpAMP copyright (c) 1998 by Software Developers Guild         '
say '                              All Rights Reserved                          '
say '                                                                           '
say ' '
say ''
say ' WarpAMP will be installed in ' installdir
say ''
say "  Press Ctrl-C to abort or any other key to continue"
say
'@pause >nul'


/* Verify if path exists and if not, create it */

if installdir <> "." then
DO
    call SysFileTree installdir, "srch", "D"
    if srch.0 = 0 then do
        rc = SysMkDir(installdir)
        if rc <> 0 then do
            say "Fatal error: cannot create directory" installdir
            exit
        end
    end
end


/* copy the WarpAMP installation to install directory */

if installdir <> "." then
do
    '@copy file_id.diz 'installdir' >nul'
    '@copy genres.txt 'installdir' >nul'
    '@copy readme.txt 'installdir' >nul'
    '@copy Warpamp.dll 'installdir' >nul'
    '@copy Warpamp.EXE 'installdir' >nul'
    '@copy Warpamp.INF 'installdir' >nul'
    '@copy Warpamp.dll 'installdir' >nul'
    '@copy PLC.EXE 'installdir' >nul'
end
if installdir = "." then installdir = directory()


/* Create Objects on the desktop */

CALL SysCls
say ''
say ' Ŀ'
say '                                                                           '
say '                                 WarpAMP                                   '
say ' Ĵ'
say '           WarpAMP copyright (c) 1998 by Software Developers Guild         '
say '                              All Rights Reserved                          '
say '                                                                           '
say ' '
say ''
say ' Preparing to create objects on the desktop for WarpAMP and to associate'
say ' files with the extensions MP3 and MPL with WarpAMP object. '
say ''
say "  Press Ctrl-C to abort or any other key to continue"
say ''
'@pause >nul'


call SysCreateObject "WPFolder", "WarpAMP", "<WP_DESKTOP>", "OBJECTID=<WarpAMPfolder>;ALWAYSSORT=NO ;OPEN=ICON ;ICONFILE=wampfold.ICO", "replace"
call SysCreateObject "WPProgram", "WarpAMP", "<WarpAMPfolder>", "EXENAME=" || installdir ||"\WarpAMP.EXE; OBJECTID=<WarpAMP>;ASSOCFILTER=*.MP3,*.MPL; STARTUPDIR=" || installdir, "replace"
call SysCreateObject "WPProgram", "WarpAMP Manual" , "<WarpAMPfolder>", "EXENAME=VIEW.EXE;PARAMETERS=" || installdir || "\WarpAMP.INF", "replace"
call SysCreateObject "WPProgram", "SDG HomePage" , "<WarpAMPfolder>", "EXENAME=NETSCAPE.EXE;PARAMETERS=" || "http://www.sdg.ml.org", "replace"

say ''
say ' Folder was successfully created'
say ''
say ' Press any key to continue'
'@pause >nul'


/* Edit the Libpath in config.sys to include WarpAMP dir */

parse upper value VALUE( "PATH",, "OS2ENVIRONMENT" ) with "\OS2\SYSTEM" -2 bdrive +2

CALL SysCls
say ''
say ' Ŀ'
say '                                                                           '
say '                                 WarpAMP                                   '
say ' Ĵ'
say '           WarpAMP copyright (c) 1998 by Software Developers Guild         '
say '                              All Rights Reserved                          '
say '                                                                           '
say ' '
say ''
say ' Preparing to edit the file 'bdrive'\config.sys to add ' installdir ' to the libpath'
say ' and PATH so the program can be run from the command line with no problems'
say ''
say "  Press Ctrl-C to abort or any other key to continue"
say ''
say '  If you abort, wish to run WarpAMP from the command line, you will have'
say '  to edit the config.sys yourself to add ' installdir ' to the libpath and PATH'
say ''
'@pause >nul'

configsys=bdrive '\config.sys'
newconfig=bdrive '\config.tmp'


rc=lineout( newconfig,, 1)

DO WHILE LINES( configsys )

configline=linein( configsys )

PARSE UPPER VAR configline editline
PARSE UPPER VAR installdir cinstalldir

IF LEFT( editline, 7) = 'LIBPATH' THEN
  DO
    IF pos( cinstalldir, editline ) = 0 THEN
      DO
        configline = strip(configline, "T", " ")
        configline = strip(configline, "T", ";")
        rc=lineout( newconfig, configline';'installdir';' )
      END
    ELSE rc=lineout( newconfig, configline )
  END
ELSE
  IF LEFT( editline, 8) = 'SET PATH' THEN
    DO
      IF pos( cinstalldir, editline ) = 0 THEN
        DO
          configline = strip(configline, "T", " ")
          configline = strip(configline, "T", ";")
          rc=lineout( newconfig, configline';'installdir';' )
        END
      ELSE rc=lineout( newconfig, configline )
    END
  ELSE
    rc=lineout( newconfig, configline )

END

rc=stream( configsys, 'c', 'close' )
rc=stream( newconfig, 'c', 'close' )

IF ( stream( newconfig, 'c', 'Query Exists' ) = '' ) THEN DO
  SAY ''
  SAY 'Failed to modify 'bdrive'\config.sys'
  SAY 'You will have to update it manually!'
  EXIT
END

'@attrib -r -s -h 'bdrive'\config.sys >nul'
'@copy 'bdrive'\config.sys 'installdir' >nul'
'@copy 'bdrive'\config.sys 'bdrive'\config.amp >nul'
'@del 'bdrive'\config.sys >nul'
'@ren 'bdrive'\config.tmp config.sys >nul'


CALL SysCls
say ''
say ' Ŀ'
say '                                                                           '
say '                                 WarpAMP                                   '
say ' Ĵ'
say '           WarpAMP copyright (c) 1998 by Software Developers Guild         '
say '                              All Rights Reserved                          '
say '                                                                           '
say ' '
say ''
say ' Installation of WarpAMP is complete, you must reboot before you can run'
say ' WarpAMP from a command line, but the icon will work immediately.'
say ''
say ''
'@pause >nul'


