#define INCL_DOSDEVICES
#define INCL_DOSEXCEPTIONS
#define INCL_DOSFILEMGR
#include <os2.h>
#include <builtin.h>
#include <stdio.h>

/*
 *  権  ``in al,XX''  ``out XX,al''
 */
#define IN_OPCODE       0xE4
#define OUT_OPCODE      0xE6

#define IOCTL_SDDHELP   0x80
#define GET_SDDHELP_SEL 0x05

/*
 * ⨯ 㭪樨 䥩  SDDHELP$
 */
void APIENTRY setIOPL (ULONG);

/*
 * ६  ࠭ १ 믮 ਢ஢ 権
 */
static BOOL fPrivileged;

/************************************************************************/
ULONG APIENTRY xcptHandler ( PEXCEPTIONREPORTRECORD pXCPTRepRec,
                             PEXCEPTIONREGISTRATIONRECORD pXCPTRegRec,
                             PCONTEXTRECORD pXCPTCtxRec,
                             PVOID p )
/************************************************************************/
/* 祭:                                                          */
/*     ࠡ稪 ᪫祭, ᯮ㥬  ஢ન    */
/*     ணࠬ 믮 ਢ஢ 樨                 */
/* 頥:                                                          */
/*      ⠭⭮ 祭  ࠡ稪 ᪫祭            */
/*     (. Control Program Reference, Exception Management)            */
/************************************************************************/
{
    /*
     * 砫쭮 ,   `` '' ᪫祭
     */
    ULONG rc = XCPT_CONTINUE_SEARCH;

    /*
     *  ⮡   㣠  ᯮ㥬 ६
     */
    pXCPTRegRec;
    p;

    /*
     * 稭 ᮢ ᪫祭 ⮫쪮  ⮬ 砥, ᫨ 
     * ᪫祭 뢠 ਢ஢ 樥   
     *  ⮣ ᪫祭
     */
    if (pXCPTRepRec->ExceptionNum == XCPT_PRIVILEGED_INSTRUCTION &&
        pXCPTCtxRec->ContextFlags & CONTEXT_CONTROL)
    {
        /*
         * 砥  樨, 맢襩 ᪫祭
         */
        PUCHAR pOpcode = (PUCHAR)pXCPTCtxRec->ctx_RegEip;

        /*
         *    FLAT, ᫨    64Kb,   
         * `` '' ᪫祭  ⮬    ᭮
         */
        if ((ULONG)pOpcode >= 0x10000)
        {
            /*
             * ``'' ᪫祭   맢 ⮫쪮 塠⮢묨
             * ﬨ ``in al,XX''  ``out XX,al''
             */
            if (*pOpcode  == IN_OPCODE || *pOpcode == OUT_OPCODE)
            {
                /*
                 * ⠭ 䫠 ``뫮 ᪫祭''
                 */
                fPrivileged = TRUE;

                /*
                 * ४㥬 稪  CPU  ⥬, ⮡  㪠뢠
                 *  ᫥ 㪨,    ,  맢
                 * ᪫祭
                 */
                pXCPTCtxRec->ctx_RegEip += 2;

                /*
                 * ᮮ頥 OS/2  ⮬,   ࠢ 訡  
                 * த 믮 ணࠬ
                 */
                rc = XCPT_CONTINUE_EXECUTION;
            }
        }
    }
    /*
     * ⠭⭮ 室  ࠡ稪 ᪫祭
     */
    return rc;
}

/************************************************************************/
BOOL grantIO ( void )
/************************************************************************/
/* 祭:                                                          */
/*     㭪 ⠥ ⠭ ஢ ਢ IO   #3, */
/*     ᯮ 㬥஢ IOCTL ࠩ SDDHELP$            */
/* 頥:                                                          */
/*     TRUE  砥 ᯥ,  FALSE                                */
/************************************************************************/
{
    int   rc;
    HFILE hSDDHelp;
    ULONG ulResult;
    ULONG parmsIn, parmsOut;
    ULONG cbIn, cbOut;
    EXCEPTIONREGISTRATIONRECORD xcptRegRec = { 0, &xcptHandler };

    /*
     * 뢠 ᨣ ६
     */
    fPrivileged = FALSE;

    /*
     *  ⠭ ᢮ ࠡ稪 ⥬ ᪫祭
     */
    DosSetExceptionHandler (&xcptRegRec);

    /*
     * ⠥  ன⢮ SDDHELP$
     */
    rc = DosOpen ("\\dev\\sddhelp$", &hSDDHelp, &ulResult, 0, 0,
                  FILE_OPEN, OPEN_SHARE_DENYNONE | OPEN_ACCESS_READWRITE,
                  NULL);
    if (!rc)
    {
        /*
         * ஡㥬  ᥫ ७ 㭪樨 ன⢠ SDDHELP$
         */
        cbIn =  sizeof (parmsIn);
        cbOut = sizeof (parmsOut);

        rc = DosDevIOCtl (hSDDHelp, IOCTL_SDDHELP, GET_SDDHELP_SEL,
                          &parmsIn, cbIn, &cbIn,
                          &parmsOut, cbOut, &cbOut);
        /*
         *  砥 ᯥ  IOPL == 3
         */
        if (!rc)
            setIOPL (parmsOut);

        /*
         * 뢠  㦭  ன⢮ SDDHELP$
         */
        DosClose (hSDDHelp);

        /*
         *   ⮬ 砥, ᫨  ⮣  뫮  訡, 믮塞
         *  ਢ஢ 樨,    맢
         * ᪫祭, ᫨  諮 ଠ쭮
         */
        if (!rc)
            _outp (0x61, _inp (0x61));
    }

    /*
     * 뢠 ࠡ稪 ᪫祭
     */
    DosUnsetExceptionHandler (&xcptRegRec);

    /*
     *  頥 १
     */
    return (!fPrivileged && !rc) ? TRUE : FALSE;
}

/************************************************************************/
main ()
/************************************************************************/
/* 祭:                                                          */
/*     ᭮ 㭪 ணࠬ,  :)                            */
/* 頥:                                                          */
/*     ᥣ 0                                                         */
/************************************************************************/
{
    printf ("⠭ IOPL   #3");
    /*
     * ஡㥬 ⠭ ᥡ ਢ  IO  ᮮ頥 㤠 
     * ᤥ  
     */
    printf ("%s ᯥ譠\n", (grantIO ()) ? "" : " ");

    return 0;
}
