/*
 * A search command for OS/2
 * Finds all files matching mask containing string
 * Freeware by M. Kimes
 */

'@echo off'
parse arg cl
recurse = 'F'
options = 'CN'
counter = 0
found = 0
insensitive = 0
nolines = 0
prepend = ''
if cl = '/?' then signal givehelp
if cl = '-?' then signal givehelp
Again:
parse upper var cl dummy mask
if dummy = '/S' then
do
  recurse = 'FS'
  parse var cl dummy cl
  signal Again
end
parse upper var cl dummy mask
if dummy = '/I' then
do
  if nolines = 0 then options = 'N' else options = ''
  insensitive = 1
  parse var cl dummy cl
  signal Again
end
parse upper var cl dummy mask
if dummy = '/N' then
do
  if insensitive = 0 then options = 'C' else options = ''
  nolines = 1
  parse var cl dummy cl
  signal Again
end
parse upper var cl dummy mask
if dummy = '/M' then
do
  more = ''
  parse var cl dummy cl
  signal Again
end
parse var cl mask text
if text = '' then signal givehelp
if mask = '' then mask = '*'
if nolines = 0 then prepend = ' **'
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
dummy = charout(,'Working...')
rc = SysFileTree(mask,filename,recurse)
dummy = charout(,'0d'x)
if rc = 0 then
do
  if filename.0 \= 0 then
  do
    do i = 1 to filename.0
      parse var filename.i fdate ftime fsize fattr fname
      fname = strip(fname,'b')
      if fname \= '' then
      do
        rc = SysFileSearch(text,fname,foundstr,option)
        if rc = 0 then
        do
          if foundstr.0 \= 0 then
          do
            found = found + 1
            say prepend''fname
            if more \= '' then
            do
              counter = counter + 1
              if counter = 24 then
              do
                if i \= filename.0 then
                do
                  dummy = charout(,'[More]')
                  dummy = SysGetKey('NOECHO')
                  dummy = charout(,'0d'x)
                  counter = 0
                end
              end
            end
            if nolines = 0 then
            do
              do j = 1 to foundstr.0
                say '>> 'strip(left(foundstr.j,76),b)
                if more \= '' then
                do
                  counter = counter + 1
                  if counter = 24 then
                  do
                    if i \= filename.0 then
                    do
                      dummy = charout(,'[More]')
                      dummy = SysGetKey('NOECHO')
                      dummy = charout(,'0d'x)
                      counter = 0
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
  else
  do
    say 'No matching files found.'
    found = 1
  end
end
if found = 0 then say 'No matching files found.'
exit

givehelp:
say 'SRCH.CMD'
say ' Searches for strings in files.'
say ''
say ' Usage:  Srch [/I] [/M] [/N] [/S] mask text to find'
say ''
say '  /I = case insensitive search'
say '  /M = no [More] prompting'
say '  /N = no lines (normally lines containing text are displayed)'
say '  /S = recurse into subdirectories'
say ''
say ' Examples:  Srch /N *.c HindMost('
say '            Srch /S /I *.txt Then the geek bit off his head.'
say ''
say 'Hector wuz here.'
exit
