/***************************************************************** THREAD.CPP
 *                                                                          *
 *                       Thread Starter Function                            *
 *                                                                          *
 ****************************************************************************/

#include <stddef.h>
#include <stdlib.h>
#include <string.h>

#define INCL_BASE
#define INCL_PM
#include <os2.h>

#include "Debug.h"
#include "Except.h"
#include "Thread.h"

//#define DEBUG


/****************************************************************************
 *                                                                          *
 *                         Definitions & Declarations                       *
 *                                                                          *
 ****************************************************************************/

  // Type Definitions

typedef struct {
   char *Name ;
   void (*Function)(void*) ;
   void *Parameter ;
} THREAD_PARMS, *PTHREAD_PARMS ;


  // Function Prototypes

static void _Optlink Thread ( void *Parameter ) ;


/****************************************************************************
 *                                                                          *
 *                         Generic Thread Starter                           *
 *                                                                          *
 ****************************************************************************/

extern TID StartThread ( char *Name, void(*Function)(void*), int StackSize, void *Parameter, int Priority ) {

   PTHREAD_PARMS Parms = PTHREAD_PARMS ( AllocateMemory ( sizeof(THREAD_PARMS) ) ) ;
   Parms->Name = PCHAR ( AllocateMemory ( strlen(Name) + 1 ) ) ;
   strcpy ( Parms->Name, Name ) ;
   Parms->Function = Function ;
   Parms->Parameter = Parameter ;

   TID ThreadID = _beginthread ( Thread, 0, StackSize, Parms ) ;

   if ( ThreadID < 1 )
      Log ( "ERROR: Unable to start thread '%s'.", Name ) ;

   DosSetPriority ( PRTYS_THREAD, PRTYC_NOCHANGE, Priority, ThreadID ) ;

   return ( ThreadID ) ;
}

/****************************************************************************
 *                                                                          *
 *                            Generic Thread                                *
 *                                                                          *
 ****************************************************************************/

static void _Optlink Thread ( void *Parameter ) {

  /**************************************************************************
   * Disable exception popups and register the exception handler.           *
   **************************************************************************/

   EXCEPTIONREGISTRATIONRECORD ExceptionRecord = { 0, ExceptionHandler } ;
   DosSetExceptionHandler ( &ExceptionRecord ) ;

  /**************************************************************************
   * Get parameters.                                                        *
   **************************************************************************/

   PTHREAD_PARMS Parms = PTHREAD_PARMS ( Parameter ) ;

  /**************************************************************************
   * Execute the function requested.                                        *
   **************************************************************************/

   #ifdef DEBUG
   Log ( "Thread '%s' starting.", Parms->Name ) ;
   #endif

   Parms->Function ( Parms->Parameter ) ;

   #ifdef DEBUG
   Log ( "Thread '%s' ending.", Parms->Name ) ;
   #endif

  /**************************************************************************
   * Release the memory allocated for the thread parameters.                *
   **************************************************************************/

   FreeMemory ( Parms->Name ) ;
   FreeMemory ( Parms ) ;

  /**************************************************************************
   * Unhook the exception handler.                                          *
   **************************************************************************/

   DosUnsetExceptionHandler ( &ExceptionRecord ) ;
}

