.. ----------------------------------------
.1 [=BASETITLE] escape characters
.. ----------------------------------------
.an TEST1
.an TEST2
.res 6001
.
Please select one of the following topics:
.su V30 u 1

.. ----------------------------------------
.2 attribute escape characters
.. ----------------------------------------
.an ESC_ATTRIBUTES
.
Example:
.fo off
 .. this is a text with attribute escape chars
 .
 **This text is bold**,
 .
 ##this text is italic##,
 .
 __this text is underlinded__,
 .
 __**This text is bold and underlined**__,
 .
 .. there is no escape character for the
 .. hilite attribute, so we use the .ATTRIBUTE command
 .at hilite
 this text is hilighted using the .ATTRIBUTE command
 .at
.fo on

The following escape characters can be used to
toggle text attributes:
.pl compact break=none tsize=4
- **
= toggle bold attibute
- ##
= toggle italic attribute
- __
= toggle underline attribute

The following rules apply to attribute escape characters:
.ul compact
- the escape character toggles the attribute on or off
  corresponding to the current status
- if you want to use the escape character itself within the text,
  you have to specify it twice
- one or more attribute can be active at a time with the following exceptions:
  - hilighted ignores all other attibutes if set
  - italic and underlined attribute being active let ignore the bold attribute

The resulting text from the example above looks like this:
.
.. this is a text with attribute escape chars
*This text is bold*,
.
#this text is italic#,
.
_this text is underlinded_,
.
_*this text is bold and underlined*_
.
.at hilite
this text is hilighted using the .ATTRIBUTE command
.at


[=NOTE]
.ul compact
- you can also use the [.CMD_ATTRIBUTE] command to toggle
  text attributes
- there is no escape character to toggle the hilite attribite
  (set to red color). You must use the [.CMD_ATTRIBUTE] command
  to toggle the hilite attribute

.. ----------------------------------------
.2 hyperlink and replacement escape characters
.. ----------------------------------------
.an ESC_LINKS
.
See the following source examples:
.su H60 u

The following rules apply to creating links and text replacement:
.ul compact
- you have to embed the link information in brackets, this
  contains either
  - an anchor name  or
  - a link text  or
  - both
- if you want to use the escape characters itself within the text,
  you have to specify them twice
- when using anchor names within the link information
  - the anchor name must start with a period right after the bracket
  - set the anchor with the [.CMD_ANCHOR] command
- if an anchor cannot be resolved, it is assumed that a section exists
  with the anchor name as an IPF *refid*. This allows to refer to sections
  outside of the IPF source being generated by [=TITLE], wehn it is
  embedded in other IPF sources.

The following types of links can be created:
.pl tsize=4 underlined
- title text link
= the link information is the exact title text of a section (case-insensitive)
- anchor link with no text
= the title of the linked page is used as link text
- anchor link with no text
= the text specified in the link information is used
- external link
= the link information is
.ul compact
  - an URL with *http://* or *ftp://*
  - an email address starting with *mailto:*
  - an inf filename starting with *inf:*
.el
.
  and optional with an alternate text to be used
  as link text instead of the URL or filename.

The following types of text replacements can be created:
.pl tsize=4 underlined
- title of linked page
= the link information is the anchor name preceeded with an equal sign and dot like: [[=.ANCHORNAME]]
- value of environment variable
= the link information is the name of the environment variable preceeded with
  an equal sign: [[=ENVVARNAME]]

[=NOTE]
.ul compact
- You can set environment variables with the [.CMD_SET] command.

.. - - - - - - - - - - - - - - - - - - - -
.3 Examples for internal links
.. - - - - - - - - - - - - - - - - - - - -
.an LINK_EXAMPLES_INTERNAL
.
_*[=.LINK_EXAMPLES_INTERNAL]*_
.fo off
 .. link this section with the exact title text:
 title text link: [[hyperlink and replacement escape characters]]
.fo on
.
title text link: [hyperlink and replacement escape characters]
.fo off
 .. link this section with an anchor name
 .. using the title text
 anchor link: [[.ESC__LINKS]]
.fo on
.
anchor link: [.ESC_LINKS]
.fo off
 .. link this section with an anchor name
 .. using alternate text
 anchor link with alternate text: [[.ESC__LINKS my link]]
.fo on
.
anchor link with alternate text: [.ESC_LINKS my link]

.. - - - - - - - - - - - - - - - - - - - -
.3 Examples for external links to INF files
.. - - - - - - - - - - - - - - - - - - - -
.an LINK_EXAMPLES_INF
.
_*[=.LINK_EXAMPLES_INF]*_
.fo off
 .. link to INF file
 INF file: [[inf:cmdref]]
.fo on
.
INF file: [inf:cmdref]
.fo off
 .
 .. link to XCOPY section of command reference
 INF file: [[inf:cmdref XCOPY]]
.fo on
.
INF file: [inf:cmdref XCOPY]

.. - - - - - - - - - - - - - - - - - - - -
.3 Examples for external links to internet resources
.. - - - - - - - - - - - - - - - - - - - -
.an LINK_EXAMPLES_URL
.
_*[=.LINK_EXAMPLES_URL]*_
.fo off
 .. link to internet resources
 web link: [[http://hobbes.nmsu.edu]]
.fo on
.
web link: [http://hobbes.nmsu.edu]
.fo off
 .. same web link with alternate text:
 [[http://hobbes.nmsu.edu The Hobbes File Archive]]
.fo on
.
[http://hobbes.nmsu.edu The Hobbes File Archive]
.fo off
 .. ftp link
 ftp link: [[ftp://ftp.netlabs.org/pub]]
.fo on
.
ftp link: [ftp://ftp.netlabs.org/pub]
.fo off
 .. email link
 email link: [[mailto:C.Langanke@Teamos2.de]]
.fo on
.
email link: [mailto:C.Langanke@Teamos2.de]
.fo off
 .. email link with alternate text
 email link: [[mailto:C.Langanke@Teamos2.de Christian Langanke]]
.fo on
.
email link: [mailto:C.Langanke@Teamos2.de Christian Langanke]

.. - - - - - - - - - - - - - - - - - - - -
.3 Examples for text replacements
.. - - - - - - - - - - - - - - - - - - - -
.an LINK_REPLACEMENTS
.
_*[=.LINK_REPLACEMENTS]*_
.fo off
 .. insert the title of the referred page
 title of the page is: [[=.ESC__LINKS]]
.fo on
.
title of the page is: [=.ESC_LINKS]
.fo off
 .. insert the content of environment variable
 IPFC directory on my harddisk is: [[=IPFC]]
.fo on
.
IPFC directory on my harddisk is: [=IPFC]


.. ----------------------------------------
.1 [=BASETITLE] commands
.. ----------------------------------------
.
Please select one of the following topics:
.su V30 u

.. ----------------------------------------
.2 [=BASETITLE] commands in general
.. ----------------------------------------
.an CMD_GENERAL
.
All [=TITLE] commands
.ul
- start with a period
- must start in the first column of the source file.
.
  As all commands start with a period, a period is not allowed
  in the first column unless it is the first character of a [=TITLE]
  command. Place all other text contaning a period that way, that
  the period is not the first character of a line.
- with the exception of some few commands, command names can be abbreviated, that is
  typing only the period plus at least two more characters of the
  command name is sufficient.

The following commands may not be abbreviated:
.ul compact
- [.CMD_INCLUDE]
- [.CMD_IF]
- [.CMD_ELSE]
- [.CMD_ENDIF]

.. ----------------------------------------
.2 .
.. ----------------------------------------
.
*.* -  Line break

Example:
.fo off
 This line and
 .
 this line will be split by a line break.

.fo on

A period in the first column forces a line break.

.. ----------------------------------------
.2 ..
.. ----------------------------------------
.
*..* - comment line

Example:
.fo off
 .. This is a comment line
.fo on

Two periods at column one and two start a comment line.

.. ----------------------------------------
.2 .1 to .6
.. ----------------------------------------
.an CMD_HEADER
.
*.1* to *.6* - page header

Example:
.fo off
 .1 This is the page title
.fo on

These commands open up a new IPF page.

The following rules apply:
.ul compact
- the number is specifying the level, where the top level is one, the
  lowest possible level is 6
- the text following the page header command is taken for title of the page
  and must be specified
- a document always must start with level 1
- you may not skip a level when increasing the level number, but you
  may of course skip a level when decreasing the level number.

The following would be a valid level sequence:
.ul compact
- .1 This is level one
  - 2. This is level two
    - 3. This is level three
- .1 this is another level one page
  - 2. This is level two again
  - 2. This is another level two page

The following would be an invalid level sequence:
.ul compact
- .1 This is level one
 - 3. This is level three
.at hilite
(Level 2 is missing !!!)
.at
- .1 this is another level one page
  - 2. This is level two again
  - 2. This is another level two page

.. ----------------------------------------
.2 .ANCHOR
.. ----------------------------------------
.an CMD_ANCHOR
.
*.ANCHOR* - set a link or footnote anchor

Example:
.fo off
 .an MY__ANCHOR
.fo on

This command sets a link anchor. It can be used
.ul
- with the [.ESC_LINKS] command in order to refer to the page
or footnote, where the anchor has been set.
- together with the [.CMD_RESID] command to allow external
  linkage

The above anchor would for an interlan link be referred to with
the following line:
.fo off
  This is the [[.MY__ANCHOR section
  for further explanation]].
.fo on
.
and the resulting text would look like this:

This is the [.CMD_ANCHOR section for further explanation].

.. ----------------------------------------
.2 .ATTRIBUTE
.. ----------------------------------------
.an CMD_ATTRIBUTE
.
*.ATTRIBUTE* - set a text attribute or reset to default

Example:
.fo off
 .at hilite
 This text will appear in red !
 .at
.fo on

This command toggles the following text attributes:
.ul compact
- bold
- italic
- underlined
- hilite (turns on red)

[=NOTE]
.ul compact
- you can toggle the bold, italic and underlined attribute also with [.ESC_ATTRIBUTES]
- you can specify more than one attribute at a time
- one or more attribute can be active at a time with the following exceptions:
  - hilighted ignores all other attibutes if set
  - italic and underlined attribute being active let ignore the bold attribute
- you can abbreviate the attribute names to a single character
- always remember that you toggle attributes on or off corresponding
  to the current status
- specify no attribute to reset to default !

.. ----------------------------------------
.2 .BITMAP
.. ----------------------------------------
.an CMD_BITMAP
.
*.BITMAP* - include a bitmap

Example:
.fo off
 This bitmap
 .bi ns.bmp
 is for URL links.
.fo on

This command includes a bitmap into the IPF text. A given bitmap is searched
at the following places:
.ul compact
- within the specified directory (current directory if none specified)
- within the directory, from where *htext.cmd* is called from
- within the subdirectory *htext* from the directory, from where *htext.cmd* is called from
- within all directories of the *INCLUDE* environment variable, if present
- within all directories of the *HTINCLUDE* environment variable, if present

The resulting text from the example above looks like this:
.
This bitmap
.bi ns.bmp
is for URL links.

.. ----------------------------------------
.2 .ELIST
.. ----------------------------------------
.an CMD_ELIST
.
*.ELIST* - end list level

Example:
.fo off
 .. end a list level
 .ul compact
 - first item of the main list
 - second item of the main list
   - first list item in the second level
     - first item in the third level
     - second item in the third level
 .el
 .at hi
     and this text belongs to the item in the
     second level again because we ended the
     third level !!!
 .at
   - last item in the second level
 - last item in the first level
.fo on

This command will end a level of a list created with the
[.CMD_SLIST], [.CMD_OLIST] and [.CMD_ULIST] commands. You normally will
require this command only if you use either nested lists or multiple list
levels, and cannot use an empty line within a list to end a level,
because an empty line will end up all open lists.

The resulting list from the example above looks like this:
.ul compact
- first item of the main list
- second item of the main list
  - first list item in the second level
    - first item in the third level
    - second item in the third level
.el
.at hi
    and this text belongs to the item in the
    second level again because we ended the
    third level !!!
.at
  - last item in the second level
- last item in the first level

.. ----------------------------------------
.2 .ELSE
.. ----------------------------------------
.an CMD_ELSE
.
*.ELSE* - switch conditional compile

Example:
.fo off
 .. compile the following if environment variable MYVAR is defined
 .ifdef MYVAR
 the condition is true
 .else
 the condition is false
 .endif
.fo on

This command will switch the condition for conditional compilation,
that can be started with the [.CMD_IF] commands.

[=NOTE]
.ul compact
- the *.ELSE* command may not abbreviated !!!

.. ----------------------------------------
.2 .ENDIF
.. ----------------------------------------
.an CMD_ENDIF
.
*.ENDIF* - stop conditional compile

Example:
.fo off
 .. compile the following if environment variable MYVAR is defined
 .ifdef MYVAR
 this is some text
 .endif
.fo on

This command will stop conditional compilation,
that can be started with the [.CMD_IF] commands.

[=NOTE]
.ul compact
- the *.ENDIF* command may not abbreviated !!!

.. ----------------------------------------
.2 .FORMAT
.. ----------------------------------------
.an CMD_FORMAT
.
*.FORMAT* - toggle IPF formatting on/off

Example:
.fo off
 .fo off
 This text will appear in monospaced font
 (just like the sample here).
 .fo on
 The text here will be layouted by IPF again.
.fo on

This command toggles IPF layout off and on. Toggle IPF layout off for example if:
.ul compact
- if you want to create tables
- if you want to make clear that some text is somewhat special (just like the example above)
- if you quote contents from a text window of a special file

.. ----------------------------------------
.2 .FN
.. ----------------------------------------
.an CMD_FN
.
*.FN* - footnode header

Example:
.fo off
 .. here is the normal IPF text again linking to
 .. the footnote below.
 Here is the [[MYFOOTNOTE footnote]].
 .fn
 .
 .an MYFOOTNOTE
 This is a footnote and can be linked to with the
 anchor .MYFOOTNOTE.
.fo on

This command creates an IPF footnote.

The following rules apply to footnotes:
.ul compact
- they are linked to exactly like one would link to normal pages
- you must use the [.CMD_ANCHOR] command to set an anchor for the
  footnote, so that you can link to the footnote with it.

The resulting footnote list from the example above looks like this:
.
.. here is the normal IPF text again linking to
.. the footnote below.
Here is the [.MYFOOTNOTE footnote].
.fn
.an MYFOOTNOTE
.
This is a footnote and can be linked to with the
anchor *.MYFOOTNOTE*.

.. ----------------------------------------
.2 .HCLEAR
.. ----------------------------------------
.an CMD_CLEAR
.
*.HCLEAR* - set header clear attribute

Example:
.fo off
 .. this will automatically add the clear attribute
 .. to allheaders of level 2, 3 and 4
 .hi 234
 .
 .. this will stopp setting the clear attribute to
 .. any of the upcoming headers
 .hi
.fo on

This command will automatically add the clear attribute to all headers, that
apply to the specified levels. The clear attribute lets IPF close all open windows
when a window with this attribute is opened.

This is very useful when using the .SUBLINK commands to split windows, which
otherwise would leave a lot of windows open when jumping between windows.
Usually you will likely determine one level in your header hirarchy, that will
split windows first, it is recommended to specify exactly this level with the
.HCLEAR command. As an alternative you can also specify the *clear* attribute
with every [.CMD_SUBLINKS] command.

Specifying no headers will clear the list of levels to get the clear attribute set.

.. ----------------------------------------
.2 .HINDEX
.. ----------------------------------------
.an CMD_HINDEX
.
*.HINDEX* - auto add page headers to index

Example:
.fo off
 .. this will automatically add all upcoming
 .. headers of level 2, 3 and 4 to the index
 .hi 234
 .
 .. this will stopp adding any of the upcoming
 .. headers to the index
 .hi
.fo on

This command will automatically add all pages to the index, that apply to the
specified levels. This saves you from having to place an [.CMD_INDEX] command
manually to all desired pages. Specifying no headers will clear the list
of levels to be added to the index.

.. ----------------------------------------
.2 .IF / .IFDEF / .IFNDEF
.. ----------------------------------------
.an CMD_IF
.
*.IF* - start conditional compile

Examples:
.fo off
 .. compile the following if environment
 .. environment variable MYVAR is defined
 .ifdef MYVAR
 .endif
 .
 .. compile the following if
 .. environment variable MYVAR is not defined
 .ifndef MYVAR
 .endif
 .
 .. compile the following if
 .. environment variable MYVAR is equal to '1'
 .. and MYVAR2 is equal to '2'
 .if MYVAR=1 & MYVAR2=2
 .endif
.fo on

This command will conditionally compile source until the
next .ELSE or .ENDIF.

The following rules apply to conditional compilation:
.ul compact
- only environment variables can be examined with the .IF** commands
- the .IF** commands may not be nested
- the .IF command supports
  - for comparison only the equal operator
  - for evaluation of boolean expressions the operators
     - & for logical *and*
     - | for logical *or*
  - you *cannot* use round brackets to group boolean expressions!

[=NOTE]
.ul compact
- the *.IFDEF* and *.IFNDEF* commands may not abbreviated !!!
- see also the commands [.CMD_ELSE] and [.CMD_ENDIF]

.. ----------------------------------------
.2 .INCLUDE
.. ----------------------------------------
.an CMD_INCLUDE
.
*.INCLUDE* - include a hypertext file

Example:
.fo off
 .include subchapter.txt
.fo on

This command will include another [=TITLE] source compatible
textfile. The file is being searchd at the following places:
.ul compact
- within the current or specified directory
- within all directories of the *INCLUDE* environment variable, if present
- within all directories of the *HTINCLUDE* environment variable, if present

[=NOTE]
.ul compact
- the *.INCLUDE* command may not abbreviated !!!

.. ----------------------------------------
.2 .INDEX
.. ----------------------------------------
.an CMD_INDEX
.
*.INDEX* - add a page to the index with an alternative text

Example:
.fo off
 .. add the page to the index with the title text
 .in
 .. add the page to the index with an alternate text
 .in This is a special page !
.fo on

This command adds the current page to the index, using either:
.ul compact
- the page title, if no alternate text is specified
- the text specified

[=NOTE]
.ul compact
- you can add the same page with different text as many times as you want

.. ----------------------------------------
.2 .LMARGIN
.. ----------------------------------------
.an CMD_LMARGIN
.
*.LMARGIN* - set left margin

Example:
.fo off
 .. set left margin to 10
 .lm 10
 .. reset left margin to default (that is 1)
 .lm
.fo on

This command sets the left margin.

[=NOTE]
.ul compact
- due to a limitation of the IPF compiler you cannot set the left margin to zero

.. ----------------------------------------
.2 .MIRROR
.. ----------------------------------------
.an CMD_MIRROR
.
*.MIRROR* - mirror a page

Example:
.fo off
 .. mirror the contents of another page
 .mi MIRRORED-PAGE

 This text is completely ignored, because only
 the contents of the mirrored page will be displayed in
 this page.
.fo on

This command mirrors the contents of another page, that
you define with its anchorname.

The following rules apply to mirroring pages:
.ul compact
- all other content of the page is ignored, only the content
  of the mirrored page is inserted
- you can mirror only one page. If you specify the *.MIRROR*
  command more than once within a page, only the last specified
  page is mirrored
- all attributes of the mirrored page, which have been set by a
  [.CMD_SUBLINKS], are copied to the mirroring page

.. ----------------------------------------
.2 .OLIST
.. ----------------------------------------
.an CMD_OLIST
.
*.OLIST* - create ordered list

Example:
.fo off
 .ol compact
 - this is item 1
 - this is item 2
   - this is item 2.1
     - this is item 2.1.1
 - this is item 3
.fo on

This command creates an ordered list.
The following rules apply to ordered lists:
.ul compact
- the following parms can be specified
.pl compact italic tsize=2
  - compact
  = do not place empty lines between items
  - bold  italic  underlined  hilite
  = one or more [.CMD_ATTRIBUTE text attributes] to be used for the parameter term
- a list must be terminated by an empty line
- a list level can explicitely be ended with the [.CMD_ELIST] command
- an item starts with a minus sign as the item marker
  being the first non-space character on the line
- the identation of the items are determined by
  the position of the item markers

The resulting list from the example above looks like this:
.ol compact
- this is item 1
- this is item 2
  - this is item 2.1
    - this is item 2.1.1
- this is item 3

.. ----------------------------------------
.2 .PLIST
.. ----------------------------------------
.an CMD_PLIST
.
*.PLIST* - create parameter list

Example:
.fo off
 .pl compact bold
 - term 1
 = definition 1
 - term 2
 = definition 2
 - term 3
 = definition 3
 .
 spanning two lines
.fo on

This command creates a parameter list. An entry
of a parameter list always consist of two elements:
the parameter term and the parameter definition explaining
the term.

The following rules apply to parameter lists:
.ul compact
- the following parms can be specified
.pl compact tsize=2
  - #compact#
  = do not place empty lines between items
  - #break=fit# or #break=none#
  = controls break between parameter term and definition
  - #tsize=n#
  = specifies the size for the parameter term. Default is 10 character units.
  - #bold  italic  underlined  hilite#
  = one or more [.CMD#ATTRIBUTE text attributes] to be used for the parameter term
- a list must be terminated by an empty line
- a list level, and with a parameter list, that is the paremetr list itself,
  can explicitely be ended with the [.CMD_ELIST] command
- the first part of a parameter, the so-called parameter term
  starts with a minus sign being the first non-space character on the line
- the second part of a parameter, the so-called parameter definition
  starts with am equal sign being the first non-space character on the line
- both term and definition can span over several lines

The resulting list from the example above looks like this:
.pl compact bold
- term 1
= definition 1
- term 2
= definition 2
- term 3
= definition 3
.
spanning two lines

[=NOTE]
.ul compact
- when nesting the .PLIST command with other list commands
  [.CMD_SLIST], [.CMD_OLIST] and [.CMD_ULIST], the tsize attribute does
  not properly work for values below 5.


.. ----------------------------------------
.2 .RESID
.. ----------------------------------------
.an CMD_RESID
.
*.RESID* - set a numeric resource id for a panel

Example:
.fo off
 .. set numericv resource id for external linkage
 .re 6001
 .. don't forget to set an anchor, otherwise the
 .. resid is quite useless
 .an EXTERNAL__PANEL
.fo on

This sets a resource id for external linkage for INF and HLP files.
You need external linkage when
.ul
- when several INF files are viewed together concatenated like
.fo off
  start view file1.inf+file2.inf+file3.inf
.fo on
.
and you want to link between the files
- an application wants to display context sensitive help panels
  from within an application

[=NOTE]
.ul compact
- specify the [.USAGE_DIRECTLY parameter /RCH] for [=TITLE] to
  additionally generate a resource header file with all external
  resource ids

.. ----------------------------------------
.2 .RMARGIN
.. ----------------------------------------
.an CMD_RMARGIN
.
*.RMARGIN* - set right margin

Example:
.fo off
 .. set right margin to 10
 .rm 10
 .. reset right margin to default (that is 0)
 .rm
.fo on

This command sets the right margin.

.. ----------------------------------------
.2 .SET
.. ----------------------------------------
.an CMD_SET
.
*.SET* - sets a variable vor conditional compile

Example:
.fo off
 .. set the environment variable MYVAR to 1
 .set MYVAR=1
.fo on

This command will set a variable, that can be used
.ul compact
- to control conditional compilation with the [.CMD_IF] commands
- for text replacement

[=NOTE]
.ul compact
.at hi
- Specifying the same variable more than once will make 
  [=TITLE] use the *last* value for *all* text replacements of
  this variable, because text replacements are evaluated after
  executing all .SET commands!
.at
.
  In opposite to that, text replacements are evaluated
  immediately when used within parameters to commands
  like for the [.CMD_IF] commands
- environment variable being set with the *.SET* command
  will not remain after program termination

.. ----------------------------------------
.2 .SLIST
.. ----------------------------------------
.an CMD_SLIST
.
*.SLIST* - create simple list

Example:
.fo off
 .sl compact
 - this is item 1
 - this is item 2
   - this is item 2.1
     - this is item 2.1.1
 - this is item 3
.fo on

This command creates a simple list (without bullets or characters).
The following rules apply to simple lists:
.ul compact
- the following parms can be specified
.pl compact italic tsize=2
  - compact
  = do not place empty lines between items
  - bold  italic  underlined  hilite
  = one or more [.CMD_ATTRIBUTE text attributes] to be used for the parameter term
- a list must be terminated by an empty line
- a list level can explicitely be ended with the [.CMD_ELIST] command
- an item starts with a minus sign as the item marker
  being the first non-space character on the line
- the identation of the items are determined by
  the position of the item markers

The resulting list from the example above looks like this:
.sl compact
- this is item 1
- this is item 2
  - this is item 2.1
    - this is item 2.1.1
- this is item 3


.. ----------------------------------------
.2 .SUBLINKS
.. ----------------------------------------
.an CMD_SUBLINKS
.
*.SUBLINKS* - creates a sublink list and/or splits windows

Example:
.fo off
  .. this sample creates three vertical windows
  .2 .SUBLINK sample - three rows
  .fo off
   .su H30 u
  .fo on
  .su H30 u

  .3 middle panel
  .fo off
   .su H30 u
  .fo on
  .su H30 u

  .4 lower panel
  .
  This window has only a height of 40% of the complete width of the INF
  application space, as the other two windows use up to 60% of it.
.fo on

This command
.ul compact
- creates a list of links to pages below the current level
.
  (see the section about [.CMD_HEADER header levels])
- and splits up the window into several so-called viewports

You can also ommit either action, thus only creating the list or
only splitting up the window.


The *.SUBLINK* command supports the following parameters:
.pl break=none tsize=15
- *x*
= where x is is the maximum levels below the current one
  that are to be processed. Specify
.pl break=none tsize=5
  - *1* to *n*
  = how all pages below the level of the current page not deeper than 1 to n
  - *0*
  = to show all pages below the level of the current page without a level limit
  - *-1* 
  = show all following pages of exactly the same level, but not including subpages
- *anchor*
= starting with a period, where the anchor defines the start page, from which the
sublink list should determined from. Default is the current page, that
contains the .SUBLINK command.
.
This parameter may not be combined with the parameter for splitting windows.
- *list type*
= specifying one of the following values (abbreviation allowed)
.ul compact
  - unordered
  - ordered
  - simple
  - breaks (uses line breaks instead of list items)
  - nolist (splits windows, but creates no list)
- *clear*
= where this parameter sets the clear attribute for the link window.
This will close all other windows before when this window is opened.
- *Vxx* or *Hxx*
= where xx is a portion of 100 percent points
of width or height, where the screen should be split
between this and the sublink pages vertically or horizontally.
xx must be between 20 and 80 and specfies the height or width
of the source window. The remaining percent points of screen
width and height are used for the linked target windows.
.
This parameter may not be specified together with an anchor name
to determine the start page.

The following restrioctions apply to sublink lists:
.ul compact
- you can use the .SUBLINK command only once per page!
- the parameters for anchor name and for splitting windows are
  mutually exclusive

For examples for the *.SUBLINK* command see also:
.ul compact
- [.SAMPLES_SUBLINK]
.su u 1 .SAMPLES_SUBLINK

.. ----------------------------------------
..
.2 .TITLE
.an CMD_TITLE
.
*.TITLE* - set document title

Example:
.fo off
 .ti This is the document title
.fo on

This command sets the document title. Speciy that
command as the very first command in your [=TITLE] compatible
source file.

.. ----------------------------------------
.2 .ULIST
.. ----------------------------------------
.an CMD_ULIST
.
*.ULIST* - create unordered list

Example:
.fo off
 .ul compact
 - this is item 1
 - this is item 2
   - this is item 2.1
     - this is item 2.1.1
 - this is item 3
.fo on

This command creates an unordered list.
The following rules apply to unordered lists:
.ul compact
- the following parms can be specified
.pl compact italic tsize=2
  - compact
  = do not place empty lines between items
  - bold  italic  underlined  hilite
  = one or more [.CMD_ATTRIBUTE text attributes] to be used for the parameter term
- a list must be terminated by an empty line
- a list level can explicitely be ended with the [.CMD_ELIST] command
- an item starts with a minus sign as the item marker
  being the first non-space character on the line
- the identation of the items are determined by
  the position of the item markers

The resulting list from the example above looks like this:
.ul compact
- this is item 1
- this is item 2
  - this is item 2.1
    - this is item 2.1.1
- this is item 3

