.. ----------------------------------------
.1 Usage
.. ----------------------------------------
.an USAGE
.
Select one of the following topics:
.su V30 u

.. ----------------------------------------
.2 call [=BASETITLE] directly
.. ----------------------------------------
.an USAGE_DIRECTLY
.

Invoking the command below , [=TITLE] will compile the source 
files to IPF source and call the [.INSTALL_IPF IPF Compiler] to 
create an INF or HLP file.
.
If the INF file can be created suscesfully, the INF file
viewer is started to display it, unless the switch parameter 
*/NOVIEW* is specified.

See some examples [.USAGE_EXAMPLE here].

.fo off
  HTEXT 
    [.FN_PARM_CMDPATH drive]   [.FN_PARM_CMDPATH path]               

  [.FN_PARM_INPUTFILE source__file] 
    [.FN_PARM_SOURCEDRIVE drive]   [.FN_PARM_SOURCEPATH path] 

 
    [.FN_PARM_IPFFILE ipf__file] 
    [.FN_PARM_TARGETDRIVE drive]   [.FN_PARM_TARGETPATH path] 

 
    [.FN_PARM_INFORHLPFILE inf__or__hlp__file] 
    [.FN_PARM_TARGETDRIVE drive]   [.FN_PARM_TARGETPATH path]               

 
    [.FN_PARM_RCHFILE rch__file] 
    [.FN_PARM_TARGETDRIVE drive]   [.FN_PARM_TARGETPATH path] 

   Ŀ
                             
 Ĵ
       [.FN_PARM_HELP /?] Ĵ
       [.FN_PARM_VERBOSE /Verbose] Ĵ
       [.FN_PARM_NOVIEW /Noview] Ĵ
       [.FN_PARM_RCH /Rch] Ĵ
         [.FN_PARM_RCHSTEM /Rch:prefix]   
       [.FN_PARM_GENHLP /Hlp] 

.fo on

.. + + + + + + + + + + + + + + + + + + + + 
.fn 
.an FN_PARM_CMDPATH
.
Specifies the drive and location for the command 
you want to process. External commands are stored 
on the disk as program files.  When an external 
command is entered, the system searches for it in 
the current directory of the default or specified 
drive. If the command is not found, the system 
continues searching for it in the directories listed in 
the PATH statement. 

.. + + + + + + + + + + + + + + + + + + + + 
.fn 
.an FN_PARM_SOURCEDRIVE
.
Specifies the drive for the source file. If you do not specify a 
drive, the file is being searched in the current
drive.

.. + + + + + + + + + + + + + + + + + + + + 
.fn 
.an FN_PARM_SOURCEPATH
.
Specifies the path for the source file. If you do not specify a 
path, the file is being searched in the current
directory (of a specified drive). 

.. + + + + + + + + + + + + + + + + + + + + 
.fn 
.an FN_PARM_TARGETDRIVE
.
Specifies the drive for the target file. If you do not specify a 
drive, the file is written in the current
drive.

.. + + + + + + + + + + + + + + + + + + + + 
.fn 
.an FN_PARM_TARGETPATH
.
Specifies the path for the target file. If you do not specify a 
path, the file is written in the current
directory (of a specified drive). 

.. + + + + + + + + + + + + + + + + + + + + 
.fn 
.an FN_PARM_INPUTFILE
.
This parameter specifies the [=TITLE] compatible source file.

.. + + + + + + + + + + + + + + + + + + + + 
.fn 
.an FN_PARM_IPFFILE
.
This optional parameter specifies the name of the intermediate IPF source
file.
.
If none is specified, [=TITLE] will create an IPF file
with the same name, but extension *.ipf* in the same directory of the
source file.

.. + + + + + + + + + + + + + + + + + + + + 
.fn 
.an FN_PARM_INFORHLPFILE
.
This optional parameter specifies the name of the resulting INF or HLP file.
.
If none is specified, [=TITLE] will create an INF or HLP file, 
with the same name, but extension *.inf* or *.hlp* in the same directory
of the source file. By default, an INF file is created, disregarding the
extension of a specified filename. Specify the switch parameter */HLP*
to create a help file instead.

.. + + + + + + + + + + + + + + + + + + + + 
.fn 
.an FN_PARM_RCHFILE
.
The optional parameter */Rch* specifies the name of the resulting 
resource header file, so that panels of INF or HLP files can be 
linked to externally.
.
You have to specify also the switch parameter [.FN_PARM_RCH /RCH].

.. + + + + + + + + + + + + + + + + + + + + 
.fn 
.an FN_PARM_HELP
.
The parameter */?* displays a brief syntax help.

.. + + + + + + + + + + + + + + + + + + + + 
.fn 
.an FN_PARM_VERBOSE
.
The parameter */Verbose* lets [=TITLE] display some information
about the compilation process and the output of the IPF compiler output.

When */Verbose* is not specified, the IPF compiler output is
only displayed, when the IPF compiler reports an error

.. + + + + + + + + + + + + + + + + + + + + 
.fn 
.an FN_PARM_NOVIEW
.
The parameter */Noview* prevents [=TITLE] from launching the 
INF file viewer after successful compilation.

.. + + + + + + + + + + + + + + + + + + + + 
.fn 
.an FN_PARM_RCH
.
The parameter */Rch* lets [=TITLE] generate a resource header file,
so that panels of INF or HLP files can be linked to externally. This file with 
the extension *.rch* includes a line like
.fo off
  ##define <anchorname>    <resid>
.fo on
.
for each panel, for wich both a resource id and an anchorname is specified
with the [.CMD_RESID] and [.CMD_ANCHOR] command.
Specify a [.FN_PARM_RCHSTEM prefix] to prepend it to all symbol names
within the header file.

.. + + + + + + + + + + + + + + + + + + + + 
.fn 
.an FN_PARM_RCHSTEM
.
The parameter */Rch:#prefix#* lets [=TITLE] generate a resource header 
file just like the plain [.FN_PARM_RCH /RCH] parameter, but will
use the specified prefix for the symbols within that file.

If you specify e.g.
.fo off
  /RCH:PANEL__
.fo on
.
the definition line looks like
.fo off
  ##define PANEL__<anchorname>    <resid>
.fo on

.. + + + + + + + + + + + + + + + + + + + + 
.fn 
.an FN_PARM_GENHLP
.
The parameter */Hlp* lets [=TITLE] create a help file with the .HLP
extension with the following restrictions:
.ul compact
- viewports are disabled, so that all windows cover 100% of the INF viewer area
- autolinks are disabled

.. ----------------------------------------
.3 [=BASETITLE] call examples
.. ----------------------------------------
.an USAGE_EXAMPLE
.
The following command creates the file *sample.inf* from *sample.txt* in the
current directory (an intermediate IPF file named *sample.ipf* is also created there).
The INF file viewer is launched with the resulting INF file right after compilation:
.fo off
htext sample.txt
.fo on

The following command does the same, but does not launch the INF file viewer
.fo off
htext sample.txt /NOVIEW
.fo on

The following command does the same, but displays some information about
the compilation process.
.fo off
htext sample.txt /VERBOSE
.fo on

The following command creates the file *target.inf* from *sample.txt* in the
subdirectory *release\inf*. The intermediate IPF file *source.ipf* is created
in the *compile* subdirectory.
.fo off
htext sample.txt compile\source.ipf release\inf\target.inf
.fo on

The following command creates the file *sample.hlp* from *sample.txt* in the
current directory (an intermediate IPF file named *sample.ipf* is also created there):
.fo off
htext sample.txt /HLP
.fo on

The following command creates the file *sample.hlp* from *sample.txt* in the
current directory and also generates a resource header file named *sample.rch*,
so that an application can use the numeric resource ids of the help file.
Within the header file, the anchornames being used as symbol names are prefixed
with the string *IDPNL__*
.fo off
htext sample.txt /HLP /RCH:IDPNL__
.fo on

.. ----------------------------------------
.2 call [=BASETITLE] as batch processor
.. ----------------------------------------
.an USAGE_EXTPROC
.
You can use [=TITLE] as an external batch processor
for CMD files, that contains [=TITLE] compatible source file.
For that (re)name a source text file to have an extension of .cmd
and place the following line at the very top of the file:
.fo off
  EXTPROC htext
.fo on

Append any [.USAGE_DIRECTLY parameters for HTEXT.CMD] to this line.

In order to let [=TITLE] compile the commandfile, simply
execute the new commandfile.

.. ----------------------------------------
.2 [=BASETITLE] environment variables
.. ----------------------------------------
.an USAGE_ENVVARS
.
The following environment variables are used by [=TITLE]:
.plist bold
- INCLUDE
= search include and bitmap files, if not found in current or specified directory
- HTINCLUDE
= search include and bitmap files if not found in current or specified directory
and the directories of the INCLUDE statement

.. ----------------------------------------
.2 EPM support
.. ----------------------------------------
.
[=TITLE] supports special features of the developers edition of the
*Enhanced Editor* of OS/2 V6.03b (EPM).
.at hi
This is not the version EPM coming with OS/2 Warp 4 !
.at
You have to replace the EPM yourself after installing an OS/2 system.

_*Error message layout*_
.ul
- the error messages of the [=TITLE] match error messages of common OS/2 compilers
- the error messages of the *IPF compiler* are transformed to match error messages
  of common OS/2 compilers

This way you can use the error scan feature and simply step through all errors
both being reported by [=TITLE] and the *IPF compiler*.

.. ----------------------------------------
.2 HtLaunch - using the default web browser
.. ----------------------------------------
.an USAGE_HTLAUNCH
.
[=TITLE] can create [.ESC_LINKS external links to internet resources]
for you, which will start a web browser automatically.

Unfortunately, an INF file has to contain the name of the web browser 
(or any other program started from it) hardcoded. As a result, 
an INF file cannot support the *default web browser* mechanism provided 
by *OS/2 Warp 3* and *OS/2 Warp 4* by default. Instead, [=TITLE] uses 
*NETSCAPE.EXE* as the browser to be used for external internet resources.

In order to still have an opportunity to support the default browser
machanism of *OS/2 Warp*, [=TITLE] comes with the *HtLaunch* utility. 

When called with an URL as parameter, *HtLaunch* will will query the 
default browser from OS/2 an use it to access the desired internet resource
In order to let an INF file use *HtLaunch*, this utility is also used
to modify any INF file created by [=TITLE] to use htlaunch.exe
instead of NETSCAPE.EXE, so that such modified INF file will from 
then on indirectly use the default web browser for external internet
resources.

As only drawback, the external links will not work any longer, if you
copy a patched INF file to a system, where htlaunch.exe is not available.

In order to use *HtLaunch*, do the following:
.ol 
- use [=TITLE] to create an INF file with [.ESC_LINKS external internet links]
- ship your application package with both htlaunch.exe and your INF file and 
  an installation routine
- when the installation routine of your package installs the INF file on a new
  system
  - copy htlaunch.exe to a directory from within the *PATH* statement
.
  (?:\OS2 recommended, where ?: is the boot drive)
  - copy the INF file to the desired location
  - modify the INF file with the following command
.fo off
    htlaunch $PATCH <pathname__of__inf__file>
.fo on

[=NOTE]
.ul compact
- The external links to internet resources within the modified INF file will 
  not longer work on systems, where *htlaunch.exe* is not available
- the *HtLaunch* utility can only patch INF files created by [=TITLE]
  to use htlaunch.exe

