/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.url.jndi;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.ResolveResult;

public abstract class GenericURLContext
implements Context {
    protected Hashtable myEnv = null;

    public GenericURLContext(Hashtable hashtable) {
        this.myEnv = hashtable;
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(string, object);
    }

    public void bind(String string, Object object) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.bind(resolveResult.getRemainingName(), object);
        }
        finally {
            Object var6_5 = null;
            context.close();
        }
    }

    public void bind(Name name, Object object) throws NamingException {
        if (name.size() == 1) {
            this.bind(name.get(0), object);
        }
        String string = name.get(0);
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            Name name2 = resolveResult.getRemainingName();
            name2.addAll(name.getSuffix(1));
            context.bind(name2, object);
        }
        finally {
            Object var7_7 = null;
            context.close();
        }
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    public String composeName(String string, String string2) throws NamingException {
        if (string2.equals("")) {
            return string;
        }
        if (string.equals("")) {
            return string2;
        }
        return String.valueOf(string2) + "/" + string;
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        return name3;
    }

    public Context createSubcontext(String string) throws NamingException {
        Context context;
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context2 = (Context)resolveResult.getResolvedObj();
        try {
            context = context2.createSubcontext(resolveResult.getRemainingName());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context2.close();
            throw throwable;
        }
        context2.close();
        return context;
    }

    public Context createSubcontext(Name name) throws NamingException {
        Context context;
        if (name.size() == 1) {
            return this.createSubcontext(name.get(0));
        }
        String string = name.get(0);
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context2 = (Context)resolveResult.getResolvedObj();
        try {
            Name name2 = resolveResult.getRemainingName();
            name2.addAll(name.getSuffix(1));
            context = context2.createSubcontext(name2);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            context2.close();
            throw throwable;
        }
        context2.close();
        return context;
    }

    public void destroySubcontext(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.destroySubcontext(resolveResult.getRemainingName());
        }
        finally {
            Object var5_4 = null;
            context.close();
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (name.size() == 1) {
            this.destroySubcontext(name.get(0));
        }
        String string = name.get(0);
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            Name name2 = resolveResult.getRemainingName();
            name2.addAll(name.getSuffix(1));
            context.destroySubcontext(name2);
        }
        finally {
            Object var6_6 = null;
            context.close();
        }
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv;
    }

    public NameParser getNameParser(String string) throws NamingException {
        NameParser nameParser;
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            nameParser = context.getNameParser(resolveResult.getRemainingName());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return nameParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        NameParser nameParser;
        if (name.size() == 1) {
            return this.getNameParser(name.get(0));
        }
        String string = name.get(0);
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            Name name2 = resolveResult.getRemainingName();
            name2.addAll(name.getSuffix(1));
            nameParser = context.getNameParser(name2);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return nameParser;
    }

    protected abstract ResolveResult getRootURLContext(String var1, Hashtable var2) throws NamingException;

    public NamingEnumeration list(String string) throws NamingException {
        NamingEnumeration<NameClassPair> namingEnumeration;
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            String string2 = resolveResult.getRemainingName().toString();
            namingEnumeration = context.list(string2);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return namingEnumeration;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        NamingEnumeration<NameClassPair> namingEnumeration;
        if (name.size() == 1) {
            return this.list(name.get(0));
        }
        String string = name.get(0);
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            Name name2 = resolveResult.getRemainingName();
            name2.addAll(name.getSuffix(1));
            namingEnumeration = context.list(name2);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return namingEnumeration;
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        NamingEnumeration<Binding> namingEnumeration;
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            namingEnumeration = context.listBindings(resolveResult.getRemainingName());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return namingEnumeration;
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        NamingEnumeration<Binding> namingEnumeration;
        if (name.size() == 1) {
            return this.listBindings(name.get(0));
        }
        String string = name.get(0);
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            Name name2 = resolveResult.getRemainingName();
            name2.addAll(name.getSuffix(1));
            namingEnumeration = context.listBindings(name2);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return namingEnumeration;
    }

    public Object lookup(String string) throws NamingException {
        Object object;
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            object = context.lookup(resolveResult.getRemainingName());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return object;
    }

    public Object lookup(Name name) throws NamingException {
        Object object;
        if (name.size() == 1) {
            return this.lookup(name.get(0));
        }
        String string = name.get(0);
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            Name name2 = resolveResult.getRemainingName();
            name2.addAll(name.getSuffix(1));
            object = context.lookup(name2);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return object;
    }

    public Object lookupLink(String string) throws NamingException {
        Object object;
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            object = context.lookupLink(resolveResult.getRemainingName());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return object;
    }

    public Object lookupLink(Name name) throws NamingException {
        Object object;
        if (name.size() == 1) {
            return this.lookupLink(name.get(0));
        }
        String string = name.get(0);
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            Name name2 = resolveResult.getRemainingName();
            name2.addAll(name.getSuffix(1));
            object = context.lookupLink(name2);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return object;
    }

    public void rebind(String string, Object object) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.rebind(resolveResult.getRemainingName(), object);
        }
        finally {
            Object var6_5 = null;
            context.close();
        }
    }

    public void rebind(Name name, Object object) throws NamingException {
        if (name.size() == 1) {
            this.rebind(name.get(0), object);
        }
        String string = name.get(0);
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            Name name2 = resolveResult.getRemainingName();
            name2.addAll(name.getSuffix(1));
            context.rebind(name2, object);
        }
        finally {
            Object var7_7 = null;
            context.close();
        }
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(string);
    }

    public void rename(String string, String string2) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            String string3 = resolveResult.getRemainingName().toString();
            context.rename(string3, string2);
        }
        finally {
            Object var6_6 = null;
            context.close();
        }
    }

    public void rename(Name name, Name name2) throws NamingException {
        if (name.size() == 1) {
            this.rename(name.get(0), name2.toString());
        }
        String string = name.get(0);
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            Name name3 = resolveResult.getRemainingName();
            name3.addAll(name.getSuffix(1));
            context.rename(name3, name2);
        }
        finally {
            Object var7_7 = null;
            context.close();
        }
    }

    public void unbind(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.unbind(resolveResult.getRemainingName());
        }
        finally {
            Object var5_4 = null;
            context.close();
        }
    }

    public void unbind(Name name) throws NamingException {
        if (name.size() == 1) {
            this.unbind(name.get(0));
        }
        String string = name.get(0);
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            Name name2 = resolveResult.getRemainingName();
            name2.addAll(name.getSuffix(1));
            context.unbind(name2);
        }
        finally {
            Object var6_6 = null;
            context.close();
        }
    }
}

