/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class BasicMenuUI
extends BasicMenuItemUI {
    protected ChangeListener changeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MenuListener menuListener;
    private int lastMnemonic = 0;

    protected ChangeListener createChangeListener(JComponent jComponent) {
        return new ChangeHandler((JMenu)jComponent, this);
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler();
    }

    protected MenuListener createMenuListener(JComponent jComponent) {
        return new MenuHandler();
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new PropertyChangeHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuUI();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (((JMenu)this.menuItem).isTopLevelMenu()) {
            Dimension dimension = jComponent.getPreferredSize();
            return new Dimension(dimension.width, Short.MAX_VALUE);
        }
        return null;
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void installDefaults() {
        super.installDefaults();
        ((JMenu)this.menuItem).setDelay(200);
    }

    protected void installKeyboardActions() {
        if (this.menuItem.getModel().getMnemonic() != this.lastMnemonic) {
            this.menuItem.unregisterKeyboardAction(KeyStroke.getKeyStroke(this.lastMnemonic, 8, false));
            this.lastMnemonic = this.menuItem.getModel().getMnemonic();
            this.menuItem.registerKeyboardAction(new PostAction((JMenu)this.menuItem, true), KeyStroke.getKeyStroke(this.lastMnemonic, 8, false), 2);
        }
    }

    protected void installListeners() {
        super.installListeners();
        this.changeListener = this.createChangeListener(this.menuItem);
        this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem);
        this.menuListener = this.createMenuListener(this.menuItem);
        this.menuItem.addChangeListener(this.changeListener);
        this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        ((JMenu)this.menuItem).addMenuListener(this.menuListener);
    }

    protected void setupPostTimer(JMenu jMenu) {
        Timer timer = new Timer(jMenu.getDelay(), new PostAction(jMenu, false));
        timer.setRepeats(false);
        timer.start();
    }

    protected void uninstallDefaults() {
        this.menuItem.setArmed(false);
        this.menuItem.setSelected(false);
        this.menuItem.resetKeyboardActions();
        super.uninstallDefaults();
    }

    protected void uninstallKeyboardActions() {
        this.menuItem.unregisterKeyboardAction(KeyStroke.getKeyStroke(this.lastMnemonic, 8, false));
        this.lastMnemonic = 0;
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removeChangeListener(this.changeListener);
        this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        this.changeListener = null;
        this.propertyChangeListener = null;
        this.menuListener = null;
    }

    private static class PostAction
    extends AbstractAction {
        JMenu menu;
        boolean force = false;

        PostAction(JMenu jMenu, boolean bl) {
            super("postAction");
            this.menu = jMenu;
            this.force = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (this.force) {
                Container container = this.menu.getParent();
                if (container != null && container instanceof JMenuBar) {
                    MenuElement[] menuElementArray = this.menu.getPopupMenu().getSubElements();
                    if (menuElementArray.length > 0) {
                        MenuElement[] menuElementArray2 = new MenuElement[]{(MenuElement)((Object)container), this.menu, this.menu.getPopupMenu(), menuElementArray[0]};
                        menuSelectionManager.setSelectedPath(menuElementArray2);
                    } else {
                        MenuElement[] menuElementArray3 = new MenuElement[]{(MenuElement)((Object)container), this.menu};
                        menuSelectionManager.setSelectedPath(menuElementArray3);
                    }
                }
            } else {
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                if (menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1] == this.menu) {
                    MenuElement[] menuElementArray4 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray4, 0, menuElementArray.length);
                    menuElementArray4[menuElementArray.length] = this.menu.getPopupMenu();
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray4);
                }
            }
        }

        public boolean isEnabled() {
            return this.menu.getModel().isEnabled();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("mnemonic")) {
                BasicMenuUI.this.installKeyboardActions();
            }
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (jMenu.isEnabled()) {
                if (!jMenu.isTopLevelMenu()) {
                    if (menuElementArray.length <= 0 || menuElementArray[menuElementArray.length - 1] != jMenu.getPopupMenu()) {
                        if (jMenu.getDelay() == 0) {
                            MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 2];
                            System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                            menuElementArray2[menuElementArray.length] = BasicMenuUI.this.menuItem;
                            menuElementArray2[menuElementArray.length + 1] = jMenu.getPopupMenu();
                            menuSelectionManager.setSelectedPath(menuElementArray2);
                        } else {
                            menuSelectionManager.setSelectedPath(BasicMenuUI.this.getPath());
                            BasicMenuUI.this.setupPostTimer(jMenu);
                        }
                    }
                } else if (menuElementArray.length > 0 && menuElementArray[0] == jMenu.getParent()) {
                    MenuElement[] menuElementArray3 = new MenuElement[]{(MenuElement)((Object)jMenu.getParent()), jMenu, jMenu.getPopupMenu()};
                    menuSelectionManager.setSelectedPath(menuElementArray3);
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            MenuElement[] menuElementArray;
            Object object;
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            if (jMenu.isTopLevelMenu() && jMenu.isEnabled()) {
                if (jMenu.isSelected()) {
                    menuSelectionManager.clearSelectedPath();
                } else {
                    object = jMenu.getParent();
                    if (object != null && object instanceof JMenuBar) {
                        menuElementArray = new MenuElement[]{(MenuElement)object, jMenu};
                        menuSelectionManager.setSelectedPath(menuElementArray);
                    }
                }
            }
            if (((MenuElement[])(object = menuSelectionManager.getSelectedPath())).length <= 0 || object[((MenuElement[])object).length - 1] != jMenu.getPopupMenu()) {
                if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0) {
                    menuElementArray = new MenuElement[((MenuElement[])object).length + 1];
                    System.arraycopy(object, 0, menuElementArray, 0, ((MenuElement[])object).length);
                    menuElementArray[((MenuElement[])object).length] = jMenu.getPopupMenu();
                    menuSelectionManager.setSelectedPath(menuElementArray);
                } else {
                    BasicMenuUI.this.setupPostTimer(jMenu);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                menuSelectionManager.clearSelectedPath();
            }
        }
    }

    private static class MenuHandler
    implements MenuListener {
        MenuHandler() {
        }

        public void menuCanceled(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (menuSelectionManager.isComponentPartOfCurrentMenu(jMenu)) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuSelected(MenuEvent menuEvent) {
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public JMenu menu;
        public BasicMenuUI ui;
        public boolean isSelected = false;
        public Component wasFocused;

        public ChangeHandler(JMenu jMenu, BasicMenuUI basicMenuUI2) {
            this.menu = jMenu;
            this.ui = basicMenuUI2;
            this.validateKeyboardActions(this.menu.isSelected());
        }

        private Component findFocusedComponent(Component component) {
            Container container = component.getParent();
            while (container != null) {
                if (container instanceof Window) {
                    return ((Window)container).getFocusOwner();
                }
                container = container.getParent();
            }
            return null;
        }

        private MenuElement nextEnabledChild(MenuElement[] menuElementArray, int n) {
            int n2 = n;
            int n3 = menuElementArray.length;
            while (n2 < n3) {
                Component component;
                if (menuElementArray[n2] != null && (component = menuElementArray[n2].getComponent()) != null && component.isEnabled()) {
                    return menuElementArray[n2];
                }
                ++n2;
            }
            return null;
        }

        private MenuElement previousEnabledChild(MenuElement[] menuElementArray, int n) {
            int n2 = n;
            while (n2 >= 0) {
                Component component;
                if (menuElementArray[n2] != null && (component = menuElementArray[n2].getComponent()) != null && component.isEnabled()) {
                    return menuElementArray[n2];
                }
                --n2;
            }
            return null;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.validateKeyboardActions(this.menu.isSelected());
        }

        private void validateKeyboardActions(boolean bl) {
            if (bl != this.isSelected) {
                this.isSelected = bl;
                if (this.isSelected) {
                    boolean bl2 = this.menu.isRequestFocusEnabled();
                    this.wasFocused = this.findFocusedComponent(this.menu);
                    if (!bl2) {
                        this.menu.setRequestFocusEnabled(true);
                    }
                    this.menu.requestFocus();
                    if (!bl2) {
                        this.menu.setRequestFocusEnabled(false);
                    }
                    this.menu.registerKeyboardAction(new CancelAction(), KeyStroke.getKeyStroke(27, 0, false), 2);
                    this.menu.registerKeyboardAction(new SelectNextItemAction(), KeyStroke.getKeyStroke(40, 0, false), 2);
                    this.menu.registerKeyboardAction(new SelectPreviousItemAction(), KeyStroke.getKeyStroke(38, 0, false), 2);
                    this.menu.registerKeyboardAction(new SelectParentItemAction(), KeyStroke.getKeyStroke(37, 0, false), 2);
                    this.menu.registerKeyboardAction(new SelectChildItemAction(), KeyStroke.getKeyStroke(39, 0, false), 2);
                    this.menu.registerKeyboardAction(new ReturnAction(), KeyStroke.getKeyStroke(10, 0, false), 2);
                    this.menu.registerKeyboardAction(new ReturnAction(), KeyStroke.getKeyStroke(32, 0, false), 2);
                } else {
                    this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
                    this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0, false));
                    this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0, false));
                    this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(37, 0, false));
                    this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(39, 0, false));
                    this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
                    this.menu.unregisterKeyboardAction(KeyStroke.getKeyStroke(32, 0, false));
                    if (this.wasFocused != null) {
                        if (this.wasFocused instanceof JComponent) {
                            JComponent jComponent = (JComponent)this.wasFocused;
                            boolean bl3 = jComponent.isRequestFocusEnabled();
                            if (!bl3) {
                                jComponent.setRequestFocusEnabled(true);
                            }
                            this.wasFocused.requestFocus();
                            if (!bl3) {
                                jComponent.setRequestFocusEnabled(false);
                            }
                        } else {
                            this.wasFocused.requestFocus();
                        }
                        this.wasFocused = null;
                    }
                }
            }
        }

        private class CancelAction
        extends AbstractAction {
            CancelAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray.length > 4) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                } else {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
            }
        }

        private class ReturnAction
        extends AbstractAction {
            ReturnAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray.length > 0) {
                    MenuElement menuElement = menuElementArray[menuElementArray.length - 1];
                    if (menuElement instanceof JMenu) {
                        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
                        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                        menuElementArray2[menuElementArray.length] = ((JMenu)menuElement).getPopupMenu();
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                    } else if (menuElement instanceof JMenuItem) {
                        MenuSelectionManager.defaultManager().clearSelectedPath();
                        ((JMenuItem)menuElement).doClick(0);
                        ((JMenuItem)menuElement).setArmed(false);
                    }
                }
            }
        }

        private class SelectNextItemAction
        extends AbstractAction {
            SelectNextItemAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                block3: {
                    MenuElement menuElement;
                    MenuElement[] menuElementArray;
                    block4: {
                        menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                        if (menuElementArray.length <= 1) break block3;
                        menuElement = menuElementArray[menuElementArray.length - 2];
                        if (!(menuElement.getComponent() instanceof JMenu)) break block4;
                        menuElement = menuElementArray[menuElementArray.length - 1];
                        MenuElement[] menuElementArray2 = menuElement.getSubElements();
                        if (menuElementArray2.length <= 0) break block3;
                        MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                        System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                        menuElementArray3[menuElementArray.length] = ChangeHandler.this.nextEnabledChild(menuElementArray2, 0);
                        if (menuElementArray3[menuElementArray.length] == null) break block3;
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray3);
                        break block3;
                    }
                    MenuElement[] menuElementArray4 = menuElement.getSubElements();
                    int n = 0;
                    int n2 = menuElementArray4.length;
                    while (n < n2) {
                        if (menuElementArray4[n] == menuElementArray[menuElementArray.length - 1]) {
                            MenuElement menuElement2 = ChangeHandler.this.nextEnabledChild(menuElementArray4, n + 1);
                            if (menuElement2 == null) {
                                menuElement2 = ChangeHandler.this.nextEnabledChild(menuElementArray4, 0);
                            }
                            if (menuElement2 == null) break;
                            menuElementArray[menuElementArray.length - 1] = menuElement2;
                            MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                            break;
                        }
                        ++n;
                    }
                }
            }
        }

        private class SelectPreviousItemAction
        extends AbstractAction {
            SelectPreviousItemAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                block3: {
                    MenuElement menuElement;
                    MenuElement[] menuElementArray;
                    block4: {
                        menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                        if (menuElementArray.length <= 1) break block3;
                        menuElement = menuElementArray[menuElementArray.length - 2];
                        if (!(menuElement.getComponent() instanceof JMenu)) break block4;
                        menuElement = menuElementArray[menuElementArray.length - 1];
                        MenuElement[] menuElementArray2 = menuElement.getSubElements();
                        if (menuElementArray2.length <= 0) break block3;
                        MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                        System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                        menuElementArray3[menuElementArray.length] = ChangeHandler.this.previousEnabledChild(menuElementArray2, menuElementArray2.length - 1);
                        if (menuElementArray3[menuElementArray.length] == null) break block3;
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray3);
                        break block3;
                    }
                    MenuElement[] menuElementArray4 = menuElement.getSubElements();
                    int n = 0;
                    int n2 = menuElementArray4.length;
                    while (n < n2) {
                        if (menuElementArray4[n] == menuElementArray[menuElementArray.length - 1]) {
                            MenuElement menuElement2 = ChangeHandler.this.previousEnabledChild(menuElementArray4, n - 1);
                            if (menuElement2 == null) {
                                menuElement2 = ChangeHandler.this.previousEnabledChild(menuElementArray4, menuElementArray4.length - 1);
                            }
                            if (menuElement2 == null) break;
                            menuElementArray[menuElementArray.length - 1] = menuElement2;
                            MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                            break;
                        }
                        ++n;
                    }
                }
            }
        }

        private class SelectParentItemAction
        extends AbstractAction {
            SelectParentItemAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray.length > 3 && menuElementArray[menuElementArray.length - 3].getComponent() instanceof JMenu && !((JMenu)menuElementArray[menuElementArray.length - 3].getComponent()).isTopLevelMenu()) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                } else if (menuElementArray.length > 0 && menuElementArray[0].getComponent() instanceof JMenuBar) {
                    MenuElement[] menuElementArray3;
                    MenuElement menuElement = null;
                    JPopupMenu jPopupMenu = null;
                    MenuElement menuElement2 = null;
                    if (menuElementArray.length > 1) {
                        menuElementArray3 = menuElementArray[0].getSubElements();
                        int n = 0;
                        int n2 = menuElementArray3.length;
                        while (n < n2) {
                            if (menuElementArray3[n] == menuElementArray[1] && (menuElement = ChangeHandler.this.previousEnabledChild(menuElementArray3, n - 1)) == null) {
                                menuElement = ChangeHandler.this.previousEnabledChild(menuElementArray3, menuElementArray3.length - 1);
                            }
                            ++n;
                        }
                    }
                    if (menuElement != null) {
                        jPopupMenu = ((JMenu)menuElement).getPopupMenu();
                        if (((JMenu)menuElement).isTopLevelMenu()) {
                            menuElement2 = null;
                        } else {
                            menuElementArray3 = jPopupMenu.getSubElements();
                            if (menuElementArray3.length > 0) {
                                menuElement2 = ChangeHandler.this.nextEnabledChild(menuElementArray3, 0);
                            }
                        }
                        MenuElement[] menuElementArray4 = menuElement2 != null ? new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu, menuElement2} : new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu};
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray4);
                    }
                }
            }
        }

        private class SelectChildItemAction
        extends AbstractAction {
            SelectChildItemAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1].getComponent().isEnabled() && menuElementArray[menuElementArray.length - 1].getComponent() instanceof JMenu && !((JMenu)menuElementArray[menuElementArray.length - 1].getComponent()).isTopLevelMenu()) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 2];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                    menuElementArray2[menuElementArray.length] = ((JMenu)menuElementArray[menuElementArray.length - 1].getComponent()).getPopupMenu();
                    MenuElement[] menuElementArray3 = menuElementArray2[menuElementArray.length].getSubElements();
                    if (menuElementArray3.length > 0) {
                        menuElementArray2[menuElementArray.length + 1] = ChangeHandler.this.nextEnabledChild(menuElementArray3, 0);
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                    }
                } else if (menuElementArray.length > 0 && menuElementArray[0].getComponent() instanceof JMenuBar) {
                    MenuElement[] menuElementArray4;
                    MenuElement menuElement = null;
                    JPopupMenu jPopupMenu = null;
                    MenuElement menuElement2 = null;
                    if (menuElementArray.length > 1) {
                        menuElementArray4 = menuElementArray[0].getSubElements();
                        int n = 0;
                        int n2 = menuElementArray4.length;
                        while (n < n2) {
                            if (menuElementArray4[n] == menuElementArray[1] && (menuElement = ChangeHandler.this.nextEnabledChild(menuElementArray4, n + 1)) == null) {
                                menuElement = ChangeHandler.this.nextEnabledChild(menuElementArray4, 0);
                            }
                            ++n;
                        }
                    }
                    if (menuElement != null) {
                        jPopupMenu = ((JMenu)menuElement).getPopupMenu();
                        if (((JMenu)menuElement).isTopLevelMenu()) {
                            menuElement2 = null;
                        } else {
                            menuElementArray4 = jPopupMenu.getSubElements();
                            if (menuElementArray4.length > 0) {
                                menuElement2 = ChangeHandler.this.nextEnabledChild(menuElementArray4, 0);
                            }
                        }
                        MenuElement[] menuElementArray5 = menuElement2 != null ? new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu, menuElement2} : new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu};
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray5);
                    }
                }
            }
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        MenuDragMouseHandler() {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            Component component;
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (!BasicMenuUI.this.menuItem.isEnabled()) {
                return;
            }
            if (point.x >= 0 && point.x < BasicMenuUI.this.menuItem.getWidth() && point.y >= 0 && point.y < BasicMenuUI.this.menuItem.getHeight()) {
                JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
                MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
                if (menuElementArray2.length <= 0 || menuElementArray2[menuElementArray2.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0 || menuDragMouseEvent.getID() == 506) {
                        MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                        System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                        menuElementArray3[menuElementArray.length] = jMenu.getPopupMenu();
                        menuSelectionManager.setSelectedPath(menuElementArray3);
                    } else {
                        menuSelectionManager.setSelectedPath(menuElementArray);
                        BasicMenuUI.this.setupPostTimer(jMenu);
                    }
                }
            } else if (menuDragMouseEvent.getID() == 502 && (component = menuSelectionManager.componentForPoint(menuDragMouseEvent.getComponent(), menuDragMouseEvent.getPoint())) == null) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        MenuKeyHandler() {
        }

        private int lower(int n) {
            if (n >= 65 && n <= 90) {
                return n + 97 - 65;
            }
            return n;
        }

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
        }
    }
}

