/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;

public class BasicToolTipUI
extends ToolTipUI {
    static BasicToolTipUI sharedInstance = new BasicToolTipUI();

    public static ComponentUI createUI(JComponent jComponent) {
        return sharedInstance;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null) {
            return new Dimension(6, fontMetrics.getHeight() + 4);
        }
        return new Dimension(fontMetrics.stringWidth(string) + 6, fontMetrics.getHeight() + 4);
    }

    protected void installDefaults(JComponent jComponent) {
        LookAndFeel.installColorsAndFont(jComponent, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installBorder(jComponent, "ToolTip.border");
    }

    protected void installListeners(JComponent jComponent) {
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults(jComponent);
        this.installListeners(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        Dimension dimension = jComponent.getSize();
        graphics.setColor(jComponent.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(jComponent.getForeground());
        graphics.setFont(font);
        String string = ((JToolTip)jComponent).getTipText();
        if (string != null) {
            graphics.drawString(((JToolTip)jComponent).getTipText(), 3, 2 + fontMetrics.getAscent());
        }
    }

    protected void uninstallDefaults(JComponent jComponent) {
        LookAndFeel.uninstallBorder(jComponent);
    }

    protected void uninstallListeners(JComponent jComponent) {
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults(jComponent);
        this.uninstallListeners(jComponent);
    }
}

