/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicButtonUI
extends ButtonUI {
    private static final BasicButtonUI buttonUI = new BasicButtonUI();
    protected int defaultTextIconGap;
    private int shiftOffset = 0;
    protected int defaultTextShiftOffset;
    private boolean defaults_initialized = false;
    private static final String propertyPrefix = "Button.";
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();

    protected void clearTextShiftOffset() {
        this.shiftOffset = 0;
    }

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new BasicButtonListener(abstractButton);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return buttonUI;
    }

    public int getDefaultTextIconGap(AbstractButton abstractButton) {
        return this.defaultTextIconGap;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        return BasicGraphicsUtils.getPreferredButtonSize(abstractButton, this.defaultTextIconGap);
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    protected int getTextShiftOffset() {
        return this.shiftOffset;
    }

    protected void installDefaults(AbstractButton abstractButton) {
        String string = this.getPropertyPrefix();
        if (!this.defaults_initialized) {
            this.defaultTextIconGap = (Integer)UIManager.get(String.valueOf(string) + "textIconGap");
            this.defaultTextShiftOffset = (Integer)UIManager.get(String.valueOf(string) + "textShiftOffset");
            this.defaults_initialized = true;
        }
        if (abstractButton.isContentAreaFilled()) {
            abstractButton.setOpaque(true);
        } else {
            abstractButton.setOpaque(false);
        }
        if (abstractButton.getMargin() == null || abstractButton.getMargin() instanceof UIResource) {
            abstractButton.setMargin(UIManager.getInsets(String.valueOf(string) + "margin"));
        }
        LookAndFeel.installColorsAndFont(abstractButton, String.valueOf(string) + "background", String.valueOf(string) + "foreground", String.valueOf(string) + "font");
        LookAndFeel.installBorder(abstractButton, String.valueOf(string) + "border");
    }

    protected void installKeyboardActions(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = (BasicButtonListener)abstractButton.getClientProperty(this);
        if (basicButtonListener != null) {
            basicButtonListener.installKeyboardActions(abstractButton);
        }
    }

    protected void installListeners(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = this.createButtonListener(abstractButton);
        if (basicButtonListener != null) {
            abstractButton.putClientProperty(this, basicButtonListener);
            abstractButton.addMouseListener(basicButtonListener);
            abstractButton.addMouseMotionListener(basicButtonListener);
            abstractButton.addFocusListener(basicButtonListener);
            abstractButton.addPropertyChangeListener(basicButtonListener);
            abstractButton.addChangeListener(basicButtonListener);
        }
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults((AbstractButton)jComponent);
        this.installListeners((AbstractButton)jComponent);
        this.installKeyboardActions((AbstractButton)jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        BasicButtonUI.viewRect.x = insets.left;
        BasicButtonUI.viewRect.y = insets.top;
        BasicButtonUI.viewRect.width = abstractButton.getWidth() - (insets.right + BasicButtonUI.viewRect.x);
        BasicButtonUI.viewRect.height = abstractButton.getHeight() - (insets.bottom + BasicButtonUI.viewRect.y);
        BasicButtonUI.textRect.height = 0;
        BasicButtonUI.textRect.width = 0;
        BasicButtonUI.textRect.y = 0;
        BasicButtonUI.textRect.x = 0;
        BasicButtonUI.iconRect.height = 0;
        BasicButtonUI.iconRect.width = 0;
        BasicButtonUI.iconRect.y = 0;
        BasicButtonUI.iconRect.x = 0;
        Font font = jComponent.getFont();
        graphics.setFont(font);
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, abstractButton.getText() == null ? 0 : this.defaultTextIconGap);
        this.clearTextShiftOffset();
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            this.paintButtonPressed(graphics, abstractButton);
        }
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics, jComponent, iconRect);
        }
        if (string != null && !string.equals("")) {
            this.paintText(graphics, jComponent, textRect, string);
        }
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            this.paintFocus(graphics, abstractButton, viewRect, textRect, iconRect);
        }
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
    }

    protected void paintIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon = null;
        if (!buttonModel.isEnabled()) {
            icon = abstractButton.getDisabledIcon();
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon = abstractButton.getPressedIcon();
            if (icon == null) {
                icon = abstractButton.getIcon();
            } else {
                this.clearTextShiftOffset();
            }
        } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
            icon = abstractButton.getRolloverIcon();
        }
        if (icon == null) {
            icon = abstractButton.getIcon();
        }
        if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon.paintIcon(jComponent, graphics, rectangle.x + this.getTextShiftOffset(), rectangle.y + this.getTextShiftOffset());
        } else {
            icon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
        }
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (buttonModel.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
            BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle.x + this.getTextShiftOffset(), rectangle.y + fontMetrics.getAscent() + this.getTextShiftOffset());
        } else {
            graphics.setColor(abstractButton.getBackground().brighter());
            BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(abstractButton.getBackground().darker());
            BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
        }
    }

    protected void setTextShiftOffset() {
        this.shiftOffset = this.defaultTextShiftOffset;
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        LookAndFeel.uninstallBorder(abstractButton);
        this.defaults_initialized = false;
    }

    protected void uninstallKeyboardActions(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = (BasicButtonListener)abstractButton.getClientProperty(this);
        if (basicButtonListener != null) {
            basicButtonListener.uninstallKeyboardActions(abstractButton);
        }
    }

    protected void uninstallListeners(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = (BasicButtonListener)abstractButton.getClientProperty(this);
        abstractButton.putClientProperty(this, null);
        if (basicButtonListener != null) {
            abstractButton.removeMouseListener(basicButtonListener);
            abstractButton.removeMouseListener(basicButtonListener);
            abstractButton.removeMouseMotionListener(basicButtonListener);
            abstractButton.removeFocusListener(basicButtonListener);
            abstractButton.removeChangeListener(basicButtonListener);
            abstractButton.removePropertyChangeListener(basicButtonListener);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions((AbstractButton)jComponent);
        this.uninstallListeners((AbstractButton)jComponent);
        this.uninstallDefaults((AbstractButton)jComponent);
    }
}

