/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabStop;
import javax.swing.text.rtf.MockAttributeSet;
import javax.swing.text.rtf.RTFAttribute;
import javax.swing.text.rtf.RTFAttributes;
import javax.swing.text.rtf.RTFParser;

class RTFReader
extends RTFParser {
    StyledDocument target;
    Dictionary parserState;
    Destination rtfDestination;
    MutableAttributeSet documentAttributes;
    Dictionary fontTable;
    Color[] colorTable;
    Style[] characterStyles;
    Style[] paragraphStyles;
    Style[] sectionStyles;
    int rtfversion;
    boolean ignoreGroupIfUnknownKeyword;
    int skippingCharacters;
    private static Dictionary straightforwardAttributes = RTFAttributes.attributesByKeyword();
    private MockAttributeSet mockery;
    static Dictionary textKeywords = null;
    static final String TabAlignmentKey = "tab_alignment";
    static final String TabLeaderKey = "tab_leader";
    static Dictionary characterSets;
    static boolean useNeXTForAnsi;

    static {
        textKeywords = new Hashtable();
        textKeywords.put("\\", "\\");
        textKeywords.put("{", "{");
        textKeywords.put("}", "}");
        textKeywords.put(" ", "\u00a0");
        textKeywords.put("~", "\u00a0");
        textKeywords.put("_", "\u2011");
        textKeywords.put("bullet", "\u2022");
        textKeywords.put("emdash", "\u2014");
        textKeywords.put("emspace", "\u2003");
        textKeywords.put("endash", "\u2013");
        textKeywords.put("enspace", "\u2002");
        textKeywords.put("ldblquote", "\u201c");
        textKeywords.put("lquote", "\u2018");
        textKeywords.put("ltrmark", "\u200e");
        textKeywords.put("rdblquote", "\u201d");
        textKeywords.put("rquote", "\u2019");
        textKeywords.put("rtlmark", "\u200f");
        textKeywords.put("tab", "\t");
        textKeywords.put("zwj", "\u200d");
        textKeywords.put("zwnj", "\u200c");
        textKeywords.put("-", "\u2027");
        useNeXTForAnsi = false;
        characterSets = new Hashtable();
    }

    public RTFReader(StyledDocument styledDocument) {
        this.target = styledDocument;
        this.parserState = new Hashtable();
        this.fontTable = new Hashtable();
        this.rtfversion = -1;
        this.mockery = new MockAttributeSet();
        this.documentAttributes = new SimpleAttributeSet();
    }

    public void begingroup() {
        Object v;
        if (this.skippingCharacters > 0) {
            this.skippingCharacters = 0;
        }
        if ((v = this.parserState.get("_savedState")) != null) {
            this.parserState.remove("_savedState");
        }
        Dictionary dictionary = (Dictionary)((Hashtable)this.parserState).clone();
        if (v != null) {
            dictionary.put("_savedState", v);
        }
        this.parserState.put("_savedState", dictionary);
        if (this.rtfDestination != null) {
            this.rtfDestination.begingroup();
        }
    }

    public void close() throws IOException {
        Enumeration enumeration = this.documentAttributes.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.target.putProperty(e, this.documentAttributes.getAttribute((String)e));
        }
        this.warnings.println("RTF filter done.");
        super.close();
    }

    Color defaultColor() {
        return Color.black;
    }

    public static synchronized void defineCharacterSet(String string, char[] cArray) {
        if (cArray.length < 256) {
            throw new IllegalArgumentException("Translation table must have 256 entries.");
        }
        characterSets.put(string, cArray);
    }

    public void endgroup() {
        Dictionary dictionary;
        Destination destination;
        if (this.skippingCharacters > 0) {
            this.skippingCharacters = 0;
        }
        if ((destination = (Destination)(dictionary = (Dictionary)this.parserState.get("_savedState")).get("dst")) != this.rtfDestination) {
            this.rtfDestination.close();
            this.rtfDestination = destination;
        }
        Dictionary dictionary2 = this.parserState;
        this.parserState = dictionary;
        if (this.rtfDestination != null) {
            this.rtfDestination.endgroup(dictionary2);
        }
    }

    public static synchronized Object getCharacterSet(String string) throws IOException {
        char[] cArray = (char[])characterSets.get(string);
        if (cArray == null) {
            Class<?> clazz;
            System.err.println("reading charset " + string);
            InputStream inputStream = null;
            try {
                clazz = Class.forName("javax.swing.text.rtf.RTFReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InternalError("Help, I do not exist (" + classNotFoundException + ")");
            }
            inputStream = clazz.getResourceAsStream("charsets/" + string + ".txt");
            cArray = RTFReader.readCharset(inputStream);
            RTFReader.defineCharacterSet(string, cArray);
        }
        return cArray;
    }

    public void handleBinaryBlob(byte[] byArray) {
        if (this.skippingCharacters > 0) {
            --this.skippingCharacters;
            return;
        }
    }

    public boolean handleKeyword(String string) {
        boolean bl = this.ignoreGroupIfUnknownKeyword;
        if (this.skippingCharacters > 0) {
            --this.skippingCharacters;
            return true;
        }
        this.ignoreGroupIfUnknownKeyword = false;
        Object v = textKeywords.get(string);
        if (v != null) {
            this.handleText((String)v);
            return true;
        }
        if (string.equals("fonttbl")) {
            this.setRTFDestination(new FonttblDestination());
            return true;
        }
        if (string.equals("colortbl")) {
            this.setRTFDestination(new ColortblDestination());
            return true;
        }
        if (string.equals("stylesheet")) {
            this.setRTFDestination(new StylesheetDestination());
            return true;
        }
        if (string.equals("info")) {
            this.setRTFDestination(new InfoDestination());
            return false;
        }
        if (string.equals("mac")) {
            this.setCharacterSet("mac");
            return true;
        }
        if (string.equals("ansi")) {
            if (useNeXTForAnsi) {
                this.setCharacterSet("NeXT");
            } else {
                this.setCharacterSet("ansi");
            }
            return true;
        }
        if (string.equals("next")) {
            this.setCharacterSet("NeXT");
            return true;
        }
        if (string.equals("pc")) {
            this.setCharacterSet("cpg437");
            return true;
        }
        if (string.equals("pca")) {
            this.setCharacterSet("cpg850");
            return true;
        }
        if (string.equals("*")) {
            this.ignoreGroupIfUnknownKeyword = true;
            return true;
        }
        if (this.rtfDestination != null && this.rtfDestination.handleKeyword(string)) {
            return true;
        }
        if (string.equals("aftncn") || string.equals("aftnsep") || string.equals("aftnsepc") || string.equals("annotation") || string.equals("atnauthor") || string.equals("atnicn") || string.equals("atnid") || string.equals("atnref") || string.equals("atntime") || string.equals("atrfend") || string.equals("atrfstart") || string.equals("bkmkend") || string.equals("bkmkstart") || string.equals("datafield") || string.equals("do") || string.equals("dptxbxtext") || string.equals("falt") || string.equals("field") || string.equals("file") || string.equals("filetbl") || string.equals("fname") || string.equals("fontemb") || string.equals("fontfile") || string.equals("footer") || string.equals("footerf") || string.equals("footerl") || string.equals("footerr") || string.equals("footnote") || string.equals("ftncn") || string.equals("ftnsep") || string.equals("ftnsepc") || string.equals("header") || string.equals("headerf") || string.equals("headerl") || string.equals("headerr") || string.equals("keycode") || string.equals("nextfile") || string.equals("object") || string.equals("pict") || string.equals("pn") || string.equals("pnseclvl") || string.equals("pntxtb") || string.equals("pntxta") || string.equals("revtbl") || string.equals("rxe") || string.equals("tc") || string.equals("template") || string.equals("txe") || string.equals("xe")) {
            bl = true;
        }
        if (bl) {
            this.setRTFDestination(new DiscardingDestination());
        }
        return false;
    }

    public boolean handleKeyword(String string, int n) {
        boolean bl = this.ignoreGroupIfUnknownKeyword;
        if (this.skippingCharacters > 0) {
            --this.skippingCharacters;
            return true;
        }
        this.ignoreGroupIfUnknownKeyword = false;
        if (string.equals("uc")) {
            this.parserState.put("UnicodeSkip", new Integer(n));
            return true;
        }
        if (string.equals("u")) {
            if (n < 0) {
                n += 65536;
            }
            this.handleText((char)n);
            Number number = (Number)this.parserState.get("UnicodeSkip");
            this.skippingCharacters = number != null ? number.intValue() : 1;
            return true;
        }
        if (string.equals("rtf")) {
            this.rtfversion = n;
            this.setRTFDestination(new DocumentDestination());
            return true;
        }
        if (string.startsWith("NeXT") || string.equals("private")) {
            bl = true;
        }
        if (this.rtfDestination != null && this.rtfDestination.handleKeyword(string, n)) {
            return true;
        }
        if (bl) {
            this.setRTFDestination(new DiscardingDestination());
        }
        return false;
    }

    public void handleText(String string) {
        if (this.skippingCharacters > 0) {
            if (this.skippingCharacters >= string.length()) {
                this.skippingCharacters -= string.length();
                return;
            }
            string = string.substring(this.skippingCharacters);
            this.skippingCharacters = 0;
        }
        if (this.rtfDestination != null) {
            this.rtfDestination.handleText(string);
            return;
        }
        this.warnings.println("Text with no destination. oops.");
    }

    static char[] readCharset(InputStream inputStream) throws IOException {
        char[] cArray = new char[256];
        StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(inputStream));
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.commentChar(35);
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.slashStarComments(true);
        int n = 0;
        while (n < 256) {
            int n2;
            try {
                n2 = streamTokenizer.nextToken();
            }
            catch (Exception exception) {
                throw new IOException("Unable to read from character set file (" + exception + ")");
            }
            if (n2 != -2) {
                throw new IOException("Unexpected token in character set file");
            }
            cArray[n] = (char)streamTokenizer.nval;
            ++n;
        }
        return cArray;
    }

    static char[] readCharset(URL uRL) throws IOException {
        return RTFReader.readCharset(uRL.openStream());
    }

    public void setCharacterSet(String string) {
        Object object;
        try {
            object = RTFReader.getCharacterSet(string);
        }
        catch (Exception exception) {
            this.warnings.println("Exception loading RTF character set \"" + string + "\": " + exception);
            object = null;
        }
        if (object != null) {
            this.translationTable = (char[])object;
        } else {
            this.warnings.println("Unknown RTF character set \"" + string + "\"");
            if (!string.equals("ansi")) {
                try {
                    this.translationTable = (char[])RTFReader.getCharacterSet("ansi");
                }
                catch (IOException iOException) {
                    throw new InternalError("RTFReader: Unable to find character set resources (" + iOException + ")");
                }
            }
        }
        this.setTargetAttribute("rtfCharacterSet", string);
    }

    protected void setRTFDestination(Destination destination) {
        Dictionary dictionary = (Dictionary)this.parserState.get("_savedState");
        if (dictionary != null && this.rtfDestination != dictionary.get("dst")) {
            this.warnings.println("Warning, RTF destination overridden, invalid RTF.");
            this.rtfDestination.close();
        }
        this.rtfDestination = destination;
        this.parserState.put("dst", this.rtfDestination);
    }

    private void setTargetAttribute(String string, Object object) {
    }

    static interface Destination {
        public void begingroup();

        public void close();

        public void endgroup(Dictionary var1);

        public void handleBinaryBlob(byte[] var1);

        public boolean handleKeyword(String var1);

        public boolean handleKeyword(String var1, int var2);

        public void handleText(String var1);
    }

    class DiscardingDestination
    implements Destination {
        DiscardingDestination() {
        }

        public void begingroup() {
        }

        public void close() {
        }

        public void endgroup(Dictionary dictionary) {
        }

        public void handleBinaryBlob(byte[] byArray) {
        }

        public boolean handleKeyword(String string) {
            return true;
        }

        public boolean handleKeyword(String string, int n) {
            return true;
        }

        public void handleText(String string) {
        }
    }

    class FonttblDestination
    implements Destination {
        int nextFontNumber;
        String nextFontFamily;

        FonttblDestination() {
        }

        public void begingroup() {
        }

        public void close() {
            Enumeration enumeration = RTFReader.this.fontTable.keys();
            RTFReader.this.warnings.println("Done reading font table.");
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                RTFReader.this.warnings.println("Number " + n + ": " + RTFReader.this.fontTable.get(n));
            }
            RTFReader.this.warnings.println();
        }

        public void endgroup(Dictionary dictionary) {
        }

        public void handleBinaryBlob(byte[] byArray) {
        }

        public boolean handleKeyword(String string) {
            if (string.charAt(0) == 'f') {
                this.nextFontFamily = string.substring(1);
                return true;
            }
            return false;
        }

        public boolean handleKeyword(String string, int n) {
            if (string.equals("f")) {
                this.nextFontNumber = n;
                return true;
            }
            return false;
        }

        public void handleText(String string) {
            int n = string.indexOf(59);
            String string2 = n > 0 ? string.substring(0, n) : string;
            RTFReader.this.fontTable.put(new Integer(this.nextFontNumber), string2);
            this.nextFontNumber = -1;
            this.nextFontFamily = null;
        }
    }

    class ColortblDestination
    implements Destination {
        int red = 0;
        int green = 0;
        int blue = 0;
        Vector proTemTable = new Vector();

        public void begingroup() {
        }

        public void close() {
            int n = this.proTemTable.size();
            RTFReader.this.warnings.println("Done reading color table, " + n + " entries.");
            RTFReader.this.colorTable = new Color[n];
            this.proTemTable.copyInto(RTFReader.this.colorTable);
        }

        public void endgroup(Dictionary dictionary) {
        }

        public void handleBinaryBlob(byte[] byArray) {
        }

        public boolean handleKeyword(String string) {
            return false;
        }

        public boolean handleKeyword(String string, int n) {
            if (string.equals("red")) {
                this.red = n;
            } else if (string.equals("green")) {
                this.green = n;
            } else if (string.equals("blue")) {
                this.blue = n;
            } else {
                return false;
            }
            return true;
        }

        public void handleText(String string) {
            int n = 0;
            n = 0;
            while (n < string.length()) {
                if (string.charAt(n) == ';') {
                    Color color = new Color(this.red, this.green, this.blue);
                    this.proTemTable.addElement(color);
                }
                ++n;
            }
        }
    }

    class StylesheetDestination
    extends DiscardingDestination
    implements Destination {
        Dictionary definedStyles = new Hashtable();

        public void begingroup() {
            RTFReader.this.setRTFDestination(new StyleDefiningDestination());
        }

        public void close() {
            Object[] objectArray;
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            Vector<Style> vector3 = new Vector<Style>();
            Enumeration enumeration = this.definedStyles.elements();
            while (enumeration.hasMoreElements()) {
                objectArray = (Object[])enumeration.nextElement();
                Style style = objectArray.realize();
                RTFReader.this.warnings.println("Style " + objectArray.number + " (" + objectArray.styleName + "): " + style);
                String string = (String)style.getAttribute("style:type");
                Vector<Style> vector4 = string.equals("section") ? vector3 : (string.equals("character") ? vector : vector2);
                if (vector4.size() <= objectArray.number) {
                    vector4.setSize(objectArray.number + 1);
                }
                vector4.setElementAt(style, objectArray.number);
            }
            if (!vector.isEmpty()) {
                objectArray = new Style[vector.size()];
                vector.copyInto(objectArray);
                RTFReader.this.characterStyles = objectArray;
            }
            if (!vector2.isEmpty()) {
                objectArray = new Style[vector2.size()];
                vector2.copyInto(objectArray);
                RTFReader.this.paragraphStyles = objectArray;
            }
            if (!vector3.isEmpty()) {
                objectArray = new Style[vector3.size()];
                vector3.copyInto(objectArray);
                RTFReader.this.sectionStyles = objectArray;
            }
        }

        class StyleDefiningDestination
        extends AttributeTrackingDestination
        implements Destination {
            final int STYLENUMBER_NONE = 222;
            boolean additive = false;
            boolean characterStyle = false;
            boolean sectionStyle = false;
            public String styleName = null;
            public int number = 0;
            int basedOn = 222;
            int nextStyle = 222;
            boolean hidden = false;
            Style realizedStyle;

            public void close() {
                int n = this.styleName.indexOf(59);
                if (n > 0) {
                    this.styleName = this.styleName.substring(0, n);
                }
                StylesheetDestination.this.definedStyles.put(new Integer(this.number), this);
                super.close();
            }

            public boolean handleKeyword(String string) {
                if (string.equals("additive")) {
                    this.additive = true;
                    return true;
                }
                if (string.equals("shidden")) {
                    this.hidden = true;
                    return true;
                }
                return super.handleKeyword(string);
            }

            public boolean handleKeyword(String string, int n) {
                if (string.equals("s")) {
                    this.characterStyle = false;
                    this.sectionStyle = false;
                    this.number = n;
                } else if (string.equals("cs")) {
                    this.characterStyle = true;
                    this.sectionStyle = false;
                    this.number = n;
                } else if (string.equals("ds")) {
                    this.characterStyle = false;
                    this.sectionStyle = true;
                    this.number = n;
                } else if (string.equals("sbasedon")) {
                    this.basedOn = n;
                } else if (string.equals("snext")) {
                    this.nextStyle = n;
                } else {
                    return super.handleKeyword(string, n);
                }
                return true;
            }

            public void handleText(String string) {
                this.styleName = this.styleName != null ? String.valueOf(this.styleName) + string : string;
            }

            public Style realize() {
                StyleDefiningDestination styleDefiningDestination;
                Style style = null;
                Style style2 = null;
                if (this.realizedStyle != null) {
                    return this.realizedStyle;
                }
                if (this.basedOn != 222 && (styleDefiningDestination = (StyleDefiningDestination)StylesheetDestination.this.definedStyles.get(new Integer(this.basedOn))) != null) {
                    style = styleDefiningDestination.realize();
                }
                this.realizedStyle = ((StylesheetDestination)StylesheetDestination.this).RTFReader.this.target.addStyle(this.styleName, style);
                if (this.characterStyle) {
                    this.realizedStyle.addAttributes(this.currentTextAttributes());
                    this.realizedStyle.addAttribute("style:type", "character");
                } else if (this.sectionStyle) {
                    this.realizedStyle.addAttributes(this.currentSectionAttributes());
                    this.realizedStyle.addAttribute("style:type", "section");
                } else {
                    this.realizedStyle.addAttributes(this.currentParagraphAttributes());
                    this.realizedStyle.addAttribute("style:type", "paragraph");
                }
                if (this.nextStyle != 222 && (styleDefiningDestination = (StyleDefiningDestination)StylesheetDestination.this.definedStyles.get(new Integer(this.nextStyle))) != null) {
                    style2 = styleDefiningDestination.realize();
                }
                if (style2 != null) {
                    this.realizedStyle.addAttribute("style:nextStyle", style2);
                }
                this.realizedStyle.addAttribute("style:additive", new Boolean(this.additive));
                this.realizedStyle.addAttribute("style:hidden", new Boolean(this.hidden));
                return this.realizedStyle;
            }
        }
    }

    class InfoDestination
    extends DiscardingDestination
    implements Destination {
        InfoDestination() {
        }
    }

    abstract class AttributeTrackingDestination
    implements Destination {
        MutableAttributeSet characterAttributes = this.rootCharacterAttributes();
        MutableAttributeSet paragraphAttributes;
        MutableAttributeSet sectionAttributes;

        public AttributeTrackingDestination() {
            RTFReader.this.parserState.put("chr", this.characterAttributes);
            this.paragraphAttributes = this.rootParagraphAttributes();
            RTFReader.this.parserState.put("pgf", this.paragraphAttributes);
            this.sectionAttributes = this.rootSectionAttributes();
            RTFReader.this.parserState.put("sec", this.sectionAttributes);
        }

        public void begingroup() {
            MutableAttributeSet mutableAttributeSet = this.currentTextAttributes();
            MutableAttributeSet mutableAttributeSet2 = this.currentParagraphAttributes();
            AttributeSet attributeSet = this.currentSectionAttributes();
            this.characterAttributes = new SimpleAttributeSet();
            this.characterAttributes.addAttributes(mutableAttributeSet);
            RTFReader.this.parserState.put("chr", this.characterAttributes);
            this.paragraphAttributes = new SimpleAttributeSet();
            this.paragraphAttributes.addAttributes(mutableAttributeSet2);
            RTFReader.this.parserState.put("pgf", this.paragraphAttributes);
            this.sectionAttributes = new SimpleAttributeSet();
            this.sectionAttributes.addAttributes(attributeSet);
            RTFReader.this.parserState.put("sec", this.sectionAttributes);
        }

        public void close() {
        }

        MutableAttributeSet currentParagraphAttributes() {
            Object object;
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(this.paragraphAttributes);
            TabStop[] tabStopArray = (TabStop[])RTFReader.this.parserState.get("_tabs_immutable");
            if (tabStopArray == null && (object = (Dictionary)RTFReader.this.parserState.get("_tabs")) != null) {
                int n = (Integer)((Dictionary)object).get("stop count");
                tabStopArray = new TabStop[n];
                int n2 = 1;
                while (n2 <= n) {
                    tabStopArray[n2 - 1] = (TabStop)((Dictionary)object).get(new Integer(n2));
                    ++n2;
                }
                RTFReader.this.parserState.put("_tabs_immutable", tabStopArray);
            }
            if (tabStopArray != null) {
                simpleAttributeSet.addAttribute("tabs", tabStopArray);
            }
            if ((object = (Style)RTFReader.this.parserState.get("paragraphStyle")) != null) {
                simpleAttributeSet.setResolveParent((AttributeSet)object);
            }
            return simpleAttributeSet;
        }

        public AttributeSet currentSectionAttributes() {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(this.sectionAttributes);
            Style style = (Style)RTFReader.this.parserState.get("sectionStyle");
            if (style != null) {
                simpleAttributeSet.setResolveParent(style);
            }
            return simpleAttributeSet;
        }

        MutableAttributeSet currentTextAttributes() {
            Object object;
            Integer n;
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(this.characterAttributes);
            Integer n2 = (Integer)RTFReader.this.parserState.get("f");
            String string = n2 != null ? (String)RTFReader.this.fontTable.get(n2) : null;
            if (string != null) {
                StyleConstants.setFontFamily(simpleAttributeSet, string);
            } else {
                simpleAttributeSet.removeAttribute(StyleConstants.FontFamily);
            }
            if (RTFReader.this.colorTable != null) {
                n = (Integer)RTFReader.this.parserState.get("cf");
                if (n != null) {
                    object = RTFReader.this.colorTable[n];
                    StyleConstants.setForeground(simpleAttributeSet, (Color)object);
                } else {
                    simpleAttributeSet.removeAttribute(StyleConstants.Foreground);
                }
            }
            if (RTFReader.this.colorTable != null) {
                n = (Integer)RTFReader.this.parserState.get("cb");
                if (n != null) {
                    object = RTFReader.this.colorTable[n];
                    simpleAttributeSet.addAttribute(StyleConstants.Background, object);
                } else {
                    simpleAttributeSet.removeAttribute(StyleConstants.Background);
                }
            }
            if ((object = (Style)RTFReader.this.parserState.get("characterStyle")) != null) {
                simpleAttributeSet.setResolveParent((AttributeSet)object);
            }
            return simpleAttributeSet;
        }

        public void endgroup(Dictionary dictionary) {
            this.characterAttributes = (MutableAttributeSet)RTFReader.this.parserState.get("chr");
            this.paragraphAttributes = (MutableAttributeSet)RTFReader.this.parserState.get("pgf");
            this.sectionAttributes = (MutableAttributeSet)RTFReader.this.parserState.get("sec");
        }

        public void handleBinaryBlob(byte[] byArray) {
            RTFReader.this.warnings.println("Unexpected binary data in RTF file.");
        }

        public boolean handleKeyword(String string) {
            if (string.equals("ulnone")) {
                return this.handleKeyword("ul", 0);
            }
            Object v = straightforwardAttributes.get(string);
            if (v != null) {
                boolean bl;
                RTFAttribute rTFAttribute = (RTFAttribute)v;
                switch (rTFAttribute.domain()) {
                    case 0: {
                        bl = rTFAttribute.set(this.characterAttributes);
                        break;
                    }
                    case 1: {
                        bl = rTFAttribute.set(this.paragraphAttributes);
                        break;
                    }
                    case 2: {
                        bl = rTFAttribute.set(this.sectionAttributes);
                        break;
                    }
                    case 4: {
                        ((RTFReader)RTFReader.this).mockery.backing = RTFReader.this.parserState;
                        bl = rTFAttribute.set(RTFReader.this.mockery);
                        ((RTFReader)RTFReader.this).mockery.backing = null;
                        break;
                    }
                    case 3: {
                        bl = rTFAttribute.set(RTFReader.this.documentAttributes);
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                if (bl) {
                    return true;
                }
            }
            if (string.equals("plain")) {
                this.resetCharacterAttributes();
                return true;
            }
            if (string.equals("pard")) {
                this.resetParagraphAttributes();
                return true;
            }
            if (string.equals("sectd")) {
                this.resetSectionAttributes();
                return true;
            }
            return false;
        }

        public boolean handleKeyword(String string, int n) {
            int n2;
            boolean bl;
            boolean bl2 = bl = n != 0;
            if (string.equals("fc")) {
                string = "cf";
            }
            if (string.equals("f")) {
                RTFReader.this.parserState.put(string, new Integer(n));
                return true;
            }
            if (string.equals("cf")) {
                RTFReader.this.parserState.put(string, new Integer(n));
                return true;
            }
            Object v = straightforwardAttributes.get(string);
            if (v != null) {
                RTFAttribute rTFAttribute = (RTFAttribute)v;
                switch (rTFAttribute.domain()) {
                    case 0: {
                        n2 = rTFAttribute.set(this.characterAttributes, n);
                        break;
                    }
                    case 1: {
                        n2 = rTFAttribute.set(this.paragraphAttributes, n);
                        break;
                    }
                    case 2: {
                        n2 = rTFAttribute.set(this.sectionAttributes, n);
                        break;
                    }
                    case 4: {
                        ((RTFReader)RTFReader.this).mockery.backing = RTFReader.this.parserState;
                        n2 = rTFAttribute.set(RTFReader.this.mockery, n);
                        ((RTFReader)RTFReader.this).mockery.backing = null;
                        break;
                    }
                    case 3: {
                        n2 = rTFAttribute.set(RTFReader.this.documentAttributes, n);
                        break;
                    }
                    default: {
                        n2 = 0;
                    }
                }
                if (n2 != 0) {
                    return true;
                }
            }
            if (string.equals("fs")) {
                StyleConstants.setFontSize(this.characterAttributes, n / 2);
                return true;
            }
            if (string.equals("sl")) {
                if (n == 1000) {
                    this.characterAttributes.removeAttribute(StyleConstants.LineSpacing);
                } else {
                    StyleConstants.setLineSpacing(this.characterAttributes, (float)n / 20.0f);
                }
                return true;
            }
            if (string.equals("tx") || string.equals("tb")) {
                Integer n3;
                float f = (float)n / 20.0f;
                n2 = 0;
                Number number = (Number)RTFReader.this.parserState.get(RTFReader.TabAlignmentKey);
                if (number != null) {
                    n2 = number.intValue();
                }
                int n4 = 0;
                number = (Number)RTFReader.this.parserState.get(RTFReader.TabLeaderKey);
                if (number != null) {
                    n4 = number.intValue();
                }
                if (string.equals("tb")) {
                    n2 = 5;
                }
                RTFReader.this.parserState.remove(RTFReader.TabAlignmentKey);
                RTFReader.this.parserState.remove(RTFReader.TabLeaderKey);
                TabStop tabStop = new TabStop(f, n2, n4);
                Hashtable<Object, Serializable> hashtable = (Hashtable<Object, Serializable>)RTFReader.this.parserState.get("_tabs");
                if (hashtable == null) {
                    hashtable = new Hashtable<Object, Serializable>();
                    RTFReader.this.parserState.put("_tabs", hashtable);
                    n3 = new Integer(1);
                } else {
                    n3 = (Integer)((Dictionary)hashtable).get("stop count");
                    n3 = new Integer(1 + n3);
                }
                ((Dictionary)hashtable).put(n3, tabStop);
                ((Dictionary)hashtable).put("stop count", n3);
                RTFReader.this.parserState.remove("_tabs_immutable");
                return true;
            }
            if (string.equals("s") && RTFReader.this.paragraphStyles != null) {
                RTFReader.this.parserState.put("paragraphStyle", RTFReader.this.paragraphStyles[n]);
                return true;
            }
            if (string.equals("cs") && RTFReader.this.characterStyles != null) {
                RTFReader.this.parserState.put("characterStyle", RTFReader.this.characterStyles[n]);
                return true;
            }
            if (string.equals("ds") && RTFReader.this.sectionStyles != null) {
                RTFReader.this.parserState.put("sectionStyle", RTFReader.this.sectionStyles[n]);
                return true;
            }
            return false;
        }

        public abstract void handleText(String var1);

        protected void resetCharacterAttributes() {
            this.handleKeyword("f", 0);
            this.handleKeyword("cf", 0);
            this.handleKeyword("fs", 24);
            Enumeration enumeration = straightforwardAttributes.elements();
            while (enumeration.hasMoreElements()) {
                RTFAttribute rTFAttribute = (RTFAttribute)enumeration.nextElement();
                if (rTFAttribute.domain() != 0) continue;
                rTFAttribute.setDefault(this.characterAttributes);
            }
            this.handleKeyword("sl", 1000);
            RTFReader.this.parserState.remove("characterStyle");
        }

        protected void resetParagraphAttributes() {
            RTFReader.this.parserState.remove("_tabs");
            RTFReader.this.parserState.remove("_tabs_immutable");
            RTFReader.this.parserState.remove("paragraphStyle");
            StyleConstants.setAlignment(this.paragraphAttributes, 0);
            Enumeration enumeration = straightforwardAttributes.elements();
            while (enumeration.hasMoreElements()) {
                RTFAttribute rTFAttribute = (RTFAttribute)enumeration.nextElement();
                if (rTFAttribute.domain() != 1) continue;
                rTFAttribute.setDefault(this.characterAttributes);
            }
        }

        protected void resetSectionAttributes() {
            Enumeration enumeration = straightforwardAttributes.elements();
            while (enumeration.hasMoreElements()) {
                RTFAttribute rTFAttribute = (RTFAttribute)enumeration.nextElement();
                if (rTFAttribute.domain() != 2) continue;
                rTFAttribute.setDefault(this.characterAttributes);
            }
            RTFReader.this.parserState.remove("sectionStyle");
        }

        protected MutableAttributeSet rootCharacterAttributes() {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setItalic(simpleAttributeSet, false);
            StyleConstants.setBold(simpleAttributeSet, false);
            StyleConstants.setUnderline(simpleAttributeSet, false);
            StyleConstants.setForeground(simpleAttributeSet, RTFReader.this.defaultColor());
            return simpleAttributeSet;
        }

        protected MutableAttributeSet rootParagraphAttributes() {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setLeftIndent(simpleAttributeSet, 0.0f);
            StyleConstants.setRightIndent(simpleAttributeSet, 0.0f);
            StyleConstants.setFirstLineIndent(simpleAttributeSet, 0.0f);
            simpleAttributeSet.setResolveParent(RTFReader.this.target.getStyle("default"));
            return simpleAttributeSet;
        }

        protected MutableAttributeSet rootSectionAttributes() {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            return simpleAttributeSet;
        }
    }

    abstract class TextHandlingDestination
    extends AttributeTrackingDestination
    implements Destination {
        boolean inParagraph = false;

        protected void beginParagraph() {
            this.inParagraph = true;
        }

        public void close() {
            if (this.inParagraph) {
                this.endParagraph();
            }
            super.close();
        }

        abstract void deliverText(String var1, AttributeSet var2);

        protected void endParagraph() {
            MutableAttributeSet mutableAttributeSet = this.currentParagraphAttributes();
            MutableAttributeSet mutableAttributeSet2 = this.currentTextAttributes();
            this.finishParagraph(mutableAttributeSet, mutableAttributeSet2);
            this.inParagraph = false;
        }

        abstract void endSection();

        abstract void finishParagraph(AttributeSet var1, AttributeSet var2);

        public boolean handleKeyword(String string) {
            if (string.equals("\r") || string.equals("\n")) {
                string = "par";
            }
            if (string.equals("par")) {
                this.endParagraph();
                return true;
            }
            if (string.equals("sect")) {
                this.endSection();
                return true;
            }
            return super.handleKeyword(string);
        }

        public void handleText(String string) {
            if (!this.inParagraph) {
                this.beginParagraph();
            }
            this.deliverText(string, this.currentTextAttributes());
        }
    }

    class DocumentDestination
    extends TextHandlingDestination
    implements Destination {
        DocumentDestination() {
        }

        public void deliverText(String string, AttributeSet attributeSet) {
            try {
                RTFReader.this.target.insertString(RTFReader.this.target.getLength(), string, this.currentTextAttributes());
            }
            catch (BadLocationException badLocationException) {
                throw new InternalError(badLocationException.getMessage());
            }
        }

        public void endSection() {
        }

        public void finishParagraph(AttributeSet attributeSet, AttributeSet attributeSet2) {
            int n = RTFReader.this.target.getLength();
            try {
                RTFReader.this.target.insertString(n, "\n", attributeSet2);
                RTFReader.this.target.setParagraphAttributes(n, 1, attributeSet, true);
            }
            catch (BadLocationException badLocationException) {
                throw new InternalError(badLocationException.getMessage());
            }
        }
    }
}

