/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifBorders;
import com.sun.java.swing.plaf.motif.MotifDesktopIconUI;
import com.sun.java.swing.plaf.motif.MotifInternalFrameTitlePane;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class MotifInternalFrameUI
extends BasicInternalFrameUI {
    Color color;
    Color highlight;
    Color shadow;
    MotifInternalFrameTitlePane titlePane;
    protected KeyStroke closeMenuKey;

    public MotifInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected void activateFrame(JInternalFrame jInternalFrame) {
        super.activateFrame(jInternalFrame);
        this.setColors(jInternalFrame);
    }

    public JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new MotifInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifInternalFrameUI((JInternalFrame)jComponent);
    }

    protected void deactivateFrame(JInternalFrame jInternalFrame) {
        this.setColors(jInternalFrame);
        super.deactivateFrame(jInternalFrame);
    }

    private JInternalFrame getFrame() {
        return this.frame;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    protected void installDefaults() {
        Border border = this.frame.getBorder();
        if (border == null || border instanceof UIResource) {
            this.frame.setBorder(new MotifBorders.InternalFrameBorder(this.frame));
        }
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.closeMenuKey = KeyStroke.getKeyStroke(27, 0);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.setColors((JInternalFrame)jComponent);
    }

    void setColors(JInternalFrame jInternalFrame) {
        this.color = jInternalFrame.isSelected() ? UIManager.getColor("activeCaptionBorder") : UIManager.getColor("inactiveCaptionBorder");
        this.highlight = this.color.brighter();
        this.shadow = this.color.darker().darker();
        this.titlePane.setColors(this.color, this.highlight, this.shadow);
    }

    protected void setupMenuCloseKey() {
        this.frame.registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MotifInternalFrameUI.this.titlePane.hideSystemMenu();
            }

            public boolean isEnabled() {
                return MotifInternalFrameUI.this.isKeyBindingActive();
            }
        }, this.closeMenuKey, 2);
        this.frame.getDesktopIcon().registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JInternalFrame.JDesktopIcon jDesktopIcon = MotifInternalFrameUI.this.getFrame().getDesktopIcon();
                MotifDesktopIconUI motifDesktopIconUI = (MotifDesktopIconUI)jDesktopIcon.getUI();
                motifDesktopIconUI.hideSystemMenu();
            }

            public boolean isEnabled() {
                return MotifInternalFrameUI.this.isKeyBindingActive();
            }
        }, this.closeMenuKey, 2);
    }

    protected void setupMenuOpenKey() {
        this.frame.registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MotifInternalFrameUI.this.titlePane.showSystemMenu();
            }

            public boolean isEnabled() {
                return MotifInternalFrameUI.this.isKeyBindingActive();
            }
        }, this.openMenuKey, 2);
        this.frame.getDesktopIcon().registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JInternalFrame.JDesktopIcon jDesktopIcon = MotifInternalFrameUI.this.getFrame().getDesktopIcon();
                MotifDesktopIconUI motifDesktopIconUI = (MotifDesktopIconUI)jDesktopIcon.getUI();
                motifDesktopIconUI.showSystemMenu();
            }

            public boolean isEnabled() {
                return MotifInternalFrameUI.this.isKeyBindingActive();
            }
        }, this.openMenuKey, 2);
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.frame);
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
        if (this.isKeyBindingRegistered()) {
            this.frame.unregisterKeyboardAction(this.closeMenuKey);
            this.frame.getDesktopIcon().unregisterKeyboardAction(this.closeMenuKey);
        }
    }
}

