/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.cosnaming;

import com.sun.jndi.cosnaming.CNCtx;
import com.sun.jndi.cosnaming.CNNameParser;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.CompositeName;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;

class CNBindingEnumeration
implements NamingEnumeration {
    private BindingListHolder _bindingList;
    private int _numOfBindings;
    private BindingIteratorHolder _bindingIterH;
    private BindingIterator _bindingIter;
    private int counter;
    private CNCtx _ctx;
    private Hashtable _env;

    CNBindingEnumeration(CNCtx cNCtx, Hashtable hashtable) {
        this._ctx = cNCtx;
        this._env = hashtable;
        this._bindingList = new BindingListHolder();
        this._bindingIterH = new BindingIteratorHolder();
        this._ctx._nc.list(Integer.MAX_VALUE, this._bindingList, this._bindingIterH);
        this._numOfBindings = this._bindingList.value.length;
        this.counter = 0;
        this._bindingIter = this._bindingIterH.value;
    }

    public boolean hasMore() throws NamingException {
        return this.hasMoreElements();
    }

    public boolean hasMoreElements() {
        return this.counter < this._numOfBindings;
    }

    private javax.naming.Binding mapBinding(Binding binding) throws NamingException {
        Object object = this._ctx.callResolve(binding.binding_name);
        String string = CNNameParser.cosNameToString(binding.binding_name);
        CompositeName compositeName = new CompositeName();
        compositeName.add(string);
        try {
            object = NamingManager.getObjectInstance(object, compositeName, this._ctx, this._env);
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException("problem generating object using object factory");
            namingException.setRootCause(exception);
            throw namingException;
        }
        javax.naming.Binding binding2 = new javax.naming.Binding(compositeName.toString(), object);
        return binding2;
    }

    public Object next() throws NamingException {
        if (this.counter == this._numOfBindings) {
            throw new NoSuchElementException();
        }
        Binding binding = this._bindingList.value[this.counter];
        ++this.counter;
        return this.mapBinding(binding);
    }

    public Object nextElement() throws NoSuchElementException {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException();
        }
    }
}

