/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.cosnaming;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.omg.CosNaming.NameComponent;

public class CNNameParser
implements NameParser {
    private static Properties mySyntax = new Properties();
    private static final char kindSeparator = '.';
    private static final char compSeparator = '/';

    static {
        ((Hashtable)mySyntax).put("jndi.syntax.direction", "left_to_right");
        ((Hashtable)mySyntax).put("jndi.syntax.separator", "/");
        ((Hashtable)mySyntax).put("jndi.syntax.ignorecase", "false");
        ((Hashtable)mySyntax).put("jndi.syntax.escape", "\\");
        ((Hashtable)mySyntax).put("jndi.syntax.beginquote", "\"");
        ((Hashtable)mySyntax).put("jndi.syntax.beginquote2", "'");
    }

    CNNameParser() {
    }

    static Name cosNameToName(NameComponent[] nameComponentArray) {
        CompositeName compositeName = new CompositeName();
        int n = 0;
        while (nameComponentArray != null && n < nameComponentArray.length) {
            StringBuffer stringBuffer = new StringBuffer(nameComponentArray[n].id);
            if (nameComponentArray[n].kind != null && !nameComponentArray[n].kind.equals("")) {
                stringBuffer.append(String.valueOf('.') + nameComponentArray[n].kind);
            }
            try {
                compositeName.add(stringBuffer.toString());
            }
            catch (InvalidNameException invalidNameException) {}
            ++n;
        }
        return compositeName;
    }

    static String cosNameToString(NameComponent[] nameComponentArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nameComponentArray.length) {
            if (n > 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(nameComponentArray[n].id);
            if (nameComponentArray[n].kind != null && !nameComponentArray[n].kind.equals("")) {
                stringBuffer.append(String.valueOf('.') + nameComponentArray[n].kind);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static NameComponent[] nameToCosName(Name name) throws InvalidNameException {
        int n = name.size();
        if (n == 0) {
            return new NameComponent[0];
        }
        NameComponent[] nameComponentArray = new NameComponent[n];
        int n2 = 0;
        while (n2 < n) {
            nameComponentArray[n2] = CNNameParser.parseComponent(name.get(n2));
            ++n2;
        }
        return nameComponentArray;
    }

    public Name parse(String string) throws NamingException {
        return new CompoundName(string, mySyntax);
    }

    private static NameComponent parseComponent(String string) {
        NameComponent nameComponent = new NameComponent();
        if (string.equals(".:") || string.equals("...")) {
            nameComponent.id = string;
            nameComponent.kind = "";
        } else {
            int n = string.indexOf(46);
            if (n < 0) {
                nameComponent.id = string;
                nameComponent.kind = "";
            } else {
                nameComponent.id = string.substring(0, n);
                nameComponent.kind = string.substring(n + 1);
            }
        }
        return nameComponent;
    }

    static NameComponent[] stringToCosName(String string) throws InvalidNameException {
        return CNNameParser.nameToCosName(new CompoundName(string, mySyntax));
    }
}

