/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rmi.corba;

import com.sun.rmi.corba.AnyImpl;
import com.sun.rmi.corba.TypeCodeFactory;
import com.sun.rmi.corba.TypeCodeOutputStream;
import com.sun.rmi.corba.TypeCodeReader;
import com.sun.rmi.corba.WrapperInputStream;
import com.sun.rmi.iiop.CDRInputStream;
import com.sun.rmi.iiop.CDROutputStream;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public final class TypeCodeImpl
extends TypeCode {
    private static final TypeCodeImpl[] primitiveConstants = new TypeCodeImpl[]{new TypeCodeImpl(0), new TypeCodeImpl(1), new TypeCodeImpl(2), new TypeCodeImpl(3), new TypeCodeImpl(4), new TypeCodeImpl(5), new TypeCodeImpl(6), new TypeCodeImpl(7), new TypeCodeImpl(8), new TypeCodeImpl(9), new TypeCodeImpl(10), new TypeCodeImpl(11), new TypeCodeImpl(12), new TypeCodeImpl(13), new TypeCodeImpl(14), null, null, null, new TypeCodeImpl(18), null, null, null, null, new TypeCodeImpl(23), new TypeCodeImpl(24), new TypeCodeImpl(25), new TypeCodeImpl(26), new TypeCodeImpl(27), new TypeCodeImpl(28), new TypeCodeImpl(29), new TypeCodeImpl(30), new TypeCodeImpl(31), new TypeCodeImpl(32)};
    protected static final int tk_indirect = -1;
    private static final int EMPTY = 0;
    private static final int SIMPLE = 1;
    private static final int COMPLEX = 2;
    private static final int[] typeTable;
    private int _kind;
    private String _id = "";
    private String _name = "";
    private int _memberCount;
    private String[] _memberNames;
    private TypeCodeImpl[] _memberTypes;
    private AnyImpl[] _unionLabels;
    private TypeCodeImpl _discriminator;
    private int _defaultIndex = -1;
    private int _length;
    private TypeCodeImpl _contentType;
    private short _digits;
    private short _scale;
    private short _type_modifier = (short)-1;
    private TypeCodeImpl _concrete_base;
    private short[] _memberAccess;
    private TypeCodeImpl _parent;
    private int _parentOffset;
    private TypeCodeImpl _indirectType;
    private TypeCodeOutputStream _lastOutStream;
    private int _outStreamPosition;
    private TypeCodeReader _lastInStream;
    private int _inStreamPosition;
    private ORB _orb;

    public TypeCodeImpl(ORB oRB) {
        this._orb = oRB;
    }

    public TypeCodeImpl(ORB oRB, TypeCode typeCode) {
        this._orb = oRB;
        if (typeCode instanceof TypeCodeImpl) {
            TypeCodeImpl typeCodeImpl = (TypeCodeImpl)typeCode;
            if (typeCodeImpl._kind == -1) {
                throw new BAD_TYPECODE();
            }
            if (typeCodeImpl._kind == 19 && typeCodeImpl._contentType == null) {
                throw new BAD_TYPECODE();
            }
        }
        this._kind = typeCode.kind().value();
        try {
            switch (this._kind) {
                case 29: {
                    this._type_modifier = typeCode.type_modifier();
                    this._concrete_base = TypeCodeImpl.convertToNative(this._orb, typeCode.concrete_base_type());
                    this._memberAccess = new short[typeCode.member_count()];
                    int n = 0;
                    while (n < typeCode.member_count()) {
                        this._memberAccess[n] = typeCode.member_visibility(n);
                        ++n;
                    }
                }
                case 15: 
                case 16: 
                case 22: {
                    this._memberTypes = new TypeCodeImpl[typeCode.member_count()];
                    int n = 0;
                    while (n < typeCode.member_count()) {
                        this._memberTypes[n] = TypeCodeImpl.convertToNative(this._orb, typeCode.member_type(n));
                        this._memberTypes[n].setParent(this);
                        ++n;
                    }
                }
                case 17: {
                    this._memberNames = new String[typeCode.member_count()];
                    int n = 0;
                    while (n < typeCode.member_count()) {
                        this._memberNames[n] = typeCode.member_name(n);
                        ++n;
                    }
                    this._memberCount = typeCode.member_count();
                }
                case 14: 
                case 21: 
                case 30: 
                case 31: 
                case 32: {
                    this.setId(typeCode.id());
                    this._name = typeCode.name();
                    break;
                }
            }
            switch (this._kind) {
                case 16: {
                    this._discriminator = TypeCodeImpl.convertToNative(this._orb, typeCode.discriminator_type());
                    this._defaultIndex = typeCode.default_index();
                    this._unionLabels = new AnyImpl[this._memberCount];
                    int n = 0;
                    while (n < this._memberCount) {
                        this._unionLabels[n] = new AnyImpl(this._orb, typeCode.member_label(n));
                        ++n;
                    }
                    break;
                }
            }
            switch (this._kind) {
                case 18: 
                case 19: 
                case 20: 
                case 27: {
                    this._length = typeCode.length();
                }
            }
            switch (this._kind) {
                case 19: 
                case 20: 
                case 21: 
                case 30: {
                    this._contentType = TypeCodeImpl.convertToNative(this._orb, typeCode.content_type());
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Bounds bounds) {
            return;
        }
        catch (BadKind badKind) {
            return;
        }
        catch (org.omg.CORBA.Bounds bounds) {
            return;
        }
    }

    public TypeCodeImpl(int n) {
        this._orb = null;
        this._kind = n;
        switch (this._kind) {
            case 14: {
                this.setId("IDL:omg.org/CORBA/Object:1.0");
                this._name = "Object";
                return;
            }
            case 18: 
            case 27: {
                this._length = 0;
                return;
            }
            case 29: {
                this._concrete_base = new TypeCodeImpl(0);
                return;
            }
        }
    }

    public TypeCodeImpl(ORB oRB, int n, String string, String string2, StructMember[] structMemberArray) {
        this._orb = oRB;
        if (n == 15 || n == 22) {
            this._kind = n;
            this.setId(string);
            this._name = string2;
            this._memberCount = structMemberArray.length;
            this._memberNames = new String[this._memberCount];
            this._memberTypes = new TypeCodeImpl[this._memberCount];
            int n2 = 0;
            while (n2 < this._memberCount) {
                this._memberNames[n2] = structMemberArray[n2].name;
                this._memberTypes[n2] = TypeCodeImpl.convertToNative(this._orb, structMemberArray[n2].type);
                this._memberTypes[n2].setParent(this);
                ++n2;
            }
        }
    }

    public TypeCodeImpl(ORB oRB, int n, String string, String string2, TypeCode typeCode, UnionMember[] unionMemberArray) {
        this._orb = oRB;
        if (n == 16) {
            this._kind = n;
            this.setId(string);
            this._name = string2;
            this._memberCount = unionMemberArray.length;
            this._discriminator = TypeCodeImpl.convertToNative(this._orb, typeCode);
            this._memberNames = new String[this._memberCount];
            this._memberTypes = new TypeCodeImpl[this._memberCount];
            this._unionLabels = new AnyImpl[this._memberCount];
            int n2 = 0;
            while (n2 < this._memberCount) {
                this._memberNames[n2] = unionMemberArray[n2].name;
                this._memberTypes[n2] = TypeCodeImpl.convertToNative(this._orb, unionMemberArray[n2].type);
                this._memberTypes[n2].setParent(this);
                this._unionLabels[n2] = new AnyImpl(this._orb, unionMemberArray[n2].label);
                if (this._unionLabels[n2].type().kind() == TCKind.tk_octet) {
                    this._defaultIndex = n2;
                }
                ++n2;
            }
        }
    }

    public TypeCodeImpl(ORB oRB, int n, String string, String string2, short s, TypeCode typeCode, ValueMember[] valueMemberArray) {
        this._orb = oRB;
        if (n == 29) {
            this._kind = n;
            this.setId(string);
            this._name = string2;
            this._type_modifier = s;
            this._concrete_base = TypeCodeImpl.convertToNative(this._orb, typeCode);
            this._memberCount = valueMemberArray.length;
            this._memberNames = new String[this._memberCount];
            this._memberTypes = new TypeCodeImpl[this._memberCount];
            this._memberAccess = new short[this._memberCount];
            int n2 = 0;
            while (n2 < this._memberCount) {
                this._memberNames[n2] = valueMemberArray[n2].name;
                this._memberTypes[n2] = TypeCodeImpl.convertToNative(this._orb, valueMemberArray[n2].type);
                this._memberTypes[n2].setParent(this);
                this._memberAccess[n2] = valueMemberArray[n2].access;
                ++n2;
            }
        }
    }

    public TypeCodeImpl(ORB oRB, int n, String string, String string2, String[] stringArray) {
        this._orb = oRB;
        if (n == 17) {
            this._kind = n;
            this.setId(string);
            this._name = string2;
            this._memberCount = stringArray.length;
            this._memberNames = new String[this._memberCount];
            int n2 = 0;
            while (n2 < this._memberCount) {
                this._memberNames[n2] = stringArray[n2];
                ++n2;
            }
        }
    }

    public TypeCodeImpl(ORB oRB, int n, String string, String string2, TypeCode typeCode) {
        this._orb = oRB;
        if (n == 21 || n == 30) {
            this._kind = n;
            this.setId(string);
            this._name = string2;
            this._contentType = TypeCodeImpl.convertToNative(this._orb, typeCode);
        }
    }

    public TypeCodeImpl(ORB oRB, int n, String string, String string2) {
        this._orb = oRB;
        if (n == 14 || n == 31 || n == 32) {
            this._kind = n;
            this.setId(string);
            this._name = string2;
        }
    }

    public TypeCodeImpl(ORB oRB, int n, int n2) {
        this._orb = oRB;
        if (n == 18 || n == 27) {
            this._kind = n;
            this._length = n2;
        }
    }

    public TypeCodeImpl(ORB oRB, int n, int n2, TypeCode typeCode) {
        this._orb = oRB;
        if (n == 19 || n == 20) {
            this._kind = n;
            this._length = n2;
            this._contentType = TypeCodeImpl.convertToNative(this._orb, typeCode);
        }
    }

    public TypeCodeImpl(ORB oRB, int n, int n2, int n3) {
        this._orb = oRB;
        if (n == 19) {
            this._kind = n;
            this._length = n2;
            this._parentOffset = n3;
        }
    }

    public TypeCodeImpl(ORB oRB, String string) {
        this._orb = oRB;
        this._kind = -1;
        this._id = string;
        this.tryIndirectType();
    }

    public TypeCodeImpl(ORB oRB, int n, short s, short s2) {
        this._orb = oRB;
        if (n == 28) {
            this._kind = n;
            this._digits = s;
            this._scale = s2;
        }
    }

    public static TypeCodeImpl get_primitive_tc(TCKind tCKind) {
        try {
            return primitiveConstants[tCKind.value()];
        }
        catch (Throwable throwable) {
            throw new BAD_OPERATION("Invalid or unavailable typecode for kind = " + tCKind.value());
        }
    }

    public static TypeCodeImpl get_primitive_tc(int n) {
        try {
            return primitiveConstants[n];
        }
        catch (Throwable throwable) {
            throw new BAD_OPERATION("Invalid or unavailable typecode for kind = " + n);
        }
    }

    protected static TypeCodeImpl convertToNative(ORB oRB, TypeCode typeCode) {
        if (typeCode instanceof TypeCodeImpl) {
            return (TypeCodeImpl)typeCode;
        }
        return new TypeCodeImpl(oRB, typeCode);
    }

    public static CDROutputStream newOutputStream(ORB oRB) {
        return new TypeCodeOutputStream(oRB);
    }

    private TypeCodeImpl indirectType() {
        this._indirectType = this.tryIndirectType();
        if (this._indirectType == null) {
            throw new BAD_TYPECODE("Invoked operation on unresolved recursive type code!");
        }
        return this._indirectType;
    }

    private TypeCodeImpl tryIndirectType() {
        if (this._indirectType != null) {
            return this._indirectType;
        }
        if (!(this._orb instanceof TypeCodeFactory)) {
            throw new BAD_TYPECODE("ORB not supporting recursive type codes!");
        }
        this.setIndirectType(((TypeCodeFactory)((Object)this._orb)).getTypeCode(this._id));
        return this._indirectType;
    }

    private void setIndirectType(TypeCodeImpl typeCodeImpl) {
        this._indirectType = typeCodeImpl;
        if (this._indirectType != null) {
            try {
                this._id = this._indirectType.id();
                return;
            }
            catch (BadKind badKind) {
                return;
            }
        }
    }

    private void setId(String string) {
        this._id = string;
        if (this._orb instanceof TypeCodeFactory) {
            ((TypeCodeFactory)((Object)this._orb)).setTypeCode(this._id, this);
        }
    }

    private void setParent(TypeCodeImpl typeCodeImpl) {
        this._parent = typeCodeImpl;
    }

    private TypeCodeImpl getParentAtLevel(int n) {
        if (n == 0) {
            return this;
        }
        if (this._parent == null) {
            throw new BAD_TYPECODE("Invoked operation on unresolved recursive type code!");
        }
        return this._parent.getParentAtLevel(n - 1);
    }

    private TypeCodeImpl lazy_content_type() {
        TypeCodeImpl typeCodeImpl;
        if (this._contentType == null && this._kind == 19 && this._parentOffset > 0 && this._parent != null && (typeCodeImpl = this.getParentAtLevel(this._parentOffset)) != null && typeCodeImpl._id != null) {
            this._contentType = new TypeCodeImpl(this._orb, typeCodeImpl._id);
        }
        return this._contentType;
    }

    public final boolean equal(TypeCode typeCode) {
        if (typeCode == this) {
            return true;
        }
        try {
            if (this._kind == -1) {
                if (this._id != null && typeCode.id() != null) {
                    return this._id.equals(typeCode.id());
                }
                return this._id == null && typeCode.id() == null;
            }
            if (this._kind != typeCode.kind().value()) {
                return false;
            }
            switch (typeTable[this._kind]) {
                case 0: {
                    return true;
                }
                case 1: {
                    switch (this._kind) {
                        case 18: 
                        case 27: {
                            return this._length == typeCode.length();
                        }
                        case 28: {
                            return this._digits == typeCode.fixed_digits() && this._scale == typeCode.fixed_scale();
                        }
                    }
                    return false;
                }
                case 2: {
                    switch (this._kind) {
                        case 14: {
                            if (this._id.compareTo(typeCode.id()) == 0) {
                                return true;
                            }
                            if (this._id.compareTo(TypeCodeImpl.get_primitive_tc(this._kind).id()) == 0) {
                                return true;
                            }
                            return typeCode.id().compareTo(TypeCodeImpl.get_primitive_tc(this._kind).id()) == 0;
                        }
                        case 31: 
                        case 32: {
                            return this._id.compareTo(typeCode.id()) == 0;
                        }
                        case 15: 
                        case 22: {
                            if (this._memberCount != typeCode.member_count()) {
                                return false;
                            }
                            if (this._id.compareTo(typeCode.id()) != 0) {
                                return false;
                            }
                            int n = 0;
                            while (n < this._memberCount) {
                                if (!this._memberTypes[n].equal(typeCode.member_type(n))) {
                                    return false;
                                }
                                ++n;
                            }
                            return true;
                        }
                        case 16: {
                            if (this._memberCount != typeCode.member_count()) {
                                return false;
                            }
                            if (this._id.compareTo(typeCode.id()) != 0) {
                                return false;
                            }
                            if (this._defaultIndex != typeCode.default_index()) {
                                return false;
                            }
                            if (!this._discriminator.equal(typeCode.discriminator_type())) {
                                return false;
                            }
                            int n = 0;
                            while (n < this._memberCount) {
                                if (!this._unionLabels[n].equal(typeCode.member_label(n))) {
                                    return false;
                                }
                                ++n;
                            }
                            int n2 = 0;
                            while (n2 < this._memberCount) {
                                if (!this._memberTypes[n2].equal(typeCode.member_type(n2))) {
                                    return false;
                                }
                                ++n2;
                            }
                            return true;
                        }
                        case 17: {
                            if (this._id.compareTo(typeCode.id()) != 0) {
                                return false;
                            }
                            return this._memberCount == typeCode.member_count();
                        }
                        case 19: 
                        case 20: {
                            if (this._length != typeCode.length()) {
                                return false;
                            }
                            return this.lazy_content_type().equal(typeCode.content_type());
                        }
                        case 29: {
                            if (this._memberCount != typeCode.member_count()) {
                                return false;
                            }
                            if (this._id.compareTo(typeCode.id()) != 0) {
                                return false;
                            }
                            int n = 0;
                            while (n < this._memberCount) {
                                if (this._memberAccess[n] != typeCode.member_visibility(n) || !this._memberTypes[n].equal(typeCode.member_type(n))) {
                                    return false;
                                }
                                ++n;
                            }
                            if (this._type_modifier == typeCode.type_modifier()) {
                                return false;
                            }
                            return this._concrete_base.equal(typeCode.concrete_base_type());
                        }
                        case 21: 
                        case 30: {
                            if (this._id.compareTo(typeCode.id()) != 0) {
                                return false;
                            }
                            return this._contentType.equal(typeCode.content_type());
                        }
                        default: {
                            return false;
                        }
                    }
                }
                default: {
                    return false;
                }
            }
        }
        catch (Bounds bounds) {
        }
        catch (BadKind badKind) {
        }
        catch (org.omg.CORBA.Bounds bounds) {}
        return false;
    }

    public TCKind kind() {
        if (this._kind == -1) {
            return this.indirectType().kind();
        }
        return TCKind.from_int(this._kind);
    }

    public String id() throws BadKind {
        switch (this._kind) {
            case -1: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return this._id;
            }
        }
        throw new BadKind();
    }

    public String name() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().name();
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return this._name;
            }
        }
        throw new BadKind();
    }

    public int member_count() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().member_count();
            }
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 29: {
                return this._memberCount;
            }
        }
        throw new BadKind();
    }

    public String member_name(int n) throws BadKind, Bounds {
        switch (this._kind) {
            case -1: {
                return this.indirectType().member_name(n);
            }
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 29: {
                try {
                    return this._memberNames[n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new Bounds();
                }
            }
        }
        throw new BadKind();
    }

    public TypeCode member_type(int n) throws BadKind, Bounds {
        switch (this._kind) {
            case -1: {
                return this.indirectType().member_type(n);
            }
            case 15: 
            case 16: 
            case 22: 
            case 29: {
                try {
                    return this._memberTypes[n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new Bounds();
                }
            }
        }
        throw new BadKind();
    }

    public Any member_label(int n) throws BadKind, Bounds {
        switch (this._kind) {
            case -1: {
                return this.indirectType().member_label(n);
            }
            case 16: {
                try {
                    return new AnyImpl(this._orb, this._unionLabels[n]);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new Bounds();
                }
            }
        }
        throw new BadKind();
    }

    public TypeCode discriminator_type() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().discriminator_type();
            }
            case 16: {
                return this._discriminator;
            }
        }
        throw new BadKind();
    }

    public int default_index() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().default_index();
            }
            case 16: {
                return this._defaultIndex;
            }
        }
        throw new BadKind();
    }

    public int length() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().length();
            }
            case 18: 
            case 19: 
            case 20: 
            case 27: {
                return this._length;
            }
        }
        throw new BadKind();
    }

    public TypeCode content_type() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().content_type();
            }
            case 19: {
                return this.lazy_content_type();
            }
            case 20: 
            case 21: 
            case 30: {
                return this._contentType;
            }
        }
        throw new BadKind();
    }

    public short fixed_digits() throws BadKind {
        switch (this._kind) {
            case 28: {
                return this._digits;
            }
        }
        throw new BadKind();
    }

    public short fixed_scale() throws BadKind {
        switch (this._kind) {
            case 28: {
                return this._scale;
            }
        }
        throw new BadKind();
    }

    public short member_visibility(int n) throws BadKind, org.omg.CORBA.Bounds {
        switch (this._kind) {
            case -1: {
                return this.indirectType().member_visibility(n);
            }
            case 29: {
                try {
                    return this._memberAccess[n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new org.omg.CORBA.Bounds();
                }
            }
        }
        throw new BadKind();
    }

    public short type_modifier() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().type_modifier();
            }
            case 29: {
                return this._type_modifier;
            }
        }
        throw new BadKind();
    }

    public TypeCode concrete_base_type() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().concrete_base_type();
            }
            case 29: {
                return this._concrete_base;
            }
        }
        throw new BadKind();
    }

    public void read_value(InputStream inputStream) {
        if (inputStream instanceof TypeCodeReader) {
            if (this.read_value_kind((TypeCodeReader)((Object)inputStream))) {
                this.read_value_body(inputStream);
                return;
            }
        } else if (inputStream instanceof CDRInputStream) {
            WrapperInputStream wrapperInputStream = new WrapperInputStream((CDRInputStream)inputStream);
            if (this.read_value_kind(wrapperInputStream)) {
                this.read_value_body(wrapperInputStream);
                return;
            }
        } else {
            this.read_value_kind(inputStream);
            this.read_value_body(inputStream);
        }
    }

    void read_value_recursive(InputStream inputStream) {
        if (inputStream instanceof TypeCodeReader) {
            if (this.read_value_kind((TypeCodeReader)((Object)inputStream))) {
                this.read_value_body(inputStream);
                return;
            }
        } else {
            this.read_value_kind(inputStream);
            this.read_value_body(inputStream);
        }
    }

    boolean read_value_kind(TypeCodeReader typeCodeReader) {
        int n = typeCodeReader.mark();
        this._kind = typeCodeReader.read_long();
        int n2 = typeCodeReader.mark() - n;
        if ((this._kind < 0 || this._kind > typeTable.length) && this._kind != -1) {
            throw new MARSHAL();
        }
        if (this._kind == 31) {
            throw new MARSHAL();
        }
        this._lastInStream = typeCodeReader.getTopLevelStream();
        this._inStreamPosition = typeCodeReader.getTopLevelPosition() - n2;
        this._lastInStream.addTypeAtPosition(this, this._inStreamPosition);
        if (this._kind == -1) {
            int n3 = typeCodeReader.read_long();
            if (n3 > -4) {
                throw new MARSHAL();
            }
            int n4 = this._inStreamPosition + 4 + n3;
            this.setIndirectType(this._lastInStream.getTypeAtPosition(n4));
            return false;
        }
        return true;
    }

    void read_value_kind(InputStream inputStream) {
        this._kind = inputStream.read_long();
        if ((this._kind < 0 || this._kind > typeTable.length) && this._kind != -1) {
            throw new MARSHAL();
        }
        if (this._kind == 31) {
            throw new MARSHAL();
        }
        if (this._kind == -1) {
            throw new MARSHAL("InputStream subtype not supporting recursive type codes!");
        }
    }

    void read_value_body(InputStream inputStream) {
        switch (typeTable[this._kind]) {
            case 1: {
                switch (this._kind) {
                    case 18: 
                    case 27: {
                        this._length = inputStream.read_long();
                        return;
                    }
                    case 28: {
                        this._digits = inputStream.read_ushort();
                        this._scale = inputStream.read_short();
                        return;
                    }
                }
                throw new MARSHAL();
            }
            case 2: {
                int n;
                CDRInputStream cDRInputStream;
                if (inputStream instanceof TypeCodeReader) {
                    cDRInputStream = ((TypeCodeReader)((Object)inputStream)).read_encapsulation(this._orb);
                } else {
                    n = inputStream.read_long();
                    byte[] byArray = new byte[n];
                    inputStream.read_octet_array(byArray, 0, byArray.length);
                    cDRInputStream = new CDRInputStream(this._orb, byArray, byArray.length);
                    ((CDRInputStream)cDRInputStream).consumeEndian();
                }
                switch (this._kind) {
                    case 14: 
                    case 32: {
                        this.setId(((org.omg.CORBA.portable.InputStream)cDRInputStream).read_string());
                        this._name = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_string();
                        return;
                    }
                    case 16: {
                        this.setId(((org.omg.CORBA.portable.InputStream)cDRInputStream).read_string());
                        this._name = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_string();
                        this._discriminator = new TypeCodeImpl(this._orb);
                        this._discriminator.read_value_recursive(cDRInputStream);
                        this._defaultIndex = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_long();
                        this._memberCount = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_long();
                        this._unionLabels = new AnyImpl[this._memberCount];
                        this._memberNames = new String[this._memberCount];
                        this._memberTypes = new TypeCodeImpl[this._memberCount];
                        n = 0;
                        while (n < this._memberCount) {
                            this._unionLabels[n] = new AnyImpl(this._orb);
                            if (n == this._defaultIndex) {
                                this._unionLabels[n].insert_octet(((org.omg.CORBA.portable.InputStream)cDRInputStream).read_octet());
                            } else {
                                switch (this._discriminator.kind().value()) {
                                    case 2: {
                                        this._unionLabels[n].insert_short(((org.omg.CORBA.portable.InputStream)cDRInputStream).read_short());
                                        break;
                                    }
                                    case 3: {
                                        this._unionLabels[n].insert_long(((org.omg.CORBA.portable.InputStream)cDRInputStream).read_long());
                                        break;
                                    }
                                    case 4: {
                                        this._unionLabels[n].insert_ushort(((org.omg.CORBA.portable.InputStream)cDRInputStream).read_short());
                                        break;
                                    }
                                    case 5: {
                                        this._unionLabels[n].insert_ulong(((org.omg.CORBA.portable.InputStream)cDRInputStream).read_long());
                                        break;
                                    }
                                    case 6: {
                                        this._unionLabels[n].insert_float(((org.omg.CORBA.portable.InputStream)cDRInputStream).read_float());
                                        break;
                                    }
                                    case 7: {
                                        this._unionLabels[n].insert_double(((org.omg.CORBA.portable.InputStream)cDRInputStream).read_double());
                                        break;
                                    }
                                    case 8: {
                                        this._unionLabels[n].insert_boolean(((org.omg.CORBA.portable.InputStream)cDRInputStream).read_boolean());
                                        break;
                                    }
                                    case 9: {
                                        this._unionLabels[n].insert_char(((org.omg.CORBA.portable.InputStream)cDRInputStream).read_char());
                                        break;
                                    }
                                    case 17: {
                                        int n2 = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_long();
                                        org.omg.CORBA.portable.OutputStream outputStream = this._unionLabels[n].create_output_stream();
                                        outputStream.write_long(n2);
                                        this._unionLabels[n].read_value(outputStream.create_input_stream(), this._discriminator);
                                        break;
                                    }
                                    case 23: {
                                        this._unionLabels[n].insert_longlong(((org.omg.CORBA.portable.InputStream)cDRInputStream).read_longlong());
                                        break;
                                    }
                                    case 24: {
                                        this._unionLabels[n].insert_ulonglong(((org.omg.CORBA.portable.InputStream)cDRInputStream).read_longlong());
                                        break;
                                    }
                                    default: {
                                        throw new MARSHAL();
                                    }
                                }
                            }
                            this._memberNames[n] = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_string();
                            this._memberTypes[n] = new TypeCodeImpl(this._orb);
                            this._memberTypes[n].read_value_recursive(cDRInputStream);
                            this._memberTypes[n].setParent(this);
                            ++n;
                        }
                        return;
                    }
                    case 17: {
                        this.setId(((org.omg.CORBA.portable.InputStream)cDRInputStream).read_string());
                        this._name = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_string();
                        this._memberCount = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_long();
                        this._memberNames = new String[this._memberCount];
                        n = 0;
                        while (n < this._memberCount) {
                            this._memberNames[n] = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_string();
                            ++n;
                        }
                        return;
                    }
                    case 19: {
                        this._contentType = new TypeCodeImpl(this._orb);
                        this._contentType.read_value_recursive(cDRInputStream);
                        this._length = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_long();
                        return;
                    }
                    case 20: {
                        this._contentType = new TypeCodeImpl(this._orb);
                        this._contentType.read_value_recursive(cDRInputStream);
                        this._length = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_long();
                        return;
                    }
                    case 21: 
                    case 30: {
                        this.setId(((org.omg.CORBA.portable.InputStream)cDRInputStream).read_string());
                        this._name = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_string();
                        this._contentType = new TypeCodeImpl(this._orb);
                        this._contentType.read_value_recursive(cDRInputStream);
                        return;
                    }
                    case 15: 
                    case 22: {
                        this.setId(((org.omg.CORBA.portable.InputStream)cDRInputStream).read_string());
                        this._name = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_string();
                        this._memberCount = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_long();
                        this._memberNames = new String[this._memberCount];
                        this._memberTypes = new TypeCodeImpl[this._memberCount];
                        n = 0;
                        while (n < this._memberCount) {
                            this._memberNames[n] = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_string();
                            this._memberTypes[n] = new TypeCodeImpl(this._orb);
                            this._memberTypes[n].read_value_recursive(cDRInputStream);
                            this._memberTypes[n].setParent(this);
                            ++n;
                        }
                        return;
                    }
                    case 29: {
                        this.setId(((org.omg.CORBA.portable.InputStream)cDRInputStream).read_string());
                        this._name = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_string();
                        this._type_modifier = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_short();
                        this._concrete_base = new TypeCodeImpl(this._orb);
                        this._concrete_base.read_value_recursive(cDRInputStream);
                        this._memberCount = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_long();
                        this._memberNames = new String[this._memberCount];
                        this._memberTypes = new TypeCodeImpl[this._memberCount];
                        this._memberAccess = new short[this._memberCount];
                        n = 0;
                        while (n < this._memberCount) {
                            this._memberNames[n] = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_string();
                            this._memberTypes[n] = new TypeCodeImpl(this._orb);
                            this._memberTypes[n].read_value_recursive(cDRInputStream);
                            this._memberTypes[n].setParent(this);
                            this._memberAccess[n] = ((org.omg.CORBA.portable.InputStream)cDRInputStream).read_short();
                            ++n;
                        }
                        return;
                    }
                }
                throw new MARSHAL();
            }
        }
    }

    public void write_value(OutputStream outputStream) {
        if (outputStream instanceof TypeCodeOutputStream) {
            this.write_value((TypeCodeOutputStream)outputStream);
            return;
        }
        boolean bl = false;
        if (outputStream instanceof CDROutputStream) {
            bl = ((CDROutputStream)outputStream).littleEndian();
        }
        TypeCodeOutputStream typeCodeOutputStream = new TypeCodeOutputStream(this._orb, bl);
        typeCodeOutputStream.setEnclosingOutputStream(outputStream);
        this.write_value(typeCodeOutputStream);
        typeCodeOutputStream.writeOctetSequenceNoLengthTo(outputStream);
    }

    public void write_value(TypeCodeOutputStream typeCodeOutputStream) {
        if (this._kind == 31) {
            throw new MARSHAL();
        }
        this._lastOutStream = typeCodeOutputStream.getTopLevelStream();
        this._outStreamPosition = typeCodeOutputStream.getTopLevelPosition();
        typeCodeOutputStream.write_long(this._kind);
        if (this._kind == -1) {
            TypeCodeOutputStream typeCodeOutputStream2 = this.indirectType()._lastOutStream;
            if (typeCodeOutputStream2 == null) {
                throw new MARSHAL("Referenced type of indirect type not marshaled!");
            }
            if (this._lastOutStream != typeCodeOutputStream2) {
                throw new MARSHAL("Referenced type of indirect type not marshaled to same stream!");
            }
            int n = this.indirectType()._outStreamPosition - (this._outStreamPosition + 4);
            if (n > -4) {
                throw new MARSHAL();
            }
            typeCodeOutputStream.write_long(n);
            return;
        }
        switch (typeTable[this._kind]) {
            case 1: {
                switch (this._kind) {
                    case 18: 
                    case 27: {
                        typeCodeOutputStream.write_long(this._length);
                        return;
                    }
                    case 28: {
                        typeCodeOutputStream.write_ushort(this._digits);
                        typeCodeOutputStream.write_short(this._scale);
                        return;
                    }
                }
                throw new MARSHAL();
            }
            case 2: {
                TypeCodeOutputStream typeCodeOutputStream3 = typeCodeOutputStream.init_encapsulation(this._orb);
                switch (this._kind) {
                    case 14: 
                    case 32: {
                        typeCodeOutputStream3.write_string(this._id);
                        typeCodeOutputStream3.write_string(this._name);
                        break;
                    }
                    case 16: {
                        typeCodeOutputStream3.write_string(this._id);
                        typeCodeOutputStream3.write_string(this._name);
                        this._discriminator.write_value(typeCodeOutputStream3);
                        typeCodeOutputStream3.write_long(this._defaultIndex);
                        typeCodeOutputStream3.write_long(this._memberCount);
                        int n = 0;
                        while (n < this._memberCount) {
                            if (n == this._defaultIndex) {
                                typeCodeOutputStream3.write_octet(this._unionLabels[n].extract_octet());
                            } else {
                                switch (this._discriminator.kind().value()) {
                                    case 2: {
                                        typeCodeOutputStream3.write_short(this._unionLabels[n].extract_short());
                                        break;
                                    }
                                    case 3: {
                                        typeCodeOutputStream3.write_long(this._unionLabels[n].extract_long());
                                        break;
                                    }
                                    case 4: {
                                        typeCodeOutputStream3.write_short(this._unionLabels[n].extract_ushort());
                                        break;
                                    }
                                    case 5: {
                                        typeCodeOutputStream3.write_long(this._unionLabels[n].extract_ulong());
                                        break;
                                    }
                                    case 6: {
                                        typeCodeOutputStream3.write_float(this._unionLabels[n].extract_float());
                                        break;
                                    }
                                    case 7: {
                                        typeCodeOutputStream3.write_double(this._unionLabels[n].extract_double());
                                        break;
                                    }
                                    case 8: {
                                        typeCodeOutputStream3.write_boolean(this._unionLabels[n].extract_boolean());
                                        break;
                                    }
                                    case 9: {
                                        typeCodeOutputStream3.write_char(this._unionLabels[n].extract_char());
                                        break;
                                    }
                                    case 17: {
                                        int n2 = this._unionLabels[n].create_input_stream().read_long();
                                        typeCodeOutputStream3.write_long(n2);
                                        break;
                                    }
                                    case 23: {
                                        typeCodeOutputStream3.write_longlong(this._unionLabels[n].extract_longlong());
                                        break;
                                    }
                                    case 24: {
                                        typeCodeOutputStream3.write_longlong(this._unionLabels[n].extract_ulonglong());
                                        break;
                                    }
                                    default: {
                                        throw new MARSHAL();
                                    }
                                }
                            }
                            typeCodeOutputStream3.write_string(this._memberNames[n]);
                            this._memberTypes[n].write_value(typeCodeOutputStream3);
                            ++n;
                        }
                        break;
                    }
                    case 17: {
                        typeCodeOutputStream3.write_string(this._id);
                        typeCodeOutputStream3.write_string(this._name);
                        typeCodeOutputStream3.write_long(this._memberCount);
                        int n = 0;
                        while (n < this._memberCount) {
                            typeCodeOutputStream3.write_string(this._memberNames[n]);
                            ++n;
                        }
                        break;
                    }
                    case 19: {
                        this.lazy_content_type().write_value(typeCodeOutputStream3);
                        typeCodeOutputStream3.write_long(this._length);
                        break;
                    }
                    case 20: {
                        this._contentType.write_value(typeCodeOutputStream3);
                        typeCodeOutputStream3.write_long(this._length);
                        break;
                    }
                    case 21: 
                    case 30: {
                        typeCodeOutputStream3.write_string(this._id);
                        typeCodeOutputStream3.write_string(this._name);
                        this._contentType.write_value(typeCodeOutputStream3);
                        break;
                    }
                    case 15: 
                    case 22: {
                        typeCodeOutputStream3.write_string(this._id);
                        typeCodeOutputStream3.write_string(this._name);
                        typeCodeOutputStream3.write_long(this._memberCount);
                        int n = 0;
                        while (n < this._memberCount) {
                            typeCodeOutputStream3.write_string(this._memberNames[n]);
                            this._memberTypes[n].write_value(typeCodeOutputStream3);
                            ++n;
                        }
                        break;
                    }
                    case 29: {
                        typeCodeOutputStream3.write_string(this._id);
                        typeCodeOutputStream3.write_string(this._name);
                        typeCodeOutputStream3.write_short(this._type_modifier);
                        this._concrete_base.write_value(typeCodeOutputStream3);
                        typeCodeOutputStream3.write_long(this._memberCount);
                        int n = 0;
                        while (n < this._memberCount) {
                            typeCodeOutputStream3.write_string(this._memberNames[n]);
                            this._memberTypes[n].write_value(typeCodeOutputStream3);
                            typeCodeOutputStream3.write_short(this._memberAccess[n]);
                            ++n;
                        }
                        break;
                    }
                    default: {
                        throw new MARSHAL();
                    }
                }
                typeCodeOutputStream3.writeOctetSequenceTo(typeCodeOutputStream);
                return;
            }
        }
    }

    protected void copy(InputStream inputStream, OutputStream outputStream) {
        switch (this._kind) {
            case 2: 
            case 4: {
                outputStream.write_short(inputStream.read_short());
                return;
            }
            case 3: 
            case 5: {
                outputStream.write_long(inputStream.read_long());
                return;
            }
            case 6: {
                outputStream.write_float(inputStream.read_float());
                return;
            }
            case 7: {
                outputStream.write_double(inputStream.read_double());
                return;
            }
            case 23: 
            case 24: {
                outputStream.write_longlong(inputStream.read_longlong());
                return;
            }
            case 25: {
                outputStream.write_double(inputStream.read_double());
                return;
            }
            case 8: {
                outputStream.write_boolean(inputStream.read_boolean());
                return;
            }
            case 9: {
                outputStream.write_char(inputStream.read_char());
                return;
            }
            case 10: {
                outputStream.write_octet(inputStream.read_octet());
                return;
            }
            case 18: {
                String string = inputStream.read_string();
                if (this._length != 0 && string.length() > this._length) {
                    throw new MARSHAL();
                }
                outputStream.write_string(string);
                return;
            }
            case 27: {
                String string = inputStream.read_wstring();
                if (this._length != 0 && string.length() > this._length) {
                    throw new MARSHAL();
                }
                outputStream.write_wstring(string);
                return;
            }
            case 28: {
                outputStream.write_ushort(inputStream.read_ushort());
                outputStream.write_short(inputStream.read_short());
                return;
            }
            case 11: {
                Any any = ((CDRInputStream)inputStream).getORB().create_any();
                TypeCodeImpl typeCodeImpl = new TypeCodeImpl(this._orb);
                typeCodeImpl.read_value(inputStream);
                typeCodeImpl.write_value(outputStream);
                any.read_value(inputStream, typeCodeImpl);
                any.write_value(outputStream);
                return;
            }
            case 12: {
                outputStream.write_TypeCode(inputStream.read_TypeCode());
                return;
            }
            case 13: {
                outputStream.write_Principal(inputStream.read_Principal());
                return;
            }
            case 14: {
                outputStream.write_Object(inputStream.read_Object());
                return;
            }
            case 22: {
                outputStream.write_string(inputStream.read_string());
            }
            case 15: 
            case 29: {
                int n = 0;
                while (n < this._memberTypes.length) {
                    this._memberTypes[n].copy(inputStream, outputStream);
                    ++n;
                }
                return;
            }
            case 16: {
                AnyImpl anyImpl = new AnyImpl(this._orb);
                switch (this._discriminator.kind().value()) {
                    case 2: {
                        short s = inputStream.read_short();
                        ((Any)anyImpl).insert_short(s);
                        outputStream.write_short(s);
                        break;
                    }
                    case 3: {
                        int n = inputStream.read_long();
                        ((Any)anyImpl).insert_long(n);
                        outputStream.write_long(n);
                        break;
                    }
                    case 4: {
                        short s = inputStream.read_short();
                        ((Any)anyImpl).insert_ushort(s);
                        outputStream.write_short(s);
                        break;
                    }
                    case 5: {
                        int n = inputStream.read_long();
                        ((Any)anyImpl).insert_ulong(n);
                        outputStream.write_long(n);
                        break;
                    }
                    case 6: {
                        float f = inputStream.read_float();
                        ((Any)anyImpl).insert_float(f);
                        outputStream.write_float(f);
                        break;
                    }
                    case 7: {
                        double d = inputStream.read_double();
                        ((Any)anyImpl).insert_double(d);
                        outputStream.write_double(d);
                        break;
                    }
                    case 8: {
                        boolean bl = inputStream.read_boolean();
                        ((Any)anyImpl).insert_boolean(bl);
                        outputStream.write_boolean(bl);
                        break;
                    }
                    case 9: {
                        char c = inputStream.read_char();
                        ((Any)anyImpl).insert_char(c);
                        outputStream.write_char(c);
                        break;
                    }
                    case 17: {
                        int n = inputStream.read_long();
                        ((Any)anyImpl).type(this._discriminator);
                        org.omg.CORBA.portable.OutputStream outputStream2 = ((Any)anyImpl).create_output_stream();
                        outputStream2.write_long(n);
                        ((Any)anyImpl).read_value(outputStream2.create_input_stream(), this._discriminator);
                        outputStream.write_long(n);
                        break;
                    }
                    case 23: {
                        long l = inputStream.read_longlong();
                        ((Any)anyImpl).insert_longlong(l);
                        outputStream.write_longlong(l);
                        break;
                    }
                    case 24: {
                        long l = inputStream.read_longlong();
                        ((Any)anyImpl).insert_ulonglong(l);
                        outputStream.write_longlong(l);
                        break;
                    }
                    default: {
                        throw new MARSHAL();
                    }
                }
                int n = 0;
                while (n < this._unionLabels.length) {
                    if (((Any)anyImpl).equal(this._unionLabels[n])) {
                        this._memberTypes[n].copy(inputStream, outputStream);
                        break;
                    }
                    ++n;
                }
                if (n != this._unionLabels.length) break;
                if (this._defaultIndex == -1) {
                    throw new MARSHAL();
                }
                this._memberTypes[this._defaultIndex].copy(inputStream, outputStream);
                return;
            }
            case 17: {
                outputStream.write_long(inputStream.read_long());
                return;
            }
            case 19: {
                int n = inputStream.read_long();
                if (this._length != 0 && n > this._length) {
                    throw new MARSHAL();
                }
                outputStream.write_long(n);
                this.lazy_content_type();
                int n2 = 0;
                while (n2 < n) {
                    this._contentType.copy(inputStream, outputStream);
                    ++n2;
                }
                return;
            }
            case 20: {
                int n = 0;
                while (n < this._length) {
                    this._contentType.copy(inputStream, outputStream);
                    ++n;
                }
                return;
            }
            case 21: 
            case 30: {
                this._contentType.copy(inputStream, outputStream);
                return;
            }
            case -1: {
                this.indirectType().copy(inputStream, outputStream);
                return;
            }
            case 31: 
            case 32: {
                throw new NO_IMPLEMENT();
            }
            default: {
                throw new MARSHAL();
            }
            case 0: 
            case 1: 
        }
    }

    static {
        int[] nArray = new int[33];
        nArray[14] = 2;
        nArray[15] = 2;
        nArray[16] = 2;
        nArray[17] = 2;
        nArray[18] = 1;
        nArray[19] = 2;
        nArray[20] = 2;
        nArray[21] = 2;
        nArray[22] = 2;
        nArray[27] = 1;
        nArray[28] = 1;
        nArray[29] = 2;
        nArray[30] = 2;
        nArray[31] = 2;
        nArray[32] = 2;
        typeTable = nArray;
    }
}

