/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rmi.iiop;

import com.sun.rmi.IOR;
import com.sun.rmi.RequestHandler;
import com.sun.rmi.ServerRequest;
import com.sun.rmi.iiop.Connection;
import com.sun.rmi.iiop.IIOPConnection;
import com.sun.rmi.iiop.IIOPInputStream;
import com.sun.rmi.iiop.IIOPOutputStream;
import com.sun.rmi.iiop.LocateReplyMessage;
import com.sun.rmi.iiop.LocateRequestMessage;
import com.sun.rmi.iiop.Message;
import com.sun.rmi.iiop.Work;
import com.sun.rmi.iiop.WorkQueue;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;

final class CachedWorkerThread
extends Thread {
    private static WorkQueue workQueue = new WorkQueue();
    private static Work currentWork;

    public void run() {
        while (true) {
            currentWork = workQueue.getWorkToDo(this);
            this.doWork(currentWork.getRequestHandler(), currentWork.getConnection(), currentWork.getIIOPInputStream());
        }
    }

    static void addWorkToDo(RequestHandler requestHandler, IIOPConnection iIOPConnection, IIOPInputStream iIOPInputStream) {
        Work work = new Work(requestHandler, iIOPConnection, iIOPInputStream);
        workQueue.addWorkToDo(work);
    }

    void doWork(RequestHandler requestHandler, Connection connection, IIOPInputStream iIOPInputStream) {
        IIOPOutputStream iIOPOutputStream = null;
        Message message = iIOPInputStream.getMessage();
        connection.requestBegins();
        switch (message.getType()) {
            case 0: {
                ServerRequest serverRequest = (ServerRequest)((Object)iIOPInputStream);
                try {
                    iIOPOutputStream = (IIOPOutputStream)((Object)requestHandler.process(serverRequest));
                    if (!serverRequest.isOneWay()) break;
                    connection.requestEnds();
                    Thread.currentThread().stop();
                    break;
                }
                catch (SystemException systemException) {
                    try {
                        iIOPOutputStream = (IIOPOutputStream)((Object)serverRequest.createSystemExceptionResponse(systemException, null));
                        break;
                    }
                    catch (Exception exception) {
                        connection.requestEnds();
                        return;
                    }
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    UNKNOWN uNKNOWN = new UNKNOWN(4, CompletionStatus.COMPLETED_MAYBE);
                    try {
                        iIOPOutputStream = (IIOPOutputStream)((Object)serverRequest.createSystemExceptionResponse(uNKNOWN, null));
                        break;
                    }
                    catch (Exception exception) {
                        connection.requestEnds();
                        return;
                    }
                }
            }
            case 3: {
                LocateReplyMessage locateReplyMessage;
                LocateRequestMessage locateRequestMessage = (LocateRequestMessage)message;
                int n = message.getRequestId();
                IOR iOR = null;
                try {
                    iOR = requestHandler.locate(locateRequestMessage.getObjectKey());
                    locateReplyMessage = iOR == null ? new LocateReplyMessage(n, 1) : new LocateReplyMessage(n, 2);
                }
                catch (Exception exception) {
                    locateReplyMessage = new LocateReplyMessage(n, 0);
                }
                iIOPOutputStream = new IIOPOutputStream(iIOPInputStream.getConnection().getORB(), iIOPInputStream.getConnection());
                locateReplyMessage.write(iIOPOutputStream);
                iIOPOutputStream.setMessage(locateReplyMessage);
                if (iOR == null) break;
                iOR.write(iIOPOutputStream);
                break;
            }
            case 2: {
                connection.requestEnds();
                return;
            }
            default: {
                connection.requestEnds();
                return;
            }
        }
        try {
            connection.sendReply(iIOPOutputStream);
            connection.requestEnds();
            return;
        }
        catch (Exception exception) {
            connection.requestEnds();
            return;
        }
    }
}

