/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rmi.iiop;

import com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
import com.sun.org.omg.SendingContext.CodeBase;
import com.sun.org.omg.SendingContext.CodeBaseHelper;
import com.sun.rmi.IOR;
import com.sun.rmi.MarshalOutputStream;
import com.sun.rmi.ServerGIOP;
import com.sun.rmi.iiop.CachedWorkerThread;
import com.sun.rmi.iiop.ClientResponseImpl;
import com.sun.rmi.iiop.Connection;
import com.sun.rmi.iiop.ConnectionTable;
import com.sun.rmi.iiop.DeleteConn;
import com.sun.rmi.iiop.FVDCodeBaseDelegate;
import com.sun.rmi.iiop.IIOPInputStream;
import com.sun.rmi.iiop.IIOPOutputStream;
import com.sun.rmi.iiop.Message;
import com.sun.rmi.iiop.ORB;
import com.sun.rmi.iiop.OutCallDesc;
import com.sun.rmi.iiop.ReaderThread;
import com.sun.rmi.iiop.ReplyMessage;
import com.sun.rmi.iiop.RequestMessage;
import com.sun.rmi.iiop.ServerRequestImpl;
import com.sun.rmi.util.Condition;
import com.sun.rmi.util.Lock;
import com.sun.rmi.util.PartnerVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public final class IIOPConnection
extends Connection
implements PartnerVersion {
    private static final int OPENING = 1;
    private static final int ESTABLISHED = 2;
    private static final int CLOSE_SENT = 3;
    private static final int CLOSE_RECVD = 4;
    private static final int ABORT = 5;
    private Hashtable out_calls = new Hashtable();
    protected String remote_host;
    protected int remote_port;
    private String threadName;
    protected int requestCount;
    private ServerGIOP server;
    private Hashtable implementations;
    private Hashtable fvds;
    private Hashtable bases;
    private CodeBase codeBaseRef;
    private boolean postInitialContexts = false;
    private IOR codeBaseServerIOR;
    private FVDCodeBaseDelegate cbDelegate;
    Thread reader;
    int state;
    private Condition event;
    private Lock lock;
    private boolean writeLocked;
    InputStream inputStream;
    OutputStream outputStream;
    private short partnerMajor;
    private short partnerMinor;
    private static Hashtable cbs = new Hashtable();

    public IIOPConnection(ORB oRB, ServerGIOP serverGIOP, ConnectionTable connectionTable, String string, int n) {
        this.orb = oRB;
        this.server = serverGIOP;
        this.connectionTable = connectionTable;
        this.threadName = "JavaIDL Reader for " + string + ":" + n;
        try {
            this.reader = new ReaderThread(oRB.threadGroup, this, this.threadName);
        }
        catch (SecurityException securityException) {
            this.reader = new ReaderThread(this, this.threadName);
        }
        this.remote_host = string;
        this.remote_port = n;
        this.state = 1;
        this.event = new Condition();
        this.lock = new Lock();
    }

    public IIOPConnection(ORB oRB, ServerGIOP serverGIOP, String string, int n, Socket socket, InputStream inputStream, OutputStream outputStream, ConnectionTable connectionTable) {
        this(oRB, serverGIOP, connectionTable, string, n);
        this.socket = socket;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.connectionTable = connectionTable;
        this.isServer = true;
        this.state = 2;
        try {
            this.reader.setDaemon(true);
        }
        catch (Exception exception) {}
        this.reader.start();
    }

    public synchronized void setPartnerVersion(short s, short s2) {
        this.partnerMajor = s;
        this.partnerMinor = s2;
    }

    public synchronized short getPartnerMajor() {
        return this.partnerMajor;
    }

    public synchronized short getPartnerMinor() {
        return this.partnerMinor;
    }

    public synchronized boolean isPostInitialContexts() {
        return this.postInitialContexts;
    }

    public synchronized void setPostInitialContexts() {
        this.postInitialContexts = true;
    }

    public synchronized void setCodeBaseRef(IOR iOR) {
        this.codeBaseServerIOR = iOR;
    }

    public synchronized IOR getCodeBaseRef() {
        return this.codeBaseServerIOR;
    }

    public CodeBase getFVDCodeBase() {
        if (this.cbDelegate == null) {
            this.cbDelegate = new FVDCodeBaseDelegate(this);
        }
        return this.cbDelegate;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public ServerGIOP getServerGIOP() {
        return this.server;
    }

    String getHost() {
        return this.remote_host;
    }

    int getPort() {
        return this.remote_port;
    }

    public IIOPInputStream createInputStream() throws Exception {
        byte[] byArray = new byte[1024];
        Message message = Message.createFromStream(byArray, this.inputStream);
        switch (message.getType()) {
            case 0: {
                return new ServerRequestImpl((Connection)this, byArray, (RequestMessage)message);
            }
            case 1: {
                return new ClientResponseImpl((Connection)this, byArray, (ReplyMessage)message);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new IIOPInputStream(this, byArray, message);
            }
        }
        throw new INTERNAL(11, CompletionStatus.COMPLETED_NO);
    }

    void processInput(IIOPInputStream iIOPInputStream) throws DeleteConn {
        int n = iIOPInputStream.getMessage().getType();
        switch (n) {
            case 0: 
            case 3: {
                if (this.debug) {
                    this.dprint("Connection:processInput: got incoming request");
                }
                CachedWorkerThread.addWorkToDo(this.server.getRequestHandler(), this, iIOPInputStream);
                return;
            }
            case 1: 
            case 4: {
                if (this.debug) {
                    this.dprint("Connection:processInput: got RESPONSE");
                }
                Integer n2 = new Integer(iIOPInputStream.getMessage().getRequestId());
                OutCallDesc outCallDesc = (OutCallDesc)this.out_calls.get(n2);
                this.out_calls.remove(n2);
                this.lock.lock();
                outCallDesc.s = iIOPInputStream;
                outCallDesc.done.signal();
                this.lock.unlock();
                return;
            }
            case 2: {
                if (!this.debug) break;
                this.dprint("Connection:processInput: got cancel");
                return;
            }
            case 5: {
                if (this.debug) {
                    this.dprint("Connection.processInput: got CloseConn, purging");
                }
                this.purge_calls(2, true, false);
                return;
            }
            default: {
                if (this.debug) {
                    this.dprint("Connection: bad message type " + String.valueOf(n));
                }
                this.purge_calls(1, true, false);
            }
        }
    }

    void purge_calls(int n, boolean bl, boolean bl2) {
        CompletionStatus completionStatus;
        block12: {
            if (this.debug) {
                this.dprint("purge_calls: starting: code = " + n + " die = " + bl);
            }
            if (this.state == 5 || this.state == 4) {
                if (this.debug) {
                    this.dprint("purge_calls: exiting duplicate invocation");
                }
                return;
            }
            try {
                if (!bl2) {
                    this.writeLock();
                }
            }
            catch (SystemException systemException) {
                if (!this.debug) break block12;
                this.dprint("purge_calls: caught exception " + systemException + "; continuing");
            }
        }
        this.lock.lock();
        if (n == 2) {
            this.state = 4;
            completionStatus = CompletionStatus.COMPLETED_NO;
        } else {
            this.state = 5;
            completionStatus = CompletionStatus.COMPLETED_MAYBE;
        }
        this.lock.unlock();
        try {
            this.inputStream.close();
            this.outputStream.close();
            this.socket.close();
        }
        catch (Exception exception) {}
        COMM_FAILURE cOMM_FAILURE = new COMM_FAILURE(n, completionStatus);
        Enumeration enumeration = this.out_calls.elements();
        while (enumeration.hasMoreElements()) {
            OutCallDesc outCallDesc = (OutCallDesc)enumeration.nextElement();
            this.lock.lock();
            outCallDesc.exc = cOMM_FAILURE;
            outCallDesc.done.signal();
            this.lock.unlock();
        }
        this.out_calls.clear();
        this.connectionTable.deleteConn(this.remote_host, this.remote_port);
        this.writeUnlock();
        if (bl) {
            Thread.currentThread().stop();
        }
    }

    public void setConnection(Socket socket, ConnectionTable connectionTable) throws Exception {
        this.socket = socket;
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
        this.connectionTable = connectionTable;
        this.lock.lock();
        this.state = 2;
        this.event.signalAll();
        try {
            this.reader.setDaemon(true);
        }
        catch (Exception exception) {}
        this.reader.start();
        this.lock.unlock();
    }

    public void abortConnection() {
        this.lock.lock();
        this.state = 5;
        this.event.signalAll();
        this.connectionTable.deleteConn(this.remote_host, this.remote_port);
        this.lock.unlock();
    }

    private boolean writeLock() {
        this.lock.lock();
        block5: while (true) {
            switch (this.state) {
                case 1: {
                    this.event.wait(this.lock);
                    continue block5;
                }
                case 2: {
                    if (!this.writeLocked) {
                        this.writeLocked = true;
                        this.lock.unlock();
                        return true;
                    }
                    this.event.wait(this.lock);
                    continue block5;
                }
                case 4: 
                case 5: {
                    this.lock.unlock();
                    throw new COMM_FAILURE(2, CompletionStatus.COMPLETED_NO);
                }
            }
            break;
        }
        if (this.debug) {
            this.dprint("Connection:writeLock: weird state");
        }
        this.lock.unlock();
        this.delete(1);
        return false;
    }

    private void writeUnlock() {
        this.lock.lock();
        this.writeLocked = false;
        this.event.signalAll();
        this.lock.unlock();
    }

    public void delete() {
        this.delete(1);
    }

    void delete(int n) {
        DeleteConn deleteConn = new DeleteConn(n);
        this.reader.stop(deleteConn);
    }

    public IIOPInputStream invoke(IIOPOutputStream iIOPOutputStream) throws SystemException {
        return this.send(iIOPOutputStream, false);
    }

    public IIOPInputStream send(IIOPOutputStream iIOPOutputStream, boolean bl) {
        OutCallDesc outCallDesc;
        boolean bl2;
        block9: {
            bl2 = false;
            outCallDesc = new OutCallDesc();
            outCallDesc.thd = Thread.currentThread();
            int n = iIOPOutputStream.getMessage().getRequestId();
            try {
                this.writeLock();
                bl2 = true;
                this.out_calls.put(new Integer(n), outCallDesc);
                try {
                    iIOPOutputStream.writeTo(this.outputStream);
                    this.outputStream.flush();
                }
                catch (IOException iOException) {
                    throw new COMM_FAILURE(3, CompletionStatus.COMPLETED_NO);
                }
                this.writeUnlock();
                bl2 = false;
                if (bl) {
                    IIOPInputStream iIOPInputStream = null;
                    java.lang.Object var8_7 = null;
                    if (bl2) {
                        this.writeUnlock();
                    }
                    return iIOPInputStream;
                }
                this.lock.lock();
                while (outCallDesc.s == null && outCallDesc.exc == null) {
                    outCallDesc.done.wait(this.lock);
                }
                this.lock.unlock();
                if (outCallDesc.exc == null) break block9;
                throw outCallDesc.exc;
            }
            catch (Throwable throwable) {
                java.lang.Object var8_9 = null;
                if (bl2) {
                    this.writeUnlock();
                }
                throw throwable;
            }
        }
        java.lang.Object var8_8 = null;
        if (bl2) {
            this.writeUnlock();
        }
        return outCallDesc.s;
    }

    public void sendReply(MarshalOutputStream marshalOutputStream) throws Exception {
        boolean bl = false;
        try {
            this.writeLock();
            bl = true;
            marshalOutputStream.writeTo(this.outputStream);
            this.outputStream.flush();
            this.writeUnlock();
            bl = false;
            return;
        }
        catch (Exception exception) {
            if (bl) {
                this.writeUnlock();
            }
            return;
        }
    }

    public String getImplementation(String string) {
        String string2 = null;
        if (this.implementations == null) {
            this.implementations = new Hashtable();
        } else {
            string2 = (String)this.implementations.get(string);
        }
        if (string2 == null) {
            if (this.codeBaseRef == null) {
                this.codeBaseRef = IIOPConnection.getCodeBase(this.orb, this.codeBaseServerIOR);
            }
            if ((string2 = this.codeBaseRef.implementation(string)) != null) {
                this.implementations.put(string, string2);
            }
        }
        return string2;
    }

    private static CodeBase getCodeBase(ORB oRB, IOR iOR) {
        CodeBase codeBase = (CodeBase)cbs.get(iOR);
        if (codeBase != null) {
            return codeBase;
        }
        if (iOR == null) {
            throw new MARSHAL("No sending context");
        }
        Object object = oRB.string_to_object(iOR.stringify());
        codeBase = CodeBaseHelper.narrow(object);
        cbs.put(iOR, codeBase);
        return codeBase;
    }

    public FullValueDescription getFVD(String string) {
        FullValueDescription fullValueDescription = null;
        if (this.fvds == null) {
            this.fvds = new Hashtable();
        } else {
            fullValueDescription = (FullValueDescription)this.fvds.get(string);
        }
        if (fullValueDescription == null) {
            if (this.codeBaseRef == null) {
                this.codeBaseRef = IIOPConnection.getCodeBase(this.orb, this.codeBaseServerIOR);
            }
            if ((fullValueDescription = this.codeBaseRef.meta(string)) != null) {
                this.fvds.put(string, fullValueDescription);
            }
        }
        return fullValueDescription;
    }

    public String[] getBases(String string) {
        String[] stringArray = null;
        if (this.bases == null) {
            this.bases = new Hashtable();
        } else {
            stringArray = (String[])this.bases.get(string);
        }
        if (stringArray == null) {
            if (this.codeBaseRef == null) {
                this.codeBaseRef = IIOPConnection.getCodeBase(this.orb, this.codeBaseServerIOR);
            }
            if ((stringArray = this.codeBaseRef.bases(string)) != null) {
                this.bases.put(string, stringArray);
            }
        }
        return stringArray;
    }

    private void sendCloseConnection() {
        Message message = new Message();
        message.setType(5);
        IIOPOutputStream iIOPOutputStream = this.orb.newOutputStream(this);
        message.write(iIOPOutputStream);
        iIOPOutputStream.setMessage(message);
        try {
            iIOPOutputStream.writeTo(this.outputStream);
            this.outputStream.flush();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public boolean isBusy() {
        return this.requestCount > 0 || this.out_calls.size() > 0;
    }

    public synchronized void cleanUp() throws Exception {
        this.writeLock();
        if (this.requestCount > 0 || this.out_calls.size() > 0) {
            this.writeUnlock();
            throw new Exception();
        }
        try {
            if (this.isServer) {
                this.sendCloseConnection();
                this.lock.lock();
                this.state = 3;
                this.lock.unlock();
            }
            Exception exception = new Exception();
            this.reader.stop(exception);
            this.purge_calls(2, false, true);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public synchronized void requestBegins() {
        ++this.requestCount;
    }

    public synchronized void requestEnds() {
        --this.requestCount;
    }

    public void print() {
        System.out.println("Connection for " + this.remote_host + " @ " + this.remote_port);
        System.out.println("    Time stamp = " + this.timeStamp);
        boolean bl = this.reader.isAlive();
        if (bl) {
            System.out.println(" Reader is Alive");
            return;
        }
        System.out.println(" Reader is not Alive");
    }
}

