/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rmi.util;

import com.sun.rmi.io.ObjectStreamClass;
import com.sun.rmi.io.TypeMismatchException;
import com.sun.rmi.util.IdentityHashtable;
import com.sun.rmi.util.JDKBridge;
import com.sun.rmi.util.RepositoryIdCache;
import com.sun.rmi.util.Utility;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.MARSHAL;

public class RepositoryId {
    public static final byte[] IDL_IDENTIFIER_CHARS;
    private static final long serialVersionUID = 123456789L;
    private static String defaultServerURL;
    private static boolean useCodebaseOnly;
    private static IdentityHashtable classToRepStr;
    private static IdentityHashtable classIDLToRepStr;
    private static IdentityHashtable classSeqToRepStr;
    private static IdentityHashtable repStrToByteArray;
    private static Hashtable repStrToClass;
    private String repId;
    private boolean isSupportedFormat = true;
    private String typeString;
    private String versionString;
    private boolean isSequence = false;
    private boolean isRMIValueType = false;
    private boolean isIDLType = false;
    private String completeClassName;
    private String unqualifiedName;
    private String definedInId;
    private Class clazz;
    private String suid;
    private String actualSuid;
    private long suidLong = -1L;
    private long actualSuidLong = -1L;
    private static final String kSequenceKeyword = "seq";
    private static final String kValuePrefix = "RMI:";
    private static final String kIDLPrefix = "IDL:";
    private static final String kIDLNamePrefix = "omg.org/";
    private static final String kIDLClassnamePrefix = "org.omg.";
    private static final String kSequencePrefix = "[";
    private static final String kCORBAPrefix = "CORBA/";
    private static final String kArrayPrefix = "RMI:[CORBA/";
    private static final int kValuePrefixLength;
    private static final int kIDLPrefixLength;
    private static final int kSequencePrefixLength;
    private static final String kInterfaceHashCode = ":0000000000000000";
    private static final String kInterfaceOnlyHashStr = "0000000000000000";
    private static final String kExternalizableHashStr = "0000000000000001";
    public static final int kInitialValueTag = 0x7FFFFF00;
    public static final int kNoTypeInfo = 0;
    public static final int kSingleRepTypeInfo = 2;
    public static final int kPartialListTypeInfo = 6;
    public static final int kChunkedMask = 8;
    public static final int kPreComputed_StandardRMIUnchunked;
    public static final int kPreComputed_CodeBaseRMIUnchunked;
    public static final int kPreComputed_StandardRMIChunked;
    public static final int kPreComputed_CodeBaseRMIChunked;
    public static final int kPreComputed_StandardRMIUnchunked_NoRep;
    public static final int kPreComputed_CodeBaseRMIUnchunked_NoRep;
    public static final int kPreComputed_StandardRMIChunked_NoRep;
    public static final int kPreComputed_CodeBaseRMIChunked_NoRep;
    public static final String kWStringValueVersion = "1.0";
    public static final String kWStringValueHash = ":1.0";
    public static final String kWStringStubValue = "WStringValue";
    public static final String kWStringTypeStr = "omg.org/CORBA/WStringValue";
    public static final String kWStringValueRepID = "IDL:omg.org/CORBA/WStringValue:1.0";
    public static final String kAnyRepID = "IDL:omg.org/CORBA/Any";
    public static final String kClassDescValueHash;
    public static final String kClassDescStubValue = "ClassDesc";
    public static final String kClassDescTypeStr = "javax.rmi.CORBA.ClassDesc";
    public static final String kClassDescValueRepID;
    public static final String kObjectValueHash = ":1.0";
    public static final String kObjectStubValue = "Object";
    public static final String kSequenceValueHash = ":1.0";
    public static final String kPrimitiveSequenceValueHash = ":0000000000000000";
    public static final String kSerializableValueHash = ":1.0";
    public static final String kSerializableStubValue = "Serializable";
    public static final String kExternalizableValueHash = ":1.0";
    public static final String kExternalizableStubValue = "Externalizable";
    public static final String kRemoteValueHash = "";
    public static final String kRemoteStubValue = "";
    public static final String kRemoteTypeStr = "";
    public static final String kRemoteValueRepID = "";
    public static final Hashtable kSpecialArrayTypeStrings;
    public static final Hashtable kSpecialCasesRepIDs;
    public static final Hashtable kSpecialCasesStubValues;
    public static final Hashtable kSpecialCasesVersions;
    public static final Hashtable kSpecialCasesClasses;
    public static final Hashtable kSpecialCasesArrayPrefix;
    public static final Hashtable kSpecialPrimitives;
    private static final byte[] ASCII_HEX;
    public static RepositoryIdCache cache;
    public static final String kjava_rmi_Remote;
    public static final String korg_omg_CORBA_Object;
    public static final Class[] kNoParamTypes;
    public static final Object[] kNoArgs;
    static /* synthetic */ Class class$javax$rmi$CORBA$ClassDesc;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$org$omg$CORBA$Object;
    static /* synthetic */ Class class$org$omg$CORBA$portable$IDLEntity;
    static /* synthetic */ Class class$org$omg$CORBA$portable$ValueBase;

    RepositoryId() {
    }

    RepositoryId(String string) {
        this.init(string);
    }

    RepositoryId init(String string) {
        this.repId = string;
        if (string.length() == 0) {
            this.clazz = class$java$rmi$Remote != null ? class$java$rmi$Remote : (class$java$rmi$Remote = RepositoryId.class$("java.rmi.Remote"));
            this.typeString = "";
            this.isRMIValueType = true;
            this.suid = kInterfaceOnlyHashStr;
            return this;
        }
        if (string.equals(kWStringValueRepID)) {
            this.clazz = class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = RepositoryId.class$("java.lang.String"));
            this.typeString = kWStringTypeStr;
            this.isIDLType = true;
            this.completeClassName = "java.lang.String";
            this.versionString = ":1.0";
            return this;
        }
        String string2 = RepositoryId.convertFromISOLatin1(string);
        this.versionString = string2.substring(string2.indexOf(58, string2.indexOf(58) + 1));
        if (string2.startsWith(kIDLPrefix)) {
            this.typeString = string2.substring(kIDLPrefixLength, string2.indexOf(58, kIDLPrefixLength));
            this.isIDLType = true;
            this.completeClassName = this.typeString.startsWith(kIDLNamePrefix) ? kIDLClassnamePrefix + this.typeString.substring(kIDLNamePrefix.length()).replace('/', '.') : this.typeString.replace('/', '.');
        } else if (string2.startsWith(kValuePrefix)) {
            this.typeString = string2.substring(kValuePrefixLength, string2.indexOf(58, kValuePrefixLength));
            this.isRMIValueType = true;
            if (this.versionString.indexOf(46) == -1) {
                this.suid = this.actualSuid = this.versionString.substring(1);
                if (this.actualSuid.indexOf(58) != -1) {
                    int n = this.actualSuid.indexOf(58) + 1;
                    this.suid = this.actualSuid.substring(n);
                    this.actualSuid = this.actualSuid.substring(0, n - 1);
                }
            }
        } else {
            this.isSupportedFormat = false;
        }
        if (this.typeString.startsWith(kSequencePrefix)) {
            this.isSequence = true;
        }
        return this;
    }

    public final String getUnqualifiedName() {
        if (this.unqualifiedName == null) {
            String string = this.getClassName();
            int n = string.lastIndexOf(46);
            if (n == -1) {
                this.unqualifiedName = string;
                this.definedInId = "IDL::1.0";
            } else {
                this.unqualifiedName = string.substring(n);
                this.definedInId = kIDLPrefix + string.substring(0, n).replace('.', '/') + ":1.0";
            }
        }
        return this.unqualifiedName;
    }

    public final String getDefinedInId() {
        if (this.definedInId == null) {
            this.getUnqualifiedName();
        }
        return this.definedInId;
    }

    public final String getTypeString() {
        return this.typeString;
    }

    public final String getVersionString() {
        return this.versionString;
    }

    public final String getSerialVersionUID() {
        return this.suid;
    }

    public final String getActualSerialVersionUID() {
        return this.actualSuid;
    }

    public final long getSerialVersionUIDAsLong() {
        return this.suidLong;
    }

    public final long getActualSerialVersionUIDAsLong() {
        return this.actualSuidLong;
    }

    public final boolean isRMIValueType() {
        return this.isRMIValueType;
    }

    public final boolean isIDLType() {
        return this.isIDLType;
    }

    public final String getRepositoryId() {
        return this.repId;
    }

    public static byte[] getByteArray(String string) {
        IdentityHashtable identityHashtable = repStrToByteArray;
        synchronized (identityHashtable) {
            byte[] byArray = (byte[])repStrToByteArray.get(string);
            Object var3_3 = null;
            return byArray;
        }
    }

    public static void setByteArray(String string, byte[] byArray) {
        IdentityHashtable identityHashtable = repStrToByteArray;
        synchronized (identityHashtable) {
            repStrToByteArray.put(string, byArray);
            return;
        }
    }

    public final boolean isSequence() {
        return this.isSequence;
    }

    public final boolean isSupportedFormat() {
        return this.isSupportedFormat;
    }

    public final String getClassName() {
        if (this.isRMIValueType) {
            return this.typeString;
        }
        if (this.isIDLType) {
            return this.completeClassName;
        }
        return null;
    }

    public final Class getClassFromRepId() throws ClassNotFoundException {
        if (this.clazz != null) {
            return this.clazz;
        }
        Class clazz = (Class)kSpecialCasesClasses.get(this.getClassName());
        if (clazz != null) {
            this.clazz = clazz;
            return clazz;
        }
        Class clazz2 = (Class)repStrToClass.get(this.repId);
        if (clazz2 != null) {
            this.clazz = clazz2;
            return clazz2;
        }
        throw new ClassNotFoundException("Unknown repId " + this.repId);
    }

    public final Class getClassFromType() throws ClassNotFoundException {
        if (this.clazz != null) {
            return this.clazz;
        }
        Class clazz = (Class)kSpecialCasesClasses.get(this.getClassName());
        if (clazz != null) {
            this.clazz = clazz;
            return clazz;
        }
        try {
            return Util.loadClass(this.getClassName(), null, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (defaultServerURL != null) {
                try {
                    return this.getClassFromType(defaultServerURL);
                }
                catch (MalformedURLException malformedURLException) {
                    throw classNotFoundException;
                }
            }
            throw classNotFoundException;
        }
    }

    public final Class getClassFromType(Class clazz, String string) throws ClassNotFoundException {
        if (this.clazz != null) {
            return this.clazz;
        }
        Class clazz2 = (Class)kSpecialCasesClasses.get(this.getClassName());
        if (clazz2 != null) {
            this.clazz = clazz2;
            return clazz2;
        }
        return Utility.loadClassOfType(this.getClassName(), string, clazz, clazz);
    }

    public final Class getClassFromType(String string) throws ClassNotFoundException, MalformedURLException {
        return Util.loadClass(this.getClassName(), string, null);
    }

    public final String toString() {
        return this.repId;
    }

    public static boolean useFullValueDescription(Class clazz, String string, boolean bl) throws IOException {
        String string2 = RepositoryId.createForAnyType(clazz, bl);
        if (string2.equals(string)) {
            return false;
        }
        RepositoryId repositoryId = cache.getId(string);
        RepositoryId repositoryId2 = bl ? new RepositoryId(string2) : cache.getId(string2);
        ObjectStreamClass.lookup(clazz);
        if (repositoryId.isRMIValueType() && repositoryId2.isRMIValueType()) {
            if (!repositoryId.getSerialVersionUID().equals(repositoryId2.getSerialVersionUID())) {
                String string3 = "Mismatched serialization UIDs : Source (Rep. ID" + repositoryId2 + ") = " + repositoryId2.getSerialVersionUID() + " whereas Target (Rep. ID " + string + ") = " + repositoryId.getSerialVersionUID();
                throw new IOException(string3);
            }
            return true;
        }
        throw new IOException("The repository ID is not of an RMI value type (Expected ID = " + string2 + "; Received ID = " + string + ")");
    }

    private static String createHashString(Serializable serializable, boolean bl) {
        return RepositoryId.createHashString(serializable.getClass(), bl);
    }

    private static String createHashString(Class clazz, boolean bl) {
        if (clazz.isInterface() || !(class$java$io$Serializable != null ? class$java$io$Serializable : (class$java$io$Serializable = RepositoryId.class$("java.io.Serializable"))).isAssignableFrom(clazz)) {
            return ":0000000000000000";
        }
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        long l = objectStreamClass.getActualSerialVersionUID(bl);
        String string = null;
        string = l == 0L ? kInterfaceOnlyHashStr : (l == 1L ? kExternalizableHashStr : Long.toHexString(l).toUpperCase());
        while (string.length() < 16) {
            string = "0" + string;
        }
        long l2 = objectStreamClass.getSerialVersionUID(bl);
        String string2 = null;
        string2 = l2 == 0L ? kInterfaceOnlyHashStr : (l2 == 1L ? kExternalizableHashStr : Long.toHexString(l2).toUpperCase());
        while (string2.length() < 16) {
            string2 = "0" + string2;
        }
        string = String.valueOf(string) + ":" + string2;
        return ":" + string;
    }

    public static String createSequenceRepID(Object object) {
        return RepositoryId.createSequenceRepID(object.getClass(), false);
    }

    public static String createSequenceRepID(Object object, boolean bl) {
        return RepositoryId.createSequenceRepID(object.getClass(), bl);
    }

    public static String createSequenceRepID(Class clazz) {
        return RepositoryId.createSequenceRepID(clazz, false);
    }

    public static String createSequenceRepID(Class clazz, boolean bl) {
        IdentityHashtable identityHashtable = classSeqToRepStr;
        synchronized (identityHashtable) {
            String string = (String)classSeqToRepStr.get(clazz);
            if (string != null) {
                String string2 = string;
                Object var4_6 = null;
                return string2;
            }
            Class<?> clazz2 = clazz;
            Class<?> clazz3 = null;
            int n = 0;
            while ((clazz3 = clazz.getComponentType()) != null) {
                ++n;
                clazz = clazz3;
            }
            if (clazz.isPrimitive()) {
                string = kValuePrefix + clazz2.getName() + ":0000000000000000";
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(kValuePrefix);
                while (n-- > 0) {
                    stringBuffer.append(kSequencePrefix);
                }
                stringBuffer.append("L");
                stringBuffer.append(RepositoryId.convertToISOLatin1(clazz.getName()));
                stringBuffer.append(";");
                stringBuffer.append(RepositoryId.createHashString(clazz, bl));
                string = stringBuffer.toString();
            }
            classSeqToRepStr.put(clazz2, string);
            String string3 = string;
            Object var4_7 = null;
            return string3;
        }
    }

    public static String createForSpecialCase(Class clazz) {
        if (clazz.isArray()) {
            return RepositoryId.createSequenceRepID(clazz);
        }
        return (String)kSpecialCasesRepIDs.get(clazz);
    }

    public static String createForSpecialCase(Serializable serializable) {
        Class<?> clazz = serializable.getClass();
        if (clazz.isArray()) {
            return RepositoryId.createSequenceRepID(serializable);
        }
        return RepositoryId.createForSpecialCase(clazz);
    }

    public static String createForJavaType(Serializable serializable) throws TypeMismatchException {
        return RepositoryId.createForJavaType(serializable, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String createForJavaType(Serializable serializable, boolean bl) throws TypeMismatchException {
        IdentityHashtable identityHashtable = classToRepStr;
        synchronized (identityHashtable) {
            String string = RepositoryId.createForSpecialCase(serializable);
            if (string != null) {
                return string;
            }
            Class<?> clazz = serializable.getClass();
            if (!bl && (string = (String)classToRepStr.get(clazz)) != null) {
                return string;
            }
            string = kValuePrefix + RepositoryId.convertToISOLatin1(clazz.getName()) + RepositoryId.createHashString(clazz, bl);
            if (bl) return string;
            classToRepStr.put(clazz, string);
            repStrToClass.put(string, clazz);
            return string;
        }
    }

    public static String createForJavaType(Class clazz) throws TypeMismatchException {
        return RepositoryId.createForJavaType(clazz, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String createForJavaType(Class clazz, boolean bl) throws TypeMismatchException {
        IdentityHashtable identityHashtable = classToRepStr;
        synchronized (identityHashtable) {
            String string = RepositoryId.createForSpecialCase(clazz);
            if (string != null) {
                return string;
            }
            if (!bl && (string = (String)classToRepStr.get(clazz)) != null) {
                return string;
            }
            string = kValuePrefix + RepositoryId.convertToISOLatin1(clazz.getName()) + RepositoryId.createHashString(clazz, bl);
            if (bl) return string;
            classToRepStr.put(clazz, string);
            repStrToClass.put(string, clazz);
            return string;
        }
    }

    public static String createForIDLType(Class clazz, int n, int n2) throws TypeMismatchException {
        IdentityHashtable identityHashtable = classIDLToRepStr;
        synchronized (identityHashtable) {
            String string = (String)classIDLToRepStr.get(clazz);
            if (string != null) {
                String string2 = string;
                Object var5_7 = null;
                return string2;
            }
            string = kIDLPrefix + RepositoryId.convertToISOLatin1(clazz.getName()).replace('.', '/') + ":" + n + "." + n2;
            classIDLToRepStr.put(clazz, string);
            String string3 = string;
            Object var5_8 = null;
            return string3;
        }
    }

    private static String getIdFromHelper(Class clazz) {
        try {
            Class clazz2 = Utility.loadClassForClass(String.valueOf(clazz.getName()) + "Helper", null, clazz, clazz);
            Method method = clazz2.getDeclaredMethod("id", kNoParamTypes);
            return (String)method.invoke(null, kNoArgs);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MARSHAL(classNotFoundException.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new MARSHAL(noSuchMethodException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MARSHAL(invocationTargetException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MARSHAL(illegalAccessException.toString());
        }
    }

    public static String createForAnyType(Class clazz) {
        return RepositoryId.createForAnyType(clazz, false);
    }

    public static String createForAnyType(Class clazz, boolean bl) {
        try {
            if (clazz.isArray()) {
                return RepositoryId.createSequenceRepID(clazz, bl);
            }
            if ((class$org$omg$CORBA$portable$IDLEntity != null ? class$org$omg$CORBA$portable$IDLEntity : (class$org$omg$CORBA$portable$IDLEntity = RepositoryId.class$("org.omg.CORBA.portable.IDLEntity"))).isAssignableFrom(clazz)) {
                try {
                    return RepositoryId.getIdFromHelper(clazz);
                }
                catch (Throwable throwable) {
                    return RepositoryId.createForIDLType(clazz, 1, 0);
                }
            }
            return RepositoryId.createForJavaType(clazz, bl);
        }
        catch (TypeMismatchException typeMismatchException) {
            return null;
        }
    }

    public static boolean isAbstractBase(Class clazz) {
        return clazz.isInterface() && (class$org$omg$CORBA$portable$IDLEntity != null ? class$org$omg$CORBA$portable$IDLEntity : (class$org$omg$CORBA$portable$IDLEntity = RepositoryId.class$("org.omg.CORBA.portable.IDLEntity"))).isAssignableFrom(clazz) && !(class$org$omg$CORBA$portable$ValueBase != null ? class$org$omg$CORBA$portable$ValueBase : (class$org$omg$CORBA$portable$ValueBase = RepositoryId.class$("org.omg.CORBA.portable.ValueBase"))).isAssignableFrom(clazz) && !(class$org$omg$CORBA$Object != null ? class$org$omg$CORBA$Object : (class$org$omg$CORBA$Object = RepositoryId.class$("org.omg.CORBA.Object"))).isAssignableFrom(clazz);
    }

    public static boolean isAnyRequired(Class clazz) {
        return clazz == (class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = RepositoryId.class$("java.lang.Object"))) || clazz == (class$java$io$Serializable != null ? class$java$io$Serializable : (class$java$io$Serializable = RepositoryId.class$("java.io.Serializable"))) || clazz == (class$java$io$Externalizable != null ? class$java$io$Externalizable : (class$java$io$Externalizable = RepositoryId.class$("java.io.Externalizable")));
    }

    public static long fromHex(String string) {
        if (string.startsWith("0x")) {
            return Long.valueOf(string.substring(2), 16);
        }
        return Long.valueOf(string, 16);
    }

    private static String convertToISOLatin1(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        StringBuffer stringBuffer = null;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c > '\u00ff' || IDL_IDENTIFIER_CHARS[c] == 0) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.substring(0, n2));
                }
                stringBuffer.append("\\U" + (char)ASCII_HEX[(c & 0xF000) >>> 12] + (char)ASCII_HEX[(c & 0xF00) >>> 8] + (char)ASCII_HEX[(c & 0xF0) >>> 4] + (char)ASCII_HEX[c & 0xF]);
            } else if (stringBuffer != null) {
                stringBuffer.append(c);
            }
            ++n2;
        }
        if (stringBuffer != null) {
            string = stringBuffer.toString();
        }
        return string;
    }

    private static String convertFromISOLatin1(String string) {
        int n = -1;
        StringBuffer stringBuffer = new StringBuffer(string);
        while ((n = stringBuffer.toString().indexOf("\\U")) != -1) {
            String string2 = "0000" + stringBuffer.toString().substring(n + 2, n + 6);
            byte[] byArray = new byte[(string2.length() - 4) / 2];
            int n2 = 4;
            int n3 = 0;
            while (n2 < string2.length()) {
                byArray[n3] = (byte)(RepositoryId.hexOf(string2.charAt(n2)) << 4 & 0xF0);
                int n4 = n3++;
                byArray[n4] = (byte)(byArray[n4] | (byte)(RepositoryId.hexOf(string2.charAt(n2 + 1)) & 0xF));
                n2 += 2;
            }
            stringBuffer = new StringBuffer(RepositoryId.delete(stringBuffer.toString(), n, n + 6));
            stringBuffer.insert(n, (char)byArray[1]);
        }
        return stringBuffer.toString();
    }

    private static int hexOf(char c) {
        int n = c - 48;
        if (n >= 0 && n <= 9) {
            return n;
        }
        n = c - 97 + 10;
        if (n >= 10 && n <= 15) {
            return n;
        }
        n = c - 65 + 10;
        if (n >= 10 && n <= 15) {
            return n;
        }
        throw new Error("Bad hex digit");
    }

    private static String delete(String string, int n, int n2) {
        return String.valueOf(string.substring(0, n)) + string.substring(n2, string.length());
    }

    private static String replace(String string, String string2, String string3) {
        int n = 0;
        n = string.indexOf(string2);
        while (n != -1) {
            String string4 = string.substring(0, n);
            String string5 = string.substring(n + string2.length());
            string = new String(String.valueOf(string4) + string3 + string5);
            n = string.indexOf(string2);
        }
        return string;
    }

    public static int computeValueTag(boolean bl, int n, boolean bl2) {
        int n2 = 0x7FFFFF00;
        if (bl) {
            n2 |= 1;
        }
        n2 |= n;
        if (bl2) {
            n2 |= 8;
        }
        return n2;
    }

    public static boolean isCodeBasePresent(int n) {
        return (n & 1) == 1;
    }

    public static int getTypeInfo(int n) {
        return n & 6;
    }

    public static boolean isChunkedEncoding(int n) {
        return (n & 8) != 0;
    }

    public static String getServerURL() {
        return defaultServerURL;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        byte[] byArray = new byte[256];
        byArray[46] = 1;
        byArray[48] = 1;
        byArray[49] = 1;
        byArray[50] = 1;
        byArray[51] = 1;
        byArray[52] = 1;
        byArray[53] = 1;
        byArray[54] = 1;
        byArray[55] = 1;
        byArray[56] = 1;
        byArray[57] = 1;
        byArray[65] = 1;
        byArray[66] = 1;
        byArray[67] = 1;
        byArray[68] = 1;
        byArray[69] = 1;
        byArray[70] = 1;
        byArray[71] = 1;
        byArray[72] = 1;
        byArray[73] = 1;
        byArray[74] = 1;
        byArray[75] = 1;
        byArray[76] = 1;
        byArray[77] = 1;
        byArray[78] = 1;
        byArray[79] = 1;
        byArray[80] = 1;
        byArray[81] = 1;
        byArray[82] = 1;
        byArray[83] = 1;
        byArray[84] = 1;
        byArray[85] = 1;
        byArray[86] = 1;
        byArray[87] = 1;
        byArray[88] = 1;
        byArray[89] = 1;
        byArray[90] = 1;
        byArray[95] = 1;
        byArray[97] = 1;
        byArray[98] = 1;
        byArray[99] = 1;
        byArray[100] = 1;
        byArray[101] = 1;
        byArray[102] = 1;
        byArray[103] = 1;
        byArray[104] = 1;
        byArray[105] = 1;
        byArray[106] = 1;
        byArray[107] = 1;
        byArray[108] = 1;
        byArray[109] = 1;
        byArray[110] = 1;
        byArray[111] = 1;
        byArray[112] = 1;
        byArray[113] = 1;
        byArray[114] = 1;
        byArray[115] = 1;
        byArray[116] = 1;
        byArray[117] = 1;
        byArray[118] = 1;
        byArray[119] = 1;
        byArray[120] = 1;
        byArray[121] = 1;
        byArray[122] = 1;
        byArray[192] = 1;
        byArray[193] = 1;
        byArray[194] = 1;
        byArray[195] = 1;
        byArray[196] = 1;
        byArray[197] = 1;
        byArray[198] = 1;
        byArray[199] = 1;
        byArray[200] = 1;
        byArray[201] = 1;
        byArray[202] = 1;
        byArray[203] = 1;
        byArray[204] = 1;
        byArray[205] = 1;
        byArray[206] = 1;
        byArray[207] = 1;
        byArray[209] = 1;
        byArray[210] = 1;
        byArray[211] = 1;
        byArray[212] = 1;
        byArray[213] = 1;
        byArray[214] = 1;
        byArray[216] = 1;
        byArray[217] = 1;
        byArray[218] = 1;
        byArray[219] = 1;
        byArray[220] = 1;
        byArray[223] = 1;
        byArray[224] = 1;
        byArray[225] = 1;
        byArray[226] = 1;
        byArray[227] = 1;
        byArray[228] = 1;
        byArray[229] = 1;
        byArray[230] = 1;
        byArray[231] = 1;
        byArray[232] = 1;
        byArray[233] = 1;
        byArray[234] = 1;
        byArray[235] = 1;
        byArray[236] = 1;
        byArray[237] = 1;
        byArray[238] = 1;
        byArray[239] = 1;
        byArray[241] = 1;
        byArray[242] = 1;
        byArray[243] = 1;
        byArray[244] = 1;
        byArray[245] = 1;
        byArray[246] = 1;
        byArray[248] = 1;
        byArray[249] = 1;
        byArray[250] = 1;
        byArray[251] = 1;
        byArray[252] = 1;
        byArray[255] = 1;
        IDL_IDENTIFIER_CHARS = byArray;
        defaultServerURL = null;
        if (defaultServerURL == null) {
            defaultServerURL = JDKBridge.getLocalCodebase();
        }
        useCodebaseOnly = JDKBridge.useCodebaseOnly();
        classToRepStr = new IdentityHashtable();
        classIDLToRepStr = new IdentityHashtable();
        classSeqToRepStr = new IdentityHashtable();
        repStrToByteArray = new IdentityHashtable();
        repStrToClass = new Hashtable();
        kValuePrefixLength = kValuePrefix.length();
        kIDLPrefixLength = kIDLPrefix.length();
        kSequencePrefixLength = kSequencePrefix.length();
        kPreComputed_StandardRMIUnchunked = RepositoryId.computeValueTag(false, 2, false);
        kPreComputed_CodeBaseRMIUnchunked = RepositoryId.computeValueTag(true, 2, false);
        kPreComputed_StandardRMIChunked = RepositoryId.computeValueTag(false, 2, true);
        kPreComputed_CodeBaseRMIChunked = RepositoryId.computeValueTag(true, 2, true);
        kPreComputed_StandardRMIUnchunked_NoRep = RepositoryId.computeValueTag(false, 0, false);
        kPreComputed_CodeBaseRMIUnchunked_NoRep = RepositoryId.computeValueTag(true, 0, false);
        kPreComputed_StandardRMIChunked_NoRep = RepositoryId.computeValueTag(false, 0, true);
        kPreComputed_CodeBaseRMIChunked_NoRep = RepositoryId.computeValueTag(true, 0, true);
        kClassDescValueHash = RepositoryId.createHashString(class$javax$rmi$CORBA$ClassDesc != null ? class$javax$rmi$CORBA$ClassDesc : (class$javax$rmi$CORBA$ClassDesc = RepositoryId.class$(kClassDescTypeStr)), false);
        kClassDescValueRepID = "RMI:javax.rmi.CORBA.ClassDesc" + kClassDescValueHash;
        kSpecialArrayTypeStrings = new Hashtable();
        kSpecialArrayTypeStrings.put("CORBA.WStringValue", new StringBuffer((class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = RepositoryId.class$("java.lang.String"))).getName()));
        kSpecialArrayTypeStrings.put(kClassDescTypeStr, new StringBuffer((class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = RepositoryId.class$("java.lang.Class"))).getName()));
        kSpecialArrayTypeStrings.put("CORBA.Object", new StringBuffer((class$java$rmi$Remote != null ? class$java$rmi$Remote : (class$java$rmi$Remote = RepositoryId.class$("java.rmi.Remote"))).getName()));
        kSpecialCasesRepIDs = new Hashtable();
        kSpecialCasesRepIDs.put(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = RepositoryId.class$("java.lang.String")), kWStringValueRepID);
        kSpecialCasesRepIDs.put(class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = RepositoryId.class$("java.lang.Class")), kClassDescValueRepID);
        kSpecialCasesRepIDs.put(class$java$rmi$Remote != null ? class$java$rmi$Remote : (class$java$rmi$Remote = RepositoryId.class$("java.rmi.Remote")), "");
        kSpecialCasesStubValues = new Hashtable();
        kSpecialCasesStubValues.put(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = RepositoryId.class$("java.lang.String")), kWStringStubValue);
        kSpecialCasesStubValues.put(class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = RepositoryId.class$("java.lang.Class")), kClassDescStubValue);
        kSpecialCasesStubValues.put(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = RepositoryId.class$("java.lang.Object")), kObjectStubValue);
        kSpecialCasesStubValues.put(class$java$io$Serializable != null ? class$java$io$Serializable : (class$java$io$Serializable = RepositoryId.class$("java.io.Serializable")), kSerializableStubValue);
        kSpecialCasesStubValues.put(class$java$io$Externalizable != null ? class$java$io$Externalizable : (class$java$io$Externalizable = RepositoryId.class$("java.io.Externalizable")), kExternalizableStubValue);
        kSpecialCasesStubValues.put(class$java$rmi$Remote != null ? class$java$rmi$Remote : (class$java$rmi$Remote = RepositoryId.class$("java.rmi.Remote")), "");
        kSpecialCasesVersions = new Hashtable();
        kSpecialCasesVersions.put(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = RepositoryId.class$("java.lang.String")), ":1.0");
        kSpecialCasesVersions.put(class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = RepositoryId.class$("java.lang.Class")), kClassDescValueHash);
        kSpecialCasesVersions.put(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = RepositoryId.class$("java.lang.Object")), ":1.0");
        kSpecialCasesVersions.put(class$java$io$Serializable != null ? class$java$io$Serializable : (class$java$io$Serializable = RepositoryId.class$("java.io.Serializable")), ":1.0");
        kSpecialCasesVersions.put(class$java$io$Externalizable != null ? class$java$io$Externalizable : (class$java$io$Externalizable = RepositoryId.class$("java.io.Externalizable")), ":1.0");
        kSpecialCasesVersions.put(class$java$rmi$Remote != null ? class$java$rmi$Remote : (class$java$rmi$Remote = RepositoryId.class$("java.rmi.Remote")), "");
        kSpecialCasesClasses = new Hashtable();
        kSpecialCasesClasses.put(kWStringTypeStr, class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = RepositoryId.class$("java.lang.String")));
        kSpecialCasesClasses.put(kClassDescTypeStr, class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = RepositoryId.class$("java.lang.Class")));
        kSpecialCasesClasses.put("", class$java$rmi$Remote != null ? class$java$rmi$Remote : (class$java$rmi$Remote = RepositoryId.class$("java.rmi.Remote")));
        kSpecialCasesClasses.put("java.lang.String", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = RepositoryId.class$("java.lang.String")));
        kSpecialCasesArrayPrefix = new Hashtable();
        kSpecialCasesArrayPrefix.put(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = RepositoryId.class$("java.lang.String")), kArrayPrefix);
        kSpecialCasesArrayPrefix.put(class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = RepositoryId.class$("java.lang.Class")), "RMI:[javax/rmi/CORBA/");
        kSpecialCasesArrayPrefix.put(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = RepositoryId.class$("java.lang.Object")), "RMI:[java/lang/");
        kSpecialCasesArrayPrefix.put(class$java$io$Serializable != null ? class$java$io$Serializable : (class$java$io$Serializable = RepositoryId.class$("java.io.Serializable")), "RMI:[java/io/");
        kSpecialCasesArrayPrefix.put(class$java$io$Externalizable != null ? class$java$io$Externalizable : (class$java$io$Externalizable = RepositoryId.class$("java.io.Externalizable")), "RMI:[java/io/");
        kSpecialCasesArrayPrefix.put(class$java$rmi$Remote != null ? class$java$rmi$Remote : (class$java$rmi$Remote = RepositoryId.class$("java.rmi.Remote")), kArrayPrefix);
        kSpecialPrimitives = new Hashtable();
        kSpecialPrimitives.put("int", "long");
        kSpecialPrimitives.put("long", "longlong");
        kSpecialPrimitives.put("byte", "octet");
        ASCII_HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        cache = new RepositoryIdCache();
        kjava_rmi_Remote = RepositoryId.createForAnyType(class$java$rmi$Remote != null ? class$java$rmi$Remote : (class$java$rmi$Remote = RepositoryId.class$("java.rmi.Remote")));
        korg_omg_CORBA_Object = RepositoryId.createForAnyType(class$org$omg$CORBA$Object != null ? class$org$omg$CORBA$Object : (class$org$omg$CORBA$Object = RepositoryId.class$("org.omg.CORBA.Object")));
        kNoParamTypes = new Class[0];
        kNoArgs = new Object[0];
    }
}

