/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.security;

import com.ibm.security12.java.security.BasicPermissionCollection;
import com.ibm.security12.java.security.Permission;
import com.ibm.security12.java.security.PermissionCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public abstract class BasicPermission
extends Permission
implements Serializable {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private transient boolean wildcard;
    private transient String path;

    private void init(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name can't be null");
        }
        if (string.endsWith(".*") || string.equals("*")) {
            this.wildcard = true;
            if (string.length() == 1) {
                this.path = "";
                return;
            }
            this.path = string.substring(0, string.length() - 1);
            return;
        }
        this.path = string;
    }

    public BasicPermission(String string) {
        super(string);
        this.init(string);
    }

    public BasicPermission(String string, String string2) {
        super(string);
        this.init(string);
    }

    public boolean implies(Permission permission) {
        if (permission == null || permission.getClass() != this.getClass()) {
            return false;
        }
        BasicPermission basicPermission = (BasicPermission)permission;
        if (this.wildcard) {
            if (basicPermission.wildcard) {
                return basicPermission.path.startsWith(this.path);
            }
            return basicPermission.path.length() > this.path.length() && basicPermission.path.startsWith(this.path);
        }
        if (basicPermission.wildcard) {
            return false;
        }
        return this.path.equals(basicPermission.path);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        BasicPermission basicPermission = (BasicPermission)object;
        return this.getName().equals(basicPermission.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return new BasicPermissionCollection();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName());
    }
}

