/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.security;

import com.ibm.security12.java.security.InvalidAlgorithmParameterException;
import com.ibm.security12.java.security.KeyPair;
import com.ibm.security12.java.security.KeyPairGeneratorSpi;
import com.ibm.security12.java.security.Provider;
import com.ibm.security12.java.security.SecureRandom;
import com.ibm.security12.java.security.Security;
import com.ibm.security12.java.security.spec.AlgorithmParameterSpec;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public abstract class KeyPairGenerator
extends KeyPairGeneratorSpi {
    private String algorithm;
    private Provider provider;

    protected KeyPairGenerator(String string) {
        this.algorithm = string;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static KeyPairGenerator getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = Security.getImpl(string, "KeyPairGenerator", null);
            if (objectArray[0] instanceof KeyPairGenerator) {
                KeyPairGenerator keyPairGenerator = (KeyPairGenerator)objectArray[0];
                keyPairGenerator.provider = (Provider)objectArray[1];
                return keyPairGenerator;
            }
            Delegate delegate = new Delegate((KeyPairGeneratorSpi)objectArray[0], string);
            delegate.provider = (Provider)objectArray[1];
            return delegate;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
        }
    }

    public static KeyPairGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = Security.getImpl(string, "KeyPairGenerator", string2);
        if (objectArray[0] instanceof KeyPairGenerator) {
            KeyPairGenerator keyPairGenerator = (KeyPairGenerator)objectArray[0];
            keyPairGenerator.provider = (Provider)objectArray[1];
            return keyPairGenerator;
        }
        Delegate delegate = new Delegate((KeyPairGeneratorSpi)objectArray[0], string);
        delegate.provider = (Provider)objectArray[1];
        return delegate;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void initialize(int n) {
        this.initialize(n, new SecureRandom());
    }

    public void initialize(int n, SecureRandom secureRandom) {
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.initialize(algorithmParameterSpec, new SecureRandom());
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
    }

    public final KeyPair genKeyPair() {
        return this.generateKeyPair();
    }

    static class Delegate
    extends KeyPairGenerator {
        private KeyPairGeneratorSpi kpairGenSpi;

        public Delegate(KeyPairGeneratorSpi keyPairGeneratorSpi, String string) {
            super(string);
            this.kpairGenSpi = keyPairGeneratorSpi;
        }

        public void initialize(int n, SecureRandom secureRandom) {
            this.kpairGenSpi.initialize(n, secureRandom);
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            this.kpairGenSpi.initialize(algorithmParameterSpec, secureRandom);
        }

        public KeyPair generateKeyPair() {
            return this.kpairGenSpi.generateKeyPair();
        }
    }
}

