/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.security;

import com.ibm.security12.java.lang.SecurityManager12;
import com.ibm.security12.java.security.AccessController;
import com.ibm.security12.java.security.Identity;
import com.ibm.security12.java.security.IdentityScope;
import com.ibm.security12.java.security.KeyPair;
import com.ibm.security12.java.security.PrivilegedActionException;
import com.ibm.security12.java.security.PrivilegedExceptionAction;
import java.security.InvalidParameterException;
import java.security.KeyException;
import java.security.KeyManagementException;
import java.security.PrivateKey;
import java.security.PublicKey;

public abstract class Signer
extends Identity {
    private PrivateKey privateKey;

    protected Signer() {
    }

    public Signer(String string) {
        super(string);
    }

    public Signer(String string, IdentityScope identityScope) throws KeyManagementException {
        super(string, identityScope);
    }

    public PrivateKey getPrivateKey() {
        Signer.check("getSignerPrivateKey");
        return this.privateKey;
    }

    public final void setKeyPair(KeyPair keyPair) throws InvalidParameterException, KeyException {
        Signer.check("setSignerKeyPair");
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        if (publicKey == null || privateKey == null) {
            throw new InvalidParameterException();
        }
        try {
            AccessController.doPrivileged(new 1(publicKey, this));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (KeyManagementException)privilegedActionException.getException();
        }
        this.privateKey = privateKey;
    }

    String printKeys() {
        String string = "";
        PublicKey publicKey = this.getPublicKey();
        string = publicKey != null && this.privateKey != null ? "\tpublic and private keys initialized" : "\tno keys";
        return string;
    }

    public String toString() {
        return "[Signer]" + super.toString();
    }

    private static void check(String string) {
        SecurityManager12 securityManager12 = (SecurityManager12)System.getSecurityManager();
        if (securityManager12 != null) {
            securityManager12.checkSecurityAccess(string);
        }
    }

    private static final class 1
    implements PrivilegedExceptionAction {
        private final /* synthetic */ Signer this$0;
        private final /* synthetic */ PublicKey val$pub;

        public Object run() throws KeyManagementException {
            this.this$0.setPublicKey(this.val$pub);
            return null;
        }

        /* synthetic */ 1(PublicKey publicKey, Signer signer) {
            this.val$pub = publicKey;
            this.this$0 = signer;
        }
    }
}

