/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.security.cert;

import com.ibm.security12.java.security.cert.CRL;
import com.ibm.security12.java.security.cert.CRLException;
import com.ibm.security12.java.security.cert.X509CRLEntry;
import com.ibm.security12.java.security.cert.X509Extension;
import com.ibm.security12.java.util.Set;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Date;

public abstract class X509CRL
extends CRL
implements X509Extension {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";

    protected X509CRL() {
        super("X.509");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CRL)) {
            return false;
        }
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = ((X509CRL)object).getEncoded();
            if (byArray.length != byArray2.length) {
                return false;
            }
            int n = 0;
            while (n < byArray.length) {
                if (byArray[n] != byArray2[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        catch (CRLException cRLException) {
            return false;
        }
    }

    public int hashCode() {
        int n = 0;
        try {
            byte[] byArray = this.getEncoded();
            int n2 = 1;
            while (n2 < byArray.length) {
                n += byArray[n2] * n2;
                ++n2;
            }
            return n;
        }
        catch (CRLException cRLException) {
            return n;
        }
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract void verify(PublicKey var1) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract int getVersion();

    public abstract Principal getIssuerDN();

    public abstract Date getThisUpdate();

    public abstract Date getNextUpdate();

    public abstract X509CRLEntry getRevokedCertificate(BigInteger var1);

    public abstract Set getRevokedCertificates();

    public abstract byte[] getTBSCertList() throws CRLException;

    public abstract byte[] getSignature();

    public abstract String getSigAlgName();

    public abstract String getSigAlgOID();

    public abstract byte[] getSigAlgParams();

    public abstract boolean hasUnsupportedCriticalExtension();

    public abstract Set getCriticalExtensionOIDs();

    public abstract Set getNonCriticalExtensionOIDs();

    public abstract byte[] getExtensionValue(String var1);
}

