/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.util.zip;

import com.ibm.security12.java.util.ArrayList;
import com.ibm.security12.java.util.HashMap;
import com.ibm.security12.java.util.Map;
import com.ibm.security12.java.util.zip.Inflater;
import com.ibm.security12.java.util.zip.InflaterInputStream;
import com.ibm.security12.java.util.zip.ZipConstants;
import com.ibm.security12.java.util.zip.ZipEntry;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.zip.ZipException;

public class ZipFile
implements ZipConstants {
    private RandomAccessFile raf;
    private String name;
    private ZipEntry[] entries;
    private Map emap;
    private long cenpos;
    private long endpos;
    private long pos;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    private ArrayList inflaters = new ArrayList();
    private static final int INBUFSIZ = 64;

    protected ZipFile() {
    }

    public ZipFile(String string) throws IOException {
        this.raf = new RandomAccessFile(string, "r");
        this.name = string;
        try {
            this.readCEN();
            return;
        }
        catch (IOException iOException) {
            try {
                this.raf.close();
            }
            catch (IOException iOException2) {}
            throw iOException;
        }
    }

    public ZipFile(File file) throws ZipException, IOException {
        this(file.getPath());
    }

    public ZipEntry getEntry(String string) {
        return (ZipEntry)this.emap.get(string);
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        if (zipEntry == null) {
            throw new NullPointerException();
        }
        ZipFileInputStream zipFileInputStream = new ZipFileInputStream(zipEntry);
        switch (zipEntry.method) {
            case 0: {
                return zipFileInputStream;
            }
            case 8: {
                return new 1(zipFileInputStream, this.getInflater());
            }
        }
        throw new ZipException("invalid compression method");
    }

    private Inflater getInflater() {
        ArrayList arrayList = this.inflaters;
        synchronized (arrayList) {
            int n = this.inflaters.size();
            if (n > 0) {
                Inflater inflater = (Inflater)this.inflaters.remove(n - 1);
                inflater.reset();
                Inflater inflater2 = inflater;
                Object var3_6 = null;
                return inflater2;
            }
            Inflater inflater = new Inflater(true);
            Object var3_7 = null;
            return inflater;
        }
    }

    private void releaseInflater(Inflater inflater) {
        ArrayList arrayList = this.inflaters;
        synchronized (arrayList) {
            this.inflaters.add(inflater);
            return;
        }
    }

    public String getName() {
        return this.name;
    }

    public Enumeration entries() {
        ZipEntry[] zipEntryArray = this.entries;
        return new 2(zipEntryArray);
    }

    public int size() {
        return this.entries.length;
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
        }
        ArrayList arrayList = this.inflaters;
        synchronized (arrayList) {
            int n = this.inflaters.size();
            int n2 = 0;
            while (n2 < n) {
                Inflater inflater = (Inflater)this.inflaters.get(n2);
                inflater.end();
                ++n2;
            }
            return;
        }
    }

    synchronized int read(long l, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (l != this.pos) {
            this.raf.seek(l);
        }
        if ((n3 = this.raf.read(byArray, n, n2)) > 0) {
            this.pos = l + (long)n3;
        }
        return n3;
    }

    synchronized int read(long l) throws IOException {
        int n;
        if (l != this.pos) {
            this.raf.seek(l);
        }
        if ((n = this.raf.read()) > 0) {
            this.pos = l + 1L;
        }
        return n;
    }

    private void readCEN() throws IOException {
        this.findEND();
        byte[] byArray = new byte[22];
        this.raf.readFully(byArray);
        if (ZipFile.get32(byArray, 0) != 101010256L) {
            throw new ZipException("invalid END header signature");
        }
        this.cenpos = ZipFile.get32(byArray, 16);
        int n = (int)ZipFile.get32(byArray, 12);
        if (this.cenpos + (long)n != this.endpos) {
            throw new ZipException("invalid END header format");
        }
        int n2 = ZipFile.get16(byArray, 10);
        if (n2 * 46 > n) {
            throw new ZipException("invalid END header format");
        }
        if (ZipFile.get16(byArray, 8) != n2) {
            throw new ZipException("cannot have more than one drive");
        }
        this.raf.seek(this.cenpos);
        byte[] byArray2 = new byte[n];
        this.raf.readFully(byArray2);
        this.entries = new ZipEntry[n2];
        this.emap = new HashMap(n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = n4;
            if (ZipFile.get32(byArray2, n5) != 33639248L) {
                throw new ZipException("invalid CEN header signature");
            }
            int n6 = ZipFile.get16(byArray2, n5 + 28);
            if (n6 == 0 || (n4 += 46) + n6 > n) {
                throw new ZipException("invalid CEN entry name");
            }
            String string = ZipFile.getUTF8String(byArray2, n4, n6);
            n4 += n6;
            ZipEntry zipEntry = this.createZipEntry(string);
            zipEntry.version = ZipFile.get16(byArray2, n5 + 6);
            zipEntry.flag = ZipFile.get16(byArray2, n5 + 8);
            zipEntry.method = ZipFile.get16(byArray2, n5 + 10);
            zipEntry.time = ZipFile.get32(byArray2, n5 + 12);
            zipEntry.crc = ZipFile.get32(byArray2, n5 + 16);
            zipEntry.size = ZipFile.get32(byArray2, n5 + 24);
            zipEntry.csize = ZipFile.get32(byArray2, n5 + 20);
            zipEntry.offset = ZipFile.get32(byArray2, n5 + 42);
            if (zipEntry.offset + zipEntry.csize > this.cenpos) {
                throw new ZipException("invalid CEN entry size");
            }
            n6 = ZipFile.get16(byArray2, n5 + 30);
            if (n6 > 0) {
                if (n4 + n6 > n) {
                    throw new ZipException("invalid CEN entry extra data");
                }
                zipEntry.extra = new byte[n6];
                System.arraycopy(byArray2, n4, zipEntry.extra, 0, n6);
                n4 += n6;
            }
            if ((n6 = ZipFile.get16(byArray2, n5 + 32)) > 0) {
                if (n4 + n6 > n) {
                    throw new ZipException("invalid CEN entry comment");
                }
                zipEntry.comment = ZipFile.getUTF8String(byArray2, n4, n6);
                n4 += n6;
            }
            this.entries[n3++] = zipEntry;
            this.emap.put(zipEntry.name, zipEntry);
        }
        if (n3 != n2) {
            throw new ZipException("invalid CEN header format");
        }
    }

    protected ZipEntry createZipEntry(String string) {
        return new ZipEntry(string);
    }

    private void findEND() throws IOException {
        long l = this.raf.length();
        this.raf.seek(l);
        long l2 = Math.max(0L, l - 65535L);
        byte[] byArray = new byte[68];
        this.pos = l;
        while (this.pos > l2) {
            int n = Math.min((int)(this.pos - l2), 64);
            this.pos -= (long)n;
            this.raf.seek(this.pos);
            this.raf.readFully(byArray, 0, n);
            while (--n > 0) {
                if (ZipFile.get32(byArray, n) != 101010256L) continue;
                this.endpos = this.pos + (long)n;
                if (l - this.endpos < 22L) continue;
                this.raf.seek(this.endpos);
                byte[] byArray2 = new byte[22];
                this.raf.readFully(byArray2);
                int n2 = ZipFile.get16(byArray2, 20);
                if (this.endpos + 22L + (long)n2 != l) continue;
                this.raf.seek(this.endpos);
                this.pos = this.endpos;
                return;
            }
        }
        throw new ZipException("not a ZIP file (END header not found)");
    }

    static final int get16(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    static final long get32(byte[] byArray, int n) {
        return (long)(byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24) & 0xFFFFFFFFL;
    }

    static final String getUTF8String(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n + n2;
        int n5 = n;
        while (n5 < n4) {
            int n6 = byArray[n5++] & 0xFF;
            switch (n6 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n3;
                    break;
                }
                case 12: 
                case 13: {
                    if ((byArray[n5++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++n3;
                    break;
                }
                case 14: {
                    if ((byArray[n5++] & 0xC0) != 128 || (byArray[n5++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++n3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        if (n5 != n4) {
            throw new IllegalArgumentException();
        }
        char[] cArray = new char[n3];
        n5 = 0;
        while (n < n4) {
            int n7 = byArray[n++] & 0xFF;
            switch (n7 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n5++] = (char)n7;
                    break;
                }
                case 12: 
                case 13: {
                    cArray[n5++] = (char)((n7 & 0x1F) << 6 | byArray[n++] & 0x3F);
                    break;
                }
                case 14: {
                    int n8 = (byArray[n++] & 0x3F) << 6;
                    cArray[n5++] = (char)((n7 & 0xF) << 12 | n8 | byArray[n++] & 0x3F);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return new String(cArray, 0, n3);
    }

    private final class 1
    extends InflaterInputStream {
        private boolean eof;

        public void close() {
            ZipFile.this.releaseInflater(this.inf);
        }

        protected void fill() throws IOException {
            if (this.eof) {
                throw new EOFException("Unexpected end of ZLIB input stream");
            }
            this.len = this.in.read(this.buf, 0, this.buf.length);
            if (this.len == -1) {
                this.buf[0] = 0;
                this.len = 1;
                this.eof = true;
            }
            this.inf.setInput(this.buf, 0, this.len);
        }

        /* synthetic */ 1(InputStream inputStream, Inflater inflater) {
            super(inputStream, inflater);
        }
    }

    private static final class 2
    implements Enumeration {
        private final /* synthetic */ ZipEntry[] val$entries;
        private int i;

        public boolean hasMoreElements() {
            return this.i < this.val$entries.length;
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.i >= this.val$entries.length) {
                throw new NoSuchElementException();
            }
            return this.val$entries[this.i++];
        }

        /* synthetic */ 2(ZipEntry[] zipEntryArray) {
            this.val$entries = zipEntryArray;
        }
    }

    private class ZipFileInputStream
    extends InputStream {
        private ZipEntry entry;
        private long pos;
        private long rem;

        ZipFileInputStream(ZipEntry zipEntry) throws IOException {
            ZipFile.this = ZipFile.this;
            this.entry = zipEntry;
            this.readLOC();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.rem <= 0L) {
                return -1;
            }
            if ((long)n2 > this.rem) {
                n2 = (int)Math.min(this.rem, Integer.MAX_VALUE);
            }
            if ((n2 = ZipFile.this.read(this.pos, byArray, n, n2)) == -1) {
                throw new ZipException("premature EOF");
            }
            this.pos += (long)n2;
            this.rem -= (long)n2;
            return n2;
        }

        public int read() throws IOException {
            if (this.rem <= 0L) {
                return -1;
            }
            int n = ZipFile.this.read(this.pos);
            if (n == -1) {
                throw new ZipException("premature EOF");
            }
            ++this.pos;
            --this.rem;
            return n;
        }

        public long skip(long l) {
            if (l > this.rem) {
                l = this.rem;
            }
            this.pos += l;
            this.rem -= l;
            return l;
        }

        public int available() {
            return (int)Math.min(this.rem, Integer.MAX_VALUE);
        }

        private void readLOC() throws IOException {
            byte[] byArray = new byte[30];
            ZipFile.this.read(this.entry.offset, byArray, 0, 30);
            if (ZipFile.get32(byArray, 0) != 67324752L) {
                throw new ZipException("invalid LOC header signature");
            }
            this.rem = this.entry.csize;
            this.pos = this.entry.offset + 30L + (long)ZipFile.get16(byArray, 26) + (long)ZipFile.get16(byArray, 28);
            if (this.pos + this.rem > ZipFile.this.cenpos) {
                throw new ZipException("invalid LOC header format");
            }
        }
    }
}

