/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.pkcs;

import com.ibm.security12.java.lang.ClassLoader12;
import com.ibm.security12.java.security.KeyFactory;
import com.ibm.security12.java.security.Security;
import com.ibm.security12.java.security.spec.InvalidKeySpecException;
import com.ibm.security12.java.security.spec.PKCS8EncodedKeySpec;
import com.ibm.security12.sun.security.util.BigInt;
import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import sun.misc.HexDumpEncoder;

public class PKCS8Key
implements PrivateKey {
    private static final long serialVersionUID = -3836890099307167124L;
    protected AlgorithmId algid;
    protected byte[] key;
    protected byte[] encodedKey;
    public static final BigInteger version = BigInteger.valueOf(0L);

    public PKCS8Key() {
    }

    private PKCS8Key(AlgorithmId algorithmId, byte[] byArray) throws InvalidKeyException {
        this.algid = algorithmId;
        this.key = byArray;
        this.encode();
    }

    public static PKCS8Key parse(DerValue derValue) throws IOException {
        PrivateKey privateKey = PKCS8Key.parseKey(derValue);
        if (privateKey instanceof PKCS8Key) {
            return (PKCS8Key)privateKey;
        }
        throw new IOException("Provider did not return PKCS8Key");
    }

    public static PrivateKey parseKey(DerValue derValue) throws IOException {
        PrivateKey privateKey;
        if (derValue.tag != 48) {
            throw new IOException("corrupt private key");
        }
        BigInteger bigInteger = derValue.data.getInteger().toBigInteger();
        if (!version.equals(bigInteger)) {
            throw new IOException("version mismatch: (supported: " + version + ", parsed: " + bigInteger);
        }
        AlgorithmId algorithmId = AlgorithmId.parse(derValue.data.getDerValue());
        try {
            privateKey = PKCS8Key.buildPKCS8Key(algorithmId, derValue.data.getOctetString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("corrupt private key");
        }
        if (derValue.data.available() != 0) {
            throw new IOException("excess private key");
        }
        return privateKey;
    }

    protected void parseKeyBits() throws IOException, InvalidKeyException {
        this.encode();
    }

    static PrivateKey buildPKCS8Key(AlgorithmId algorithmId, byte[] byArray) throws IOException, InvalidKeyException {
        Serializable serializable;
        DerOutputStream derOutputStream = new DerOutputStream();
        PKCS8Key.encode(derOutputStream, algorithmId, byArray);
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(derOutputStream.toByteArray());
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithmId.getName());
            return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {}
        String string = "";
        try {
            ClassLoader12 classLoader12;
            Class clazz;
            block14: {
                serializable = Security.getProvider("SUN");
                if (serializable == null) {
                    throw new InstantiationException();
                }
                string = serializable.getProperty("PrivateKey.PKCS#8." + algorithmId.getName());
                if (string == null) {
                    throw new InstantiationException();
                }
                clazz = null;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classLoader12 = ClassLoader12.getSystemClassLoader();
                    if (classLoader12 == null) break block14;
                    clazz = classLoader12.loadClass(string);
                }
            }
            classLoader12 = null;
            if (clazz != null) {
                classLoader12 = clazz.newInstance();
            }
            if (classLoader12 instanceof PKCS8Key) {
                PKCS8Key pKCS8Key = (PKCS8Key)((Object)classLoader12);
                pKCS8Key.algid = algorithmId;
                pKCS8Key.key = byArray;
                pKCS8Key.parseKeyBits();
                return pKCS8Key;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException(String.valueOf(string) + " [internal error]");
        }
        serializable = new PKCS8Key();
        ((PKCS8Key)serializable).algid = algorithmId;
        ((PKCS8Key)serializable).key = byArray;
        return serializable;
    }

    public String getAlgorithm() {
        return this.algid.getName();
    }

    public AlgorithmId getAlgorithmId() {
        return this.algid;
    }

    public final void encode(DerOutputStream derOutputStream) throws IOException {
        PKCS8Key.encode(derOutputStream, this.algid, this.key);
    }

    public synchronized byte[] getEncoded() {
        byte[] byArray = null;
        try {
            byArray = this.encode();
        }
        catch (InvalidKeyException invalidKeyException) {}
        return byArray;
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] encode() throws InvalidKeyException {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.encodedKey = derOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("IOException : " + iOException.getMessage());
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        return "algorithm = " + this.algid.toString() + ", unparsed keybits = \n" + hexDumpEncoder.encodeBuffer(this.key);
    }

    public void decode(InputStream inputStream) throws InvalidKeyException {
        try {
            DerValue derValue = new DerValue(inputStream);
            if (derValue.tag != 48) {
                throw new InvalidKeyException("invalid key format");
            }
            BigInteger bigInteger = derValue.data.getInteger().toBigInteger();
            if (!bigInteger.equals(version)) {
                throw new IOException("version mismatch: (supported: " + version + ", parsed: " + bigInteger);
            }
            this.algid = AlgorithmId.parse(derValue.data.getDerValue());
            this.key = derValue.data.getOctetString();
            this.parseKeyBits();
            if (derValue.data.available() != 0) {
                throw new InvalidKeyException("excess key data");
            }
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("IOException : " + iOException.getMessage());
        }
    }

    public void decode(byte[] byArray) throws InvalidKeyException {
        this.decode(new ByteArrayInputStream(byArray));
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.getEncoded());
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.decode(objectInputStream);
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
            throw new IOException("deserialized key is invalid: " + invalidKeyException.getMessage());
        }
    }

    static void encode(DerOutputStream derOutputStream, AlgorithmId algorithmId, byte[] byArray) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(new BigInt(version.toByteArray()));
        algorithmId.encode(derOutputStream2);
        derOutputStream2.putOctetString(byArray);
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Key) {
            byte[] byArray;
            byte[] byArray2 = this.encodedKey != null ? this.encodedKey : this.getEncoded();
            if (byArray2.length != (byArray = ((Key)object).getEncoded()).length) {
                return false;
            }
            int n = 0;
            while (n < byArray2.length) {
                if (byArray2[n] != byArray[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        byte[] byArray = this.getEncoded();
        int n2 = 1;
        while (n2 < byArray.length) {
            n += byArray[n2] * n2;
            ++n2;
        }
        return n;
    }
}

