/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.provider;

import com.ibm.security12.java.security.AlgorithmParametersSpi;
import com.ibm.security12.java.security.spec.AlgorithmParameterSpec;
import com.ibm.security12.java.security.spec.DSAParameterSpec;
import com.ibm.security12.java.security.spec.InvalidParameterSpecException;
import com.ibm.security12.sun.security.util.BigInt;
import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class DSAParameters
extends AlgorithmParametersSpi {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    protected BigInteger p;
    protected BigInteger q;
    protected BigInteger g;

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.p = ((DSAParameterSpec)algorithmParameterSpec).getP();
        this.q = ((DSAParameterSpec)algorithmParameterSpec).getQ();
        this.g = ((DSAParameterSpec)algorithmParameterSpec).getG();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag != 48) {
            throw new IOException("DSA params parsing error");
        }
        derValue.data.reset();
        this.p = derValue.data.getInteger().toBigInteger();
        this.q = derValue.data.getInteger().toBigInteger();
        this.g = derValue.data.getInteger().toBigInteger();
        if (derValue.data.available() != 0) {
            throw new IOException("encoded params have " + derValue.data.available() + " extra bytes");
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        try {
            Class<?> clazz2 = Class.forName("com.ibm.security12.java.security.spec.DSAParameterSpec");
            if (clazz2.isAssignableFrom(clazz)) {
                return new DSAParameterSpec(this.p, this.q, this.g);
            }
            throw new InvalidParameterSpecException("Inappropriate parameter Specification");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + classNotFoundException.getMessage());
        }
    }

    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(new BigInt(this.p.toByteArray()));
        derOutputStream2.putInteger(new BigInt(this.q.toByteArray()));
        derOutputStream2.putInteger(new BigInt(this.g.toByteArray()));
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        return "\n\tp: " + new BigInt(this.p).toString() + "\n\tq: " + new BigInt(this.q).toString() + "\n\tg: " + new BigInt(this.g).toString() + "\n";
    }
}

