/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.provider;

import com.ibm.security12.java.io.File12;
import com.ibm.security12.java.net.SocketPermission;
import com.ibm.security12.java.security.AccessController;
import com.ibm.security12.java.security.AllPermission;
import com.ibm.security12.java.security.CodeSource;
import com.ibm.security12.java.security.Identity;
import com.ibm.security12.java.security.IdentityScope;
import com.ibm.security12.java.security.KeyStore;
import com.ibm.security12.java.security.KeyStoreException;
import com.ibm.security12.java.security.Permission;
import com.ibm.security12.java.security.PermissionCollection;
import com.ibm.security12.java.security.Permissions;
import com.ibm.security12.java.security.Policy;
import com.ibm.security12.java.security.PrivilegedAction;
import com.ibm.security12.java.security.Security;
import com.ibm.security12.java.security.UnresolvedPermission;
import com.ibm.security12.java.security.cert.Certificate;
import com.ibm.security12.java.security.cert.X509Certificate;
import com.ibm.security12.java.util.ArrayList;
import com.ibm.security12.java.util.Hashtable;
import com.ibm.security12.java.util.PropertyPermission;
import com.ibm.security12.sun.security.provider.IdentityDatabase;
import com.ibm.security12.sun.security.provider.PolicyParser;
import com.ibm.security12.sun.security.provider.PolicyPermissions;
import com.ibm.security12.sun.security.provider.SystemIdentity;
import com.ibm.security12.sun.security.provider.SystemSigner;
import com.ibm.security12.sun.security.util.Debug;
import com.ibm.security12.sun.security.util.PropertyExpander;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class PolicyFile
extends Policy {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static final Debug debug = Debug.getInstance("policy");
    private Vector policyEntries;
    private Hashtable aliasMapping;
    private boolean initialized = false;
    private boolean expandProperties = true;
    private boolean ignoreIdentityScope = false;
    private static final Class[] PARAMS = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = PolicyFile.class$("java.lang.String")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = PolicyFile.class$("java.lang.String"))};
    private static IdentityScope scope = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$ibm$security12$sun$security$provider$PolicyFile;

    private synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.policyEntries = new Vector();
        this.aliasMapping = new Hashtable(11);
        AccessController.doPrivileged(new 1());
    }

    public synchronized void refresh() {
        this.initialized = false;
        this.init();
    }

    private KeyStore initKeyStore(URL uRL, String string, String string2) {
        if (string != null) {
            try {
                URL uRL2 = null;
                try {
                    uRL2 = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL2 = new URL(uRL, string);
                }
                if (debug != null) {
                    debug.println("reading keystore" + uRL2);
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getInputStream(uRL2));
                KeyStore keyStore = string2 != null ? KeyStore.getInstance(string2) : KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(bufferedInputStream, null);
                ((InputStream)bufferedInputStream).close();
                return keyStore;
            }
            catch (Exception exception) {
                if (debug != null) {
                    exception.printStackTrace();
                }
                return null;
            }
        }
        return null;
    }

    private void initPolicyFile() {
        Object object;
        boolean bl;
        String string;
        String string2;
        String string3;
        String string4 = Security.getProperty("policy.expandProperties");
        if (string4 != null) {
            this.expandProperties = string4.equalsIgnoreCase("true");
        }
        if ((string3 = Security.getProperty("policy.ignoreIdentityScope")) != null) {
            this.ignoreIdentityScope = string3.equalsIgnoreCase("true");
        }
        if ((string2 = Security.getProperty("policy.allowSystemProperty")) != null && string2.equalsIgnoreCase("true") && (string = System.getProperty("java.security.policy")) != null) {
            block14: {
                bl = false;
                if (string.startsWith("=")) {
                    bl = true;
                    string = string.substring(1);
                }
                try {
                    string = PropertyExpander.expand(string);
                    File file = new File(string);
                    object = file.exists() ? new URL("file:" + file.getCanonicalPath()) : new URL(string);
                    if (debug != null) {
                        debug.println("reading " + object);
                    }
                    this.init((URL)object);
                }
                catch (Exception exception) {
                    if (debug == null) break block14;
                    debug.println("caught exception: " + exception);
                }
            }
            if (bl) {
                if (debug != null) {
                    debug.println("overriding other policies!");
                }
                return;
            }
        }
        int n = 1;
        bl = false;
        while ((object = Security.getProperty("policy.url." + n)) != null) {
            block15: {
                try {
                    object = PropertyExpander.expand((String)object).replace(File.separatorChar, '/');
                    if (debug != null) {
                        debug.println("reading " + (String)object);
                    }
                    this.init(new URL((String)object));
                    bl = true;
                }
                catch (Exception exception) {
                    if (debug == null) break block15;
                    debug.println("error reading policy " + exception);
                    exception.printStackTrace();
                }
            }
            ++n;
        }
        if (!bl) {
            this.initStaticPolicy();
        }
    }

    private boolean checkForTrustedIdentity(Certificate certificate) {
        Certificate[] certificateArray;
        if (certificate == null) {
            return false;
        }
        if (this.ignoreIdentityScope) {
            return false;
        }
        if (scope == null) {
            Object object;
            if (class$com$ibm$security12$sun$security$provider$PolicyFile != null) {
                object = class$com$ibm$security12$sun$security$provider$PolicyFile;
            } else {
                class$com$ibm$security12$sun$security$provider$PolicyFile = PolicyFile.class$("com.ibm.security12.sun.security.provider.PolicyFile");
                object = class$com$ibm$security12$sun$security$provider$PolicyFile;
            }
            certificateArray = object;
            synchronized (certificateArray) {
                IdentityScope identityScope;
                if (scope == null && (identityScope = (IdentityScope)AccessController.doPrivileged(new 2())) instanceof IdentityDatabase) {
                    scope = identityScope;
                }
            }
        }
        if (scope == null) {
            this.ignoreIdentityScope = true;
            return false;
        }
        Identity identity = (Identity)AccessController.doPrivileged(new 3(certificate));
        if (this.isTrusted(identity)) {
            if (debug != null) {
                debug.println("Adding policy entry for trusted Identity: ");
                AccessController.doPrivileged(new 4(identity));
                debug.println("");
            }
            certificateArray = new Certificate[]{certificate};
            PolicyEntry policyEntry = new PolicyEntry(new CodeSource(null, certificateArray));
            policyEntry.add(new AllPermission());
            this.policyEntries.addElement(policyEntry);
            this.aliasMapping.put(certificate, identity.getName());
            return true;
        }
        return false;
    }

    private boolean isTrusted(Identity identity) {
        SystemSigner systemSigner;
        SystemIdentity systemIdentity;
        return identity instanceof SystemIdentity ? (systemIdentity = (SystemIdentity)identity).isTrusted() : identity instanceof SystemSigner && (systemSigner = (SystemSigner)identity).isTrusted();
    }

    private void initStaticPolicy() {
        PolicyEntry policyEntry = new PolicyEntry(new CodeSource(null, null));
        policyEntry.add(new SocketPermission("localhost:1024-", "listen"));
        policyEntry.add(new PropertyPermission("java.version", "read"));
        policyEntry.add(new PropertyPermission("java.vendor", "read"));
        policyEntry.add(new PropertyPermission("java.vendor.url", "read"));
        policyEntry.add(new PropertyPermission("java.class.version", "read"));
        policyEntry.add(new PropertyPermission("os.name", "read"));
        policyEntry.add(new PropertyPermission("os.version", "read"));
        policyEntry.add(new PropertyPermission("os.arch", "read"));
        policyEntry.add(new PropertyPermission("file.separator", "read"));
        policyEntry.add(new PropertyPermission("path.separator", "read"));
        policyEntry.add(new PropertyPermission("line.separator", "read"));
        policyEntry.add(new PropertyPermission("java.specification.version", "read"));
        policyEntry.add(new PropertyPermission("java.specification.vendor", "read"));
        policyEntry.add(new PropertyPermission("java.specification.name", "read"));
        policyEntry.add(new PropertyPermission("java.vm.specification.version", "read"));
        policyEntry.add(new PropertyPermission("java.vm.specification.vendor", "read"));
        policyEntry.add(new PropertyPermission("java.vm.specification.name", "read"));
        policyEntry.add(new PropertyPermission("java.vm.version", "read"));
        policyEntry.add(new PropertyPermission("java.vm.vendor", "read"));
        policyEntry.add(new PropertyPermission("java.vm.name", "read"));
        this.policyEntries.addElement(policyEntry);
        try {
            String string = PropertyExpander.expand("file:${java.home}/lib/ext/");
            policyEntry = new PolicyEntry(new CodeSource(new URL(string), null));
            policyEntry.add(new AllPermission());
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void init(URL uRL) {
        block5: {
            PolicyParser policyParser = new PolicyParser(this.expandProperties);
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.getInputStream(uRL));
                policyParser.read(inputStreamReader);
                inputStreamReader.close();
                KeyStore keyStore = this.initKeyStore(uRL, policyParser.getKeyStoreUrl(), policyParser.getKeyStoreType());
                Enumeration enumeration = policyParser.grantElements();
                while (enumeration.hasMoreElements()) {
                    PolicyParser.GrantEntry grantEntry = (PolicyParser.GrantEntry)enumeration.nextElement();
                    this.addGrantEntry(grantEntry, keyStore);
                }
                return;
            }
            catch (PolicyParser.ParsingException parsingException) {
                System.err.println("com.ibm.security12.java.security.Policy: error parsing " + uRL);
                System.err.println("com.ibm.security12.java.security.Policy: " + parsingException.getMessage());
                if (debug != null) {
                    parsingException.printStackTrace();
                    return;
                }
            }
            catch (Exception exception) {
                if (debug == null) break block5;
                debug.println("error parsing " + uRL);
                debug.println(exception.toString());
                exception.printStackTrace();
            }
        }
    }

    private InputStream getInputStream(URL uRL) throws IOException {
        if ("file".equals(uRL.getProtocol())) {
            String string = uRL.getFile().replace('/', File.separatorChar);
            return new FileInputStream(string);
        }
        return uRL.openStream();
    }

    CodeSource getCodeSource(PolicyParser.GrantEntry grantEntry, KeyStore keyStore) throws MalformedURLException {
        Certificate[] certificateArray = null;
        if (grantEntry.signedBy != null && (certificateArray = this.getCertificates(keyStore, grantEntry.signedBy)) == null) {
            if (debug != null) {
                debug.println(" no certs for alias " + grantEntry.signedBy + ", ignoring.");
            }
            return null;
        }
        URL uRL = grantEntry.codeBase != null ? new URL(grantEntry.codeBase) : null;
        return this.canonicalizeCodebase(new CodeSource(uRL, certificateArray), false);
    }

    private void addGrantEntry(PolicyParser.GrantEntry grantEntry, KeyStore keyStore) {
        if (debug != null) {
            debug.println("Adding policy entry: ");
            debug.println("  signedBy " + grantEntry.signedBy);
            debug.println("  codeBase " + grantEntry.codeBase);
            debug.println();
        }
        try {
            CodeSource codeSource = this.getCodeSource(grantEntry, keyStore);
            if (codeSource == null) {
                return;
            }
            PolicyEntry policyEntry = new PolicyEntry(codeSource);
            Enumeration enumeration = grantEntry.permissionElements();
            while (enumeration.hasMoreElements()) {
                Certificate[] certificateArray;
                PolicyParser.PermissionEntry permissionEntry = (PolicyParser.PermissionEntry)enumeration.nextElement();
                try {
                    certificateArray = PolicyFile.getInstance(permissionEntry.permission, permissionEntry.name, permissionEntry.action);
                    policyEntry.add((Permission)certificateArray);
                    if (debug == null) continue;
                    debug.println("  " + certificateArray);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    certificateArray = permissionEntry.signedBy != null ? this.getCertificates(keyStore, permissionEntry.signedBy) : null;
                    if (certificateArray == null && permissionEntry.signedBy != null) continue;
                    UnresolvedPermission unresolvedPermission = new UnresolvedPermission(permissionEntry.permission, permissionEntry.name, permissionEntry.action, certificateArray);
                    policyEntry.add(unresolvedPermission);
                    if (debug == null) continue;
                    debug.println("  " + unresolvedPermission);
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.err.println("com.ibm.security12.java.security.Policy: error adding Permission " + permissionEntry.permission + " " + invocationTargetException.getTargetException());
                }
                catch (Exception exception) {
                    System.err.println("com.ibm.security12.java.security.Policy: error adding Permission " + permissionEntry.permission + " " + exception);
                }
            }
            this.policyEntries.addElement(policyEntry);
        }
        catch (Exception exception) {
            System.err.println("com.ibm.security12.java.security.Policy: error adding Entry " + grantEntry + " " + exception);
        }
        if (debug != null) {
            debug.println();
        }
    }

    private static final Permission getInstance(String string, String string2, String string3) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = Class.forName(string);
        Constructor<?> constructor = clazz.getConstructor(PARAMS);
        return (Permission)constructor.newInstance(string2, string3);
    }

    Certificate[] getCertificates(KeyStore keyStore, String string) {
        Object[] objectArray;
        Vector<Certificate> vector = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken().trim();
            ++n;
            Certificate certificate = null;
            certificate = (Certificate)this.aliasMapping.get(objectArray);
            if (certificate == null && keyStore != null) {
                try {
                    certificate = keyStore.getCertificate((String)objectArray);
                }
                catch (KeyStoreException keyStoreException) {}
                if (certificate != null) {
                    this.aliasMapping.put(objectArray, certificate);
                    this.aliasMapping.put(certificate, objectArray);
                }
            }
            if (certificate == null) continue;
            if (vector == null) {
                vector = new Vector<Certificate>();
            }
            vector.addElement(certificate);
        }
        if (vector != null && n == vector.size()) {
            objectArray = new Certificate[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    private final synchronized Enumeration elements() {
        return this.policyEntries.elements();
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        return new PolicyPermissions(this, codeSource);
    }

    public void getPermissions(Permissions permissions, CodeSource codeSource) {
        Certificate[] certificateArray;
        if (!this.initialized) {
            this.init();
        }
        CodeSource[] codeSourceArray = new CodeSource[]{null};
        AccessController.doPrivileged(new 5(codeSourceArray, codeSource, permissions, this));
        if (!this.ignoreIdentityScope && (certificateArray = codeSourceArray[0].getCertificates()) != null) {
            int n = 0;
            while (n < certificateArray.length) {
                if (this.aliasMapping.get(certificateArray[n]) == null && this.checkForTrustedIdentity(certificateArray[n])) {
                    permissions.add(new AllPermission());
                }
                ++n;
            }
        }
    }

    protected Certificate[] getSignerCertificates(CodeSource codeSource) {
        Certificate[] certificateArray = null;
        certificateArray = codeSource.getCertificates();
        if (certificateArray == null) {
            return null;
        }
        int n = 0;
        while (n < certificateArray.length) {
            if (!(certificateArray[n] instanceof X509Certificate)) {
                return codeSource.getCertificates();
            }
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < certificateArray.length) {
            ++n3;
            while (n2 + 1 < certificateArray.length && ((X509Certificate)certificateArray[n2]).getIssuerDN().equals(((X509Certificate)certificateArray[n2 + 1]).getSubjectDN())) {
                ++n2;
            }
            ++n2;
        }
        if (n3 == certificateArray.length) {
            return certificateArray;
        }
        ArrayList arrayList = new ArrayList();
        n2 = 0;
        while (n2 < certificateArray.length) {
            arrayList.add(certificateArray[n2]);
            while (n2 + 1 < certificateArray.length && ((X509Certificate)certificateArray[n2]).getIssuerDN().equals(((X509Certificate)certificateArray[n2 + 1]).getSubjectDN())) {
                ++n2;
            }
            ++n2;
        }
        Object[] objectArray = new Certificate[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    private CodeSource canonicalizeCodebase(CodeSource codeSource, boolean bl) {
        CodeSource codeSource2;
        block6: {
            codeSource2 = codeSource;
            if (codeSource.getLocation() != null && codeSource.getLocation().getProtocol().equalsIgnoreCase("file")) {
                try {
                    File file = new File(codeSource.getLocation().getFile().replace('/', File.separatorChar));
                    if (bl) {
                        codeSource2 = new CodeSource(new File12(file.getCanonicalPath()).toURL(), this.getSignerCertificates(codeSource));
                        break block6;
                    }
                    codeSource2 = new CodeSource(new File12(file.getCanonicalPath()).toURL(), codeSource.getCertificates());
                }
                catch (IOException iOException) {
                    if (bl) {
                        codeSource2 = new CodeSource(codeSource.getLocation(), this.getSignerCertificates(codeSource));
                    }
                    break block6;
                }
            }
            if (bl) {
                codeSource2 = new CodeSource(codeSource.getLocation(), this.getSignerCertificates(codeSource));
            }
        }
        return codeSource2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ boolean access$1(PolicyFile policyFile) {
        return policyFile.initialized;
    }

    private final class 1
    implements PrivilegedAction {
        public Object run() {
            PolicyFile.this.initPolicyFile();
            PolicyFile.this.initialized = true;
            return null;
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements PrivilegedAction {
        public Object run() {
            return IdentityScope.getSystemScope();
        }

        /* synthetic */ 2() {
        }
    }

    private static final class 3
    implements PrivilegedAction {
        private final /* synthetic */ Certificate val$cert;

        public Object run() {
            return scope.getIdentity(this.val$cert.getPublicKey());
        }

        /* synthetic */ 3(Certificate certificate) {
            this.val$cert = certificate;
        }
    }

    private static final class 4
    implements PrivilegedAction {
        private final /* synthetic */ Identity val$id;

        public Object run() {
            debug.println("  identity = " + this.val$id);
            return null;
        }

        /* synthetic */ 4(Identity identity) {
            this.val$id = identity;
        }
    }

    private static final class 5
    implements PrivilegedAction {
        private final /* synthetic */ Permissions val$perms;
        private final /* synthetic */ PolicyFile this$0;
        private final /* synthetic */ CodeSource val$cs;
        private final /* synthetic */ CodeSource[] val$codesource;

        public Object run() {
            this.val$codesource[0] = this.this$0.canonicalizeCodebase(this.val$cs, true);
            if (debug != null) {
                debug.println("evaluate(" + this.val$codesource[0] + ")");
            }
            int n = 0;
            while (n < this.this$0.policyEntries.size()) {
                PolicyEntry policyEntry = (PolicyEntry)this.this$0.policyEntries.elementAt(n);
                if (policyEntry.codesource.implies(this.val$codesource[0])) {
                    int n2 = 0;
                    while (n2 < policyEntry.permissions.size()) {
                        Permission permission = (Permission)policyEntry.permissions.elementAt(n2);
                        if (debug != null) {
                            debug.println("  granting " + permission);
                        }
                        this.val$perms.add(permission);
                        ++n2;
                    }
                }
                ++n;
            }
            return null;
        }

        /* synthetic */ 5(CodeSource[] codeSourceArray, CodeSource codeSource, Permissions permissions, PolicyFile policyFile) {
            this.val$codesource = codeSourceArray;
            this.val$cs = codeSource;
            this.val$perms = permissions;
            this.this$0 = policyFile;
        }
    }

    private static class PolicyEntry {
        CodeSource codesource;
        Vector permissions;

        PolicyEntry(CodeSource codeSource) {
            this.codesource = codeSource;
            this.permissions = new Vector();
        }

        void add(Permission permission) {
            this.permissions.addElement(permission);
        }

        CodeSource getCodeSource() {
            return this.codesource;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            stringBuffer.append(this.getCodeSource());
            stringBuffer.append("\n");
            int n = 0;
            while (n < this.permissions.size()) {
                Permission permission = (Permission)this.permissions.elementAt(n);
                stringBuffer.append("  ");
                stringBuffer.append(permission);
                stringBuffer.append("\n");
                ++n;
            }
            stringBuffer.append(")\n");
            return stringBuffer.toString();
        }
    }
}

