/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.util;

import com.ibm.security12.sun.security.util.DerInputBuffer;
import com.ibm.security12.sun.security.util.DerInputStream;
import com.ibm.security12.sun.security.util.DerOutputStream;
import java.io.IOException;
import java.io.Serializable;

public final class ObjectIdentifier
implements Serializable {
    private static final long serialVersionUID = 8697030238860181294L;
    private int[] components;
    private int componentLen;
    private static final int allocationQuantum = 5;

    public ObjectIdentifier(String string) {
        int n = 46;
        int n2 = 0;
        int n3 = 0;
        this.componentLen = 0;
        while ((n3 = string.indexOf(n, n2)) != -1) {
            n2 = n3 + 1;
            ++this.componentLen;
        }
        ++this.componentLen;
        this.components = new int[this.componentLen];
        n2 = 0;
        int n4 = 0;
        String string2 = null;
        while ((n3 = string.indexOf(n, n2)) != -1) {
            string2 = string.substring(n2, n3);
            this.components[n4++] = Integer.valueOf(string2);
            n2 = n3 + 1;
        }
        string2 = string.substring(n2);
        this.components[n4] = Integer.valueOf(string2);
    }

    public ObjectIdentifier(int[] nArray) {
        try {
            this.components = (int[])nArray.clone();
            this.componentLen = nArray.length;
            return;
        }
        catch (Throwable throwable) {
            System.out.println("X509.ObjectIdentifier(), no cloning!");
            return;
        }
    }

    public ObjectIdentifier(DerInputStream derInputStream) throws IOException {
        byte by = (byte)derInputStream.getByte();
        if (by != 6) {
            throw new IOException("X509.ObjectIdentifier() -- data isn't an object ID (tag = " + by + ")");
        }
        int n = derInputStream.available() - derInputStream.getLength() - 1;
        if (n < 0) {
            throw new IOException("X509.ObjectIdentifier() -- not enough data");
        }
        this.initFromEncoding(derInputStream, n);
    }

    ObjectIdentifier(DerInputBuffer derInputBuffer) throws IOException {
        this.initFromEncoding(new DerInputStream(derInputBuffer), 0);
    }

    private void initFromEncoding(DerInputStream derInputStream, int n) throws IOException {
        boolean bl = true;
        this.components = new int[5];
        this.componentLen = 0;
        while (derInputStream.available() > n) {
            int n2 = ObjectIdentifier.getComponent(derInputStream);
            if (bl) {
                int n3 = n2 < 40 ? 0 : (n2 < 80 ? 1 : 2);
                int n4 = n2 - n3 * 40;
                this.components[0] = n3;
                this.components[1] = n4;
                this.componentLen = 2;
                bl = false;
                continue;
            }
            if (this.componentLen >= this.components.length) {
                int[] nArray = new int[this.components.length + 5];
                System.arraycopy(this.components, 0, nArray, 0, this.components.length);
                this.components = nArray;
            }
            this.components[this.componentLen++] = n2;
        }
        if (derInputStream.available() != n) {
            throw new IOException("X509.ObjectIdentifier() -- malformed input data");
        }
    }

    void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(this.components[0] * 40 + this.components[1]);
        int n = 2;
        while (n < this.componentLen) {
            ObjectIdentifier.putComponent(derOutputStream2, this.components[n]);
            ++n;
        }
        derOutputStream.write((byte)6, derOutputStream2);
    }

    private static int getComponent(DerInputStream derInputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        while (n < 4) {
            n2 <<= 7;
            int n3 = derInputStream.getByte();
            n2 |= n3 & 0x7F;
            if ((n3 & 0x80) == 0) {
                return n2;
            }
            ++n;
        }
        throw new IOException("X509.OID, component value too big");
    }

    private static void putComponent(DerOutputStream derOutputStream, int n) throws IOException {
        byte[] byArray = new byte[4];
        int n2 = 0;
        while (n2 < 4) {
            byArray[n2] = (byte)(n & 0x7F);
            if ((n >>>= 7) == 0) break;
            ++n2;
        }
        while (n2 > 0) {
            derOutputStream.write(byArray[n2] | 0x80);
            --n2;
        }
        derOutputStream.write(byArray[0]);
    }

    public boolean precedes(ObjectIdentifier objectIdentifier) {
        if (objectIdentifier == this || this.componentLen < objectIdentifier.componentLen) {
            return false;
        }
        if (objectIdentifier.componentLen < this.componentLen) {
            return true;
        }
        int n = 0;
        while (n < this.componentLen) {
            if (objectIdentifier.components[n] < this.components[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectIdentifier) {
            return this.equals((ObjectIdentifier)object);
        }
        return false;
    }

    public boolean equals(ObjectIdentifier objectIdentifier) {
        if (objectIdentifier == this) {
            return true;
        }
        if (this.componentLen != objectIdentifier.componentLen) {
            return false;
        }
        int n = 0;
        while (n < this.componentLen) {
            if (this.components[n] != objectIdentifier.components[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        int n = 0;
        String string = "";
        while (n < this.componentLen) {
            if (n != 0) {
                string = String.valueOf(string) + ".";
            }
            string = String.valueOf(string) + this.components[n];
            ++n;
        }
        return string;
    }
}

