/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.sun.security.util.BigInt;
import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.x509.GeneralName;
import java.io.IOException;

public class GeneralSubtree {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static final byte TAG_MIN = 0;
    private static final byte TAG_MAX = 1;
    private static final int MIN_DEFAULT = 0;
    private GeneralName name;
    private int minimum = 0;
    private int maximum = -1;

    public GeneralSubtree(GeneralName generalName, int n, int n2) {
        this.name = generalName;
        this.minimum = n;
        this.maximum = n2;
    }

    public GeneralSubtree(DerValue derValue) throws IOException {
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding for GeneralSubtree.");
        }
        this.name = new GeneralName(derValue.data.getDerValue());
        while (derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            if (derValue2.isContextSpecific((byte)0) && !derValue2.isConstructed()) {
                derValue2.resetTag((byte)2);
                this.minimum = derValue2.getInteger().toInt();
                continue;
            }
            if (derValue2.isContextSpecific((byte)1) && !derValue2.isConstructed()) {
                derValue2.resetTag((byte)2);
                this.maximum = derValue2.getInteger().toInt();
                continue;
            }
            throw new IOException("Invalid encoding of GeneralSubtree.");
        }
    }

    public String toString() {
        String string = "\n   GeneralSubtree: [\n    GeneralName: " + (this.name == null ? "" : this.name.toString()) + "\n    Minimum: " + this.minimum;
        string = this.maximum == -1 ? String.valueOf(string) + "\t    Maximum: undefined" : String.valueOf(string) + "\t    Maximum: " + this.maximum;
        string = String.valueOf(string) + "    ]\n";
        return string;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2;
        DerOutputStream derOutputStream3 = new DerOutputStream();
        this.name.encode(derOutputStream3);
        if (this.minimum != 0) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(new BigInt(this.minimum));
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), derOutputStream2);
        }
        if (this.maximum != -1) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(new BigInt(this.maximum));
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream3);
    }
}

