/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.util.ObjectIdentifier;
import com.ibm.security12.sun.security.x509.AttributeNameEnumeration;
import com.ibm.security12.sun.security.x509.CertAttrSet;
import com.ibm.security12.sun.security.x509.Extension;
import com.ibm.security12.sun.security.x509.GeneralSubtrees;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

public class NameConstraintsExtension
extends Extension
implements CertAttrSet {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static final int[] NameConstraints_data = new int[]{2, 5, 29, 30};
    public static final String IDENT = "x509.info.extensions.NameConstraints";
    public static final String NAME = "NameConstraints";
    public static final String PERMITTED_SUBTREES = "permitted_subtrees";
    public static final String EXCLUDED_SUBTREES = "excluded_subtrees";
    private static final byte TAG_PERMITTED = 0;
    private static final byte TAG_EXCLUDED = 1;
    private GeneralSubtrees permitted;
    private GeneralSubtrees excluded;

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream;
        if (this.permitted == null && this.excluded == null) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.permitted != null) {
            derOutputStream = new DerOutputStream();
            this.permitted.encode(derOutputStream);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        }
        if (this.excluded != null) {
            derOutputStream = new DerOutputStream();
            this.excluded.encode(derOutputStream);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream3);
        this.extensionValue = derOutputStream2.toByteArray();
    }

    public NameConstraintsExtension(GeneralSubtrees generalSubtrees, GeneralSubtrees generalSubtrees2) throws IOException {
        if (generalSubtrees == null && generalSubtrees2 == null) {
            throw new IOException("NameConstraints: Invalid arguments");
        }
        this.permitted = generalSubtrees;
        this.excluded = generalSubtrees2;
        this.extensionId = new ObjectIdentifier(NameConstraints_data);
        this.critical = false;
        this.encodeThis();
    }

    /*
     * Unable to fully structure code
     */
    public NameConstraintsExtension(Boolean var1_1, Object var2_2) throws IOException {
        super();
        this.extensionId = new ObjectIdentifier(NameConstraintsExtension.NameConstraints_data);
        this.critical = var1_1;
        if (!(var2_2 instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        var3_3 = Array.getLength(var2_2);
        var4_4 = new byte[var3_3];
        System.arraycopy(var2_2, 0, var4_4, 0, var3_3);
        this.extensionValue = var4_4;
        var5_5 = new DerValue(var4_4);
        if (var5_5.tag == 48) ** GOTO lbl27
        throw new IOException("Invalid encoding for NameConstraintsExtension.");
lbl-1000:
        // 1 sources

        {
            var6_6 = var5_5.data.getDerValue();
            if (var6_6.isContextSpecific((byte)0) && var6_6.isConstructed()) {
                if (this.permitted != null) {
                    throw new IOException("Duplicate permitted GeneralSubtrees in NameConstraintsExtension.");
                }
                var6_6.resetTag((byte)48);
                this.permitted = new GeneralSubtrees(var6_6);
                continue;
            }
            if (var6_6.isContextSpecific((byte)1) && var6_6.isConstructed()) {
                if (this.excluded != null) {
                    throw new IOException("Duplicate excluded GeneralSubtrees in NameConstraintsExtension.");
                }
                var6_6.resetTag((byte)48);
                this.excluded = new GeneralSubtrees(var6_6);
                continue;
            }
            throw new IOException("Invalid encoding of NameConstraintsExtension.");
lbl27:
            // 3 sources

            ** while (var5_5.data.available() != 0)
        }
lbl28:
        // 1 sources

    }

    public String toString() {
        return String.valueOf(super.toString()) + "NameConstraints: [" + (this.permitted == null ? "" : "\n    Permitted:" + this.permitted.toString()) + (this.excluded == null ? "" : "\n    Excluded:" + this.excluded.toString()) + "   ]\n";
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = new ObjectIdentifier(NameConstraints_data);
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            if (!(object instanceof GeneralSubtrees)) {
                throw new IOException("Attribute value should be of type GeneralSubtrees.");
            }
            this.permitted = (GeneralSubtrees)object;
        } else if (string.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            if (!(object instanceof GeneralSubtrees)) {
                throw new IOException("Attribute value should be of type GeneralSubtrees.");
            }
            this.excluded = (GeneralSubtrees)object;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
        }
        this.encodeThis();
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            return this.permitted;
        }
        if (string.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            return this.excluded;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
    }

    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            this.permitted = null;
        } else if (string.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            this.excluded = null;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
        }
        this.encodeThis();
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(PERMITTED_SUBTREES);
        attributeNameEnumeration.addElement(EXCLUDED_SUBTREES);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }
}

