/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.java.security.cert.CertificateException;
import com.ibm.security12.sun.security.util.ObjectIdentifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class OIDMap {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static final String ROOT = "x509.info.extensions";
    private static final String AUTH_KEY_IDENTIFIER = "x509.info.extensions.AuthorityKeyIdentifier";
    private static final String SUB_KEY_IDENTIFIER = "x509.info.extensions.SubjectKeyIdentifier";
    private static final String KEY_USAGE = "x509.info.extensions.KeyUsage";
    private static final String PRIVATE_KEY_USAGE = "x509.info.extensions.PrivateKeyUsage";
    private static final String POLICY_MAPPINGS = "x509.info.extensions.PolicyMappings";
    private static final String SUB_ALT_NAME = "x509.info.extensions.SubjectAlternativeName";
    private static final String ISSUER_ALT_NAME = "x509.info.extensions.IssuerAlternativeName";
    private static final String BASIC_CONSTRAINTS = "x509.info.extensions.BasicConstraints";
    private static final String NAME_CONSTRAINTS = "x509.info.extensions.NameConstraints";
    private static final String POLICY_CONSTRAINTS = "x509.info.extensions.PolicyConstraints";
    private static final String CRL_NUMBER = "x509.info.extensions.CRLNumber";
    private static final String CRL_REASON = "x509.info.extensions.CRLReasonCode";
    private static final String NETSCAPE_CERT = "x509.info.extensions.NetscapeCertType";
    private static final Hashtable oid2Name = new Hashtable(15);
    private static final Hashtable name2OID = new Hashtable(15);
    private static final Hashtable name2Class = new Hashtable(15);

    private static void loadNamesDefault(Properties properties) {
        ((Hashtable)properties).put(SUB_KEY_IDENTIFIER, "2.5.29.14");
        ((Hashtable)properties).put(KEY_USAGE, "2.5.29.15");
        ((Hashtable)properties).put(PRIVATE_KEY_USAGE, "2.5.29.16");
        ((Hashtable)properties).put(SUB_ALT_NAME, "2.5.29.17");
        ((Hashtable)properties).put(ISSUER_ALT_NAME, "2.5.29.18");
        ((Hashtable)properties).put(BASIC_CONSTRAINTS, "2.5.29.19");
        ((Hashtable)properties).put(CRL_NUMBER, "2.5.29.20");
        ((Hashtable)properties).put(CRL_REASON, "2.5.29.21");
        ((Hashtable)properties).put(NAME_CONSTRAINTS, "2.5.29.30");
        ((Hashtable)properties).put(POLICY_MAPPINGS, "2.5.29.33");
        ((Hashtable)properties).put(AUTH_KEY_IDENTIFIER, "2.5.29.35");
        ((Hashtable)properties).put(POLICY_CONSTRAINTS, "2.5.29.36");
        ((Hashtable)properties).put(NETSCAPE_CERT, "2.16.840.1.113730.1.1");
    }

    private static void loadClassDefault(Properties properties) {
        ((Hashtable)properties).put(AUTH_KEY_IDENTIFIER, "com.ibm.security12.sun.security.x509.AuthorityKeyIdentifierExtension");
        ((Hashtable)properties).put(SUB_KEY_IDENTIFIER, "com.ibm.security12.sun.security.x509.SubjectKeyIdentifierExtension");
        ((Hashtable)properties).put(KEY_USAGE, "com.ibm.security12.sun.security.x509.KeyUsageExtension");
        ((Hashtable)properties).put(PRIVATE_KEY_USAGE, "com.ibm.security12.sun.security.x509.PrivateKeyUsageExtension");
        ((Hashtable)properties).put(POLICY_MAPPINGS, "com.ibm.security12.sun.security.x509.PolicyMappingsExtension");
        ((Hashtable)properties).put(SUB_ALT_NAME, "com.ibm.security12.sun.security.x509.SubjectAlternativeNameExtension");
        ((Hashtable)properties).put(ISSUER_ALT_NAME, "com.ibm.security12.sun.security.x509.IssuerAlternativeNameExtension");
        ((Hashtable)properties).put(BASIC_CONSTRAINTS, "com.ibm.security12.sun.security.x509.BasicConstraintsExtension");
        ((Hashtable)properties).put(NAME_CONSTRAINTS, "com.ibm.security12.sun.security.x509.NameConstraintsExtension");
        ((Hashtable)properties).put(POLICY_CONSTRAINTS, "com.ibm.security12.sun.security.x509.PolicyConstraintsExtension");
        ((Hashtable)properties).put(CRL_NUMBER, "com.ibm.security12.sun.security.x509.CRLNumberExtension");
        ((Hashtable)properties).put(CRL_REASON, "com.ibm.security12.sun.security.x509.CRLReasonCodeExtension");
        ((Hashtable)properties).put(NETSCAPE_CERT, "com.ibm.security12.sun.security.x509.NetscapeCertTypeExtension");
    }

    private static void loadNames() {
        Properties properties = new Properties();
        OIDMap.loadNamesDefault(properties);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(string2);
            name2OID.put(string, objectIdentifier);
            oid2Name.put(objectIdentifier, string);
        }
    }

    private static void loadClasses() {
        Properties properties = new Properties();
        OIDMap.loadClassDefault(properties);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            name2Class.put(string, string2);
        }
    }

    public static void addAttribute(String string, String string2, String string3) throws CertificateException {
        ObjectIdentifier objectIdentifier = new ObjectIdentifier(string2);
        if (oid2Name.get(objectIdentifier) != null) {
            throw new CertificateException("Object identifier already exists");
        }
        if (name2OID.get(string3) != null) {
            throw new CertificateException("Name already exists");
        }
        if (name2Class.get(string) != null) {
            throw new CertificateException("Class already exists");
        }
        oid2Name.put(objectIdentifier, string3);
        name2OID.put(string3, objectIdentifier);
        name2Class.put(string3, string);
    }

    public static String getName(ObjectIdentifier objectIdentifier) {
        return (String)oid2Name.get(objectIdentifier);
    }

    public static ObjectIdentifier getOID(String string) {
        return (ObjectIdentifier)name2OID.get(string);
    }

    public static Class getClass(String string) throws CertificateException {
        String string2 = (String)name2Class.get(string);
        if (string2 == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(string2);
            return clazz;
        }
        catch (Exception exception) {
            throw new CertificateException("Error instantiating class for " + string + " " + exception.toString());
        }
    }

    public static Class getClass(ObjectIdentifier objectIdentifier) throws CertificateException {
        String string = OIDMap.getName(objectIdentifier);
        if (string == null) {
            return null;
        }
        String string2 = (String)name2Class.get(string);
        if (string2 == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(string2);
            return clazz;
        }
        catch (Exception exception) {
            throw new CertificateException("Error instantiating class for " + string + " " + exception.toString());
        }
    }

    static {
        OIDMap.loadNames();
        OIDMap.loadClasses();
    }
}

